/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.selfrun.order.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.atom.busicommon.order.api.DycUocHaveDoneFunction;
import com.tydic.dyc.atom.busicommon.order.bo.DycUocHaveDoneFuncReqBO;
import com.tydic.dyc.atom.busicommon.order.bo.DycUocHaveDoneFuncRspBO;
import com.tydic.dyc.atom.common.api.DycBusiProcessFlowFunction;
import com.tydic.dyc.atom.common.bo.DycBusiProcessFlowFuncReqBO;
import com.tydic.dyc.atom.common.bo.DycBusiProcessFlowFuncRspBO;
import com.tydic.dyc.oc.service.domainservice.UocSaleShipOrderService;
import com.tydic.dyc.oc.service.domainservice.bo.UocSaleShipOrderReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocSaleShipOrderRspBo;
import com.tydic.dyc.selfrun.order.api.DycUocDeliverCommodityService;
import com.tydic.dyc.selfrun.order.bo.DycUocDeliverCommodityContextBO;
import com.tydic.dyc.selfrun.order.bo.DycUocDeliverCommodityReqBO;
import com.tydic.dyc.selfrun.order.bo.DycUocDeliverCommodityRspBO;
import com.tydic.dyc.selfrun.order.bo.DycUocDeliverDetailBO;
import java.math.BigDecimal;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_GROUP_DEV/3.0.0/com.tydic.dyc.selfrun.order.api.DycUocDeliverCommodityService"})
public class DycUocDeliverCommodityServiceImpl
implements DycUocDeliverCommodityService {
    @Autowired
    private DycBusiProcessFlowFunction dycBusiProcessFlowFunction;
    @Autowired
    private UocSaleShipOrderService uocSaleShipOrderService;
    @Autowired
    private DycUocHaveDoneFunction dycUocHaveDoneFunction;

    @Override
    @PostMapping(value={"deliverCommodity"})
    public DycUocDeliverCommodityRspBO deliverCommodity(@RequestBody DycUocDeliverCommodityReqBO reqBO) {
        this.verifyParam(reqBO);
        DycUocDeliverCommodityContextBO contextBO = (DycUocDeliverCommodityContextBO)((Object)JSONObject.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), DycUocDeliverCommodityContextBO.class));
        this.createShipOrder(contextBO);
        this.flowBusiProcess(contextBO);
        this.pushTodo(contextBO);
        return new DycUocDeliverCommodityRspBO();
    }

    private void pushTodo(DycUocDeliverCommodityContextBO contextBO) {
        DycUocHaveDoneFuncReqBO dycUocHaveDoneFuncReqBO = new DycUocHaveDoneFuncReqBO();
        dycUocHaveDoneFuncReqBO.setOrderId(contextBO.getOrderId());
        dycUocHaveDoneFuncReqBO.setTaskId(contextBO.getTaskId());
        dycUocHaveDoneFuncReqBO.setUserId(contextBO.getUserId());
        dycUocHaveDoneFuncReqBO.setUserName(contextBO.getName());
        DycUocHaveDoneFuncRspBO dycUocHaveDoneFuncRspBO = this.dycUocHaveDoneFunction.dealUocHaveDone(dycUocHaveDoneFuncReqBO);
        if (!"0000".equals(dycUocHaveDoneFuncRspBO.getRespCode())) {
            // empty if block
        }
    }

    private void createShipOrder(DycUocDeliverCommodityContextBO contextBO) {
        UocSaleShipOrderReqBo uocSaleShipOrderReqBo = (UocSaleShipOrderReqBo)JSON.parseObject((String)JSON.toJSONString((Object)((Object)contextBO)), UocSaleShipOrderReqBo.class);
        UocSaleShipOrderRspBo uocSaleShipOrderRspBo = this.uocSaleShipOrderService.dealImplShipOrder(uocSaleShipOrderReqBo);
        if (!"0000".equals(uocSaleShipOrderRspBo.getRespCode())) {
            throw new ZTBusinessException("\u521b\u5efa\u53d1\u8d27\u5355\u5931\u8d25\uff1a" + uocSaleShipOrderRspBo.getRespDesc());
        }
        contextBO.setShipOrderId(uocSaleShipOrderRspBo.getShipOrderId());
        contextBO.setFinish(uocSaleShipOrderRspBo.getFinish());
        contextBO.setShipOrderNo(uocSaleShipOrderRspBo.getShipOrderNo());
    }

    private void flowBusiProcess(DycUocDeliverCommodityContextBO contextBO) {
        DycBusiProcessFlowFuncReqBO dycBusiProcessFlowFuncReqBO = new DycBusiProcessFlowFuncReqBO();
        dycBusiProcessFlowFuncReqBO.setTaskId(contextBO.getTaskId());
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("shipOrderId", contextBO.getShipOrderId());
        variables.put("shipStartflag", 1);
        variables.put("needArrivalProcess", 1);
        variables.put("userId", contextBO.getUserId());
        variables.put("userName", contextBO.getName());
        variables.put("saleOrderId", contextBO.getSaleOrderId());
        variables.put("saleOrderNo", contextBO.getSaleOrderNo());
        variables.put("shipOrderNo", contextBO.getShipOrderNo());
        variables.put("arrivalDate", contextBO.getEstimateArrivalTime());
        variables.put("purUserId", contextBO.getPurUserId());
        variables.put("supId", contextBO.getSupId());
        if (contextBO.getFinish().booleanValue()) {
            variables.put("shipCompleteflag", 1);
        }
        dycBusiProcessFlowFuncReqBO.setVariables(variables);
        DycBusiProcessFlowFuncRspBO dycBusiProcessFlowFuncRspBO = this.dycBusiProcessFlowFunction.flowBusiProcess(dycBusiProcessFlowFuncReqBO);
        if (!"0000".equals(dycBusiProcessFlowFuncRspBO.getRespCode())) {
            throw new ZTBusinessException("\u53d1\u8d27\u6d41\u7a0b\u6d41\u8f6c\u5931\u8d25\uff1a" + dycBusiProcessFlowFuncRspBO.getRespDesc());
        }
    }

    private void verifyParam(DycUocDeliverCommodityReqBO reqBO) {
        if (null == reqBO) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getOrderId()) {
            throw new ZTBusinessException("\u8ba2\u5355ID\u4e3a\u7a7a");
        }
        if (null == reqBO.getSaleOrderId()) {
            throw new ZTBusinessException("\u9500\u552e\u5355ID\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBO.getTaskId())) {
            throw new ZTBusinessException("\u4efb\u52a1id\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBO.getShipCompanyNo())) {
            throw new ZTBusinessException("\u914d\u9001\u5355\u53f7\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBO.getShipName())) {
            throw new ZTBusinessException("\u53d1\u8d27\u8054\u7cfb\u4eba\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBO.getShipPhone())) {
            throw new ZTBusinessException("\u53d1\u8d27\u8054\u7cfb\u4eba\u7535\u8bdd\u4e3a\u7a7a");
        }
        if (null == reqBO.getShipTime()) {
            throw new ZTBusinessException("\u53d1\u8d27\u65e5\u671f\u4e3a\u7a7a");
        }
        if (null == reqBO.getEstimateArrivalTime()) {
            throw new ZTBusinessException("\u9884\u8ba1\u5230\u8d27\u65e5\u671f\u4e3a\u7a7a");
        }
        if (null == reqBO.getUserId()) {
            throw new ZTBusinessException("\u5f53\u524d\u767b\u5f55\u4ebaID\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBO.getName())) {
            throw new ZTBusinessException("\u5f53\u524d\u767b\u5f55\u4eba\u540d\u79f0\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty(reqBO.getShipOrderItemBoList())) {
            throw new ZTBusinessException("\u53d1\u8d27\u660e\u7ec6\u4e3a\u7a7a");
        }
        if (!CollectionUtils.isEmpty(reqBO.getShipOrderItemBoList())) {
            for (DycUocDeliverDetailBO dycUocDeliverDetailBO : reqBO.getShipOrderItemBoList()) {
                if (null == dycUocDeliverDetailBO.getSendCount()) {
                    throw new ZTBusinessException("\u53d1\u8d27\u6570\u91cf\u4e3a\u7a7a");
                }
                if (dycUocDeliverDetailBO.getSendCount().compareTo(BigDecimal.ZERO) != 0) continue;
                throw new ZTBusinessException("\u53d1\u8d27\u6570\u91cf\u4e3a0");
            }
        }
    }
}

