/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.selfrun.order.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.dyc.atom.common.api.DycGeneralQueryFunction;
import com.tydic.dyc.atom.common.api.DycTabTacheCodeQryFunction;
import com.tydic.dyc.atom.common.bo.DycGeneralQueryFuncReqBO;
import com.tydic.dyc.atom.common.bo.DycGeneralQueryFuncRspBO;
import com.tydic.dyc.atom.common.bo.DycTabTacheCodeInfoFuncBO;
import com.tydic.dyc.atom.common.bo.DycTabTacheCodeQryFuncReqBO;
import com.tydic.dyc.atom.common.bo.DycTabTacheCodeQryFuncRspBO;
import com.tydic.dyc.base.bo.BaseUmcReqBo;
import com.tydic.dyc.base.utils.ParseUrlParamUtil;
import com.tydic.dyc.oc.service.domainservice.UocTacheButtonQryService;
import com.tydic.dyc.oc.service.domainservice.bo.UocTacheButtonInfoBO;
import com.tydic.dyc.oc.service.domainservice.bo.UocTacheButtonQryReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocTacheButtonQryRspBo;
import com.tydic.dyc.oc.service.order.UocProOrderEffectivePageQueryService;
import com.tydic.dyc.oc.service.order.bo.UocProOrderEffectiveInfoBo;
import com.tydic.dyc.oc.service.order.bo.UocProOrderEffectiveListPageQueryReqBo;
import com.tydic.dyc.oc.service.order.bo.UocProOrderEffectiveListPageQueryRspBo;
import com.tydic.dyc.selfrun.order.api.DycUocOrderListQryService;
import com.tydic.dyc.selfrun.order.bo.DycUocButtonBo;
import com.tydic.dyc.selfrun.order.bo.DycUocOrderCommodityInfoBO;
import com.tydic.dyc.selfrun.order.bo.DycUocOrderInfoBO;
import com.tydic.dyc.selfrun.order.bo.DycUocOrderListQryReqBO;
import com.tydic.dyc.selfrun.order.bo.DycUocOrderListQryRspBO;
import com.tydic.dyc.selfrun.order.bo.DycUocTabCountsBO;
import com.tydic.dyc.selfrun.order.bo.DycUocTabQueryCountBO;
import com.tydic.dyc.selfrun.order.bo.DycUocTaskInstInfoBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_GROUP_DEV/3.0.0/com.tydic.dyc.selfrun.order.api.DycUocOrderListQryService"})
public class DycUocOrderListQryServiceImpl
implements DycUocOrderListQryService {
    private static final Logger log = LoggerFactory.getLogger(DycUocOrderListQryServiceImpl.class);
    @Autowired
    private DycGeneralQueryFunction dycGeneralQueryFunction;
    @Autowired
    private UocTacheButtonQryService uocTacheButtonQryService;
    @Autowired
    private DycTabTacheCodeQryFunction dycTabTacheCodeQryFunction;
    @Value(value="#{'${button.form.params.sale:orderId,saleOrderId,orderSource,busiTaskInstBos.taskId:taskId,busiTaskInstBos.tacheCode:tacheCode,auditTaskInstBos.taskId:auditTaskId,auditOrderBoList.auditOrderId:auditOrderId}'.split(',')}")
    private List<String> buttonFormParams;
    @Autowired
    private UocProOrderEffectivePageQueryService uocProOrderEffectivePageQueryService;
    private static final String EFFECTIVE_CODE_STOCK = "1";
    public static final String DEFAULT = "DEFAULT";
    public static final String TAB_COUNT = "tabCount";
    public static final String TAB_NAME = "tabName";
    public static final Long ID = 1L;

    @Override
    @PostMapping(value={"qryOrderList"})
    public DycUocOrderListQryRspBO qryOrderList(@RequestBody DycUocOrderListQryReqBO reqBo) {
        this.setAuthUser(reqBo);
        JSONObject reqJsonObj = JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBo)));
        this.setTabConf(reqBo, reqJsonObj);
        DycGeneralQueryFuncReqBO dycGeneralQueryFuncReqBO = new DycGeneralQueryFuncReqBO();
        dycGeneralQueryFuncReqBO.setQueryCountFlag(Boolean.valueOf(false));
        dycGeneralQueryFuncReqBO.setReqParams(reqJsonObj.toJSONString());
        log.info("\u6574\u5355\u67e5\u8be2\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)dycGeneralQueryFuncReqBO));
        DycGeneralQueryFuncRspBO dycGeneralQueryFuncRspBO = this.dycGeneralQueryFunction.generalQuery(dycGeneralQueryFuncReqBO);
        DycUocOrderListQryRspBO rspBO = (DycUocOrderListQryRspBO)((Object)JSONObject.parseObject((String)dycGeneralQueryFuncRspBO.getRspJsonStr(), DycUocOrderListQryRspBO.class));
        if (StringUtils.isNotBlank((CharSequence)reqBo.getTabId())) {
            this.setButton(rspBO.getRows(), reqBo);
        }
        Map<Long, Map<String, Object>> tabsCountMap = this.getTabsCount(reqBo);
        this.setTabCount(reqBo, rspBO, tabsCountMap);
        if (ObjectUtil.isNotEmpty(rspBO.getRows())) {
            for (DycUocOrderInfoBO item : rspBO.getRows()) {
                for (DycUocTaskInstInfoBO taskInfo : item.getAuditTaskInstBos()) {
                    if (!String.valueOf(reqBo.getUserId()).equals(taskInfo.getDealId())) continue;
                    item.setTaskSignTag(taskInfo.getTaskSignTag());
                }
            }
        }
        return rspBO;
    }

    private Map<Long, Map<String, Object>> getTabsCount(DycUocOrderListQryReqBO reqBO) {
        BaseUmcReqBo baseUmcReqBo = (BaseUmcReqBo)JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), BaseUmcReqBo.class);
        DycUocOrderListQryReqBO dycUocOrderListQryReqBO = (DycUocOrderListQryReqBO)((Object)JSON.parseObject((String)JSON.toJSONString((Object)baseUmcReqBo), DycUocOrderListQryReqBO.class));
        HashMap<Long, Map<String, Object>> tabCountMap = new HashMap<Long, Map<String, Object>>();
        if (ObjectUtil.isNotEmpty(reqBO.getTabQueryCountBos())) {
            for (DycUocTabQueryCountBO tabQueryCountBo : reqBO.getTabQueryCountBos()) {
                JSONObject baseReqJsonObj;
                Date now = new Date();
                DycGeneralQueryFuncReqBO dycGeneralQueryFuncReqBO = new DycGeneralQueryFuncReqBO();
                dycGeneralQueryFuncReqBO.setQueryCountFlag(Boolean.valueOf(true));
                if (tabQueryCountBo.getTabId().toString().equals(reqBO.getTabId())) {
                    baseReqJsonObj = JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)));
                } else {
                    dycUocOrderListQryReqBO.setTabId(tabQueryCountBo.getTabId().toString());
                    dycUocOrderListQryReqBO.setObjBusiType(reqBO.getObjBusiType());
                    this.setAuthUser(dycUocOrderListQryReqBO);
                    baseReqJsonObj = JSON.parseObject((String)JSON.toJSONString((Object)((Object)dycUocOrderListQryReqBO)));
                    baseReqJsonObj.put("code", (Object)"881184533233897472");
                }
                if (StringUtils.isNotBlank((CharSequence)tabQueryCountBo.getParamJson())) {
                    JSONObject tabQryCountJsonObj = JSON.parseObject((String)tabQueryCountBo.getParamJson());
                    baseReqJsonObj.putAll((Map)tabQryCountJsonObj);
                }
                log.info("\u67e5\u8be2\u6570\u91cf\u5165\u53c2:{}", (Object)baseReqJsonObj.toJSONString());
                dycGeneralQueryFuncReqBO.setReqParams(baseReqJsonObj.toJSONString());
                String rspJsonStr = this.dycGeneralQueryFunction.generalQuery(dycGeneralQueryFuncReqBO).getRspJsonStr();
                HashMap<String, Object> map = new HashMap<String, Object>();
                if (ObjectUtil.isNotEmpty((Object)rspJsonStr)) {
                    JSONObject jsonObject = JSON.parseObject((String)rspJsonStr);
                    map.put(TAB_COUNT, ObjectUtil.isNotNull((Object)jsonObject.get((Object)"recordsTotal")) ? jsonObject.get((Object)"recordsTotal") : Integer.valueOf(0));
                }
                map.put(TAB_NAME, null != tabQueryCountBo.getTabName() ? tabQueryCountBo.getTabName() : "");
                tabCountMap.put(tabQueryCountBo.getTabId(), map);
                Date now2 = new Date();
                log.info("\u5faa\u73af\u67e5\u8be2\u6570\u91cf\u65f6\u95f4\u5f00\u59cb:{} \u7ed3\u675f:{} \u8017\u65f6:{}ms", new Object[]{DateUtils.dateToStr((Date)now, (String)"yyyy-MM-dd HH:mm:ss SSS"), DateUtils.dateToStr((Date)now2, (String)"yyyy-MM-dd HH:mm:ss SSS"), now2.getTime() - now.getTime()});
            }
        }
        return tabCountMap;
    }

    private void setAuthUser(DycUocOrderListQryReqBO reqBO) {
        if (null != reqBO.getUserId() && ObjectUtil.notEqual((Object)reqBO.getUserId(), (Object)ID) && !"0".equals(reqBO.getIsProfessionalOrgExt()) && !EFFECTIVE_CODE_STOCK.equals(reqBO.getIsProfessionalOrgExt()) && "2".equals(reqBO.getIsProfessionalOrgExt())) {
            if (null == reqBO.getSupplierId() || reqBO.getSupplierId().equals("")) {
                reqBO.setSupplierId(reqBO.getSupId().toString());
            } else {
                reqBO.setSupplierId(reqBO.getSupId().toString().equals(reqBO.getSupplierId()) ? reqBO.getSupId().toString() : "*");
            }
        }
        if (reqBO.getObjBusiType() != null) {
            ArrayList<String> auditDealResultQryKeys = new ArrayList<String>();
            String auditDealResultQryKey3 = reqBO.getUserId() + "_" + reqBO.getObjBusiType();
            String auditDealResultQryKey1 = reqBO.getUserId() + "_" + reqBO.getObjBusiType() + "_" + 0;
            String auditDealResultQryKey2 = reqBO.getUserId() + "_" + reqBO.getObjBusiType() + "_" + 1;
            if (!CollectionUtils.isEmpty(reqBO.getAuditOrderStatusQry())) {
                String auditDealResultQryKey = reqBO.getUserId() + "_" + reqBO.getObjBusiType() + "_" + reqBO.getAuditOrderStatusQry().get(0);
                auditDealResultQryKeys.add(auditDealResultQryKey);
            } else if (reqBO.getTabId().equals("30014")) {
                auditDealResultQryKeys.add(auditDealResultQryKey3);
            } else if (reqBO.getTabId().equals("30015")) {
                this.buildTime(reqBO);
                auditDealResultQryKeys.add(auditDealResultQryKey1);
                auditDealResultQryKeys.add(auditDealResultQryKey2);
            } else {
                auditDealResultQryKeys.add(auditDealResultQryKey1);
                auditDealResultQryKeys.add(auditDealResultQryKey2);
                auditDealResultQryKeys.add(auditDealResultQryKey3);
            }
            reqBO.setAuditDealResultQryKeys(auditDealResultQryKeys);
        }
    }

    private void buildTime(DycUocOrderListQryReqBO reqBO) {
        String dealApprovalTimeStart = reqBO.getDealApprovalTimeStart();
        String dealApprovalTimeEnd = reqBO.getDealApprovalTimeEnd();
        if (ObjectUtil.isNotEmpty((Object)dealApprovalTimeStart) && ObjectUtil.isNotEmpty((Object)dealApprovalTimeEnd)) {
            long startTime = DateUtil.parse((CharSequence)dealApprovalTimeStart, (String)"yyyy-MM-dd HH:mm:ss").getTime();
            long endTime = DateUtil.parse((CharSequence)dealApprovalTimeEnd, (String)"yyyy-MM-dd HH:mm:ss").getTime();
            reqBO.setDealApprovalTimeStart(reqBO.getUserId() + "" + reqBO.getObjBusiType() + startTime);
            reqBO.setDealApprovalTimeEnd(reqBO.getUserId() + "" + reqBO.getObjBusiType() + endTime);
        }
    }

    private void setTabCount(DycUocOrderListQryReqBO reqBO, DycUocOrderListQryRspBO rspBO, Map<Long, Map<String, Object>> tabsCountMap) {
        if (ObjectUtil.isNotNull((Object)((Object)rspBO)) && ObjectUtil.isNotEmpty(reqBO.getTabQueryCountBos())) {
            ArrayList<DycUocTabCountsBO> saleTabCountList = new ArrayList<DycUocTabCountsBO>();
            List<DycUocTabQueryCountBO> dycUocTabQueryCountBOList = reqBO.getTabQueryCountBos();
            if (StringUtils.isNotBlank((CharSequence)reqBO.getMenuCode())) {
                dycUocTabQueryCountBOList = dycUocTabQueryCountBOList.stream().sorted(Comparator.comparing(DycUocTabQueryCountBO::getSort)).collect(Collectors.toList());
            }
            dycUocTabQueryCountBOList.forEach(each -> {
                DycUocTabCountsBO tabCountsBO = new DycUocTabCountsBO();
                tabCountsBO.setTabId(each.getTabId());
                if (ObjectUtil.isNotEmpty((Object)tabsCountMap) && tabsCountMap.containsKey(each.getTabId())) {
                    tabCountsBO.setTabCount((Integer)((Map)tabsCountMap.get(each.getTabId())).get(TAB_COUNT));
                    tabCountsBO.setTabName(((Map)tabsCountMap.get(each.getTabId())).get(TAB_NAME).toString());
                    if (tabCountsBO.getTabName().startsWith("\u5168\u90e8") || tabCountsBO.getTabName().startsWith("\u5df2\u5ba1\u6279")) {
                        tabCountsBO.setTabNameCount(tabCountsBO.getTabName());
                    } else {
                        tabCountsBO.setTabNameCount(tabCountsBO.getTabName() + "(" + tabCountsBO.getTabCount() + ")");
                    }
                }
                saleTabCountList.add(tabCountsBO);
            });
            rspBO.setTabCountList(saleTabCountList);
        }
    }

    private void setButton(List<DycUocOrderInfoBO> rows, DycUocOrderListQryReqBO reqBO) {
        if (CollectionUtils.isEmpty(rows)) {
            return;
        }
        HashSet tacheCodes = new HashSet();
        HashSet orderIdList = new HashSet();
        ArrayList objIdList = new ArrayList();
        HashSet orderStateList = new HashSet();
        if ("30014".equals(reqBO.getTabId())) {
            Iterator<DycUocOrderInfoBO> iterator = rows.iterator();
            while (iterator.hasNext()) {
                DycUocOrderInfoBO dycUocOrderInfoBO2 = iterator.next();
                if (!"ZD_SP_QX".equals(dycUocOrderInfoBO2.getOrderState())) continue;
                iterator.remove();
            }
        }
        rows.forEach(dycUocOrderInfoBO -> {
            for (DycUocTaskInstInfoBO busiTaskInstBo : dycUocOrderInfoBO.getBusiTaskInstBos()) {
                tacheCodes.add(busiTaskInstBo.getTacheCode());
            }
            orderIdList.add(dycUocOrderInfoBO.getOrderId());
            objIdList.add(dycUocOrderInfoBO.getOrderId());
            if (StringUtils.isNotBlank((CharSequence)dycUocOrderInfoBO.getOrderState())) {
                orderStateList.add(dycUocOrderInfoBO.getOrderState());
            }
        });
        UocTacheButtonQryReqBo uocTacheButtonQryFuncReqBo = new UocTacheButtonQryReqBo();
        uocTacheButtonQryFuncReqBo.setTabId(reqBO.getTabId());
        uocTacheButtonQryFuncReqBo.setOrderStatusList(new ArrayList(orderStateList));
        uocTacheButtonQryFuncReqBo.setTacheCodes(new ArrayList(tacheCodes));
        uocTacheButtonQryFuncReqBo.setObjIdList(objIdList);
        uocTacheButtonQryFuncReqBo.setOrderIdList(new ArrayList(orderIdList));
        uocTacheButtonQryFuncReqBo.setReflected(reqBO.getReflected());
        UocTacheButtonQryRspBo uocTacheButtonQryFuncRspBo = this.uocTacheButtonQryService.qryTacheButton(uocTacheButtonQryFuncReqBo);
        List uocTacheButtonInfoFuncBOS = uocTacheButtonQryFuncRspBo.getUocTacheButtonS();
        if (!CollectionUtil.isEmpty((Collection)uocTacheButtonInfoFuncBOS)) {
            HashMap buttonParamMap = new HashMap();
            ArrayList<String> buttonParamList = new ArrayList<String>(this.buttonFormParams);
            buttonParamList.forEach(buttonFormParam -> {
                if (buttonFormParam.contains(":")) {
                    String[] paramRel = buttonFormParam.split("\\:");
                    buttonParamMap.put(paramRel[0], paramRel[1]);
                } else {
                    buttonParamMap.put(buttonFormParam, buttonFormParam);
                }
            });
            this.buttonFormParams = new ArrayList(buttonParamMap.keySet());
            Map<String, List<UocTacheButtonInfoBO>> tacheCodeMap = uocTacheButtonInfoFuncBOS.stream().collect(Collectors.groupingBy(UocTacheButtonInfoBO::getTacheCode));
            Map<String, List<UocTacheButtonInfoBO>> subTacheCodeMap = uocTacheButtonInfoFuncBOS.stream().filter(uocTacheButton -> StringUtils.isNotBlank((CharSequence)uocTacheButton.getSubOrderStatusCode())).collect(Collectors.groupingBy(UocTacheButtonInfoBO::getSubOrderStatusCode));
            Map<String, List<UocTacheButtonInfoBO>> statusMap = uocTacheButtonInfoFuncBOS.stream().filter(uocTacheButton -> StringUtils.isNotBlank((CharSequence)uocTacheButton.getOrderStatus())).collect(Collectors.groupingBy(UocTacheButtonInfoBO::getOrderStatus));
            ArrayList defaultButtonList = tacheCodeMap.get(DEFAULT);
            List defaultButtonBos = (CollectionUtils.isEmpty(defaultButtonList) ? new ArrayList() : defaultButtonList).stream().map(uocButtonFuncBo -> {
                DycUocButtonBo dycUocButtonBo = new DycUocButtonBo();
                dycUocButtonBo.setMenuCode(uocButtonFuncBo.getMenuCode());
                dycUocButtonBo.setMenuDesc(uocButtonFuncBo.getMenuDesc());
                dycUocButtonBo.setUri(uocButtonFuncBo.getUri());
                return dycUocButtonBo;
            }).collect(Collectors.toList());
            Map<String, Map<String, Long>> effConfMap = this.getConf();
            rows.forEach(dycUocOrderInfoBO -> {
                ArrayList dycUocButtonBos = new ArrayList(defaultButtonBos);
                if (StringUtils.isNotBlank((CharSequence)dycUocOrderInfoBO.getOrderState())) {
                    List tacheButtonInfoFuncBOS = (List)statusMap.get(dycUocOrderInfoBO.getOrderState());
                    if (!CollectionUtil.isEmpty((Collection)tacheButtonInfoFuncBOS)) {
                        dycUocButtonBos.addAll(tacheButtonInfoFuncBOS.stream().map(uocButtonFuncBo -> {
                            DycUocButtonBo dycUocButtonBo = new DycUocButtonBo();
                            dycUocButtonBo.setMenuCode(uocButtonFuncBo.getMenuCode());
                            dycUocButtonBo.setMenuDesc(uocButtonFuncBo.getMenuDesc());
                            dycUocButtonBo.setUri(uocButtonFuncBo.getUri());
                            return dycUocButtonBo;
                        }).collect(Collectors.toList()));
                    }
                } else if (!CollectionUtil.isEmpty(dycUocOrderInfoBO.getBusiTaskInstBos())) {
                    for (DycUocTaskInstInfoBO busiTaskInstBo : dycUocOrderInfoBO.getBusiTaskInstBos()) {
                        List uocButtonFuncBos = (List)tacheCodeMap.get(busiTaskInstBo.getTacheCode());
                        if (CollectionUtil.isEmpty((Collection)uocButtonFuncBos)) continue;
                        dycUocButtonBos.addAll(uocButtonFuncBos.stream().map(uocButtonFuncBo -> {
                            DycUocButtonBo dycUocButtonBo = new DycUocButtonBo();
                            dycUocButtonBo.setMenuCode(uocButtonFuncBo.getMenuCode());
                            dycUocButtonBo.setMenuDesc(uocButtonFuncBo.getMenuDesc());
                            dycUocButtonBo.setUri(uocButtonFuncBo.getUri());
                            return dycUocButtonBo;
                        }).collect(Collectors.toList()));
                    }
                }
                dycUocOrderInfoBO.setButtons(dycUocButtonBos.stream().distinct().collect(Collectors.toList()));
                if (!CollectionUtils.isEmpty(dycUocOrderInfoBO.getButtons())) {
                    dycUocOrderInfoBO.getButtons().forEach(dycUocButtonBo -> {
                        if (null != dycUocButtonBo) {
                            dycUocButtonBo.setUri(ParseUrlParamUtil.calUri((String)dycUocButtonBo.getUri(), (Object)dycUocOrderInfoBO, (Map)buttonParamMap, this.buttonFormParams));
                        }
                    });
                }
                log.info("\u6574\u5355\u67e5\u8be2effConfMap\uff1a{}", (Object)effConfMap);
                List<DycUocOrderCommodityInfoBO> commodityInfos = dycUocOrderInfoBO.getCommodityInfos();
                dycUocOrderInfoBO.setStockAging(((DycUocOrderCommodityInfoBO)commodityInfos.stream().peek(commodityInfo -> {
                    Map stockEffMap;
                    if (!CollectionUtils.isEmpty((Map)effConfMap) && StringUtils.isNotBlank((CharSequence)commodityInfo.getSupplierId()) && null != (stockEffMap = (Map)effConfMap.get(EFFECTIVE_CODE_STOCK + commodityInfo.getSkuSource()))) {
                        Long time = (Long)stockEffMap.get(dycUocOrderInfoBO.getSupId());
                        if (null == time) {
                            time = (Long)stockEffMap.get("0");
                        }
                        commodityInfo.setStockAging(time);
                    }
                }).sorted(Comparator.comparing(DycUocOrderCommodityInfoBO::getStockAging)).collect(Collectors.toList()).get(0)).getStockAging());
            });
        } else {
            this.setAging(rows, reqBO);
        }
    }

    private void setAging(List<DycUocOrderInfoBO> rows, DycUocOrderListQryReqBO reqBO) {
        Map<String, Map<String, Long>> effConfMap = this.getConf();
        if (CollectionUtils.isEmpty(rows)) {
            return;
        }
        rows.forEach(dycUocOrderInfoBO -> {
            log.info("\u6574\u5355\u67e5\u8be2effConfMap\uff1a{}", (Object)effConfMap);
            List<DycUocOrderCommodityInfoBO> commodityInfos = dycUocOrderInfoBO.getCommodityInfos();
            dycUocOrderInfoBO.setStockAging(((DycUocOrderCommodityInfoBO)commodityInfos.stream().peek(commodityInfo -> {
                Map stockEffMap;
                if (!CollectionUtils.isEmpty((Map)effConfMap) && StringUtils.isNotBlank((CharSequence)commodityInfo.getSupplierId()) && null != (stockEffMap = (Map)effConfMap.get(EFFECTIVE_CODE_STOCK + commodityInfo.getSkuSource()))) {
                    Long time = (Long)stockEffMap.get(dycUocOrderInfoBO.getSupId());
                    if (null == time) {
                        time = (Long)stockEffMap.get("0");
                    }
                    commodityInfo.setStockAging(time);
                }
            }).sorted(Comparator.comparing(DycUocOrderCommodityInfoBO::getStockAging)).collect(Collectors.toList()).get(0)).getStockAging());
        });
    }

    private void setTabConf(DycUocOrderListQryReqBO reqBO, JSONObject reqJsonObj) {
        if (StringUtils.isNotBlank((CharSequence)reqBO.getMenuCode())) {
            DycTabTacheCodeInfoFuncBO dycTabTacheCodeInfoFuncBO;
            List dycTabTacheCodeInfoFuncBOS;
            List<DycTabTacheCodeInfoFuncBO> dycTabTacheCodeInfoFuncBOList = this.qryTab(reqBO.getMenuCode());
            if (CollectionUtils.isEmpty(dycTabTacheCodeInfoFuncBOList)) {
                return;
            }
            ConcurrentMap<Integer, List<DycTabTacheCodeInfoFuncBO>> tabTachCodeMap = dycTabTacheCodeInfoFuncBOList.stream().collect(Collectors.groupingByConcurrent(DycTabTacheCodeInfoFuncBO::getTabId));
            if (StringUtils.isBlank((CharSequence)reqBO.getTabId())) {
                reqBO.setTabId(Convert.toStr((Object)dycTabTacheCodeInfoFuncBOList.get(0).getTabId()));
            }
            if (!CollectionUtils.isEmpty((Collection)(dycTabTacheCodeInfoFuncBOS = (List)tabTachCodeMap.get(Convert.toInt((Object)reqBO.getTabId())))) && StringUtils.isNotBlank((CharSequence)(dycTabTacheCodeInfoFuncBO = (DycTabTacheCodeInfoFuncBO)dycTabTacheCodeInfoFuncBOS.get(0)).getParamJson())) {
                JSONObject paramJsonObj = JSON.parseObject((String)dycTabTacheCodeInfoFuncBO.getParamJson());
                reqJsonObj.putAll((Map)paramJsonObj);
            }
            ArrayList<DycUocTabQueryCountBO> tabQueryCountBos = new ArrayList<DycUocTabQueryCountBO>();
            tabTachCodeMap.forEach((key, value) -> {
                if (!CollectionUtils.isEmpty((Collection)value)) {
                    DycTabTacheCodeInfoFuncBO dycTabTacheCodeInfoFuncBO = (DycTabTacheCodeInfoFuncBO)value.get(0);
                    DycUocTabQueryCountBO dycUocTabQueryCountBO = new DycUocTabQueryCountBO();
                    dycUocTabQueryCountBO.setTabId(key.longValue());
                    dycUocTabQueryCountBO.setTabName(dycTabTacheCodeInfoFuncBO.getTabName());
                    dycUocTabQueryCountBO.setTabCodes(dycTabTacheCodeInfoFuncBO.getTacheCodes());
                    dycUocTabQueryCountBO.setTabStatus(dycTabTacheCodeInfoFuncBO.getTabStatusList());
                    dycUocTabQueryCountBO.setTabSubCodes(dycTabTacheCodeInfoFuncBO.getSubTacheCodes());
                    dycUocTabQueryCountBO.setTabDoneSubCodes(dycTabTacheCodeInfoFuncBO.getDoneTacheCodeList());
                    dycUocTabQueryCountBO.setParamJson(dycTabTacheCodeInfoFuncBO.getParamJson());
                    dycUocTabQueryCountBO.setSort(dycTabTacheCodeInfoFuncBO.getSort());
                    tabQueryCountBos.add(dycUocTabQueryCountBO);
                }
            });
            reqBO.setTabQueryCountBos(tabQueryCountBos);
        }
    }

    private List<DycTabTacheCodeInfoFuncBO> qryTab(String menuCode) {
        DycTabTacheCodeQryFuncReqBO dycTabTacheCodeQryFuncReqBO = new DycTabTacheCodeQryFuncReqBO();
        dycTabTacheCodeQryFuncReqBO.setMenuCode(menuCode);
        DycTabTacheCodeQryFuncRspBO dycTabTacheCodeQryFuncRspBO = this.dycTabTacheCodeQryFunction.qryTabTacheCode(dycTabTacheCodeQryFuncReqBO);
        return dycTabTacheCodeQryFuncRspBO.getRows();
    }

    private Map<String, Map<String, Long>> getConf() {
        UocProOrderEffectiveListPageQueryReqBo dycUocProOrderEffectiveListPageQueryFuncReqBo = new UocProOrderEffectiveListPageQueryReqBo();
        dycUocProOrderEffectiveListPageQueryFuncReqBo.setPageNo(-1);
        dycUocProOrderEffectiveListPageQueryFuncReqBo.setPageSize(-1);
        UocProOrderEffectiveListPageQueryRspBo dycUocProOrderEffectiveListPageQueryFuncRspBo = this.uocProOrderEffectivePageQueryService.queryOrderEffectiveListPage(dycUocProOrderEffectiveListPageQueryFuncReqBo);
        if (CollectionUtils.isEmpty((Collection)dycUocProOrderEffectiveListPageQueryFuncRspBo.getRows())) {
            return new HashMap<String, Map<String, Long>>();
        }
        Map<String, List<UocProOrderEffectiveInfoBo>> effListMap = dycUocProOrderEffectiveListPageQueryFuncRspBo.getRows().stream().collect(Collectors.groupingBy(e -> e.getEffectiveCode() + e.getBusinessTypeCode()));
        HashMap<String, Map<String, Long>> map = new HashMap<String, Map<String, Long>>();
        effListMap.forEach((key, value) -> map.put((String)key, value.stream().collect(Collectors.toMap(UocProOrderEffectiveInfoBo::getSupplierNo, UocProOrderEffectiveInfoBo::getAging))));
        return map;
    }
}

