/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.atom.busicommon.impl;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.atom.busicommon.api.DycPingAnRefundOnlinePaymentFunction;
import com.tydic.dyc.atom.busicommon.bo.DycPingAnExtendData;
import com.tydic.dyc.atom.busicommon.bo.DycPingAnRefundOnlinePaymentReqBO;
import com.tydic.dyc.atom.busicommon.bo.DycPingAnRefundOnlinePaymentRspBO;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class DycPingAnRefundOnlinePaymentFunctionImpl
implements DycPingAnRefundOnlinePaymentFunction {
    private static final Logger log = LoggerFactory.getLogger(DycPingAnRefundOnlinePaymentFunctionImpl.class);
    @Value(value="${ESB_REFUND_PAYMENT_ORDER_URL}")
    private String esbRefundPaymentOrderUrl;

    @Override
    public DycPingAnRefundOnlinePaymentRspBO refundOnlinePayment(DycPingAnRefundOnlinePaymentReqBO reqBO) {
        DycPingAnRefundOnlinePaymentRspBO rspBO = new DycPingAnRefundOnlinePaymentRspBO();
        this.checkParam(reqBO);
        log.info("\u5728\u7ebf\u652f\u4ed8\u9000\u6b3e\u8bf7\u6c42:{}", (Object)reqBO);
        String res = HttpUtil.post((String)this.esbRefundPaymentOrderUrl, (String)JSON.toJSONString((Object)reqBO));
        log.info("\u5728\u7ebf\u652f\u4ed8\u9000\u6b3e\u8fd4\u56de:{}", (Object)res);
        if (StringUtils.isBlank((CharSequence)res)) {
            throw new ZTBusinessException("\u5728\u7ebf\u652f\u4ed8\u9000\u6b3e\u63a5\u53e3\u8c03\u7528\u5931\u8d25");
        }
        JSONObject jsonObject = JSON.parseObject((String)res);
        Object dataObj = jsonObject.get((Object)"Data");
        if (dataObj != null) {
            rspBO = (DycPingAnRefundOnlinePaymentRspBO)((Object)JSON.parseObject((String)dataObj.toString(), (TypeReference)new TypeReference<DycPingAnRefundOnlinePaymentRspBO>(){}, (Feature[])new Feature[0]));
        } else {
            dataObj = jsonObject.get((Object)"ExtendData");
            if (dataObj == null) {
                log.error("\u5728\u7ebf\u652f\u4ed8\u9000\u6b3e\u5931\u8d25:{}", (Object)res);
                throw new ZTBusinessException("\u5728\u7ebf\u652f\u4ed8\u9000\u6b3e\u5931\u8d25");
            }
            DycPingAnExtendData data = (DycPingAnExtendData)JSON.parseObject((String)dataObj.toString(), (TypeReference)new TypeReference<DycPingAnExtendData>(){}, (Feature[])new Feature[0]);
            rspBO.setTxnReturnMsg(data.getTxnReturnMsg());
            rspBO.setTxnReturnCode(data.getTxnReturnCode());
        }
        return rspBO;
    }

    private void checkParam(DycPingAnRefundOnlinePaymentReqBO reqBO) {
        if (reqBO == null) {
            throw new ZTBusinessException("\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getTraderNo())) {
            throw new ZTBusinessException("\u5546\u6237\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getOldMerOrderNo())) {
            throw new ZTBusinessException("\u5546\u6237\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getOldOrderSendTime())) {
            throw new ZTBusinessException("\u8ba2\u5355\u53d1\u9001\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

