/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.atom.common.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.dyc.atom.common.api.DycBusiProcessStartFunction;
import com.tydic.dyc.atom.common.bo.DycBusiProcessStartFuncReqBO;
import com.tydic.dyc.atom.common.bo.DycBusiProcessStartFuncRspBO;
import com.tydic.dyc.oc.service.common.UocWorkFlowFailLogDealService;
import com.tydic.dyc.oc.service.common.bo.UocWorkFlowFailLogDealReqBO;
import com.tydic.osworkflow.ability.OsworkflowStartProcAbilityService;
import com.tydic.osworkflow.ability.bo.StartWithInstanceReqBO;
import com.tydic.osworkflow.ability.bo.StartWithInstanceRespBO;
import java.util.Date;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
@Primary
public class DycBusiProcessStartFunctionExtImpl
implements DycBusiProcessStartFunction {
    private static final Logger log = LoggerFactory.getLogger(DycBusiProcessStartFunctionExtImpl.class);
    @Autowired
    private OsworkflowStartProcAbilityService osworkflowStartProcAbilityService;
    @Autowired
    private UocWorkFlowFailLogDealService uocWorkFlowFailLogDealService;
    @Resource(name="dycUocSendOsConsumerLogProvider")
    private ProxyMessageProducer proxyMessageProducer;
    @Value(value="${os.workflow.log.topic:OS_WORKFLOW_TOPIC}")
    private String osWorkflowTopic;
    @Value(value="${os.consumer.log.tag:OS_CONSUMER_LOG}")
    private String osWorkflowTag;

    public DycBusiProcessStartFuncRspBO startBusiProcess(DycBusiProcessStartFuncReqBO reqBO) {
        StartWithInstanceReqBO startWithInstanceReqBO = new StartWithInstanceReqBO();
        startWithInstanceReqBO.setVariables(reqBO.getVariables());
        startWithInstanceReqBO.setProcDefKey(reqBO.getProcDefKey());
        startWithInstanceReqBO.setPartitonKey(reqBO.getPartitonKey());
        startWithInstanceReqBO.setSysCode(reqBO.getSysCode());
        startWithInstanceReqBO.setSysTenantId(ObjectUtils.isEmpty((Object)reqBO.getSysTenantId()) ? "" : String.valueOf(reqBO.getSysTenantId()));
        startWithInstanceReqBO.setSysTenantName(reqBO.getSysTenantName());
        log.info("\u6269\u5c55\u8c03\u7528\u6d41\u7a0b\u4e2d\u5fc3\u5165\u53c2\u4e3a\uff1a" + JSON.toJSONString((Object)startWithInstanceReqBO));
        StartWithInstanceRespBO sartWithInstanceRespBO = this.osworkflowStartProcAbilityService.startWithInstanceByMq(startWithInstanceReqBO);
        log.info("\u6269\u5c55\u8c03\u7528\u6d41\u7a0b\u4e2d\u5fc3\u51fa\u53c2\u4e3a\uff1a" + JSON.toJSONString((Object)sartWithInstanceRespBO));
        if (!"0000".equals(sartWithInstanceRespBO.getRespCode())) {
            this.insertLog(startWithInstanceReqBO, sartWithInstanceRespBO);
            this.proxyMessageProducer.send(new ProxyMessage(this.osWorkflowTopic, this.osWorkflowTag, JSON.toJSONString((Object)startWithInstanceReqBO)));
            throw new ZTBusinessException("\u6d41\u7a0b\u542f\u52a8\u5931\u8d25,\u5f02\u5e38\u7f16\u7801\u3010" + sartWithInstanceRespBO.getRespCode() + "\u3011," + sartWithInstanceRespBO.getRespDesc());
        }
        return new DycBusiProcessStartFuncRspBO();
    }

    private void insertLog(StartWithInstanceReqBO startWithInstanceReqBO, StartWithInstanceRespBO sartWithInstanceRespBO) {
        UocWorkFlowFailLogDealReqBO uocWorkFlowFailLogDealReqBO = new UocWorkFlowFailLogDealReqBO();
        uocWorkFlowFailLogDealReqBO.setProcessKey(startWithInstanceReqBO.getProcDefKey());
        uocWorkFlowFailLogDealReqBO.setOperType("1");
        uocWorkFlowFailLogDealReqBO.setReqParam(JSON.toJSONString((Object)startWithInstanceReqBO));
        uocWorkFlowFailLogDealReqBO.setRspParam(JSON.toJSONString((Object)sartWithInstanceRespBO));
        uocWorkFlowFailLogDealReqBO.setCreateTime(new Date());
        uocWorkFlowFailLogDealReqBO.setFailDesc(sartWithInstanceRespBO.getRespDesc());
        this.uocWorkFlowFailLogDealService.insertFailLog(uocWorkFlowFailLogDealReqBO);
    }
}

