/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.atom.selfrun.impl;

import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.tydic.commodity.mall.ability.api.UccMallSpuOrderListQueryAbilityService;
import com.tydic.commodity.mall.ability.bo.UccMallSkuDetailInfoBO;
import com.tydic.commodity.mall.ability.bo.UccMallSkuOrderQryReqBO;
import com.tydic.commodity.mall.ability.bo.UccMallSpuOrderListQueryAbilityReqBO;
import com.tydic.commodity.mall.ability.bo.UccMallSpuOrderListQueryAbilityRspBO;
import com.tydic.commodity.mall.ability.bo.UccMallSpuOrderListQueryBO;
import com.tydic.dyc.atom.selfrun.api.DycUocCommodityBatchQryFunction;
import com.tydic.dyc.atom.selfrun.bo.DycUocCommodityBatchQryFuncBO;
import com.tydic.dyc.atom.selfrun.bo.DycUocCommodityBatchQryFuncReqBO;
import com.tydic.dyc.atom.selfrun.bo.DycUocCommodityBatchQryFuncRspBO;
import com.tydic.dyc.atom.selfrun.bo.DycUocCommodityFuncBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

@Service
@Primary
public class DycUocCommodityBatchQryFunctionExtImpl
implements DycUocCommodityBatchQryFunction {
    private static final Logger log = LoggerFactory.getLogger(DycUocCommodityBatchQryFunctionExtImpl.class);
    @Autowired
    private UccMallSpuOrderListQueryAbilityService uccMallSpuOrderListQueryAbilityService;

    public DycUocCommodityBatchQryFuncRspBO qryCommodityByBatch(DycUocCommodityBatchQryFuncReqBO reqBO) {
        DycUocCommodityBatchQryFuncRspBO rsp = new DycUocCommodityBatchQryFuncRspBO();
        UccMallSpuOrderListQueryAbilityReqBO uccMallSpuOrderListQueryAbilityReqBO = new UccMallSpuOrderListQueryAbilityReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)uccMallSpuOrderListQueryAbilityReqBO);
        List skuOrderList = JSON.parseArray((String)JSON.toJSONString((Object)reqBO.getCommodityBatchQryBos()), UccMallSkuOrderQryReqBO.class);
        uccMallSpuOrderListQueryAbilityReqBO.setSkuOrderList(skuOrderList);
        log.info("\u5546\u54c1\u4e2d\u5fc3\u67e5\u8be2\u5165\u53c2: {}", (Object)JSON.toJSONString((Object)skuOrderList));
        UccMallSpuOrderListQueryAbilityRspBO uccMallSpuOrderListQueryAbilityRspBO = this.uccMallSpuOrderListQueryAbilityService.querySpuOrderListInfo(uccMallSpuOrderListQueryAbilityReqBO);
        log.info("\u5546\u54c1\u4e2d\u5fc3\u67e5\u8be2\u51fa\u53c2: {}", (Object)JSON.toJSONString((Object)uccMallSpuOrderListQueryAbilityRspBO));
        if (!"0000".equals(uccMallSpuOrderListQueryAbilityRspBO.getRespCode())) {
            throw new ZTBusinessException("\u8c03\u7528\u5546\u54c1\u4e2d\u5fc3\u5546\u57ce\u4e0b\u5355\u5546\u54c1\u6570\u636e\u67e5\u8be2API\u5931\u8d25\uff1a" + uccMallSpuOrderListQueryAbilityRspBO.getRespDesc());
        }
        List<DycUocCommodityFuncBO> commodityBos = this.encapsulatedReference(reqBO.getCommodityBatchQryBos(), uccMallSpuOrderListQueryAbilityRspBO.getOrderSpuList());
        if (reqBO.getCommodityBatchQryBos().size() != commodityBos.size()) {
            throw new ZTBusinessException("\u6279\u91cf\u67e5\u8be2\u5546\u54c1\u4fe1\u606f\u8fd4\u56de\u7ed3\u679c\u6570\u91cf\u4e0d\u4e00\u81f4\uff01");
        }
        rsp.setCommodityBos(commodityBos);
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u4e0b\u5355\u5546\u54c1\u4fe1\u606f\u6279\u91cf\u67e5\u8be2\u6210\u529f\uff01");
        return rsp;
    }

    private List<DycUocCommodityFuncBO> encapsulatedReference(List<DycUocCommodityBatchQryFuncBO> commodityBatchQryBos, List<UccMallSpuOrderListQueryBO> orderSpuList) {
        Map reqSkuCommodityMap = commodityBatchQryBos.stream().collect(Collectors.toMap(DycUocCommodityBatchQryFuncBO::getSkuId, Function.identity()));
        ArrayList<DycUocCommodityFuncBO> commodityBos = new ArrayList<DycUocCommodityFuncBO>();
        for (UccMallSpuOrderListQueryBO bo : orderSpuList) {
            for (UccMallSkuDetailInfoBO bo2 : bo.getOrderSkuList()) {
                Long reqSalePrice = this.bTwol(((DycUocCommodityBatchQryFuncBO)reqSkuCommodityMap.get(bo2.getSkuId())).getSalePrice());
                if (!bo2.getSalePrice().equals(reqSalePrice)) {
                    throw new ZTBusinessException(bo2.getSkuId() + "\u5165\u53c2\u4ef7\u683c\u548c\u5546\u54c1\u4e2d\u5fc3\u8fd4\u56de\u4ef7\u683c\u4e0d\u4e00\u81f4\uff01");
                }
                DycUocCommodityFuncBO dycUocCommodityFuncBO = new DycUocCommodityFuncBO();
                dycUocCommodityFuncBO.setSkuId(bo2.getSkuId().toString());
                dycUocCommodityFuncBO.setSkuCode(bo2.getSkuCode());
                dycUocCommodityFuncBO.setSkuName(bo2.getSkuName());
                dycUocCommodityFuncBO.setCommodityId(Convert.toStr((Object)bo2.getCommodityId()));
                dycUocCommodityFuncBO.setCommodityName(bo.getCommodityName());
                dycUocCommodityFuncBO.setCommodityTypeId(Convert.toStr((Object)bo2.getCommodityTypeId()));
                dycUocCommodityFuncBO.setCommodityTypeName(bo2.getCommodityTypeName());
                dycUocCommodityFuncBO.setSupId(Convert.toStr((Object)bo.getVendorId()));
                dycUocCommodityFuncBO.setSupNo(null);
                dycUocCommodityFuncBO.setSupplierShopId(Convert.toStr((Object)bo2.getSupplierShopId()));
                dycUocCommodityFuncBO.setSupplierShopName(bo2.getShopName());
                dycUocCommodityFuncBO.setPurchasePrice(this.lTwob(bo2.getAgreementPrice()));
                dycUocCommodityFuncBO.setSalePrice(this.lTwob(bo2.getSalePrice()));
                dycUocCommodityFuncBO.setPurchaseCount(((DycUocCommodityBatchQryFuncBO)reqSkuCommodityMap.get(bo2.getSkuId())).getNum());
                dycUocCommodityFuncBO.setSkuSource(bo2.getSkuSource());
                dycUocCommodityFuncBO.setTransFee(null);
                dycUocCommodityFuncBO.setUnitName(bo2.getMeasureName());
                dycUocCommodityFuncBO.setSettleUnit(bo2.getSettlementUnit());
                dycUocCommodityFuncBO.setMarkUpRate(null);
                dycUocCommodityFuncBO.setPlanNo(null);
                dycUocCommodityFuncBO.setPlanItemNo(null);
                dycUocCommodityFuncBO.setTaxPrice(null);
                dycUocCommodityFuncBO.setTax(Convert.toStr((Object)bo.getRate()));
                dycUocCommodityFuncBO.setExtSkuId(bo2.getExtSkuId());
                dycUocCommodityFuncBO.setSkuMaterialId(Convert.toStr((Object)bo2.getMaterialId()));
                dycUocCommodityFuncBO.setSkuMaterialCode(Convert.toStr((Object)bo2.getMaterialCode()));
                dycUocCommodityFuncBO.setSkuBrandId(Convert.toStr((Object)bo2.getBrandId()));
                dycUocCommodityFuncBO.setSkuBrandName(bo2.getBrandName());
                dycUocCommodityFuncBO.setSkuMaterialName(bo2.getMaterialName());
                dycUocCommodityFuncBO.setSkuMaterialTypeName(bo2.getCatalogName());
                dycUocCommodityFuncBO.setSkuMaterialTypeId(Convert.toStr((Object)bo2.getCatalogId()));
                dycUocCommodityFuncBO.setModel(bo2.getModel());
                dycUocCommodityFuncBO.setSpec(bo2.getSpec());
                dycUocCommodityFuncBO.setRejectAllowDate(bo.getRejectAllowDate());
                dycUocCommodityFuncBO.setExchangeAllowDate(bo.getExchangeAllowDate());
                dycUocCommodityFuncBO.setMaintainAllowDate(bo.getMaintainAllowDate());
                dycUocCommodityFuncBO.setSkuMainPicUrl(bo2.getSkuMainPic());
                dycUocCommodityFuncBO.setAgreementId(Convert.toStr((Object)bo2.getAgreementId()));
                dycUocCommodityFuncBO.setCommodityCode(bo.getCommodityCode());
                dycUocCommodityFuncBO.setJdCz(bo2.getIsFactoryShip());
                commodityBos.add(dycUocCommodityFuncBO);
            }
        }
        return commodityBos;
    }

    private BigDecimal lTwob(Long money) {
        BigDecimal price = null;
        try {
            price = MoneyUtils.Long2BigDecimal((Long)money);
        }
        catch (Exception e) {
            throw new ZTBusinessException("\u91d1\u989d\u8f6c\u6362\u9519\u8bef\uff01");
        }
        return price;
    }

    private Long bTwol(BigDecimal money) {
        Long price = null;
        try {
            price = MoneyUtils.BigDecimal2Long((BigDecimal)money);
        }
        catch (Exception e) {
            throw new ZTBusinessException("\u91d1\u989d\u8f6c\u6362\u9519\u8bef\uff01");
        }
        return price;
    }
}

