package com.tydic.dyc.ssc.service.procinst;

import cn.hutool.core.collection.CollectionUtil;
import com.tydic.dyc.ssc.model.auditorder.ISscAuditOrderModel;
import com.tydic.dyc.ssc.model.auditorder.SscAuditOrderDo;
import com.tydic.dyc.ssc.model.auditorder.qrybo.SscAuditOrderQryBo;
import com.tydic.dyc.ssc.model.auditorder.sub.UocApprovalObj;
import com.tydic.dyc.ssc.model.procinst.ISscProcInstModel;
import com.tydic.dyc.ssc.model.procinst.SscProcInstDo;
import com.tydic.dyc.ssc.service.procinst.bo.SscGetProcInstListReqBO;
import com.tydic.dyc.ssc.service.procinst.bo.SscGetProcInstListRspBO;
import com.tydic.dyc.ssc.service.procinst.bo.SscProcInstBO;
import com.tydic.dyc.ssc.utils.SscRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.stream.Collectors;

/**
 * 标题:SscGetProcInstListServiceImpl
 * 说明:TODO
 * 时间:2023/3/13 16:26
 * 作者:代愿愿
 */
@HTServiceImpl
public class SscGetProcInstListServiceImpl implements SscGetProcInstListService {
    @Autowired
    private ISscProcInstModel iSscProcInstModel;
    @Autowired
    private ISscAuditOrderModel iSscAuditOrderModel;
    @Override
    public SscGetProcInstListRspBO getProcInstList(SscGetProcInstListReqBO sscGetProcInstListReqBO) {
        SscGetProcInstListRspBO rspBO = SscRu.success(SscGetProcInstListRspBO.class);

        // 查询审批单信息
        SscAuditOrderDo auditOrderDo = getSscAuditOrderDo(sscGetProcInstListReqBO);
        List<UocApprovalObj> approvalObjList = auditOrderDo.getUocApprovalObj();
        if (CollectionUtil.isEmpty(approvalObjList)) {
            return rspBO;
        }

        // 根据审批单id(auditOrderId)查询流程实例id
        SscProcInstDo sscProcInstDo = SscRu.js(sscGetProcInstListReqBO,SscProcInstDo.class);
        sscProcInstDo.setObjIdList(approvalObjList.stream().map(UocApprovalObj::getAuditOrderId).collect(Collectors.toList()));
        SscProcInstDo sscProcInstDo1 = iSscProcInstModel.getProcInstList(sscProcInstDo);
        if(!CollectionUtils.isEmpty(sscProcInstDo1.getSscUocOrderProcInst())){
            rspBO.setRows(SscRu.jsl(sscProcInstDo1.getSscUocOrderProcInst(), SscProcInstBO.class));
        }
        return rspBO;
    }

    private SscAuditOrderDo getSscAuditOrderDo(SscGetProcInstListReqBO sscGetProcInstListReqBO) {
        SscAuditOrderQryBo sscAuditOrderQryBo = new SscAuditOrderQryBo();
        sscAuditOrderQryBo.setOrderId(sscGetProcInstListReqBO.getOrderId());
        sscAuditOrderQryBo.setObjId(sscGetProcInstListReqBO.getObjId());
        sscAuditOrderQryBo.setObjVersion(sscGetProcInstListReqBO.getObjVersion());
        return this.iSscAuditOrderModel.getAuditObj(sscAuditOrderQryBo);
    }
}
