package com.tydic.dyc.ssc.service.scheme;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.bo.BaseExtendFieldBo;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.ssc.constant.SscCommConstant;
import com.tydic.dyc.ssc.constant.SscRspConstant;
import com.tydic.dyc.ssc.model.common.ISscCommonModel;
import com.tydic.dyc.ssc.model.common.SscCommonDo;
import com.tydic.dyc.ssc.model.common.sub.SscExtInfo;
import com.tydic.dyc.ssc.model.common.sub.SscExtObjInfo;
import com.tydic.dyc.ssc.model.scheme.ISscSchemeModel;
import com.tydic.dyc.ssc.model.scheme.qrybo.SchemeInviteSupBO;
import com.tydic.dyc.ssc.model.scheme.qrybo.SscQrySchemeInviteSupListReqBO;
import com.tydic.dyc.ssc.model.scheme.qrybo.SscQrySchemeInviteSupListRspBO;
import com.tydic.dyc.ssc.service.scheme.bo.*;
import com.tydic.dyc.ssc.utils.SscRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 标题：SscQrySchemeInviteSupListServiceImpl
 * 时间：2022/11/11
 * 说明：方案明细邀请供应商查询服务
 *
 * @author wukb
 */
@HTServiceImpl
public class SscQrySchemeInviteSupListServiceImpl implements SscQrySchemeInviteSupListService {

    @Autowired
    private ISscSchemeModel iSscSchemeModel;

    @Autowired
    private ISscCommonModel iSscCommonModel;

    @Override
    public SscQrySchemeInviteSupListPageRspBO qrySchemeInviteSupList(SscQrySchemeInviteSupListPageReqBO reqBO) {
        //1 参数校验
        validationParam(reqBO);
        //2 组装入参
        SscQrySchemeInviteSupListReqBO schemeInviteSupListReqBO = SscRu.js(reqBO, SscQrySchemeInviteSupListReqBO.class);
        //3 方案邀请供应商分页查询
        SscQrySchemeInviteSupListRspBO sscQrySchemeInviteSupListRspBO = iSscSchemeModel.qrySchemeInviteSupList(schemeInviteSupListReqBO);
        // 设置扩展字段信息
        this.setExtInfo(sscQrySchemeInviteSupListRspBO, reqBO.getEnableDraft(), reqBO);
        //4 返回结果
        SscQrySchemeInviteSupListPageRspBO rspBO = SscRu.js(sscQrySchemeInviteSupListRspBO, SscQrySchemeInviteSupListPageRspBO.class);
        rspBO.setRespCode(SscRspConstant.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(SscRspConstant.RSP_DESC_SUCCESS);
        return rspBO;
    }


    private void validationParam(SscQrySchemeInviteSupListPageReqBO reqBO) {
        if (reqBO == null) {
            throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "入参对象[SscQrySchemeInviteSupListPageReqBO]不能为空");
        }
        if (reqBO.getPageNo() == null) {
            throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "入参对象[pageNo]不能为空");
        }
        if (reqBO.getPageSize() == null) {
            throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "入参对象[pageSize]不能为空");
        }
        if (reqBO.getEnableDraft() == null) {
            throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "入参对象[enableDraft]不能为空");
        }
    }

    private void setExtInfo(SscQrySchemeInviteSupListRspBO rspBO, Boolean enableDraft,  SscQrySchemeInviteSupListPageReqBO reqBO) {
        List<SchemeInviteSupBO> rows = rspBO.getRows();
        if (CollectionUtil.isNotEmpty(rows)) {
            SscCommonDo sscCommonDo = new SscCommonDo();
            List<SscExtObjInfo> objInfoList = rows.stream().map(e -> {
                SscExtObjInfo objInfo = new SscExtObjInfo();
                objInfo.setOrderId(e.getSchemeId());
                if (ObjectUtil.isNotNull(reqBO.getSchemeHisId())) {
                    objInfo.setObjId(e.getSchemeInviteSupHisId());
                    objInfo.setObjType(SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_INVITE_SUP_HIS_EXT);
                } else if (enableDraft) {
                    objInfo.setObjId(e.getSchemeInviteSupId());
                    objInfo.setObjType(SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_INVITE_SUP_EXT_DRAFT);
                } else {
                    objInfo.setObjId(e.getSchemeInviteSupId());
                    objInfo.setObjType(SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_INVITE_SUP_EXT);
                }
                return objInfo;
            }).collect(Collectors.toList());
            sscCommonDo.setExtObjInfos(objInfoList);
            SscCommonDo qryExtInfo = this.iSscCommonModel.qryExtInfo(sscCommonDo);
            List<SscExtObjInfo> resultList = qryExtInfo.getExtObjInfos();
            if (CollectionUtil.isNotEmpty(resultList)) {
                Map<Long, List<SscExtInfo>> objIdExtInfoMap = resultList.stream().collect(Collectors.toMap(SscExtObjInfo::getObjId, SscExtObjInfo::getExtInfo));
                rows.forEach(e -> e.setExtFields(SscRu.jsl(objIdExtInfoMap.get(ObjectUtil.isNotNull(reqBO.getSchemeHisId()) ? e.getSchemeInviteSupHisId() : e.getSchemeInviteSupId()), BaseExtendFieldBo.class)));
            }
        }
    }


}
