package com.tydic.dyc.ssc.service.scheme;

import com.tydic.dyc.ssc.constant.SscCommConstant;
import com.tydic.dyc.ssc.model.procinst.ISscProcInstModel;
import com.tydic.dyc.ssc.model.procinst.SscProcInstDo;
import com.tydic.dyc.ssc.model.procinst.sub.UocOrderTaskInst;
import com.tydic.dyc.ssc.service.scheme.bo.SscQrySchemeDetailRspBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscRecallSchemeReqBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscRecallSchemeRspBO;
import com.tydic.dyc.ssc.utils.SscRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 类名：SscRecallSchemeServiceImpl
 * 说明：方案撤回服务
 * 时间：2022/11/14
 * 作者：hechenze
 */
@HTServiceImpl
public class SscRecallSchemeServiceImpl implements SscRecallSchemeService{
    @Autowired
    private ISscProcInstModel iSscProcInstModel;

    @Override
    public SscRecallSchemeRspBO recallScheme(SscRecallSchemeReqBO sscRecallSchemeReqBO) {
        SscRecallSchemeRspBO rspBO = SscRu.success(SscRecallSchemeRspBO.class);
        SscProcInstDo instDo = new SscProcInstDo();
        List<UocOrderTaskInst> sscUocOrderTaskInsts = new ArrayList<>();
        UocOrderTaskInst uocOrderTaskInst = new UocOrderTaskInst();
        uocOrderTaskInst.setFinishTag(SscCommConstant.PROC_TASK_FINISHED.FINISHED);
        uocOrderTaskInst.setFinishTime(new Date());
        uocOrderTaskInst.setDealOperId(sscRecallSchemeReqBO.getUserId());
        uocOrderTaskInst.setDealOperName(sscRecallSchemeReqBO.getName());
        uocOrderTaskInst.setOrderId(sscRecallSchemeReqBO.getSchemeId());
        uocOrderTaskInst.setTaskInstId(sscRecallSchemeReqBO.getTaskId());
        uocOrderTaskInst.setObjId(sscRecallSchemeReqBO.getSchemeId());
        uocOrderTaskInst.setObjType(1);
        sscUocOrderTaskInsts.add(uocOrderTaskInst);
        instDo.setSscUocOrderTaskInst(sscUocOrderTaskInsts);
        iSscProcInstModel.updateTask(instDo);
        return rspBO;
    }
}
