package com.tydic.dyc.ssc.service.scheme;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.base.utils.JUtil;
import com.tydic.dyc.ssc.constant.SscRspConstant;
import com.tydic.dyc.ssc.model.scheme.ISscSchemeModel;
import com.tydic.dyc.ssc.model.scheme.SscSchemeDo;
import com.tydic.dyc.ssc.service.scheme.bo.SscSchemeChangeReqBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscSchemeChangeRspBO;
import com.tydic.dyc.ssc.utils.SscRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * @Description: SscSchemeChangeServiceImpl
 * @Author: the_xhl
 * @Date: 2023-01-16
 */
@HTServiceImpl
public class SscSchemeChangeServiceImpl implements SscSchemeChangeService{

    @Autowired
    private ISscSchemeModel iSscSchemeModel;

    @Override
    public SscSchemeChangeRspBO dealSchemeChange(SscSchemeChangeReqBO sscSchemeChangeReqBO) {
        SscSchemeChangeRspBO rspBO = SscRu.success(SscSchemeChangeRspBO.class);
        check(sscSchemeChangeReqBO);
        iSscSchemeModel.dealSchemeChange(JUtil.js(sscSchemeChangeReqBO, SscSchemeDo.class));
        return rspBO;
    }

    private void check(SscSchemeChangeReqBO reqBO) {
        if (ObjectUtil.isNull(reqBO.getSchemeId())) {
            throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "入参对象属性[schemeId]不能为空");
        }
    }
}
