package com.tydic.dyc.ssc.service.scheme;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.bo.BaseExtendFieldBo;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.ssc.constant.SscCommConstant;
import com.tydic.dyc.ssc.constant.SscRspConstant;
import com.tydic.dyc.ssc.model.common.ISscCommonModel;
import com.tydic.dyc.ssc.model.common.SscCommonDo;
import com.tydic.dyc.ssc.model.common.sub.SscExtInfo;
import com.tydic.dyc.ssc.model.common.sub.SscExtObjInfo;
import com.tydic.dyc.ssc.model.scheme.ISscSchemeModel;
import com.tydic.dyc.ssc.model.scheme.SscSchemeDo;
import com.tydic.dyc.ssc.model.scheme.sub.SscSchemePack;
import com.tydic.dyc.ssc.service.scheme.bo.SscUpdatePackMainReqBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscUpdatePackMainRspBO;
import com.tydic.dyc.ssc.utils.SscRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Collections;
import java.util.List;

/**
 * @Description: SscUpdatePackMainServiceImpl
 * @Author: the_xhl
 * @Date: 2023-03-13
 */
@HTServiceImpl
public class SscUpdatePackMainServiceImpl implements SscUpdatePackMainService {

    @Autowired
    private ISscSchemeModel iSscSchemeModel;

    @Autowired
    private ISscCommonModel iSscCommonModel;

    @Override
    public SscUpdatePackMainRspBO updatePackMain(SscUpdatePackMainReqBO sscUpdatePackMainReqBO) {
        check(sscUpdatePackMainReqBO);
        SscUpdatePackMainRspBO rspBO = SscRu.success(SscUpdatePackMainRspBO.class);
        SscSchemePack schemePack = SscRu.js(sscUpdatePackMainReqBO, SscSchemePack.class);
        SscSchemeDo sscSchemeDo = new SscSchemeDo();
        sscSchemeDo.setSscSchemePack(Collections.singletonList(schemePack));
        iSscSchemeModel.updatePackMain(sscSchemeDo);
        // 修改扩展字段信息
        this.updateExtInfo(sscUpdatePackMainReqBO);
        return rspBO;
    }

    private void check(SscUpdatePackMainReqBO reqBO) {
        if (ObjectUtil.isNull(reqBO.getPackId())) {
            throw new BaseBusinessException(SscRspConstant.RSP_CODE_SERVICE_EMPTY_ERROR, "入参对象[packId]为空");
        }
    }

    private void updateExtInfo(SscUpdatePackMainReqBO reqBO) {
        List<BaseExtendFieldBo> extFieldList = reqBO.getExtFields();
        if (CollectionUtil.isNotEmpty(extFieldList)) {
            SscCommonDo sscCommonDo = new SscCommonDo();
            SscExtObjInfo objInfo = new SscExtObjInfo();
            objInfo.setObjId(reqBO.getPackId());
            objInfo.setObjType(SscCommConstant.EXT_OBJ_TYPE.SSC_SCHEME_PACK_EXT);
            objInfo.setExtInfo(SscRu.jsl(extFieldList, SscExtInfo.class));
            sscCommonDo.setExtObjInfos(Collections.singletonList(objInfo));
            iSscCommonModel.updateExtInfo(sscCommonDo);
        }
    }
}
