/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.ssc.service.scheme;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.dyc.ssc.model.common.ISscCommonModel;
import com.tydic.dyc.ssc.model.common.SscCommonDo;
import com.tydic.dyc.ssc.model.common.sub.SscExtInfo;
import com.tydic.dyc.ssc.model.common.sub.SscExtObjInfo;
import com.tydic.dyc.ssc.model.scheme.ISscSchemeModel;
import com.tydic.dyc.ssc.model.scheme.SscSchemeDo;
import com.tydic.dyc.ssc.service.scheme.SscAddSchemeService;
import com.tydic.dyc.ssc.service.scheme.bo.SscAddSchemeReqBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscAddSchemeRspBO;
import com.tydic.dyc.ssc.utils.SscRu;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SSC_GROUP_DEV/3.0.0/com.tydic.dyc.ssc.service.scheme.SscAddSchemeService"})
public class SscAddSchemeServiceImpl
implements SscAddSchemeService {
    private static final Logger log = LoggerFactory.getLogger(SscAddSchemeServiceImpl.class);
    @Autowired
    private ISscSchemeModel iSscSchemeModel;
    @Autowired
    private ISscCommonModel iSscCommonModel;

    @PostMapping(value={"addScheme"})
    public SscAddSchemeRspBO addScheme(@RequestBody SscAddSchemeReqBO sscAddSchemeReqBO0) {
        log.info("\u65b9\u6848\u65b0\u589e\u5165\u53c2\u4fe1\u606f\u4e3a: {}", (Object)JSON.toJSONString((Object)sscAddSchemeReqBO0));
        SscAddSchemeRspBO rspBO = SscRu.success(SscAddSchemeRspBO.class);
        SscSchemeDo sscSchemeDo = SscRu.js(sscAddSchemeReqBO0, SscSchemeDo.class);
        this.iSscSchemeModel.addSchemeMain(sscSchemeDo);
        SscSchemeDo copyDo = new SscSchemeDo();
        copyDo.setSchemeId(sscAddSchemeReqBO0.getSchemeId());
        if (!Boolean.FALSE.equals(sscAddSchemeReqBO0.getDelFlag())) {
            this.iSscSchemeModel.copyScheme(copyDo);
        }
        this.addExtInfo(sscAddSchemeReqBO0);
        if (StrUtil.isNotEmpty((CharSequence)sscAddSchemeReqBO0.getPickerConfigNo())) {
            rspBO.setPickerConfigNo(sscAddSchemeReqBO0.getPickerConfigNo());
        }
        return rspBO;
    }

    public void addExtInfo(SscAddSchemeReqBO reqBO) {
        List sscSchemePack;
        List extFieldList = reqBO.getExtFields();
        ArrayList<SscExtObjInfo> extObjInfoList = new ArrayList<SscExtObjInfo>();
        if (CollectionUtil.isNotEmpty((Collection)extFieldList)) {
            SscExtObjInfo objInfo = new SscExtObjInfo();
            objInfo.setObjId(reqBO.getSchemeId());
            objInfo.setOrderId(reqBO.getSchemeId());
            objInfo.setObjType("ssc_scheme_ext");
            objInfo.setExtInfo(SscRu.jsl(extFieldList, SscExtInfo.class));
            extObjInfoList.add(objInfo);
        }
        if (CollectionUtil.isNotEmpty((Collection)(sscSchemePack = reqBO.getSscSchemePack()))) {
            List objInfoList = sscSchemePack.stream().filter(e -> CollectionUtil.isNotEmpty((Collection)e.getExtFields())).map(e -> {
                List extFields = e.getExtFields();
                SscExtObjInfo objInfo = new SscExtObjInfo();
                objInfo.setObjId(e.getPackId());
                objInfo.setOrderId(reqBO.getSchemeId());
                objInfo.setObjType("ssc_scheme_pack_ext");
                objInfo.setExtInfo(SscRu.jsl(extFields, SscExtInfo.class));
                return objInfo;
            }).collect(Collectors.toList());
            extObjInfoList.addAll(objInfoList);
        }
        SscCommonDo sscCommonDo = new SscCommonDo();
        sscCommonDo.setExtObjInfos(extObjInfoList);
        this.iSscCommonModel.addExtInfo(sscCommonDo);
    }
}

