/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.ssc.service.scheme;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.ssc.model.common.ISscCommonModel;
import com.tydic.dyc.ssc.model.common.SscCommonDo;
import com.tydic.dyc.ssc.model.common.sub.SscExtInfo;
import com.tydic.dyc.ssc.model.common.sub.SscExtObjInfo;
import com.tydic.dyc.ssc.model.scheme.ISscSchemeModel;
import com.tydic.dyc.ssc.model.scheme.SscSchemeDo;
import com.tydic.dyc.ssc.service.scheme.SscUpdatePackMainBatchService;
import com.tydic.dyc.ssc.service.scheme.bo.SscSchemePackBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscUpdatePackMainBatchReqBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscUpdatePackMainBatchRspBO;
import com.tydic.dyc.ssc.utils.SscRu;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SSC_GROUP_DEV/3.0.0/com.tydic.dyc.ssc.service.scheme.SscUpdatePackMainBatchService"})
public class SscUpdatePackMainBatchServiceImpl
implements SscUpdatePackMainBatchService {
    @Autowired
    private ISscSchemeModel iSscSchemeModel;
    @Autowired
    private ISscCommonModel iSscCommonModel;

    @PostMapping(value={"updateSchemeBatchMain"})
    public SscUpdatePackMainBatchRspBO updateSchemeBatchMain(@RequestBody SscUpdatePackMainBatchReqBO sscUpdatePackMainBatchReqBO) {
        this.check(sscUpdatePackMainBatchReqBO);
        SscUpdatePackMainBatchRspBO rspBO = SscRu.success(SscUpdatePackMainBatchRspBO.class);
        this.iSscSchemeModel.updatePackMain(SscRu.js(sscUpdatePackMainBatchReqBO, SscSchemeDo.class));
        this.updateExtInfo(sscUpdatePackMainBatchReqBO);
        return rspBO;
    }

    private void check(SscUpdatePackMainBatchReqBO reqBO) {
        if (CollectionUtil.isEmpty((Collection)reqBO.getSscSchemePack())) {
            throw new BaseBusinessException("291001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[sscSchemePack]\u4e3a\u7a7a");
        }
        SscSchemePackBO sscSchemePackBO = reqBO.getSscSchemePack().stream().filter(e -> ObjectUtil.isNull((Object)e.getPackId())).findAny().orElse(null);
        if (ObjectUtil.isNotNull((Object)sscSchemePackBO)) {
            throw new BaseBusinessException("291001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[packId]\u4e3a\u7a7a");
        }
    }

    private void updateExtInfo(SscUpdatePackMainBatchReqBO reqBO) {
        List sscSchemePack = reqBO.getSscSchemePack();
        SscCommonDo sscCommonDo = new SscCommonDo();
        List<SscExtObjInfo> packObjInfoList = sscSchemePack.stream().filter(e -> CollectionUtil.isNotEmpty((Collection)e.getExtFields())).map(e -> {
            SscExtObjInfo objInfo = new SscExtObjInfo();
            objInfo.setObjId(e.getPackId());
            objInfo.setObjType("ssc_scheme_pack_ext");
            objInfo.setExtInfo(SscRu.jsl(e.getExtFields(), SscExtInfo.class));
            return objInfo;
        }).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(packObjInfoList)) {
            sscCommonDo.setExtObjInfos(packObjInfoList);
            this.iSscCommonModel.updateExtInfo(sscCommonDo);
        }
    }
}

