/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.base.utils;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.file.FileClient;
import com.ohaotian.plugin.file.fastdfs.FastdfsFileInfo;
import com.tydic.commodity.base.utils.FileAppBo;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class OssUtils {
    private static final Logger log = LoggerFactory.getLogger(OssUtils.class);
    @Autowired
    private FileClient fileClient;
    private static final String PATH = "pesapp-common";
    @Value(value="${plugin.file.type}")
    private String fileType;
    @Value(value="${oss.fileUrl:}")
    private String ossFileUrl;
    @Value(value="${fastdfs.httpTrackerHttpPort:}")
    private String fastdfsHttpTrackerHttpPort;
    @Value(value="${fastdfs.trackerServers:}")
    private String fastdfsTrackerServers;
    @Value(value="${fastdfs.downloadUrl}")
    private String fastdfsDownloadUrl;

    public List<Map<String, String>> upload(File[] files) {
        if (files == null || files.length == 0) {
            return null;
        }
        ArrayList<FileAppBo> list = new ArrayList<FileAppBo>();
        for (File file : files) {
            FileInputStream inputStream = null;
            try {
                inputStream = new FileInputStream(file);
                String fileName = file.getName();
                String suffix = fileName.substring(fileName.lastIndexOf("."));
                byte[] bytes = new byte[((InputStream)inputStream).available()];
                ((InputStream)inputStream).read(bytes);
                FileAppBo comUocFileAppBO = new FileAppBo();
                comUocFileAppBO.setFile(bytes);
                comUocFileAppBO.setFileName(fileName);
                comUocFileAppBO.setFileType(suffix);
                list.add(comUocFileAppBO);
            }
            catch (Exception e) {
                throw new ZTBusinessException("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25");
            }
            finally {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (IOException e) {
                    log.debug("\u6587\u4ef6\u4e0a\u4f20\u5173\u95ed\u6d41\u5931\u8d25");
                }
            }
        }
        return this.upload(list);
    }

    private List<Map<String, String>> upload(List<FileAppBo> bos) {
        ArrayList<Map<String, String>> fileList = new ArrayList<Map<String, String>>();
        for (FileAppBo file : bos) {
            String fileUrl;
            ByteArrayInputStream inputStream = new ByteArrayInputStream(file.getFile());
            String fileName = UUID.randomUUID().toString().replaceAll("-", "") + file.getFileType();
            String path = this.fileClient.uploadFileByInputStream(PATH, fileName, (InputStream)inputStream);
            if ("OSS".equals(this.fileType)) {
                String httphead = "https://";
                if (path.endsWith(".jpg") || path.endsWith(".jpeg") || path.endsWith(".png")) {
                    httphead = "http://";
                }
                fileUrl = httphead + this.ossFileUrl + path;
            } else if ("FASTDFS".equals(this.fileType)) {
                FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)path);
                fileUrl = this.fastdfsDownloadUrl + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
            } else {
                throw new ZTBusinessException("\u6682\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u670d\u52a1\u5668\u7c7b\u578b");
            }
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("name", file.getFileName());
            map.put("url", fileUrl);
            fileList.add(map);
        }
        return fileList;
    }
}

