/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.base.utils;

import com.tydic.commodity.base.exception.BusinessException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;

public class FtpUtils {
    private static final Logger logger = LoggerFactory.getLogger(FtpUtils.class);
    public static final String DIR_NOT_EXIST = "\u8be5\u76ee\u5f55\u4e0d\u5b58\u5728";
    public static final String DIR_CONTAINS_NO_FILE = "\u8be5\u76ee\u5f55\u4e0b\u6ca1\u6709\u6587\u4ef6";
    @Value(value="${ftp.fileHost}")
    private String ftpAddress;
    @Value(value="${ftp.filePort}")
    private int ftpPort;
    @Value(value="${ftp.fileUser}")
    private String ftpUsername;
    @Value(value="${ftp.filePwd}")
    private String ftpPassword;
    private String basePath = "";
    private static String localCharset = "GBK";
    private static String serverCharset = "ISO-8859-1";
    private static final String CHARSET_UTF8 = "UTF-8";
    private static final String OPTS_UTF8 = "OPTS UTF8";
    private static final int BUFFER_SIZE = 0x400000;
    private static FTPClient ftpClient = null;
    public ArrayList<String> arFiles = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean downloadFiles(String ftpPath, String savePath) throws IOException {
        this.login(this.ftpAddress, this.ftpPort, this.ftpUsername, this.ftpPassword);
        if (ftpClient != null) {
            try {
                String path = FtpUtils.changeEncoding(this.basePath + ftpPath);
                if (!ftpClient.changeWorkingDirectory(path)) {
                    logger.error(this.basePath + ftpPath + DIR_NOT_EXIST);
                    boolean bl = Boolean.FALSE;
                    return bl;
                }
                ftpClient.enterLocalPassiveMode();
                String[] fs = ftpClient.listNames();
                if (fs == null || fs.length == 0) {
                    logger.error(this.basePath + ftpPath + DIR_CONTAINS_NO_FILE);
                    boolean bl = Boolean.FALSE;
                    return bl;
                }
                for (String ff : fs) {
                    String ftpName = new String(ff.getBytes(serverCharset), localCharset);
                    File file = new File(savePath + '/' + ftpName);
                    try (FileOutputStream os = new FileOutputStream(file);){
                        ftpClient.retrieveFile(ff, (OutputStream)os);
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
            }
            catch (IOException e) {
                logger.error("\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            }
            finally {
                this.closeConnect();
            }
        }
        return Boolean.TRUE;
    }

    private void login(String address, int port, String username, String password) {
        ftpClient = new FTPClient();
        try {
            ftpClient.connect(address, port);
            ftpClient.login(username, password);
            ftpClient.setFileType(2);
            ftpClient.setBufferSize(0x400000);
            int reply = ftpClient.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)reply)) {
                this.closeConnect();
                logger.error("FTP\u670d\u52a1\u5668\u8fde\u63a5\u5931\u8d25");
            }
        }
        catch (Exception e) {
            logger.error("FTP\u767b\u5f55\u5931\u8d25", (Throwable)e);
        }
    }

    private static String changeEncoding(String ftpPath) {
        String directory = null;
        try {
            if (FTPReply.isPositiveCompletion((int)ftpClient.sendCommand(OPTS_UTF8, "ON"))) {
                localCharset = CHARSET_UTF8;
            }
            directory = new String(ftpPath.getBytes(localCharset), serverCharset);
        }
        catch (Exception e) {
            logger.error("\u8def\u5f84\u7f16\u7801\u8f6c\u6362\u5931\u8d25", (Throwable)e);
        }
        return directory;
    }

    public void closeConnect() {
        if (ftpClient != null && ftpClient.isConnected()) {
            try {
                ftpClient.logout();
                ftpClient.disconnect();
            }
            catch (IOException e) {
                logger.error("\u5173\u95edFTP\u8fde\u63a5\u5931\u8d25", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkFileInFtp(String ftpPath, String fileName) {
        this.login(this.ftpAddress, this.ftpPort, this.ftpUsername, this.ftpPassword);
        if (ftpClient != null) {
            try {
                String path = FtpUtils.changeEncoding(this.basePath + ftpPath);
                if (!ftpClient.changeWorkingDirectory(path)) {
                    logger.error(this.basePath + ftpPath + DIR_NOT_EXIST);
                    boolean bl = Boolean.FALSE;
                    return bl;
                }
                ftpClient.enterLocalPassiveMode();
                String[] fs = ftpClient.listNames();
                if (fs == null || fs.length == 0) {
                    logger.error(this.basePath + ftpPath + DIR_CONTAINS_NO_FILE);
                    boolean bl = Boolean.FALSE;
                    return bl;
                }
                for (String ff : fs) {
                    String ftpName = new String(ff.getBytes(serverCharset), localCharset);
                    if (!ftpName.equals(fileName)) continue;
                    boolean bl = Boolean.TRUE;
                    return bl;
                }
            }
            catch (IOException e) {
                logger.error("\u8bf7\u6c42\u51fa\u9519", (Throwable)e);
            }
            finally {
                this.closeConnect();
            }
        }
        return Boolean.TRUE;
    }

    public boolean changeWorkingDirectory(String directory) {
        boolean flag = true;
        try {
            flag = ftpClient.changeWorkingDirectory(directory);
            if (flag) {
                System.out.println("\u8fdb\u5165\u6587\u4ef6\u5939" + directory + " \u6210\u529f\uff01");
            } else {
                System.out.println("\u8fdb\u5165\u6587\u4ef6\u5939" + directory + " \u5931\u8d25\uff01\u5f00\u59cb\u521b\u5efa\u6587\u4ef6\u5939");
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return flag;
    }

    public boolean CreateDirecroty(String remote) throws IOException {
        boolean success;
        block5: {
            success = true;
            String directory = remote + "/";
            if (directory.equalsIgnoreCase("/") || this.changeWorkingDirectory(new String(directory))) break block5;
            int start = 0;
            int end = 0;
            start = directory.startsWith("/") ? 1 : 0;
            end = directory.indexOf("/", start);
            String path = "";
            String paths = "";
            do {
                String subDirectory = new String(remote.substring(start, end).getBytes("GBK"), "iso-8859-1");
                if (!this.existFile(path = path + "/" + subDirectory)) {
                    if (this.makeDirectory(subDirectory)) {
                        this.changeWorkingDirectory(subDirectory);
                    } else {
                        System.out.println("\u521b\u5efa\u76ee\u5f55[" + subDirectory + "]\u5931\u8d25");
                        this.changeWorkingDirectory(subDirectory);
                    }
                } else {
                    this.changeWorkingDirectory(subDirectory);
                }
                paths = paths + "/" + subDirectory;
            } while ((end = directory.indexOf("/", start = end + 1)) > start);
        }
        return success;
    }

    public boolean existFile(String path) throws IOException {
        boolean flag = false;
        FTPFile[] ftpFileArr = ftpClient.listFiles(path);
        if (ftpFileArr.length > 0) {
            flag = true;
        }
        return flag;
    }

    public boolean makeDirectory(String dir) {
        boolean flag = true;
        try {
            flag = ftpClient.makeDirectory(dir);
            if (flag) {
                System.out.println("\u521b\u5efa\u6587\u4ef6\u5939" + dir + " \u6210\u529f\uff01");
            } else {
                System.out.println("\u521b\u5efa\u6587\u4ef6\u5939" + dir + " \u5931\u8d25\uff01");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> downLoadTableFile(String ftpPath, String savePath) {
        this.login(this.ftpAddress, this.ftpPort, this.ftpUsername, this.ftpPassword);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (ftpClient != null) {
            try {
                String path = FtpUtils.changeEncoding(this.basePath + "/" + ftpPath);
                if (!ftpClient.changeWorkingDirectory(path)) {
                    logger.error(this.basePath + "/" + ftpPath + DIR_NOT_EXIST);
                    resultMap.put("result", false);
                    HashMap<String, Object> hashMap = resultMap;
                    return hashMap;
                }
                ftpClient.enterLocalPassiveMode();
                String[] fs = ftpClient.listNames();
                if (fs == null || fs.length == 0) {
                    logger.error(this.basePath + "/" + ftpPath + DIR_CONTAINS_NO_FILE);
                    resultMap.put("result", false);
                    HashMap<String, Object> hashMap = resultMap;
                    return hashMap;
                }
                ArrayList<String> tableFileNameList = new ArrayList<String>();
                String tableDirName = savePath + "/" + ftpPath;
                File tableDirs = new File(tableDirName);
                if (!tableDirs.exists()) {
                    tableDirs.mkdirs();
                }
                for (String ff : fs) {
                    String ftpName = new String(ff.getBytes(serverCharset), localCharset);
                    File file = new File(tableDirName + "/" + ftpName);
                    tableFileNameList.add(tableDirName + "/" + ftpName);
                    try (FileOutputStream os = new FileOutputStream(file);){
                        ftpClient.retrieveFile(ff, (OutputStream)os);
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
                resultMap.put("fileNameList", tableFileNameList);
                resultMap.put("result", true);
                HashMap<String, Object> hashMap = resultMap;
                return hashMap;
            }
            catch (IOException e) {
                logger.error("\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            }
            finally {
                this.closeConnect();
            }
        }
        resultMap.put("result", false);
        return resultMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, File> downloadFilesToMap(String ftpPath, String savePath, List<String> fileNames) throws IOException {
        HashMap<String, File> map = new HashMap<String, File>();
        this.login(this.ftpAddress, this.ftpPort, this.ftpUsername, this.ftpPassword);
        if (ftpClient != null) {
            try {
                String path = FtpUtils.changeEncoding(this.basePath + ftpPath);
                if (!ftpClient.changeWorkingDirectory(path)) {
                    logger.error(this.basePath + ftpPath + DIR_NOT_EXIST);
                    HashMap<String, File> hashMap = new HashMap<String, File>();
                    return hashMap;
                }
                ftpClient.enterLocalPassiveMode();
                String[] fs = ftpClient.listNames();
                if (fs == null || fs.length == 0) {
                    logger.error(this.basePath + ftpPath + DIR_CONTAINS_NO_FILE);
                    HashMap<String, File> hashMap = new HashMap<String, File>();
                    return hashMap;
                }
                for (String ff : fs) {
                    String ftpName = new String(ff.getBytes(serverCharset), localCharset);
                    if (!CollectionUtils.isEmpty(fileNames) && !fileNames.contains(ftpName)) continue;
                    File file = File.createTempFile(ftpName.substring(0, ftpName.indexOf(".")), ftpName.substring(ftpName.indexOf(".")));
                    logger.info("\u4e34\u65f6\u6587\u4ef6\u6240\u5728\u7684\u672c\u5730\u8def\u5f84\uff1a" + file.getCanonicalPath());
                    try (FileOutputStream os = new FileOutputStream(file);){
                        ftpClient.retrieveFile(ff, (OutputStream)os);
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                    map.put(ftpName.substring(0, ftpName.indexOf(".")), file);
                }
            }
            catch (IOException e) {
                logger.error("\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            }
            finally {
                this.closeConnect();
            }
        }
        return map;
    }

    public void List(String pathName) throws IOException {
        if (pathName.startsWith("/") && pathName.endsWith("/")) {
            FTPFile[] files;
            this.login(this.ftpAddress, this.ftpPort, this.ftpUsername, this.ftpPassword);
            ftpClient.changeWorkingDirectory(pathName);
            for (FTPFile file : files = ftpClient.listFiles()) {
                if (file.isFile()) {
                    this.arFiles.add(file.getName());
                    continue;
                }
                if (!file.isDirectory() || ".".equals(file.getName()) || "..".equals(file.getName())) continue;
                this.List(pathName + file.getName() + "/");
            }
        }
    }

    public void List(String pathName, String ext) throws IOException {
        if (pathName.startsWith("/") && pathName.endsWith("/")) {
            FTPFile[] files;
            this.login(this.ftpAddress, this.ftpPort, this.ftpUsername, this.ftpPassword);
            ftpClient.changeWorkingDirectory(pathName);
            for (FTPFile file : files = ftpClient.listFiles()) {
                if (file.isFile()) {
                    if (!file.getName().endsWith(ext)) continue;
                    this.arFiles.add(pathName + file.getName());
                    continue;
                }
                if (!file.isDirectory() || ".".equals(file.getName()) || "..".equals(file.getName())) continue;
                this.List(pathName + file.getName() + "/", ext);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteFile(String pathname, List<String> fileList) {
        boolean flag = false;
        if (!ftpClient.isAvailable()) {
            this.login(this.ftpAddress, this.ftpPort, this.ftpUsername, this.ftpPassword);
        }
        try {
            int replyCode = ftpClient.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)replyCode)) {
                boolean bl = flag;
                return bl;
            }
            ftpClient.changeWorkingDirectory(pathname);
            if (FTPReply.isPositiveCompletion((int)ftpClient.sendCommand(OPTS_UTF8, "ON"))) {
                localCharset = CHARSET_UTF8;
            }
            ftpClient.setControlEncoding(localCharset);
            ftpClient.enterLocalPassiveMode();
            ftpClient.setFileType(2);
            for (String flie : fileList) {
                flie = new String(flie.getBytes(localCharset), serverCharset);
                ftpClient.dele(flie);
            }
            flag = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (ftpClient.isConnected()) {
                try {
                    ftpClient.logout();
                    ftpClient.disconnect();
                }
                catch (IOException iOException) {}
            }
        }
        return flag;
    }

    public static void main(String[] args) {
        FtpUtils ftpUtils = new FtpUtils();
        ftpUtils.ftpAddress = "172.16.100.36";
        ftpUtils.ftpPort = 21;
        ftpUtils.ftpUsername = "vsftpd";
        ftpUtils.ftpPassword = "JKH234Asdjjkd";
        String path = UUID.randomUUID().toString();
        try {
            Map<String, File> map = ftpUtils.downloadFilesToMap("/home/vsftpd/vsftpd/upload/ucc", "C:\\Users", null);
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(map.get("10579")));
            for (Map.Entry<String, File> each : map.entrySet()) {
                each.getValue().delete();
            }
            System.out.println("yes!");
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            throw new BusinessException("8888", "\u5931\u8d25");
        }
        finally {
            File file = new File("C:\\Users\\temp" + path);
            file.delete();
        }
    }

    public String getFtpAddress() {
        return this.ftpAddress;
    }

    public void setFtpAddress(String ftpAddress) {
        this.ftpAddress = ftpAddress;
    }

    public int getFtpPort() {
        return this.ftpPort;
    }

    public void setFtpPort(int ftpPort) {
        this.ftpPort = ftpPort;
    }

    public String getFtpUsername() {
        return this.ftpUsername;
    }

    public void setFtpUsername(String ftpUsername) {
        this.ftpUsername = ftpUsername;
    }

    public String getFtpPassword() {
        return this.ftpPassword;
    }

    public void setFtpPassword(String ftpPassword) {
        this.ftpPassword = ftpPassword;
    }
}

