/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.invoice;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.constants.UmcCommConstant;
import com.tydic.dyc.umc.model.invoice.IUmcInvoiceInfoModel;
import com.tydic.dyc.umc.model.invoice.UmcInvoiceInfoDo;
import com.tydic.dyc.umc.model.invoice.qrybo.UmcInvoiceInfoQryBo;
import com.tydic.dyc.umc.service.invoice.UmcInvoiceInfoOperService;
import com.tydic.dyc.umc.service.invoice.bo.UmcInvoiceInfoOperReqBo;
import com.tydic.dyc.umc.service.invoice.bo.UmcInvoiceInfoOperRspBo;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

@HSFProvider(serviceVersion="2.0.0", serviceGroup="UMC_GROUP_DEV", serviceInterface=UmcInvoiceInfoOperService.class)
public class UmcInvoiceInfoOperServiceImpl
implements UmcInvoiceInfoOperService {
    @Autowired
    private IUmcInvoiceInfoModel iUmcInvoiceInfoModel;

    public UmcInvoiceInfoOperRspBo operInvoiceInfo(UmcInvoiceInfoOperReqBo reqBo) {
        this.validateParam(reqBo);
        UmcInvoiceInfoOperRspBo rspBo = UmcRu.success(UmcInvoiceInfoOperRspBo.class);
        for (Long invoiceId : reqBo.getInvoiceIds()) {
            List<UmcInvoiceInfoDo> invoiceInfoDoList;
            UmcInvoiceInfoQryBo invoiceInfoQryBo = new UmcInvoiceInfoQryBo();
            invoiceInfoQryBo.setInvoiceId(invoiceId);
            UmcInvoiceInfoDo invoiceInfoDo = this.iUmcInvoiceInfoModel.getInvoiceInfo(invoiceInfoQryBo);
            if (null == invoiceInfoDo) {
                throw new BaseBusinessException("201002", "\u4e0d\u5b58\u5728invoiceId=" + invoiceId + "\u7684\u5e10\u5957\u53d1\u7968\uff01");
            }
            if (UmcCommConstant.AccInvOperType.DELETE.equals(reqBo.getOperType())) {
                invoiceInfoDo.setDelFlag("1");
            } else if (UmcCommConstant.AccInvOperType.START.equals(reqBo.getOperType())) {
                invoiceInfoDo.setInvoiceStatus("01");
                invoiceInfoDo.setMainFlag(UmcCommConstant.EntInvMainFlag.NO);
            } else if (UmcCommConstant.AccInvOperType.STOP.equals(reqBo.getOperType())) {
                invoiceInfoDo.setInvoiceStatus("00");
            } else if (UmcCommConstant.AccInvOperType.SET_MAIN.equals(reqBo.getOperType()) && !CollectionUtils.isEmpty(invoiceInfoDoList = this.qryInvByAccountId(invoiceInfoDo.getAccountId()))) {
                this.cancleMainFlagAddr(invoiceInfoDoList);
                invoiceInfoDo.setMainFlag(UmcCommConstant.EntInvMainFlag.NO);
            }
            invoiceInfoDo.setInvoiceId(invoiceId);
            invoiceInfoDo.setUpdateTime(new Date());
            this.iUmcInvoiceInfoModel.updateInvoiceInfo(invoiceInfoDo);
        }
        return rspBo;
    }

    private List<UmcInvoiceInfoDo> qryInvByAccountId(Long accountId) {
        UmcInvoiceInfoQryBo qryBo = new UmcInvoiceInfoQryBo();
        qryBo.setAccountId(accountId);
        qryBo.setMainFlag(UmcCommConstant.InvAddrMainFlag.YES);
        qryBo.setDelFlag("00");
        return this.iUmcInvoiceInfoModel.getInvoiceInfoList(qryBo);
    }

    private void cancleMainFlagAddr(List<UmcInvoiceInfoDo> invoiceInfoDoList) {
        for (UmcInvoiceInfoDo invoiceInfoDo : invoiceInfoDoList) {
            UmcInvoiceInfoDo invoiceInfoDo1 = new UmcInvoiceInfoDo();
            invoiceInfoDo1.setMainFlag(UmcCommConstant.InvAddrMainFlag.NO);
            invoiceInfoDo1.setInvoiceId(invoiceInfoDo.getInvoiceId());
            invoiceInfoDo1.setDelFlag("00");
            this.iUmcInvoiceInfoModel.updateInvoiceInfo(invoiceInfoDo1);
        }
    }

    private void validateParam(UmcInvoiceInfoOperReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException("201001", "\u4f1a\u5458\u4e2d\u5fc3\u8d26\u5957\u53d1\u7968\u542f\u505c/\u5220\u9664\u4e1a\u52a1\u670d\u52a1API\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == reqBo.getOperType()) {
            throw new BaseBusinessException("201001", "\u4f1a\u5458\u4e2d\u5fc3\u8d26\u5957\u53d1\u7968\u542f\u505c/\u5220\u9664\u4e1a\u52a1\u670d\u52a1API\u5165\u53c2\u3010operType\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (!(reqBo.getOperType().equals(UmcCommConstant.AccInvOperType.START) || reqBo.getOperType().equals(UmcCommConstant.AccInvOperType.STOP) || reqBo.getOperType().equals(UmcCommConstant.AccInvOperType.DELETE))) {
            throw new BaseBusinessException("201001", "\u4f1a\u5458\u4e2d\u5fc3\u8d26\u5957\u53d1\u7968\u542f\u505c/\u5220\u9664\u4e1a\u52a1\u670d\u52a1API\u5165\u53c2\u3010operType\u3011\u975e\u6cd5\uff01");
        }
        if (CollectionUtils.isEmpty((Collection)reqBo.getInvoiceIds())) {
            throw new BaseBusinessException("201001", "\u4f1a\u5458\u4e2d\u5fc3\u8d26\u5957\u53d1\u7968\u542f\u505c/\u5220\u9664\u4e1a\u52a1\u670d\u52a1API\u5165\u53c2\u3010invoiceIds\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        for (Long invoiceId : reqBo.getInvoiceIds()) {
            if (null != invoiceId) continue;
            throw new BaseBusinessException("201001", "\u4f1a\u5458\u4e2d\u5fc3\u8d26\u5957\u53d1\u7968\u542f\u505c/\u5220\u9664\u4e1a\u52a1\u670d\u52a1API\u5165\u53c2\u3010invoiceIds.invoiceId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

