/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.signcontractapply;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.umc.constants.UmcCommConstant;
import com.tydic.dyc.umc.model.signcontractapply.IUmcSignContractApplyModel;
import com.tydic.dyc.umc.model.signcontractapply.UmcSignContractApplyDo;
import com.tydic.dyc.umc.model.signcontractapply.sup.SignContractLog;
import com.tydic.dyc.umc.model.signcontractapply.sup.SignContractYearRuleApply;
import com.tydic.dyc.umc.model.signcontractapply.sup.SignSalesCategoryApply;
import com.tydic.dyc.umc.service.signcontractapply.UmcUpdateSignContractApplyService;
import com.tydic.dyc.umc.service.signcontractapply.bo.UmcUpdateSignContractApplyReqBo;
import com.tydic.dyc.umc.service.signcontractapply.bo.UmcUpdateSignContractApplyRspBo;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

@HSFProvider(serviceVersion="2.0.0", serviceGroup="UMC_GROUP_DEV", serviceInterface=UmcUpdateSignContractApplyService.class)
public class UmcUpdateSignContractApplyServiceImpl
implements UmcUpdateSignContractApplyService {
    private static final Logger log = LoggerFactory.getLogger(UmcUpdateSignContractApplyServiceImpl.class);
    @Autowired
    private IUmcSignContractApplyModel iUmcSignContractApplyModel;

    public UmcUpdateSignContractApplyRspBo updateSignContractApply(UmcUpdateSignContractApplyReqBo reqBo) {
        this.validateAgr(reqBo);
        this.iUmcSignContractApplyModel.updateSignContractApply(UmcRu.js(reqBo, UmcSignContractApplyDo.class));
        if (!CollectionUtils.isEmpty((Collection)reqBo.getSignSalesCategoryApplyBos())) {
            List<SignSalesCategoryApply> salesCategoryApplies = UmcRu.jsl(reqBo.getSignSalesCategoryApplyBos(), SignSalesCategoryApply.class);
            UmcSignContractApplyDo salesCategoryApplyDo = new UmcSignContractApplyDo();
            salesCategoryApplyDo.setSignSalesCategoryApplies(salesCategoryApplies);
            this.iUmcSignContractApplyModel.updateSignSalesCategoryApplies(salesCategoryApplyDo);
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getSignContractYearRuleApplyBos())) {
            List<SignContractYearRuleApply> ruleApplies = UmcRu.jsl(reqBo.getSignContractYearRuleApplyBos(), SignContractYearRuleApply.class);
            UmcSignContractApplyDo ruleApplyDo = new UmcSignContractApplyDo();
            ruleApplyDo.setSignContractYearRuleApplies(ruleApplies);
            this.iUmcSignContractApplyModel.addSignContractYearRuleApplies(ruleApplyDo);
        }
        UmcSignContractApplyDo logDo = new UmcSignContractApplyDo();
        SignContractLog logReqPo = new SignContractLog();
        logReqPo.setApplyId(reqBo.getApplyId());
        logReqPo.setCreateOperId(reqBo.getUserId());
        logReqPo.setCreateOperName(reqBo.getUserName());
        logReqPo.setCreateTime(new Date());
        logReqPo.setDelFlag("0");
        logReqPo.setTenantId(reqBo.getTenantId());
        logReqPo.setOperType(reqBo.getStatus().toString());
        if (reqBo.getStatus() != null) {
            if (reqBo.getStatus().equals(UmcCommConstant.SUP_SIGN_CONTRACT_STATUS.Draft)) {
                logReqPo.setOperTypeStr("\u4fdd\u5b58");
            } else if (reqBo.getStatus().equals(UmcCommConstant.SUP_SIGN_CONTRACT_STATUS.APPLYING)) {
                logReqPo.setOperTypeStr("\u63d0\u4ea4");
            } else if (reqBo.getStatus().equals(UmcCommConstant.SUP_SIGN_CONTRACT_STATUS.CONFIRM)) {
                logReqPo.setOperTypeStr("\u529e\u7406");
            } else if (reqBo.getStatus().equals(UmcCommConstant.SUP_SIGN_CONTRACT_STATUS.COMPLITE)) {
                logReqPo.setOperTypeStr("\u786e\u8ba4");
            } else if (reqBo.getStatus().equals(UmcCommConstant.SUP_SIGN_CONTRACT_STATUS.FEFUSE)) {
                logReqPo.setOperTypeStr("\u62d2\u7edd");
            }
        }
        logReqPo.setSignContractId(reqBo.getSignContractId());
        logDo.setSignContractLogs(Arrays.asList(logReqPo));
        this.iUmcSignContractApplyModel.addSignContractLogs(logDo);
        UmcUpdateSignContractApplyRspBo rspBo = new UmcUpdateSignContractApplyRspBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private void validateAgr(UmcUpdateSignContractApplyReqBo reqBo) {
        if (reqBo == null) {
            throw new ZTBusinessException("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getApplyId() == null) {
            throw new ZTBusinessException("\u5165\u53c2\u7533\u8bf7\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

