/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.domainservice;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.umc.constants.UmcCommConstant;
import com.tydic.dyc.umc.model.signcontract.IUmcSignContractModel;
import com.tydic.dyc.umc.model.signcontract.SignContractDo;
import com.tydic.dyc.umc.model.signcontract.sup.SignSalesCategory;
import com.tydic.dyc.umc.model.signcontractapply.IUmcSignContractApplyModel;
import com.tydic.dyc.umc.model.signcontractapply.UmcSignContractApplyDo;
import com.tydic.dyc.umc.model.signcontractapply.sup.SignContractLog;
import com.tydic.dyc.umc.model.signcontractapply.sup.SignSalesCategoryApply;
import com.tydic.dyc.umc.service.domainservice.UmcCreateSignContractService;
import com.tydic.dyc.umc.service.domainservice.bo.UmcCreateSignContractReqBo;
import com.tydic.dyc.umc.service.domainservice.bo.UmcCreateSignContractRspBo;
import com.tydic.dyc.umc.service.domainservice.bo.UmcSignSalesCategoryBo;
import com.tydic.dyc.umc.utils.IdUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@HSFProvider(serviceVersion="2.0.0", serviceGroup="UMC_GROUP_DEV", serviceInterface=UmcCreateSignContractService.class)
public class UmcCreateSignContractServiceImpl
implements UmcCreateSignContractService {
    private static final Logger log = LoggerFactory.getLogger(UmcCreateSignContractServiceImpl.class);
    @Autowired
    private IUmcSignContractModel iUmcSignContractModel;
    @Autowired
    private IUmcSignContractApplyModel iUmcSignContractApplyModel;

    public UmcCreateSignContractRspBo createSignContract(UmcCreateSignContractReqBo reqBo) {
        UmcCreateSignContractRspBo rspBo = new UmcCreateSignContractRspBo();
        this.validateArg(reqBo);
        long applyId = IdUtil.nextId();
        long signContractId = IdUtil.nextId();
        UmcSignContractApplyDo applyDo = UmcRu.js(reqBo, UmcSignContractApplyDo.class);
        applyDo.setStatus(reqBo.getSignStatus());
        applyDo.setApplyId(applyId);
        applyDo.setSignContractId(signContractId);
        applyDo.setTenantId(reqBo.getTenantId());
        applyDo.setCreateTime(new Date());
        applyDo.setCreateOperId(reqBo.getUserId());
        applyDo.setCreateOperName(reqBo.getUserName());
        applyDo.setDelFlag("0");
        applyDo.setOrgId(reqBo.getOrgId());
        applyDo.setOrgName(reqBo.getOrgName());
        applyDo.setApplyType("1");
        List<SignSalesCategoryApply> signSalesCategoryApplies = UmcRu.jsl(reqBo.getSignSalesCategoryBoList(), SignSalesCategoryApply.class);
        for (SignSalesCategoryApply bo : signSalesCategoryApplies) {
            if (bo.getServiceFeeRate() == null) {
                bo.setServiceFeeRate(0.0);
            }
            bo.setSignContractId(signContractId);
            bo.setApplyId(applyId);
            bo.setCreateTime(new Date());
            bo.setCreateOperId(reqBo.getUserId());
            bo.setCreateOperName(reqBo.getUserName());
            bo.setTenantId(reqBo.getTenantId());
            bo.setDelFlag("0");
            bo.setChngType("4");
        }
        applyDo.setSignSalesCategoryApplies(signSalesCategoryApplies);
        SignContractLog log = UmcRu.js(reqBo, SignContractLog.class);
        log.setOperType(applyDo.getStatus() + "");
        log.setOperTypeStr(applyDo.getStatus().equals(UmcCommConstant.SUP_SIGN_CONTRACT_STATUS.Draft) ? "\u4fdd\u5b58" : "\u63d0\u4ea4");
        applyDo.setSignContractLogs(Arrays.asList(log));
        this.iUmcSignContractApplyModel.createSignContractApply(applyDo);
        SignContractDo signContractDo = UmcRu.js((Object)applyDo, SignContractDo.class);
        signContractDo.setSignStatus(reqBo.getSignStatus());
        List<SignSalesCategory> signSalesCategories = UmcRu.jsl(signSalesCategoryApplies, SignSalesCategory.class);
        signContractDo.setSignSalesCategories(signSalesCategories);
        this.iUmcSignContractModel.createSignContract(signContractDo);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private void validateArg(UmcCreateSignContractReqBo reqBo) {
        if (reqBo == null) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getTenantId() == null) {
            throw new ZTBusinessException("\u5165\u53c2TenantId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getOrgId() == null) {
            throw new ZTBusinessException("\u673a\u6784ID OrgId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getSignStatus() == null) {
            throw new ZTBusinessException("\u7b7e\u7ea6\u72b6\u6001Status\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!reqBo.getSignStatus().equals(UmcCommConstant.SUP_SIGN_CONTRACT_STATUS.Draft) && !reqBo.getSignStatus().equals(UmcCommConstant.SUP_SIGN_CONTRACT_STATUS.APPLYING)) {
            throw new ZTBusinessException("\u7b7e\u7ea6\u72b6\u6001Status\u9519\u8bef");
        }
        if (CollectionUtils.isEmpty((Collection)reqBo.getSignSalesCategoryBoList())) {
            throw new ZTBusinessException("\u7b7e\u7ea6\u54c1\u7c7b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (UmcSignSalesCategoryBo bo : reqBo.getSignSalesCategoryBoList()) {
            if (bo.getItemCatId() == null) {
                throw new ZTBusinessException("\u7b7e\u7ea6\u54c1\u7c7bID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.isEmpty((Object)bo.getItemCatName())) continue;
            throw new ZTBusinessException("\u7b7e\u7ea6\u54c1\u7c7b\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

