/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.model.umcgoodscollection.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.bo.BasePageRspBo;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.umcgoodscollection.IUmcGoodsCollectionModel;
import com.tydic.dyc.umc.model.umcgoodscollection.UmcGoodsCollectionDo;
import com.tydic.dyc.umc.model.umcgoodscollection.qrybo.UmcGoodsCollectionQryBo;
import com.tydic.dyc.umc.model.umcgoodscollection.sub.UmcGoodsCollectionExtMap;
import com.tydic.dyc.umc.repository.UmcGoodsCollectionRepository;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class UmcGoodsCollectionModelImpl
implements IUmcGoodsCollectionModel {
    @Autowired
    private UmcGoodsCollectionRepository umcGoodsCollectionRepository;

    @Override
    public BasePageRspBo<UmcGoodsCollectionDo> getGoodsCollectionsPageList(UmcGoodsCollectionQryBo reqBo) {
        if (ObjectUtil.isEmpty((Object)((Object)reqBo))) {
            throw new BaseBusinessException("200001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getUserId() == null || reqBo.getUserId() == 0L) {
            throw new BaseBusinessException("200001", "\u5165\u53c2\u4f1a\u5458ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BasePageRspBo<UmcGoodsCollectionDo> goodsCollectionsPageList = this.umcGoodsCollectionRepository.getGoodsCollectionsPageList(reqBo);
        if (goodsCollectionsPageList == null || CollectionUtil.isEmpty((Collection)goodsCollectionsPageList.getRows())) {
            return goodsCollectionsPageList;
        }
        for (UmcGoodsCollectionDo bo : goodsCollectionsPageList.getRows()) {
            UmcGoodsCollectionExtMap reqMapPo = new UmcGoodsCollectionExtMap();
            reqMapPo.setGoodsCllectionId(bo.getGoodsCllectionId());
            List<UmcGoodsCollectionExtMap> goodsCollectionExtMapList = this.umcGoodsCollectionRepository.getGoodsCollectionExtMapList(reqMapPo);
            if (CollectionUtil.isEmpty(goodsCollectionExtMapList)) continue;
            for (UmcGoodsCollectionExtMap map : goodsCollectionExtMapList) {
                if ("skuSource".equals(map.getFieldCode())) {
                    bo.setSkuSource(map.getFieldValue());
                }
                if ("supplierName".equals(map.getFieldCode())) {
                    bo.setSupplierName(map.getFieldValue());
                }
                if ("skuImgUrl".equals(map.getFieldCode())) {
                    bo.setSkuImgUrl(map.getFieldValue());
                }
                if ("supplierShopId".equals(map.getFieldCode())) {
                    bo.setSupplierShopId(map.getFieldValue());
                }
                if ("supplierShopName".equals(map.getFieldCode())) {
                    bo.setSupplierShopName(map.getFieldValue());
                }
                if ("channelIds".equals(map.getFieldCode()) && !StringUtils.isEmpty((Object)map.getFieldValue())) {
                    bo.setChannelIds(Arrays.asList(map.getFieldValue().split(",")));
                }
                if (!"channelNames".equals(map.getFieldCode()) || StringUtils.isEmpty((Object)map.getFieldValue())) continue;
                bo.setChannelNames(Arrays.asList(map.getFieldValue().split(",")));
            }
        }
        return goodsCollectionsPageList;
    }

    @Override
    public UmcGoodsCollectionDo addGoodsCollections(UmcGoodsCollectionDo umcGoodsCollectionDo) {
        UmcGoodsCollectionDo addRspPo = this.umcGoodsCollectionRepository.addGoodsCollections(umcGoodsCollectionDo);
        return addRspPo;
    }

    @Override
    public UmcGoodsCollectionDo removeGoodsCollections(UmcGoodsCollectionDo umcGoodsCollectionDo) {
        return this.umcGoodsCollectionRepository.removeGoodsCollections(umcGoodsCollectionDo);
    }
}

