/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.invoiceaddress;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.constants.UmcCommConstant;
import com.tydic.dyc.umc.model.enterprise.IUmcEnterpriseInfoModel;
import com.tydic.dyc.umc.model.enterprise.qrybo.UmcOrgInfoQryBo;
import com.tydic.dyc.umc.model.invoiceaddress.IUmcInvoiceAddressModel;
import com.tydic.dyc.umc.model.invoiceaddress.UmcInvoiceAddressDo;
import com.tydic.dyc.umc.model.invoiceaddress.qrybo.UmcInvoiceAddressQryBo;
import com.tydic.dyc.umc.service.invoiceaddress.UmcInvoiceAddressUpdateService;
import com.tydic.dyc.umc.service.invoiceaddress.bo.UmcInvoiceAddressUpdateReqBo;
import com.tydic.dyc.umc.service.invoiceaddress.bo.UmcInvoiceAddressUpdateRspBo;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

@HSFProvider(serviceVersion="2.0.0", serviceGroup="UMC_GROUP_DEV", serviceInterface=UmcInvoiceAddressUpdateService.class)
public class UmcInvoiceAddressUpdateServiceImpl
implements UmcInvoiceAddressUpdateService {
    @Autowired
    private IUmcInvoiceAddressModel iUmcInvoiceAddressModel;
    @Autowired
    private IUmcEnterpriseInfoModel iUmcEnterpriseInfoModel;

    public UmcInvoiceAddressUpdateRspBo upadteInvoiceAddress(UmcInvoiceAddressUpdateReqBo reqBo) {
        List<UmcInvoiceAddressDo> invoiceAddressDoList;
        this.validationParams(reqBo);
        UmcInvoiceAddressUpdateRspBo rspBo = UmcRu.success(UmcInvoiceAddressUpdateRspBo.class);
        UmcInvoiceAddressQryBo qryBo = new UmcInvoiceAddressQryBo();
        qryBo.setInvoiceAddrId(reqBo.getInvoiceAddrId());
        qryBo.setDelFlag("00");
        int checkIdValue = this.iUmcInvoiceAddressModel.getInvoiceAddressCheck(qryBo);
        if (checkIdValue < 1) {
            throw new BaseBusinessException("201005", "\u53d1\u7968\u90ae\u5bc4\u5730\u5740\u4fee\u6539\u5931\u8d25\uff0c\u8be5\u53d1\u7968\u5730\u5740ID[" + reqBo.getInvoiceAddrId() + "]\u4e0d\u5b58\u5728");
        }
        if (null == reqBo.getAccountId()) {
            UmcOrgInfoQryBo orgInfoCheckReqBo = new UmcOrgInfoQryBo();
            orgInfoCheckReqBo.setOrgId(reqBo.getOrgIdWeb());
            Integer checkOrgInfo = this.iUmcEnterpriseInfoModel.getCheckOrgInfo(orgInfoCheckReqBo);
            if (checkOrgInfo == null) {
                throw new BaseBusinessException("201005", "\u53d1\u7968\u90ae\u5bc4\u5730\u5740\u65b0\u589e\u5931\u8d25\uff0c\u8be5\u673a\u6784[" + reqBo.getOrgIdWeb() + "]\u4e0d\u5b58\u5728");
            }
            if (checkOrgInfo < 1) {
                throw new BaseBusinessException("201005", "\u53d1\u7968\u90ae\u5bc4\u5730\u5740\u65b0\u589e\u5931\u8d25\uff0c\u8be5\u673a\u6784[" + reqBo.getOrgIdWeb() + "]\u4e0d\u5b58\u5728");
            }
        }
        if (reqBo.getMainFlag().equals(UmcCommConstant.InvAddrMainFlag.YES) && !CollectionUtils.isEmpty(invoiceAddressDoList = null != reqBo.getAccountId() ? this.qryAddrByAccountId(reqBo.getAccountId()) : this.qryAddrByOrgId(reqBo.getOrgIdWeb()))) {
            this.cancleMainFlagAddr(invoiceAddressDoList);
        }
        UmcInvoiceAddressDo invoiceAddressDo = UmcRu.js(reqBo, UmcInvoiceAddressDo.class);
        invoiceAddressDo.setCompanyName(reqBo.getCompanyNameWeb());
        invoiceAddressDo.setOrgId(reqBo.getOrgIdWeb());
        invoiceAddressDo.setName(reqBo.getContactNameWeb());
        invoiceAddressDo.setAddrStatus("01");
        invoiceAddressDo.setUpdateTime(new Date());
        invoiceAddressDo.setUpdateOperName(reqBo.getCustNameIn());
        invoiceAddressDo.setUpdateOperId(reqBo.getUserIdIn());
        this.iUmcInvoiceAddressModel.updateInvoiceAddress(invoiceAddressDo);
        return rspBo;
    }

    private List<UmcInvoiceAddressDo> qryAddrByAccountId(Long accountId) {
        UmcInvoiceAddressQryBo qryBo = new UmcInvoiceAddressQryBo();
        qryBo.setAccountId(accountId);
        qryBo.setMainFlag(UmcCommConstant.InvAddrMainFlag.YES);
        qryBo.setDelFlag("00");
        return this.iUmcInvoiceAddressModel.getInvoiceAddressList(qryBo);
    }

    private List<UmcInvoiceAddressDo> qryAddrByOrgId(Long orgId) {
        UmcInvoiceAddressQryBo qryBo = new UmcInvoiceAddressQryBo();
        qryBo.setOrgId(orgId);
        qryBo.setMainFlag(UmcCommConstant.InvAddrMainFlag.YES);
        qryBo.setDelFlag("00");
        return this.iUmcInvoiceAddressModel.getInvoiceAddressList(qryBo);
    }

    private void cancleMainFlagAddr(List<UmcInvoiceAddressDo> invoiceAddressDoList) {
        UmcInvoiceAddressDo invoiceAddressDo = new UmcInvoiceAddressDo();
        List collect = invoiceAddressDoList.stream().map(UmcInvoiceAddressDo::getInvoiceAddrId).collect(Collectors.toList());
        for (Long id : collect) {
            invoiceAddressDo.setInvoiceAddrId(id);
            invoiceAddressDo.setMainFlag(UmcCommConstant.InvAddrMainFlag.NO);
            this.iUmcInvoiceAddressModel.updateInvoiceAddress(invoiceAddressDo);
        }
    }

    private void validationParams(UmcInvoiceAddressUpdateReqBo reqBo) {
        String msgHead = " \u53d1\u7968\u90ae\u5bc4\u5730\u5740\u4fee\u6539\u670d\u52a1\u5165\u53c2";
        if (null == reqBo.getOperType()) {
            throw new BaseBusinessException("200001", msgHead + "\u64cd\u4f5c\u7c7b\u578b[operType]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getOrgIdWeb()) {
            throw new BaseBusinessException("200001", msgHead + "\u673a\u6784ID[orgIdWeb]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBo.getContactNameWeb())) {
            throw new BaseBusinessException("200001", msgHead + "\u8054\u7cfb\u4eba[contactNameWeb]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBo.getAddrDesc())) {
            throw new BaseBusinessException("200001", msgHead + "\u8be6\u7ec6\u5730\u5740[addrDesc]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBo.getAreaName())) {
            throw new BaseBusinessException("200001", msgHead + "\u6240\u5728\u5730\u533a\u540d\u79f0[areaName]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBo.getTel())) {
            throw new BaseBusinessException("200001", msgHead + "\u624b\u673a\u53f7\u7801[areaName]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getMainFlag()) {
            throw new BaseBusinessException("200001", msgHead + "\u662f\u5426\u9ed8\u8ba4\u5730\u5740[mainFlag]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!UmcCommConstant.InvAddrMainFlag.YES.equals(reqBo.getMainFlag()) && !UmcCommConstant.InvAddrMainFlag.NO.equals(reqBo.getMainFlag())) {
            throw new BaseBusinessException("200001", msgHead + "\u662f\u5426\u9ed8\u8ba4\u5730\u5740[mainFlag]\u53c2\u6570\u53ea\u80fd\u4e3a0\u62161");
        }
        if (StringUtils.isEmpty((CharSequence)reqBo.getAreaCode())) {
            throw new BaseBusinessException("200001", msgHead + "\u6240\u5728\u5730\u533a\u7f16\u7801[areaCode]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getInvoiceAddrId()) {
            throw new BaseBusinessException("200001", msgHead + "\u4e3b\u952eID[id]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

