/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.user;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.user.IUmcUserInfoModel;
import com.tydic.dyc.umc.model.user.UmcUserInfoDo;
import com.tydic.dyc.umc.model.user.qrybo.UmcUserInfoQryBo;
import com.tydic.dyc.umc.model.user.sub.UmcUserRoleRel;
import com.tydic.dyc.umc.model.user.sub.UmcUserTagRel;
import com.tydic.dyc.umc.service.user.UmcUserInfoPartService;
import com.tydic.dyc.umc.service.user.bo.UmcUserInfoBo;
import com.tydic.dyc.umc.service.user.bo.UmcUserInfoPartReqBo;
import com.tydic.dyc.umc.service.user.bo.UmcUserInfoPartRspBo;
import com.tydic.dyc.umc.service.user.bo.UmcUserRoleRelBo;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

@HSFProvider(serviceVersion="2.0.0", serviceGroup="UMC_GROUP_DEV", serviceInterface=UmcUserInfoPartService.class)
public class UmcUserInfoPartServiceImpl
implements UmcUserInfoPartService {
    @Autowired
    private IUmcUserInfoModel iUmcUserInfoModel;

    public UmcUserInfoPartRspBo partUserInfo(UmcUserInfoPartReqBo reqBo) {
        this.validReqParam(reqBo);
        UmcUserInfoPartRspBo rspBo = UmcRu.success(UmcUserInfoPartRspBo.class);
        UmcUserInfoQryBo userInfoQryBo = new UmcUserInfoQryBo();
        userInfoQryBo.setUserId(reqBo.getUserId());
        userInfoQryBo.setDelFlag("00");
        UmcUserInfoDo userInfoDo = this.iUmcUserInfoModel.getUserInfo(userInfoQryBo);
        if (null == userInfoDo) {
            throw new BaseBusinessException("200001", "\u672a\u67e5\u8be2\u5230\u7528\u6237\u4fe1\u606f");
        }
        UmcUserInfoDo umcUserInfoDo = this.buildUserInfo(reqBo, userInfoDo);
        this.iUmcUserInfoModel.createUserInfo(umcUserInfoDo);
        rspBo.setUserInfoBo(UmcRu.js(umcUserInfoDo, UmcUserInfoBo.class));
        return rspBo;
    }

    private UmcUserInfoDo buildUserInfo(UmcUserInfoPartReqBo reqBo, UmcUserInfoDo userInfoDo) {
        UmcUserInfoDo umcUserInfoDo = UmcRu.js(userInfoDo, UmcUserInfoDo.class);
        umcUserInfoDo.setUserId(reqBo.getNewUserId());
        umcUserInfoDo.setCustInfo(null);
        umcUserInfoDo.setIsMain("01");
        if (!CollectionUtils.isEmpty((Collection)reqBo.getUserTagRelList())) {
            List<UmcUserTagRel> userTagRelList = UmcRu.jsl(reqBo.getUserRoleRelBoList(), UmcUserTagRel.class);
            umcUserInfoDo.setUserTagRelList(userTagRelList);
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getUserRoleRelBoList())) {
            List<UmcUserRoleRel> userRoleRelList = UmcRu.jsl(reqBo.getUserRoleRelBoList(), UmcUserRoleRel.class);
            umcUserInfoDo.setUserRoleRelList(userRoleRelList);
        }
        return umcUserInfoDo;
    }

    private void validReqParam(UmcUserInfoPartReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("200001", "\u5165\u53c2\u5bf9\u8c61[AuthCreateRoleInfoReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getUserId() == null) {
            throw new BaseBusinessException("200001", "\u5165\u53c2\u5bf9\u8c61[UserId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getNewUserId() == null) {
            throw new BaseBusinessException("200001", "\u5165\u53c2\u5bf9\u8c61[newUserId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getNewOrgId() == null) {
            throw new BaseBusinessException("200001", "\u5165\u53c2\u5bf9\u8c61[NewOrgId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getUserRoleRelBoList())) {
            for (UmcUserRoleRelBo bo : reqBo.getUserRoleRelBoList()) {
                if (bo.getRoleId() != null) continue;
                throw new BaseBusinessException("200001", "\u5165\u53c2\u5bf9\u8c61[RoleId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getUserTagRelList())) {
            for (UmcUserRoleRelBo bo : reqBo.getUserTagRelList()) {
                if (bo.getTagId() != null) continue;
                throw new BaseBusinessException("200001", "\u5165\u53c2\u5bf9\u8c61[TagId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
    }
}

