/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.enterprise;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.model.enterprise.IUmcEnterpriseInfoModel;
import com.tydic.dyc.umc.model.enterprise.UmcEnterpriseInfoDo;
import com.tydic.dyc.umc.model.enterprise.sub.UmcEnterpriseBank;
import com.tydic.dyc.umc.model.enterprise.sub.UmcEnterpriseContact;
import com.tydic.dyc.umc.model.enterprise.sub.UmcEnterpriseInvoice;
import com.tydic.dyc.umc.model.enterprise.sub.UmcOrgInfo;
import com.tydic.dyc.umc.service.enterprise.UmcEnterpriseInfoAddService;
import com.tydic.dyc.umc.service.enterprise.bo.UmcEnterpriseInfoAddReqBo;
import com.tydic.dyc.umc.service.enterprise.bo.UmcEnterpriseInfoAddRspBo;
import com.tydic.dyc.umc.utils.IdUtil;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

@HSFProvider(serviceVersion="2.0.0", serviceGroup="UMC_GROUP_DEV", serviceInterface=UmcEnterpriseInfoAddService.class)
public class UmcEnterpriseInfoAddServiceImpl
implements UmcEnterpriseInfoAddService {
    @Autowired
    private IUmcEnterpriseInfoModel iUmcEnterpriseInfoModel;

    public UmcEnterpriseInfoAddRspBo createEnterpriseInfo(UmcEnterpriseInfoAddReqBo reqBo) {
        this.validateParams(reqBo);
        UmcEnterpriseInfoAddRspBo rspBo = UmcRu.success(UmcEnterpriseInfoAddRspBo.class);
        UmcOrgInfo umcEnterpriseOrg = UmcRu.js(reqBo.getOrgInfoBo(), UmcOrgInfo.class);
        if (null == umcEnterpriseOrg.getOrgId()) {
            umcEnterpriseOrg.setOrgId(IdUtil.nextId());
        }
        umcEnterpriseOrg = this.iUmcEnterpriseInfoModel.createOrgInfo(umcEnterpriseOrg);
        if (ObjectUtil.isNotEmpty((Object)reqBo.getEnterpriseInvoiceBoList())) {
            List<UmcEnterpriseInvoice> enterpriseInvoiceList = UmcRu.jsl(reqBo.getEnterpriseInvoiceBoList(), UmcEnterpriseInvoice.class);
            for (UmcEnterpriseInvoice enterpriseInvoice : enterpriseInvoiceList) {
                enterpriseInvoice.setOrgId(umcEnterpriseOrg.getOrgId());
                enterpriseInvoice.setDelFlag("0");
                if (null != enterpriseInvoice.getInvoiceId()) continue;
                enterpriseInvoice.setInvoiceId(IdUtil.nextId());
            }
            this.iUmcEnterpriseInfoModel.createEnterpriseInvoice(enterpriseInvoiceList);
        }
        if (ObjectUtil.isNotEmpty((Object)reqBo.getEnterpriseBankBoList())) {
            List<UmcEnterpriseBank> enterpriseBankList = UmcRu.jsl(reqBo.getEnterpriseBankBoList(), UmcEnterpriseBank.class);
            for (UmcEnterpriseBank enterpriseBank : enterpriseBankList) {
                enterpriseBank.setOrgId(umcEnterpriseOrg.getOrgId());
                enterpriseBank.setDelFlag("0");
                if (null != enterpriseBank.getBankId()) continue;
                enterpriseBank.setBankId(IdUtil.nextId());
            }
            this.iUmcEnterpriseInfoModel.createEnterpriseBank(enterpriseBankList);
        }
        if (ObjectUtil.isNotEmpty((Object)reqBo.getEnterpriseContactBoList())) {
            List<UmcEnterpriseContact> enterpriseContactList = UmcRu.jsl(reqBo.getEnterpriseContactBoList(), UmcEnterpriseContact.class);
            for (UmcEnterpriseContact enterpriseContact : enterpriseContactList) {
                enterpriseContact.setOrgId(umcEnterpriseOrg.getOrgId());
                enterpriseContact.setDelFlag("0");
                if (null != enterpriseContact.getContactId()) continue;
                enterpriseContact.setContactId(IdUtil.nextId());
            }
            this.iUmcEnterpriseInfoModel.createEnterpriseContact(enterpriseContactList);
        }
        UmcEnterpriseInfoDo umcEnterpriseInfoDo = UmcRu.js(reqBo, UmcEnterpriseInfoDo.class);
        umcEnterpriseInfoDo.setOrgId(umcEnterpriseOrg.getOrgId());
        UmcEnterpriseInfoDo enterpriseInfoDo = this.iUmcEnterpriseInfoModel.createEnterpriseInfo(umcEnterpriseInfoDo);
        return rspBo;
    }

    private void validateParams(UmcEnterpriseInfoAddReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException("200001", "\u4f01\u4e1a\u521b\u5efa \u5165\u53c2\u4e3a\u7a7a\uff01");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getOrgInfoBo())) {
            throw new BaseBusinessException("200001", "\u4f01\u4e1a\u521b\u5efa \u5165\u53c2[enterpriseOrgBo]\u4e3a\u7a7a\uff01");
        }
    }
}

