/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.service.todo;

import com.alibaba.boot.hsf.annotation.HSFProvider;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.constants.UmcCommConstant;
import com.tydic.dyc.umc.model.todo.IUmcTodoModel;
import com.tydic.dyc.umc.model.todo.UmcTodoDo;
import com.tydic.dyc.umc.model.todo.qrybo.UmcTodoQryBo;
import com.tydic.dyc.umc.model.todo.sub.UmcTodoDone;
import com.tydic.dyc.umc.service.todo.UmcSendHaveDoneService;
import com.tydic.dyc.umc.service.todo.bo.UmcSendHaveDoneReqBo;
import com.tydic.dyc.umc.service.todo.bo.UmcSendHaveDoneRspBo;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

@HSFProvider(serviceVersion="2.0.0", serviceGroup="UMC_GROUP_DEV", serviceInterface=UmcSendHaveDoneService.class)
public class UmcSendHaveDoneServiceImpl
implements UmcSendHaveDoneService {
    @Autowired
    private IUmcTodoModel iUmcTodoModel;

    public UmcSendHaveDoneRspBo sendHaveDone(UmcSendHaveDoneReqBo reqBO) {
        if (null == reqBO.getTodoId() && StringUtils.isEmpty((CharSequence)reqBO.getBusiId())) {
            throw new BaseBusinessException("200001", "\u63a8\u9001\u5df2\u529e\u5931\u8d25\uff1a\u5f85\u529eid\uff0c\u4e1a\u52a1id\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getOperUserId())) {
            throw new BaseBusinessException("200001", "\u63a8\u9001\u5df2\u529e\u5931\u8d25\uff1a\u5904\u7406\u4ebaid\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getOperUserName())) {
            throw new BaseBusinessException("200001", "\u63a8\u9001\u5df2\u529e\u5931\u8d25\uff1a\u5904\u7406\u4eba\u540d\u79f0\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        UmcSendHaveDoneRspBo rspBO = UmcRu.success(UmcSendHaveDoneRspBo.class);
        UmcTodoQryBo umcTodoQryBo = new UmcTodoQryBo();
        umcTodoQryBo.setTodoId(reqBO.getTodoId());
        umcTodoQryBo.setBusiId(reqBO.getBusiId());
        umcTodoQryBo.setTodoItemCode(reqBO.getTodoItemCode());
        List<UmcTodoDo> umcTodoPOS = this.iUmcTodoModel.selectTodoList(umcTodoQryBo);
        if (!CollectionUtils.isEmpty(umcTodoPOS)) {
            UmcTodoDo deleteUmcTodoPO = new UmcTodoDo();
            deleteUmcTodoPO.setTodoId(reqBO.getTodoId());
            deleteUmcTodoPO.setBusiId(reqBO.getBusiId());
            deleteUmcTodoPO.setTodoItemCode(reqBO.getTodoItemCode());
            int deleteResult = this.iUmcTodoModel.deleteTodo(deleteUmcTodoPO);
            if (deleteResult == umcTodoPOS.size()) {
                ArrayList<UmcTodoDone> list = new ArrayList<UmcTodoDone>();
                for (UmcTodoDo umcTodoInfo : umcTodoPOS) {
                    UmcTodoDone insertUmcTodoDonePO = new UmcTodoDone();
                    BeanUtils.copyProperties((Object)umcTodoInfo, (Object)insertUmcTodoDonePO);
                    insertUmcTodoDonePO.setOperId(reqBO.getOperUserId());
                    insertUmcTodoDonePO.setOperName(reqBO.getOperUserName());
                    insertUmcTodoDonePO.setOperTime(new Date());
                    insertUmcTodoDonePO.setTodoState(1);
                    if (!reqBO.getOperUserId().equals(umcTodoInfo.getCandidateOperId())) {
                        insertUmcTodoDonePO.setTodoState(UmcCommConstant.TodoState.OTHER_DONE);
                    }
                    list.add(insertUmcTodoDonePO);
                }
                int insertBatchResult = this.iUmcTodoModel.createDone(list);
                if (insertBatchResult == umcTodoPOS.size()) {
                    return rspBO;
                }
                throw new BaseBusinessException("101020", "\u63a8\u9001\u5df2\u529e\u5931\u8d25\uff1a\u751f\u6210\u5df2\u529e\u4fe1\u606f\u5931\u8d25");
            }
            throw new BaseBusinessException("101020", "\u63a8\u9001\u5df2\u529e\u5931\u8d25\uff1a\u5220\u9664\u5f85\u529e\u4fe1\u606f\u5931\u8d25");
        }
        throw new BaseBusinessException("101020", "\u63a8\u9001\u5df2\u529e\u5931\u8d25\uff1a\u5f85\u529e\u4fe1\u606f\u4e0d\u5b58\u5728");
    }
}

