/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.repository.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.umc.constants.UmcCommConstants;
import com.tydic.dyc.umc.model.supapproval.UmcSupMisconductReplyBusiService;
import com.tydic.dyc.umc.model.supapproval.qrybo.UmcSupMisconductReplyBusiReqBO;
import com.tydic.dyc.umc.model.supapproval.sub.UmcSupMisconductReplyBusiRspBO;
import com.tydic.dyc.umc.repository.dao.SupplierAuditMapper;
import com.tydic.dyc.umc.repository.dao.SupplierMisconductDescMapper;
import com.tydic.dyc.umc.repository.dao.SupplierMisconductMapper;
import com.tydic.dyc.umc.repository.po.SupplierMisconductDescPO;
import com.tydic.dyc.umc.repository.po.SupplierMisconductPO;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UmcSupMisconductReplyBusiServiceImpl
implements UmcSupMisconductReplyBusiService {
    private static final Logger log = LoggerFactory.getLogger(UmcSupMisconductReplyBusiServiceImpl.class);
    @Autowired
    private SupplierMisconductMapper supplierMisconductMapper;
    @Autowired
    private SupplierMisconductDescMapper supplierMisconductDescMapper;
    @Autowired
    private SupplierAuditMapper supplierAuditMapper;

    public UmcSupMisconductReplyBusiRspBO supMisconductReply(UmcSupMisconductReplyBusiReqBO reqBO) {
        UmcSupMisconductReplyBusiRspBO rspBO = new UmcSupMisconductReplyBusiRspBO();
        for (Long misconductId : reqBO.getMisconductIds()) {
            SupplierMisconductPO smPO = new SupplierMisconductPO();
            BeanUtils.copyProperties((Object)reqBO, (Object)smPO);
            smPO.setOrgId(null);
            smPO.setOrgName(null);
            smPO.setReplyTime(new Date());
            smPO.setReplyId(Sequence.getInstance().nextId());
            smPO.setReplyName(reqBO.getUserName());
            smPO.setMisconductId(misconductId);
            if (UmcCommConstants.MisconductReplyType.APPROVED.intValue() == reqBO.getReplyType().intValue()) {
                smPO.setMisconductStatus(UmcCommConstants.MisconductStatus.APPEALED);
                smPO.setAppealStatus(UmcCommConstants.MisconductAppealStatus.APPEAL_SUCCES);
            } else if (UmcCommConstants.MisconductReplyType.REFUSE.intValue() == reqBO.getReplyType().intValue()) {
                smPO.setAppealStatus(UmcCommConstants.MisconductAppealStatus.APPEAL_FAILED);
                smPO.setMisconductStatus(UmcCommConstants.MisconductStatus.APPEAL_FAILED);
            }
            this.supplierMisconductMapper.updateByPrimaryKeySelective(smPO);
            SupplierMisconductDescPO smdPO = new SupplierMisconductDescPO();
            smdPO.setMisconductId(misconductId);
            smdPO.setReplyDesc(reqBO.getReplyDesc());
            this.supplierMisconductDescMapper.updateByPrimaryKeySelective(smdPO);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

