/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.repository.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.umc.constants.UmcCommConstants;
import com.tydic.dyc.umc.model.rectification.UmcQrySupRectificationListBusiService;
import com.tydic.dyc.umc.model.rectification.qrybo.UmcQrySupRectificationListBusiReqBO;
import com.tydic.dyc.umc.model.rectification.sub.UmcQrySupRectificationListBusiRspBO;
import com.tydic.dyc.umc.repository.dao.AssessmentLevelSetMapper;
import com.tydic.dyc.umc.repository.dao.UmcSupplierRectificationRequireScoreContactMapper;
import com.tydic.dyc.umc.repository.dao.UmcSupplierRectificationScoreContactMapper;
import com.tydic.dyc.umc.repository.po.AssessmentLevelSetPO;
import com.tydic.dyc.umc.repository.po.UmcSupplierRectificationRequireScoreContactPO;
import com.tydic.dyc.umc.service.rectification.bo.UmcSupRectificationBO;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class UmcQrySupRectificationListBusiServiceImpl
implements UmcQrySupRectificationListBusiService {
    private static final Logger log = LoggerFactory.getLogger(UmcQrySupRectificationListBusiServiceImpl.class);
    @Autowired
    private UmcSupplierRectificationScoreContactMapper umcSupplierRectificationScoreContactMapper;
    @Autowired
    private UmcSupplierRectificationRequireScoreContactMapper umcSupplierRectificationRequireScoreContactMapper;
    @Autowired
    private AssessmentLevelSetMapper assessmentLevelSetMapper;

    public UmcQrySupRectificationListBusiRspBO qrySupRectificationList(UmcQrySupRectificationListBusiReqBO reqBO) {
        UmcQrySupRectificationListBusiRspBO rspBO = new UmcQrySupRectificationListBusiRspBO();
        AssessmentLevelSetPO assessmentLevelSetPO = new AssessmentLevelSetPO();
        assessmentLevelSetPO.setRectificationStatus("1");
        List<AssessmentLevelSetPO> levelSetPOS = this.assessmentLevelSetMapper.selectRecList(assessmentLevelSetPO);
        ArrayList<String> scorelevelList = new ArrayList<String>();
        for (AssessmentLevelSetPO levelSetPO : levelSetPOS) {
            scorelevelList.add(levelSetPO.getLevelCode());
        }
        reqBO.setScoreLevelList(scorelevelList);
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        if (!ObjectUtils.isEmpty((Object)reqBO.getStatus()) && reqBO.getStatus().equals(0)) {
            reqBO.setStatusT(Integer.valueOf(2));
        }
        log.debug("========selectRecList======[{}]", (Object)reqBO);
        List<UmcSupRectificationBO> rectificationBOS = this.umcSupplierRectificationScoreContactMapper.selectRecList(reqBO, (Page<UmcSupRectificationBO>)page);
        List result = rectificationBOS.stream().map(item -> {
            UmcSupRectificationBO rectificationBO = new UmcSupRectificationBO();
            BeanUtils.copyProperties((Object)item, (Object)rectificationBO);
            UmcSupplierRectificationRequireScoreContactPO requireScoreContactPO = this.umcSupplierRectificationRequireScoreContactMapper.selectBySpuAndRat(item.getSupplierId(), item.getSupplierRatingId());
            if (!ObjectUtils.isEmpty((Object)requireScoreContactPO)) {
                rectificationBO.setSubmitRequireStatus(Integer.valueOf(1));
                rectificationBO.setSubmitRequireStatusDes("\u5df2\u63d0\u4ea4\u6574\u6539\u901a\u77e5\uff01");
            }
            if (null == rectificationBO.getStatus()) {
                rectificationBO.setStatus(UmcCommConstants.RectificationStatus.WAIT_RECTIFICATION);
            }
            if (UmcCommConstants.RectificationStatus.WAIT_RECTIFICATION.equals(rectificationBO.getStatus()) || UmcCommConstants.RectificationStatus.WAIT_RECTIFICATION_T.equals(rectificationBO.getStatus())) {
                rectificationBO.setStatusDes("\u5f85\u6574\u6539");
            }
            if (UmcCommConstants.RectificationStatus.RECTIFICATIONING.equals(rectificationBO.getStatus())) {
                rectificationBO.setStatusDes("\u6574\u6539\u4e2d");
            }
            if (UmcCommConstants.RectificationStatus.RECTIFICATIONED.equals(rectificationBO.getStatus())) {
                rectificationBO.setStatusDes("\u5df2\u6574\u6539");
            }
            if (UmcCommConstants.RectificationStatus.WAIT_AUDIT.equals(rectificationBO.getStatus())) {
                rectificationBO.setStatusDes("\u5f85\u5ba1\u6838");
            }
            return rectificationBO;
        }).collect(Collectors.toList());
        rspBO.setRows(result);
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

