/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.repository.impl;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.umc.constants.UmcCommConstants;
import com.tydic.dyc.umc.model.blmanagement.qrybo.UmcAddEnterpriseBlacklistBusiReqBO;
import com.tydic.dyc.umc.model.blmanagement.sub.UmcAddEnterpriseBlacklistBusiRspBO;
import com.tydic.dyc.umc.repository.UmcAuditSupEnterpriseBlacklistRepository;
import com.tydic.dyc.umc.repository.dao.ExtEnterpriseOrgMapper;
import com.tydic.dyc.umc.repository.dao.SupplierAuditMapper;
import com.tydic.dyc.umc.repository.dao.SupplierMisconductMapper;
import com.tydic.dyc.umc.repository.dao.UmcEnterpriseBlacklistMapper;
import com.tydic.dyc.umc.repository.po.EnterpriseOrgPO;
import com.tydic.dyc.umc.repository.po.UmcEnterpriseBlacklistPO;
import com.tydic.dyc.umc.service.enterprise.DictionaryBusiService;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UmcAuditSupEnterpriseBlacklistRepositoryImpl
implements UmcAuditSupEnterpriseBlacklistRepository {
    private static final Logger log = LoggerFactory.getLogger(UmcAuditSupEnterpriseBlacklistRepositoryImpl.class);
    @Autowired
    private UmcEnterpriseBlacklistMapper umcEnterpriseBlacklistMapper;
    @Autowired
    private DictionaryBusiService dictionaryBusiService;
    @Autowired
    private SupplierAuditMapper supplierAuditMapper;
    @Autowired
    private SupplierMisconductMapper supplierMisconductMapper;
    @Autowired
    private ExtEnterpriseOrgMapper enterpriseOrgMapper;
    private static final Pattern p = Pattern.compile("\\{([^}]*)\\}");
    private static final Integer FREEZE_ONE = 1;
    private static final Integer AUDIT_TYPE_ZERO = 0;
    private static final Integer AUDIT_TYPE_THREE = 3;

    public UmcAddEnterpriseBlacklistBusiRspBO supBlacklistAudit(UmcAddEnterpriseBlacklistBusiReqBO reqBO) {
        if (AUDIT_TYPE_ZERO.equals(reqBO.getAuditType())) {
            reqBO.setAuditType(AUDIT_TYPE_THREE);
        }
        UmcAddEnterpriseBlacklistBusiRspBO rspBO = new UmcAddEnterpriseBlacklistBusiRspBO();
        this.editBalckListStatus(reqBO, (Long)reqBO.getBlacklistIds().get(0));
        if (reqBO.getAuditType().equals(UmcCommConstants.blackStatus.APPROVED)) {
            UmcEnterpriseBlacklistPO umcEnterpriseBlacklistPO = new UmcEnterpriseBlacklistPO();
            umcEnterpriseBlacklistPO.setBlacklistIds(reqBO.getBlacklistIds());
            List<UmcEnterpriseBlacklistPO> blackNeedStopOrgList = this.umcEnterpriseBlacklistMapper.getBlackNeedStopOrgList(umcEnterpriseBlacklistPO);
            List<Long> orgIds = blackNeedStopOrgList.stream().map(UmcEnterpriseBlacklistPO::getEnterpriseId).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(orgIds)) {
                EnterpriseOrgPO enterpriseOrgPO = new EnterpriseOrgPO();
                enterpriseOrgPO.setOrgIds(orgIds);
                enterpriseOrgPO.setStatus("0");
                this.enterpriseOrgMapper.updateByIds(enterpriseOrgPO);
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void editBalckListStatus(UmcAddEnterpriseBlacklistBusiReqBO reqBO, Long mlacklistId) {
        UmcEnterpriseBlacklistPO conditionPO = new UmcEnterpriseBlacklistPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)conditionPO);
        conditionPO.setBlacklistId(mlacklistId);
        if (reqBO.getAuditType().equals(UmcCommConstants.blackStatus.APPROVED)) {
            conditionPO.setStatus(UmcCommConstants.blackStatus.APPROVED);
        } else if (reqBO.getAuditType().equals(UmcCommConstants.blackStatus.REFUSE)) {
            conditionPO.setStatus(UmcCommConstants.blackStatus.REFUSE);
        }
        try {
            System.err.println("------------\u9ed1\u540d\u5355\u66f4\u65b0\u72b6\u6001\u5165\u53c2\uff1a--------------" + conditionPO);
            this.umcEnterpriseBlacklistMapper.updateByPrimaryKeySelective(conditionPO);
        }
        catch (Exception e) {
            throw new BaseBusinessException("163053", "\u5ba1\u6838\u5931\u8d25\uff1a" + e.getMessage());
        }
    }
}

