/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.repository.impl;

import com.tydic.dyc.umc.model.sysdictionary.SysDicDictionaryDo;
import com.tydic.dyc.umc.model.sysdictionary.sub.PesDicConfig;
import com.tydic.dyc.umc.repository.UmcSysDicDictionaryRepository;
import com.tydic.dyc.umc.repository.dao.PesDicConfigMapper;
import com.tydic.dyc.umc.repository.dao.SysDicDictionaryMapper;
import com.tydic.dyc.umc.repository.po.PesDicConfigPo;
import com.tydic.dyc.umc.repository.po.SysDicDictionaryPo;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class UmcSysDicDictionaryRepositoryImpl
implements UmcSysDicDictionaryRepository {
    @Autowired
    private SysDicDictionaryMapper sysDicDictionaryMapper;
    @Autowired
    private PesDicConfigMapper pesDicConfigMapper;
    private static final String SYS_CODE_DEFAULT = "*";

    public Map<String, String> queryBypCodeBackMap(String sysCode, String pCode) {
        List<SysDicDictionaryPo> listPo = this.sysDicDictionaryMapper.getList(this.getDicDictionaryPO(sysCode, pCode));
        if (listPo == null || listPo.size() == 0) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (SysDicDictionaryPo po : listPo) {
            map.put(po.getCode(), po.getTitle());
        }
        return map;
    }

    public SysDicDictionaryPo getDicDictionaryPO(String sysCode, String pCode) {
        SysDicDictionaryPo queryDictionaryPO = new SysDicDictionaryPo();
        queryDictionaryPO.setPCode(pCode);
        if (StringUtils.isEmpty((Object)sysCode)) {
            sysCode = SYS_CODE_DEFAULT;
        }
        queryDictionaryPO.setSysCode(sysCode);
        return queryDictionaryPO;
    }

    public SysDicDictionaryDo getDictionaryByDo(SysDicDictionaryDo dicDictionaryDo) {
        SysDicDictionaryDo dictionaryDo = new SysDicDictionaryDo();
        SysDicDictionaryPo dictionaryPo = new SysDicDictionaryPo();
        BeanUtils.copyProperties((Object)dicDictionaryDo, (Object)dictionaryPo);
        SysDicDictionaryPo sysDicDictionaryPo = this.sysDicDictionaryMapper.getModelBy(dictionaryPo);
        if (null != sysDicDictionaryPo) {
            BeanUtils.copyProperties((Object)sysDicDictionaryPo, (Object)dictionaryDo);
        }
        return dictionaryDo;
    }

    public List<PesDicConfig> qryPesDicListByConfigKeys(List<String> callConfigKeys) {
        List<PesDicConfigPo> dics = this.pesDicConfigMapper.getListByConfigKeys(callConfigKeys);
        if (CollectionUtils.isEmpty(dics)) {
            return new ArrayList<PesDicConfig>();
        }
        return UmcRu.jsl(dics, PesDicConfig.class);
    }

    public List<SysDicDictionaryDo> queryBypCodeBackPo(SysDicDictionaryDo dicDictionaryDo) {
        List<SysDicDictionaryPo> list;
        SysDicDictionaryPo js = (SysDicDictionaryPo)UmcRu.js((Object)dicDictionaryDo, SysDicDictionaryPo.class);
        if (StringUtils.isEmpty((Object)js.getOrderBy())) {
            js.setOrderBy("ORDER_ID Asc");
        }
        if (CollectionUtils.isEmpty(list = this.sysDicDictionaryMapper.getList(js))) {
            return new ArrayList<SysDicDictionaryDo>();
        }
        return UmcRu.jsl(list, SysDicDictionaryDo.class);
    }
}

