/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.umc.repository.impl;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.umc.constants.UmcCommConstant;
import com.tydic.dyc.umc.model.common.sub.UocOrderProcInst;
import com.tydic.dyc.umc.model.common.sub.UocOrderProcInstRspBo;
import com.tydic.dyc.umc.model.common.sub.UocOrderTaskDeal;
import com.tydic.dyc.umc.model.common.sub.UocOrderTaskDealList;
import com.tydic.dyc.umc.model.common.sub.UocOrderTaskInst;
import com.tydic.dyc.umc.model.common.sub.UocOrderTaskInstList;
import com.tydic.dyc.umc.model.common.sub.UocOrderTaskInstRspBo;
import com.tydic.dyc.umc.model.common.sub.UserDownloadRecord;
import com.tydic.dyc.umc.repository.UmcCommonRepository;
import com.tydic.dyc.umc.repository.dao.UocApprovalObjMapper;
import com.tydic.dyc.umc.repository.dao.UocOrderProcInstMapper;
import com.tydic.dyc.umc.repository.dao.UocOrderTaskDealMapper;
import com.tydic.dyc.umc.repository.dao.UocOrderTaskInstLogMapper;
import com.tydic.dyc.umc.repository.dao.UocOrderTaskInstMapper;
import com.tydic.dyc.umc.repository.dao.UserDownloadRecordMapper;
import com.tydic.dyc.umc.repository.po.UocOrderProcInstPo;
import com.tydic.dyc.umc.repository.po.UocOrderTaskDealPo;
import com.tydic.dyc.umc.repository.po.UocOrderTaskInstLogPo;
import com.tydic.dyc.umc.repository.po.UocOrderTaskInstPo;
import com.tydic.dyc.umc.repository.po.UserDownloadRecordPo;
import com.tydic.dyc.umc.utils.UmcRu;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class UmcCommonRepositoryImpl
implements UmcCommonRepository {
    @Autowired
    private UserDownloadRecordMapper userDownloadRecordMapper;
    @Autowired
    private UocOrderTaskInstMapper uocOrderTaskInstMapper;
    @Autowired
    private UocOrderTaskInstLogMapper uocOrderTaskInstLogMapper;
    @Autowired
    private UocOrderProcInstMapper uocOrderProcInstMapper;
    @Autowired
    private UocOrderTaskDealMapper uocOrderTaskDealMapper;
    @Autowired
    private UocApprovalObjMapper uocApprovalObjMapper;

    public void updateFileNameByTaskId(UserDownloadRecord userDownloadRecord) {
        UserDownloadRecordPo set = new UserDownloadRecordPo();
        set.setFileName(userDownloadRecord.getFileName());
        set.setDownloadTaskId(userDownloadRecord.getNewTaskId());
        if (!StringUtils.isEmpty((Object)userDownloadRecord.getTaskStatus())) {
            set.setTaskStatus(Integer.parseInt(userDownloadRecord.getTaskStatus()));
        }
        UserDownloadRecordPo where = new UserDownloadRecordPo();
        where.setDownloadTaskId(userDownloadRecord.getTaskId());
        this.userDownloadRecordMapper.updateBy(set, where);
    }

    public void updateToFinished(UocOrderTaskInstList uocOrderTaskInstList) {
        for (UocOrderTaskInst uocOrderTaskInst : uocOrderTaskInstList.getUocOrderTaskInstList()) {
            UocOrderTaskInstPo updateSetPo = new UocOrderTaskInstPo();
            updateSetPo.setFinishTag(UmcCommConstant.PROC_TASK_FINISHED.FINISHED);
            updateSetPo.setFinishTime(new Date());
            updateSetPo.setDealOperId(uocOrderTaskInst.getDealOperId());
            updateSetPo.setDealOperName(uocOrderTaskInst.getDealOperName());
            updateSetPo.setDealResult(uocOrderTaskInst.getDealResult());
            updateSetPo.setDealRemark(uocOrderTaskInst.getDealRemark());
            UocOrderTaskInstPo updateWherePo = new UocOrderTaskInstPo();
            updateWherePo.setOrderId(uocOrderTaskInst.getOrderId());
            updateWherePo.setTaskInstId(uocOrderTaskInst.getTaskInstId());
            this.uocOrderTaskInstMapper.updateBy(updateSetPo, updateWherePo);
        }
    }

    public void saveProcTaskInst(UocOrderTaskInstList saveTaskList) {
        if (ObjectUtil.isNotEmpty((Object)saveTaskList.getUocOrderTaskInstList())) {
            this.uocOrderTaskInstMapper.insertBatch(UmcRu.jsl((List)saveTaskList.getUocOrderTaskInstList(), UocOrderTaskInstPo.class));
        }
    }

    public UocOrderProcInst createProInst(UocOrderProcInst inst) {
        this.uocOrderProcInstMapper.insert((UocOrderProcInstPo)UmcRu.js((Object)inst, UocOrderProcInstPo.class));
        return inst;
    }

    public UocOrderProcInstRspBo qryProcInsList(UocOrderProcInst inst) {
        List uocOrderProcInsts = UmcRu.jsl(this.uocOrderProcInstMapper.getList((UocOrderProcInstPo)UmcRu.js((Object)inst, UocOrderProcInstPo.class)), UocOrderProcInst.class);
        UocOrderProcInstRspBo uocOrderProcInstRspBo = new UocOrderProcInstRspBo();
        uocOrderProcInstRspBo.setUocOrderProcInstList(uocOrderProcInsts);
        return uocOrderProcInstRspBo;
    }

    public void saveOrderTaskDealList(UocOrderTaskDealList dealList) {
        if (null != dealList && ObjectUtil.isNotEmpty((Object)dealList.getDealList())) {
            this.uocOrderTaskDealMapper.insertBatch(UmcRu.jsl((List)dealList.getDealList(), UocOrderTaskDealPo.class));
        }
    }

    public UocOrderTaskInstRspBo qryTaskInstList(UocOrderTaskInst taskInst) {
        UocOrderTaskInstRspBo rspBo = new UocOrderTaskInstRspBo();
        if (ObjectUtil.isNotEmpty((Object)taskInst)) {
            List instList = UmcRu.jsl(this.uocOrderTaskInstMapper.getList((UocOrderTaskInstPo)UmcRu.js((Object)taskInst, UocOrderTaskInstPo.class)), UocOrderTaskInst.class);
            rspBo.setRows(instList);
            return rspBo;
        }
        return rspBo;
    }

    public UocOrderProcInst updateProInst(UocOrderProcInst inst) {
        UocOrderProcInstPo set = (UocOrderProcInstPo)UmcRu.js((Object)inst, UocOrderProcInstPo.class);
        UocOrderProcInstPo where = new UocOrderProcInstPo();
        where.setOrderId(inst.getOrderId());
        where.setObjId(inst.getObjId());
        where.setObjType(inst.getObjType());
        where.setProcInstId(inst.getProcInstId());
        this.uocOrderProcInstMapper.updateBy(set, where);
        return inst;
    }

    public void updateTaskInst(UocOrderTaskInst inst) {
        UocOrderTaskInstPo set = (UocOrderTaskInstPo)UmcRu.js((Object)inst, UocOrderTaskInstPo.class);
        UocOrderTaskInstPo where = new UocOrderTaskInstPo();
        where.setTaskInstId(inst.getTaskInstId());
        where.setOrderId(inst.getOrderId());
        where.setObjId(inst.getObjId());
        where.setObjType(inst.getObjType());
        where.setId(inst.getId());
        where.setProcState(inst.getProcState());
        this.uocOrderTaskInstMapper.updateBy(set, where);
    }

    public void deleteTaskInstByStepIdAndFinshTag(UocOrderTaskInst taskInst) {
        UocOrderTaskInstPo where = new UocOrderTaskInstPo();
        where.setOrderId(taskInst.getOrderId());
        where.setProcState(taskInst.getProcState());
        this.uocOrderTaskInstMapper.deleteTaskInstByStepIdAndFinshTag(where);
    }

    public void saveProcTaskInstLog(List<UocOrderTaskInst> saveTaskList) {
        List uocOrderTaskInstLogPos = UmcRu.jsl(saveTaskList, UocOrderTaskInstLogPo.class);
        if (!CollectionUtils.isEmpty((Collection)uocOrderTaskInstLogPos)) {
            this.uocOrderTaskInstLogMapper.insertBatch(uocOrderTaskInstLogPos);
        }
    }

    public void deleteProcTaskInstByIds(UocOrderTaskInst taskInst) {
        UocOrderTaskInstPo where = new UocOrderTaskInstPo();
        where.setOrderId(taskInst.getOrderId());
        where.setIds(taskInst.getIds());
        this.uocOrderTaskInstMapper.deleteProcTaskInstByIds(where);
    }

    public void updateTaskDeal(UocOrderTaskDeal taskDeal) {
        UocOrderTaskDealPo set = new UocOrderTaskDealPo();
        set.setDealId(taskDeal.getDealId());
        set.setDealName(taskDeal.getDealName());
        UocOrderTaskDealPo where = new UocOrderTaskDealPo();
        where.setTaskInstId(taskDeal.getTaskInstId());
        this.uocOrderTaskDealMapper.updateBy(set, where);
    }
}

