/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dycpro.saas.agr.agreement.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.pro.base.core.dictionary.enums.PublicProcInstBusiType;
import com.tydic.dyc.pro.dmc.service.agrchng.api.DycProAgrChngMainSaveService;
import com.tydic.dyc.pro.dmc.service.agrchng.bo.DycProAgrChngMainSaveReqBO;
import com.tydic.dyc.pro.dmc.service.agrchng.bo.DycProAgrChngMainSaveRspBO;
import com.tydic.dycpro.saas.agr.agreement.api.DycProSaasAgrChngSaveAndSubmitService;
import com.tydic.dycpro.saas.agr.agreement.bo.DycProSaasAgrChngMainBO;
import com.tydic.dycpro.saas.agr.agreement.bo.DycProSaasAgrChngSaveAndSubmitReqBO;
import com.tydic.dycpro.saas.agr.agreement.bo.DycProSaasAgrChngSaveAndSubmitRspBO;
import com.tydic.osworkflow.approve.ability.EacProjectAbilityService;
import com.tydic.osworkflow.approve.ability.bo.EacStartProjectAbilityReqBO;
import com.tydic.osworkflow.approve.ability.bo.EacStartProjectAbilityRspBO;
import com.tydic.osworkflow.approve.ability.bo.EacStartProjectAbilityRspInfoBO;
import java.util.ArrayList;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_PRO_GROUP/4.0.0/com.tydic.dycpro.saas.agr.agreement.api.DycProSaasAgrChngSaveAndSubmitService"})
public class DycProSaasAgrChngSaveAndSubmitServiceImpl
implements DycProSaasAgrChngSaveAndSubmitService {
    private static final Logger log = LoggerFactory.getLogger(DycProSaasAgrChngSaveAndSubmitServiceImpl.class);
    @Autowired
    private DycProAgrChngMainSaveService dycProAgrChngMainSaveService;
    @Autowired
    private EacProjectAbilityService eacProjectAbilityService;
    @Value(value="${process.sysCode:DYC}")
    private String processSysCode;
    @Value(value="${agr.approve.change.switch:true}")
    private Boolean agrChangeApproveSwitch;
    @Value(value="${agr.approve.change.key:AGR_CHANGE_APPROVE_KEY}")
    private String agrChangeApproveKey;

    @Override
    @PostMapping(value={"saveAndSubmitAgrChng"})
    public DycProSaasAgrChngSaveAndSubmitRspBO saveAndSubmitAgrChng(@RequestBody DycProSaasAgrChngSaveAndSubmitReqBO reqBO) {
        this.validateParam(reqBO);
        if (this.agrChangeApproveSwitch.booleanValue() && reqBO.getOperType() == 1 && (reqBO.getAgrChngInfo().getChngType() == 1 || reqBO.getAgrChngInfo().getChngType() == 2 || reqBO.getAgrChngInfo().getChngType() == 3 || reqBO.getAgrChngInfo().getChngType() == 5)) {
            this.startApprovalFlow(reqBO, this.agrChangeApproveKey, PublicProcInstBusiType.AGR_CHANGE_APPROVE.getCode(), reqBO.getAgrChngInfo().getChngApplyId());
        }
        DycProAgrChngMainSaveRspBO centerRspBO = this.saveAgrChngMain(reqBO, this.agrChangeApproveSwitch);
        log.debug("\u534f\u8bae\u53d8\u66f4\u4fdd\u5b58\u63d0\u4ea4\u8fd4\u56de\u7ed3\u679c\uff1a" + JSON.toJSONString((Object)centerRspBO));
        DycProSaasAgrChngSaveAndSubmitRspBO rspBO = (DycProSaasAgrChngSaveAndSubmitRspBO)((Object)JSON.parseObject((String)JSON.toJSONString((Object)centerRspBO), DycProSaasAgrChngSaveAndSubmitRspBO.class));
        rspBO.setAgrChangeApproveSwitch(this.agrChangeApproveSwitch);
        rspBO.setChngType(reqBO.getAgrChngInfo().getChngType());
        rspBO.setChngApplyId(rspBO.getChngApplyId());
        rspBO.setChngApplyNo(rspBO.getChngApplyNo());
        rspBO.setAgrObjPrimaryId(rspBO.getAgrObjPrimaryId());
        rspBO.setAgrId(rspBO.getAgrId());
        log.debug("\u534f\u8bae\u53d8\u66f4\u4fdd\u5b58SAAS\u8fd4\u56de\u7ed3\u679c\uff1a" + JSON.toJSONString((Object)((Object)rspBO)));
        return rspBO;
    }

    private String startApprovalFlow(DycProSaasAgrChngSaveAndSubmitReqBO reqBO, String procDefKey, String businessType, Long businessId) {
        EacStartProjectAbilityRspBO eacStartProjectAbilityRspBO;
        EacStartProjectAbilityReqBO eacStartProjectAbilityReqBO = new EacStartProjectAbilityReqBO();
        eacStartProjectAbilityReqBO.setSysCode(this.processSysCode);
        eacStartProjectAbilityReqBO.setProcDefKey(procDefKey);
        eacStartProjectAbilityReqBO.setBusinessType(businessType);
        ArrayList<String> businessIdList = new ArrayList<String>();
        businessIdList.add(businessId.toString());
        eacStartProjectAbilityReqBO.setBusinessIdList(businessIdList);
        eacStartProjectAbilityReqBO.setOrgId(reqBO.getOrgId().toString());
        eacStartProjectAbilityReqBO.setOrgName(reqBO.getOrgName());
        eacStartProjectAbilityReqBO.setUserId(reqBO.getUserId().toString());
        eacStartProjectAbilityReqBO.setUserName(reqBO.getName());
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("agrObjPrimaryId", businessId);
        variables.put("auditResult", "pass");
        eacStartProjectAbilityReqBO.setVariables(variables);
        try {
            log.info("\u534f\u8bae\u521b\u5efa\u5ba1\u6279\u5355\u5165\u53c2eacStartProjectAbilityReqBO :" + JSON.toJSON((Object)eacStartProjectAbilityReqBO));
            eacStartProjectAbilityRspBO = this.eacProjectAbilityService.startProjectByMq(eacStartProjectAbilityReqBO);
            log.info("\u534f\u8bae\u521b\u5efa\u5ba1\u6279\u5355\u51fa\u53c2eacStartProjectAbilityRspBO:" + JSON.toJSON((Object)eacStartProjectAbilityRspBO));
        }
        catch (Exception e) {
            log.error("\u534f\u8bae\u521b\u5efa\u5ba1\u6279\u5355\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e);
            throw new ZTBusinessException("\u534f\u8bae\u521b\u5efa\u5ba1\u6279\u5355\u5931\u8d25");
        }
        if (!"0000".equals(eacStartProjectAbilityRspBO.getRespCode())) {
            throw new ZTBusinessException("\u8c03\u7528\u6d41\u7a0b\u5ba1\u6279\u542f\u52a8\u5931\u8d25,\u5f02\u5e38\u7f16\u7801\u3010" + eacStartProjectAbilityRspBO.getRespCode() + "\u3011," + eacStartProjectAbilityRspBO.getRespDesc());
        }
        return ((EacStartProjectAbilityRspInfoBO)eacStartProjectAbilityRspBO.getData().get(0)).getApproveInstId();
    }

    private DycProAgrChngMainSaveRspBO saveAgrChngMain(DycProSaasAgrChngSaveAndSubmitReqBO reqBO, boolean agrChangeApproveSwitch) {
        DycProAgrChngMainSaveReqBO centerReqBO = (DycProAgrChngMainSaveReqBO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), DycProAgrChngMainSaveReqBO.class);
        centerReqBO.setApproveSwitch(Boolean.valueOf(agrChangeApproveSwitch));
        DycProAgrChngMainSaveRspBO centerRspBO = this.dycProAgrChngMainSaveService.saveAgrChngMain(centerReqBO);
        if (!"0000".equals(centerRspBO.getRespCode())) {
            throw new ZTBusinessException(centerRspBO.getRespDesc());
        }
        return centerRspBO;
    }

    private void validateParam(DycProSaasAgrChngSaveAndSubmitReqBO reqBO) {
        if (reqBO == null) {
            throw new ZTBusinessException("\u5165\u53c2[reqBO]\u4e3a\u7a7a");
        }
        if (null == reqBO.getOperType()) {
            throw new ZTBusinessException("\u5165\u53c2\u3010operType\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == reqBO.getAgrChngInfo()) {
            throw new ZTBusinessException("\u5165\u53c2\u3010agrChngInfo\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        DycProSaasAgrChngMainBO agrChngInfo = reqBO.getAgrChngInfo();
        if (null == agrChngInfo.getChngType()) {
            throw new ZTBusinessException("\u5165\u53c2\u3010agrChngInfo.chngType\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == agrChngInfo.getAgrObjPrimaryId()) {
            throw new ZTBusinessException("\u5165\u53c2\u3010agrChngInfo.agrObjPrimaryId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

