package com.tydic.dyc.pro.base.utils.esb;

import lombok.Data;

import java.math.BigDecimal;

/**
 * 标题：DycProBaseCallEsbUtilUpdateSendSkuReqBO
 * 描述：售后发运信息填写入参（非京东）
 */
@Data
public class DycProBaseCallEsbUtilUpdateSendSkuReqBO extends DycProBaseCallEsbReqBaseBO {

    private static final long serialVersionUID = -4095279691690037012L;

    /**
     * 供应商识别编码
     */
    private String hsn;

    /**
     * 调用地址
     */
    private String url;

    /**
     * 服务单号
     */
    private String afsServiceId;

    /**
     * 运费
     */
    private BigDecimal freightMoney;

    /**
     * 发运公司：例如圆通快递、申通快递
     */
    private String expressCompany;

    /**
     * 发货日期，格式为yyyy-MM-dd HH:mm:ss
     */
    private String deliverDate;

    /**
     * 快递单号
     */
    private String trackingCode;

}
