/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.dmc.service.agrchng.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.pro.base.bo.esmapping.DycProEsIndexMappingBansRuleBO;
import com.tydic.dyc.pro.base.bo.esmapping.DycProEsIndexMappingSkuInUpcBO;
import com.tydic.dyc.pro.base.core.encode.service.api.DycProEncodeSerialService;
import com.tydic.dyc.pro.base.core.encode.service.bo.DycProEncodeSerialReqBO;
import com.tydic.dyc.pro.base.core.encode.service.bo.DycProEncodeSerialRspBO;
import com.tydic.dyc.pro.dmc.constant.DycProAgrConstants;
import com.tydic.dyc.pro.dmc.repository.agrchng.api.DycProAgrChngRepository;
import com.tydic.dyc.pro.dmc.repository.agrchng.dto.DycProAgrApplicationScopeChngDTO;
import com.tydic.dyc.pro.dmc.repository.agrchng.dto.DycProAgrChngMainDTO;
import com.tydic.dyc.pro.dmc.repository.agreement.api.DycProAgrRepository;
import com.tydic.dyc.pro.dmc.repository.agreement.dto.DycProAgrBansRecordInfoDTO;
import com.tydic.dyc.pro.dmc.repository.agreement.dto.DycProAgrListQryDTO;
import com.tydic.dyc.pro.dmc.repository.agreement.dto.DycProAgrMainDTO;
import com.tydic.dyc.pro.dmc.repository.agreement.dto.DycProAgrMainHandleDTO;
import com.tydic.dyc.pro.dmc.repository.agreement.dto.DycProAgrMainQryDTO;
import com.tydic.dyc.pro.dmc.repository.agreement.dto.DycProAgrSkuDTO;
import com.tydic.dyc.pro.dmc.service.agrchng.api.DycProAgrChngMainSaveService;
import com.tydic.dyc.pro.dmc.service.agrchng.bo.DycProAgrApplicationScopeChngApiBO;
import com.tydic.dyc.pro.dmc.service.agrchng.bo.DycProAgrChngMainApiBO;
import com.tydic.dyc.pro.dmc.service.agrchng.bo.DycProAgrChngMainSaveReqBO;
import com.tydic.dyc.pro.dmc.service.agrchng.bo.DycProAgrChngMainSaveRspBO;
import com.tydic.dyc.pro.dmc.service.agrchng.bo.DycProAgrCooperationChngCatalogApiBO;
import com.tydic.dyc.pro.dmc.service.agrchng.bo.DycProAgrFileInfoApiBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"DMC_GROUP/4.0.0/com.tydic.dyc.pro.dmc.service.agrchng.api.DycProAgrChngMainSaveService"})
public class DycProAgrChngMainSaveServiceImpl
implements DycProAgrChngMainSaveService {
    private static final Logger log = LoggerFactory.getLogger(DycProAgrChngMainSaveServiceImpl.class);
    @Autowired
    private DycProAgrRepository agrMainRepository;
    @Autowired
    private DycProAgrChngRepository agrChngRepository;
    @Autowired
    private DycProEncodeSerialService encodeSerialService;

    @PostMapping(value={"saveAgrChngMain"})
    public DycProAgrChngMainSaveRspBO saveAgrChngMain(@RequestBody DycProAgrChngMainSaveReqBO reqBO) {
        DycProAgrChngMainSaveRspBO rspBO = new DycProAgrChngMainSaveRspBO();
        this.validateParam(reqBO);
        DycProAgrChngMainDTO agrChngMainDetail = this.getDycProAgrChngMain(reqBO);
        DycProAgrMainDTO agrDetail = this.getDycProAgrMainDTO(reqBO);
        if (agrChngMainDetail == null || ObjectUtils.isEmpty((Object)agrChngMainDetail) || null == agrChngMainDetail.getChngApplyId()) {
            DycProAgrChngMainApiBO agrChngMain = this.createAgrChngMain(reqBO, agrDetail);
            rspBO.setChngApplyId(agrChngMain.getChngApplyId());
            rspBO.setChngApplyNo(agrChngMain.getChngApplyNo());
            rspBO.setAgrObjPrimaryId(reqBO.getAgrChngInfo().getAgrObjPrimaryId());
            rspBO.setAgrId(reqBO.getAgrChngInfo().getAgrId());
        } else {
            this.updateAgrChngMain(reqBO, agrDetail);
            rspBO.setChngApplyId(reqBO.getAgrChngInfo().getChngApplyId());
            rspBO.setChngApplyNo(reqBO.getAgrChngInfo().getChngApplyNo());
            rspBO.setAgrObjPrimaryId(reqBO.getAgrChngInfo().getAgrObjPrimaryId());
            rspBO.setAgrId(reqBO.getAgrChngInfo().getAgrId());
        }
        if (Objects.equals(reqBO.getOperType(), DycProAgrConstants.AgrInterfaceOperType.SUBMIT)) {
            this.dealAgrStatusAndCommLable(reqBO, agrDetail);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void dealAgrStatusAndCommLable(DycProAgrChngMainSaveReqBO reqBO, DycProAgrMainDTO agrDetail) {
        switch (reqBO.getAgrChngInfo().getChngType()) {
            case 1: {
                this.dealFreezeAgr(reqBO, agrDetail);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                this.dealFreezeAgr(reqBO, agrDetail);
                break;
            }
            case 4: {
                this.dealFreezeAgr(reqBO, agrDetail);
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                this.dealFreezeAgr(reqBO, agrDetail);
                break;
            }
            case 7: {
                this.dealFreezeAgr(reqBO, agrDetail);
                break;
            }
        }
    }

    private void dealFreezeAgr(DycProAgrChngMainSaveReqBO reqBO, DycProAgrMainDTO agrDetail) {
        if (Objects.equals(agrDetail.getAgrStatus(), DycProAgrConstants.AgrStatus.ACTIVE)) {
            if (reqBO.getApproveSwitch().booleanValue()) {
                if (reqBO.getAgrChngInfo().getChngType().equals(DycProAgrConstants.AgrChngType.PAUSE) || reqBO.getAgrChngInfo().getChngType().equals(DycProAgrConstants.AgrChngType.TERMINATE) || reqBO.getAgrChngInfo().getChngType().equals(DycProAgrConstants.AgrChngType.SUPPLEMENT) || reqBO.getAgrChngInfo().getChngType().equals(DycProAgrConstants.AgrChngType.ADJUST_PRICE)) {
                    ArrayList<DycProAgrMainDTO> dycProAgrMainDTOList = new ArrayList<DycProAgrMainDTO>();
                    DycProAgrMainDTO updateAgrMainDTO = new DycProAgrMainDTO();
                    updateAgrMainDTO.setAgrObjPrimaryId(reqBO.getAgrChngInfo().getAgrObjPrimaryId());
                    updateAgrMainDTO.setAgrStatus(DycProAgrConstants.AgrStatus.FREEZE);
                    dycProAgrMainDTOList.add(updateAgrMainDTO);
                    this.agrMainRepository.updateAgrMainByIds(dycProAgrMainDTOList);
                    ArrayList<DycProAgrMainHandleDTO> handleDTOList = new ArrayList<DycProAgrMainHandleDTO>();
                    DycProAgrMainHandleDTO handleDTO = new DycProAgrMainHandleDTO();
                    handleDTO.setAgrObjPrimaryId(reqBO.getAgrChngInfo().getAgrObjPrimaryId());
                    handleDTO.setAgrId(reqBO.getAgrChngInfo().getAgrId());
                    if (reqBO.getAgrChngInfo().getChngType().equals(DycProAgrConstants.AgrChngType.PAUSE)) {
                        handleDTO.setBansType(DycProAgrConstants.BansType.AGR_PAUSE);
                        handleDTO.setBansReason("\u534f\u8bae\u6682\u505c");
                    }
                    if (reqBO.getAgrChngInfo().getChngType().equals(DycProAgrConstants.AgrChngType.TERMINATE)) {
                        handleDTO.setBansType(DycProAgrConstants.BansType.AGR_TERMINATE);
                        handleDTO.setBansReason("\u534f\u8bae\u7ec8\u6b62");
                    }
                    if (reqBO.getAgrChngInfo().getChngType().equals(DycProAgrConstants.AgrChngType.SUPPLEMENT)) {
                        handleDTO.setBansType(DycProAgrConstants.BansType.AGR_SUPPLEMENT);
                        handleDTO.setBansReason("\u534f\u8bae\u8865\u5145");
                    }
                    if (reqBO.getAgrChngInfo().getChngType().equals(DycProAgrConstants.AgrChngType.ADJUST_PRICE)) {
                        handleDTO.setBansType(DycProAgrConstants.BansType.AGR_ADJUST_PRICE);
                        handleDTO.setBansReason("\u534f\u8bae\u8c03\u4ef7");
                    }
                    handleDTOList.add(handleDTO);
                    DycProAgrMainDTO addBansRecordRsp = this.agrChngRepository.addBansRecordBatchAndSyncNosql(handleDTOList, true);
                    this.sysnUpdateUpcSkuInfo(addBansRecordRsp, reqBO);
                }
            } else if (reqBO.getAgrChngInfo().getChngType().equals(DycProAgrConstants.AgrChngType.SUPPLEMENT) || reqBO.getAgrChngInfo().getChngType().equals(DycProAgrConstants.AgrChngType.ADJUST_PRICE)) {
                ArrayList<DycProAgrMainDTO> dycProAgrMainDTOList = new ArrayList<DycProAgrMainDTO>();
                DycProAgrMainDTO updateAgrMainDTO = new DycProAgrMainDTO();
                updateAgrMainDTO.setAgrObjPrimaryId(reqBO.getAgrChngInfo().getAgrObjPrimaryId());
                updateAgrMainDTO.setAgrStatus(DycProAgrConstants.AgrStatus.FREEZE);
                dycProAgrMainDTOList.add(updateAgrMainDTO);
                this.agrMainRepository.updateAgrMainByIds(dycProAgrMainDTOList);
                ArrayList<DycProAgrMainHandleDTO> handleDTOList = new ArrayList<DycProAgrMainHandleDTO>();
                DycProAgrMainHandleDTO handleDTO = new DycProAgrMainHandleDTO();
                handleDTO.setAgrObjPrimaryId(reqBO.getAgrChngInfo().getAgrObjPrimaryId());
                handleDTO.setAgrId(reqBO.getAgrChngInfo().getAgrId());
                handleDTO.setBansType(DycProAgrConstants.BansType.AGREEMENT_FREEZE);
                handleDTO.setBansReason("\u534f\u8bae\u6682\u505c");
                if (reqBO.getAgrChngInfo().getChngType().equals(DycProAgrConstants.AgrChngType.SUPPLEMENT)) {
                    handleDTO.setBansReason("\u534f\u8bae\u8865\u5145");
                }
                if (reqBO.getAgrChngInfo().getChngType().equals(DycProAgrConstants.AgrChngType.ADJUST_PRICE)) {
                    handleDTO.setBansReason("\u534f\u8bae\u8c03\u4ef7");
                }
                handleDTOList.add(handleDTO);
                DycProAgrMainDTO addBansRecordRsp = this.agrChngRepository.addBansRecordBatchAndSyncNosql(handleDTOList, true);
                this.sysnUpdateUpcSkuInfo(addBansRecordRsp, reqBO);
            }
        }
    }

    private void sysnUpdateUpcSkuInfo(DycProAgrMainDTO addBansRecordRsp, DycProAgrChngMainSaveReqBO reqBO) {
        DycProAgrListQryDTO qryCommSkuDTO = new DycProAgrListQryDTO();
        qryCommSkuDTO.setAgrIds(Collections.singletonList(reqBO.getAgrChngInfo().getAgrId()));
        DycProAgrMainDTO agrSkuDTO = this.agrMainRepository.qrySkuByAgr(qryCommSkuDTO);
        List agrSkuList = agrSkuDTO.getAgrSkuList();
        List<Object> updateUpcSkuList = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)agrSkuList)) {
            updateUpcSkuList = agrSkuList.stream().filter(sku -> sku.getUpcId() != null).collect(Collectors.toList());
        }
        if (!CollectionUtils.isEmpty(updateUpcSkuList)) {
            Map upcSkuMap = updateUpcSkuList.stream().distinct().collect(Collectors.toMap(DycProAgrSkuDTO::getSkuId, Function.identity()));
            if (!CollectionUtils.isEmpty((Collection)addBansRecordRsp.getBansRecordInfoList())) {
                List bansRecordInfoList = addBansRecordRsp.getBansRecordInfoList();
                Map<Long, List<DycProAgrBansRecordInfoDTO>> addBansRecordMap = bansRecordInfoList.stream().collect(Collectors.groupingBy(DycProAgrBansRecordInfoDTO::getSkuId));
                for (Map.Entry<Long, List<DycProAgrBansRecordInfoDTO>> addBansRecord : addBansRecordMap.entrySet()) {
                    if (!upcSkuMap.containsKey(addBansRecord.getKey())) continue;
                    DycProEsIndexMappingSkuInUpcBO updateUpcSkuBO = new DycProEsIndexMappingSkuInUpcBO();
                    updateUpcSkuBO.setSkuId(addBansRecord.getKey());
                    ArrayList bansRuleList = new ArrayList(JSON.parseArray((String)JSON.toJSONString(addBansRecord.getValue()), DycProEsIndexMappingBansRuleBO.class));
                    updateUpcSkuBO.setBansRuleList(bansRuleList);
                    this.agrChngRepository.sysnUpdateUpcSkuInfo(updateUpcSkuBO);
                }
            }
        }
    }

    private DycProAgrChngMainDTO getDycProAgrChngMain(DycProAgrChngMainSaveReqBO reqBO) {
        DycProAgrChngMainDTO qryDTO = new DycProAgrChngMainDTO();
        qryDTO.setChngApplyId(reqBO.getAgrChngInfo().getChngApplyId());
        return this.agrChngRepository.getAgrChngMainInfo(qryDTO);
    }

    private DycProAgrMainDTO getDycProAgrMainDTO(DycProAgrChngMainSaveReqBO reqBO) {
        DycProAgrMainQryDTO qryDTO = new DycProAgrMainQryDTO();
        qryDTO.setAgrObjPrimaryId(reqBO.getAgrChngInfo().getAgrObjPrimaryId());
        qryDTO.setQryManageCatalogFlag(Boolean.valueOf(true));
        qryDTO.setQryScopeFlag(Boolean.valueOf(true));
        return this.agrMainRepository.getAgrDetail(qryDTO);
    }

    public DycProAgrChngMainApiBO createAgrChngMain(DycProAgrChngMainSaveReqBO reqBO, DycProAgrMainDTO agrDetail) {
        JSONObject agrDetailJson = JSON.parseObject((String)JSON.toJSONString((Object)agrDetail));
        JSONObject reqChngInfoJson = JSON.parseObject((String)JSON.toJSONString((Object)reqBO.getAgrChngInfo()));
        agrDetailJson.putAll((Map)reqChngInfoJson);
        DycProAgrChngMainDTO insertDTO = (DycProAgrChngMainDTO)JSON.parseObject((String)JSON.toJSONString((Object)agrDetailJson), DycProAgrChngMainDTO.class);
        if (insertDTO.getPurScopeType().equals(DycProAgrConstants.AgrScopeType.ALL)) {
            insertDTO.setViewScopeType(DycProAgrConstants.AgrScopeType.ALL);
        }
        insertDTO.setOldAgrStatus(agrDetail.getAgrStatus());
        if (Objects.equals(reqBO.getOperType(), DycProAgrConstants.AgrInterfaceOperType.SUBMIT)) {
            if (reqBO.getApproveSwitch().booleanValue() && (Objects.equals(reqBO.getAgrChngInfo().getChngType(), DycProAgrConstants.AgrChngType.PAUSE) || Objects.equals(reqBO.getAgrChngInfo().getChngType(), DycProAgrConstants.AgrChngType.ENABLE) || Objects.equals(reqBO.getAgrChngInfo().getChngType(), DycProAgrConstants.AgrChngType.TERMINATE) || Objects.equals(reqBO.getAgrChngInfo().getChngType(), DycProAgrConstants.AgrChngType.EXTEND))) {
                insertDTO.setChngApplyStatus(DycProAgrConstants.AgrChngStatus.APPROVAL);
            } else {
                insertDTO.setChngApplyStatus(DycProAgrConstants.AgrChngStatus.CONFIRMING);
            }
        } else if (Objects.equals(reqBO.getOperType(), DycProAgrConstants.AgrInterfaceOperType.SAVE)) {
            insertDTO.setChngApplyStatus(DycProAgrConstants.AgrChngStatus.DRAFT);
        }
        DycProEncodeSerialReqBO encodeSerialReqBO = new DycProEncodeSerialReqBO();
        encodeSerialReqBO.setCenterCode("AGR");
        switch (reqBO.getAgrChngInfo().getChngType()) {
            case 1: {
                encodeSerialReqBO.setEncodeRuleCode("AGREEMENT_CHNG_RULE_ZT_CODE");
                break;
            }
            case 2: {
                encodeSerialReqBO.setEncodeRuleCode("AGREEMENT_CHNG_RULE_QY_CODE");
                break;
            }
            case 3: {
                encodeSerialReqBO.setEncodeRuleCode("AGREEMENT_CHNG_RULE_ZZ_CODE");
                break;
            }
            case 4: {
                encodeSerialReqBO.setEncodeRuleCode("AGREEMENT_CHNG_RULE_TJ_CODE");
                break;
            }
            case 5: {
                encodeSerialReqBO.setEncodeRuleCode("AGREEMENT_CHNG_RULE_YQ_CODE");
                break;
            }
            case 6: {
                encodeSerialReqBO.setEncodeRuleCode("AGREEMENT_CHNG_RULE_BC_CODE");
                break;
            }
            case 7: {
                encodeSerialReqBO.setEncodeRuleCode("AGREEMENT_CHNG_RULE_QT_CODE");
                break;
            }
        }
        encodeSerialReqBO.setNum(Long.valueOf(1L));
        DycProEncodeSerialRspBO encode = this.encodeSerialService.getEncode(encodeSerialReqBO);
        insertDTO.setChngApplyNo(reqBO.getAgrChngInfo().getAgrCode() + "-" + (String)encode.getSerialNoList().get(0));
        ArrayList agrApplicationScopeChngList = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)reqBO.getAgrChngInfo().getPurChngScopeList())) {
            agrApplicationScopeChngList.addAll(JSON.parseArray((String)JSON.toJSONString((Object)reqBO.getAgrChngInfo().getPurChngScopeList()), DycProAgrApplicationScopeChngDTO.class));
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getAgrChngInfo().getViewChngScopeList())) {
            agrApplicationScopeChngList.addAll(JSON.parseArray((String)JSON.toJSONString((Object)reqBO.getAgrChngInfo().getViewChngScopeList()), DycProAgrApplicationScopeChngDTO.class));
        }
        insertDTO.setChngApplyId(reqBO.getAgrChngInfo().getChngApplyId());
        insertDTO.setAgrApplicationScopeChngList(agrApplicationScopeChngList);
        insertDTO.setCreateUserId(reqBO.getUserId());
        insertDTO.setCreateUserName(reqBO.getName());
        insertDTO.setCreateUserAccount(reqBO.getUserName());
        insertDTO.setCreateCompanyId(reqBO.getCompanyId());
        insertDTO.setCreateOrgId(reqBO.getOrgId());
        insertDTO.setCreateOrgPath(reqBO.getOrgPath());
        insertDTO.setCreateCompanyName(reqBO.getCompanyName());
        insertDTO.setCreateOrgName(reqBO.getOrgName());
        log.debug("\u65b0\u589e\u534f\u8bae\u53d8\u66f4\u5355\u57fa\u5efa\u5c42\u5165\u53c2:{}", (Object)insertDTO);
        DycProAgrChngMainDTO agrChngInfo = this.agrChngRepository.createAgrChngInfo(insertDTO);
        DycProAgrChngMainApiBO agrChngMainBO = new DycProAgrChngMainApiBO();
        agrChngMainBO.setChngApplyId(agrChngInfo.getChngApplyId());
        agrChngMainBO.setChngApplyNo(insertDTO.getChngApplyNo());
        return agrChngMainBO;
    }

    public void updateAgrChngMain(DycProAgrChngMainSaveReqBO reqBO, DycProAgrMainDTO agrDetail) {
        DycProAgrChngMainDTO updateChngMainDTO = (DycProAgrChngMainDTO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO.getAgrChngInfo()), DycProAgrChngMainDTO.class);
        updateChngMainDTO.setOldAgrStatus(agrDetail.getAgrStatus());
        if (Objects.equals(reqBO.getOperType(), DycProAgrConstants.AgrInterfaceOperType.SUBMIT)) {
            if (reqBO.getApproveSwitch().booleanValue() && (Objects.equals(reqBO.getAgrChngInfo().getChngType(), DycProAgrConstants.AgrChngType.PAUSE) || Objects.equals(reqBO.getAgrChngInfo().getChngType(), DycProAgrConstants.AgrChngType.ENABLE) || Objects.equals(reqBO.getAgrChngInfo().getChngType(), DycProAgrConstants.AgrChngType.TERMINATE) || Objects.equals(reqBO.getAgrChngInfo().getChngType(), DycProAgrConstants.AgrChngType.EXTEND))) {
                updateChngMainDTO.setChngApplyStatus(DycProAgrConstants.AgrChngStatus.APPROVAL);
            } else {
                updateChngMainDTO.setChngApplyStatus(DycProAgrConstants.AgrChngStatus.CONFIRMING);
            }
        }
        ArrayList agrApplicationScopeChngList = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)reqBO.getAgrChngInfo().getPurChngScopeList())) {
            agrApplicationScopeChngList.addAll(JSON.parseArray((String)JSON.toJSONString((Object)reqBO.getAgrChngInfo().getPurChngScopeList()), DycProAgrApplicationScopeChngDTO.class));
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getAgrChngInfo().getViewChngScopeList())) {
            agrApplicationScopeChngList.addAll(JSON.parseArray((String)JSON.toJSONString((Object)reqBO.getAgrChngInfo().getViewChngScopeList()), DycProAgrApplicationScopeChngDTO.class));
        }
        updateChngMainDTO.setAgrApplicationScopeChngList(agrApplicationScopeChngList);
        updateChngMainDTO.setUpdateUserId(reqBO.getUserId());
        updateChngMainDTO.setUpdateUserName(reqBO.getName());
        updateChngMainDTO.setUpdateUserAccount(reqBO.getUserName());
        updateChngMainDTO.setUpdateCompanyId(reqBO.getCompanyId());
        updateChngMainDTO.setUpdateOrgId(reqBO.getOrgId());
        updateChngMainDTO.setUpdateOrgPath(reqBO.getOrgPath());
        updateChngMainDTO.setUpdateCompanyName(reqBO.getCompanyName());
        updateChngMainDTO.setUpdateOrgName(reqBO.getOrgName());
        this.agrChngRepository.updateAgrChngInfo(updateChngMainDTO);
    }

    private void validateParam(DycProAgrChngMainSaveReqBO reqBO) {
        if (reqBO == null) {
            throw new ZTBusinessException("\u5165\u53c2[reqBO]\u4e3a\u7a7a");
        }
        if (null == reqBO.getOperType()) {
            throw new ZTBusinessException("\u5165\u53c2\u3010operType\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == reqBO.getAgrChngInfo()) {
            throw new ZTBusinessException("\u5165\u53c2\u3010agrChngInfo\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (Objects.equals(reqBO.getOperType(), DycProAgrConstants.AgrInterfaceOperType.SUBMIT)) {
            DycProAgrChngMainApiBO agrChngInfo = reqBO.getAgrChngInfo();
            if (null == agrChngInfo.getChngType()) {
                throw new ZTBusinessException("\u5165\u53c2\u3010agrChngInfo.chngType\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (null == agrChngInfo.getAgrObjPrimaryId()) {
                throw new ZTBusinessException("\u5165\u53c2\u3010agrChngInfo.agrObjPrimaryId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (null == agrChngInfo.getAgrId()) {
                throw new ZTBusinessException("\u5165\u53c2\u3010agrChngInfo.agrId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (null == agrChngInfo.getChngApplyId()) {
                throw new ZTBusinessException("\u5165\u53c2\u3010agrChngInfo.chngApplyId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StringUtils.isEmpty((String)agrChngInfo.getAgrCode())) {
                throw new ZTBusinessException("\u5165\u53c2\u3010agrChngInfo.agrCode\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (agrChngInfo.getChngType().equals(DycProAgrConstants.AgrChngType.OTHER)) {
                if (null == agrChngInfo.getVendorMode()) {
                    throw new ZTBusinessException("\u5165\u53c2\u3010agrChngInfo.vendorMode\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (agrChngInfo.getVendorMode().equals(DycProAgrConstants.AgrVendorMode.OPER)) {
                    agrChngInfo.setManagementOrgId(reqBO.getCompanyId());
                    agrChngInfo.setManagementOrgName(reqBO.getCompanyName());
                } else if (agrChngInfo.getVendorMode().equals(DycProAgrConstants.AgrVendorMode.SUP)) {
                    agrChngInfo.setManagementOrgId(agrChngInfo.getSupplierId());
                    agrChngInfo.setManagementOrgName(agrChngInfo.getSupplierName());
                } else if (agrChngInfo.getVendorMode().equals(DycProAgrConstants.AgrVendorMode.PUR)) {
                    agrChngInfo.setManagementOrgId(reqBO.getCompanyId());
                    agrChngInfo.setManagementOrgName(reqBO.getCompanyName());
                }
                if (null == agrChngInfo.getAdjustPriceType()) {
                    throw new ZTBusinessException("\u5165\u53c2\u3010agrChngInfo.adjustPriceType\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (null != agrChngInfo.getWhetherManageCatalog() && agrChngInfo.getWhetherManageCatalog().equals(DycProAgrConstants.AgrBooleanFlag.YES)) {
                    if (CollectionUtils.isEmpty((Collection)agrChngInfo.getAgrCooperationChngCatalogBOList())) {
                        throw new ZTBusinessException("\u5165\u53c2\u3010agrChngInfo.agrCooperationChngCatalogBOList\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    }
                    for (DycProAgrCooperationChngCatalogApiBO catalogBO : agrChngInfo.getAgrCooperationChngCatalogBOList()) {
                        if (ObjectUtils.isEmpty((Object)catalogBO.getManageCatalogId())) {
                            throw new ZTBusinessException("\u3010\u5408\u4f5c\u7c7b\u76eeid\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                        }
                        if (ObjectUtils.isEmpty((Object)catalogBO.getManageCatalogName())) {
                            throw new ZTBusinessException("\u3010\u5408\u4f5c\u7c7b\u76ee\u540d\u79f0\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                        }
                        if (ObjectUtils.isEmpty((Object)catalogBO.getManageCatalogLevel())) {
                            throw new ZTBusinessException("\u3010\u5408\u4f5c\u7c7b\u76ee\u7b49\u7ea7\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                        }
                        if (ObjectUtils.isEmpty((Object)catalogBO.getManageCatalogParentId())) {
                            throw new ZTBusinessException("\u3010\u5408\u4f5c\u76ee\u5f55\u4e0a\u7ea7id\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                        }
                        if (ObjectUtils.isEmpty((Object)catalogBO.getDiscountRate())) {
                            throw new ZTBusinessException("\u3010\u6298\u6263\u7387\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                        }
                        if (!ObjectUtils.isEmpty((Object)catalogBO.getServiceChargeRate())) continue;
                        throw new ZTBusinessException("\u3010\u670d\u52a1\u8d39\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                }
                if (ObjectUtils.isEmpty((Object)agrChngInfo.getPurScopeType())) {
                    throw new ZTBusinessException("\u3010\u53ef\u91c7\u8d2d\u8303\u56f4\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (DycProAgrConstants.AgrScopeType.SPECIFIED_COMPANY.equals(agrChngInfo.getPurScopeType())) {
                    if (CollectionUtils.isEmpty((Collection)agrChngInfo.getPurChngScopeList())) {
                        throw new ZTBusinessException("\u3010\u534f\u8bae\u9002\u7528\u8303\u56f4\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    for (DycProAgrApplicationScopeChngApiBO scopeBO : agrChngInfo.getPurChngScopeList()) {
                        if (ObjectUtils.isEmpty((Object)scopeBO.getApplicationType())) {
                            throw new ZTBusinessException("\u3010\u9002\u7528\u7c7b\u578b\u9009\u9879\u503c\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                        }
                        if (ObjectUtils.isEmpty((Object)scopeBO.getApplicationType())) {
                            throw new ZTBusinessException("\u3010\u9002\u7528\u8303\u56f4\u5355\u4f4dID\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                        }
                        if (!ObjectUtils.isEmpty((Object)scopeBO.getApplicationScopeOrgTreePath())) continue;
                        throw new ZTBusinessException("\u3010\u9002\u7528\u5355\u4f4d\u673a\u6784\u6811\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                }
                if (DycProAgrConstants.AgrScopeType.SPECIFIED_COMPANY.equals(agrChngInfo.getViewScopeType())) {
                    if (CollectionUtils.isEmpty((Collection)agrChngInfo.getViewChngScopeList())) {
                        throw new ZTBusinessException("\u3010\u534f\u8bae\u9002\u7528\u8303\u56f4\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    for (DycProAgrApplicationScopeChngApiBO scopeBO : agrChngInfo.getViewChngScopeList()) {
                        if (ObjectUtils.isEmpty((Object)scopeBO.getApplicationType())) {
                            throw new ZTBusinessException("\u3010\u9002\u7528\u7c7b\u578b\u9009\u9879\u503c\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                        }
                        if (ObjectUtils.isEmpty((Object)scopeBO.getApplicationType())) {
                            throw new ZTBusinessException("\u3010\u9002\u7528\u8303\u56f4\u5355\u4f4dID\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                        }
                        if (!ObjectUtils.isEmpty((Object)scopeBO.getApplicationScopeOrgTreePath())) continue;
                        throw new ZTBusinessException("\u3010\u9002\u7528\u5355\u4f4d\u673a\u6784\u6811\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                }
            }
            if (!ObjectUtils.isEmpty((Object)agrChngInfo.getAgrFileInfoBOList())) {
                for (DycProAgrFileInfoApiBO fileInfoBO : agrChngInfo.getAgrFileInfoBOList()) {
                    if (ObjectUtils.isEmpty((Object)fileInfoBO.getFileName())) {
                        throw new ZTBusinessException("\u3010\u9644\u4ef6\u540d\u79f0\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (!ObjectUtils.isEmpty((Object)fileInfoBO.getFileUrl())) continue;
                    throw new ZTBusinessException("\u3010\u9644\u4ef6url\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                }
            }
        }
    }
}

