/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.dmc.service.agreement.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.pro.base.bo.esmapping.DycProEsIndexMappingBansRuleBO;
import com.tydic.dyc.pro.base.bo.esmapping.DycProEsIndexMappingSkuInUpcBO;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcAgrChngApplyChngApplyStatus;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcAgrChngApplyChngType;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcAgrConfirmType;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcAgrMainAgrStatus;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcCommBansRecordBansTypeEnum;
import com.tydic.dyc.pro.dmc.repository.agrchng.api.DycProAgrChngRepository;
import com.tydic.dyc.pro.dmc.repository.agrchng.dto.DycProAgrChngHandleDTO;
import com.tydic.dyc.pro.dmc.repository.agrchng.dto.DycProAgrChngMainDTO;
import com.tydic.dyc.pro.dmc.repository.agreement.api.DycProAgrRepository;
import com.tydic.dyc.pro.dmc.repository.agreement.dto.DycProAgrBansRecordInfoDTO;
import com.tydic.dyc.pro.dmc.repository.agreement.dto.DycProAgrListQryDTO;
import com.tydic.dyc.pro.dmc.repository.agreement.dto.DycProAgrMainDTO;
import com.tydic.dyc.pro.dmc.repository.agreement.dto.DycProAgrMainHandleDTO;
import com.tydic.dyc.pro.dmc.repository.agreement.dto.DycProAgrSkuDTO;
import com.tydic.dyc.pro.dmc.service.agreement.api.DycProAgrDealConfirmService;
import com.tydic.dyc.pro.dmc.service.agreement.bo.DycProAgrDealConfirmReqBO;
import com.tydic.dyc.pro.dmc.service.agreement.bo.DycProAgrDealConfirmRspBO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"DMC_GROUP/4.0.0/com.tydic.dyc.pro.dmc.service.agreement.api.DycProAgrDealConfirmService"})
public class DycProAgrDealConfirmServiceImpl
implements DycProAgrDealConfirmService {
    @Autowired
    private DycProAgrRepository agrMainRepository;
    @Autowired
    private DycProAgrChngRepository agrChngRepository;

    @PostMapping(value={"dealAgrConfirm"})
    public DycProAgrDealConfirmRspBO dealAgrConfirm(@RequestBody DycProAgrDealConfirmReqBO reqBO) {
        this.judge(reqBO);
        if (reqBO.getConfirmType().equals(Integer.parseInt(DmcAgrConfirmType.CREATE.getCode()))) {
            this.dealAgrCreate(reqBO);
        } else if (reqBO.getConfirmType().equals(Integer.parseInt(DmcAgrConfirmType.CHANGE.getCode()))) {
            this.dealAgrChange(reqBO);
        }
        DycProAgrDealConfirmRspBO rspBO = new DycProAgrDealConfirmRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void dealAgrCreate(DycProAgrDealConfirmReqBO reqBO) {
        DycProAgrListQryDTO agrListQryDTO = new DycProAgrListQryDTO();
        agrListQryDTO.setAgrObjPrimaryId(reqBO.getAgrObjPrimaryId());
        List agrMainList = this.agrMainRepository.selectAgrMainList(agrListQryDTO);
        if (CollectionUtils.isEmpty((Collection)agrMainList)) {
            throw new ZTBusinessException("\u534f\u8bae\u67e5\u8be2\u4e3a\u7a7a");
        }
        DycProAgrMainDTO agrMainDTO = (DycProAgrMainDTO)agrMainList.get(0);
        if (!agrMainDTO.getAgrStatus().equals(Integer.parseInt(DmcAgrMainAgrStatus.PENDING_REVIEW.getCode()))) {
            throw new ZTBusinessException("\u5f53\u524d\u534f\u8bae\u72b6\u6001\u4e0d\u4e3a" + DmcAgrMainAgrStatus.PENDING_REVIEW.getValue());
        }
        Integer agrStatus = null;
        if (reqBO.getOperType() == 1) {
            if (reqBO.getApproveSwitch().booleanValue()) {
                agrStatus = Integer.parseInt(DmcAgrMainAgrStatus.APPROVAL.getCode());
            } else {
                DycProAgrMainHandleDTO handleDTO = new DycProAgrMainHandleDTO();
                handleDTO.setAgrObjPrimaryIds(Arrays.asList(reqBO.getAgrObjPrimaryId()));
                handleDTO.setApproveResult("pass");
                this.agrMainRepository.dealAgrApprove(handleDTO);
            }
        } else if (reqBO.getOperType() == 0) {
            agrStatus = Integer.parseInt(DmcAgrMainAgrStatus.NOT_ACCEPTED.getCode());
        } else {
            throw new ZTBusinessException("\u672a\u77e5\u7684\u786e\u8ba4\u7ed3\u679c");
        }
        if (agrStatus != null) {
            this.updateAgrStatus(reqBO, agrStatus);
        }
    }

    private void dealAgrChange(DycProAgrDealConfirmReqBO reqBO) {
        Integer chngApplyStatus = null;
        if (reqBO.getOperType() == 1) {
            if (reqBO.getApproveSwitch().booleanValue()) {
                chngApplyStatus = Integer.parseInt(DmcAgrChngApplyChngApplyStatus.APPROVAL.getCode());
            } else {
                DycProAgrChngHandleDTO dycProAgrChngHandleDTO = new DycProAgrChngHandleDTO();
                dycProAgrChngHandleDTO.setChngApplyId(reqBO.getChngApplyId());
                dycProAgrChngHandleDTO.setAgrChngApplyIdList(Collections.singletonList(reqBO.getChngApplyId()));
                dycProAgrChngHandleDTO.setApproveResult("pass");
                this.agrChngRepository.dealAgrChngApprove(dycProAgrChngHandleDTO);
            }
        } else if (reqBO.getOperType() == 0) {
            chngApplyStatus = Integer.parseInt(DmcAgrChngApplyChngApplyStatus.NOT_ACCEPTED.getCode());
            DycProAgrListQryDTO agrListQryDTO = new DycProAgrListQryDTO();
            agrListQryDTO.setAgrObjPrimaryId(reqBO.getAgrObjPrimaryId());
            List agrMainList = this.agrMainRepository.selectAgrMainList(agrListQryDTO);
            if (CollectionUtils.isEmpty((Collection)agrMainList)) {
                throw new ZTBusinessException("\u534f\u8bae\u67e5\u8be2\u4e3a\u7a7a");
            }
            DycProAgrMainDTO agrMainDTO = (DycProAgrMainDTO)agrMainList.get(0);
            if (Integer.valueOf(DmcAgrMainAgrStatus.FREEZE.getCode()).equals(agrMainDTO.getAgrStatus())) {
                DycProAgrChngHandleDTO dycProAgrChngMainDTO = new DycProAgrChngHandleDTO();
                dycProAgrChngMainDTO.setChngApplyId(reqBO.getChngApplyId());
                DycProAgrChngMainDTO agrChngMainInfo = this.agrChngRepository.getAgrChngMainInfo((DycProAgrChngMainDTO)dycProAgrChngMainDTO);
                ArrayList<DycProAgrMainDTO> dycProAgrMainDTOList = new ArrayList<DycProAgrMainDTO>();
                DycProAgrMainDTO updateAgrMainDTO = new DycProAgrMainDTO();
                updateAgrMainDTO.setAgrObjPrimaryId(reqBO.getAgrObjPrimaryId());
                updateAgrMainDTO.setAgrStatus(agrChngMainInfo.getOldAgrStatus());
                dycProAgrMainDTOList.add(updateAgrMainDTO);
                this.agrMainRepository.updateAgrMainByIds(dycProAgrMainDTOList);
                ArrayList<DycProAgrMainHandleDTO> handleDTOS = new ArrayList<DycProAgrMainHandleDTO>();
                DycProAgrMainHandleDTO handleDTO = new DycProAgrMainHandleDTO();
                handleDTO.setAgrObjPrimaryId(reqBO.getAgrObjPrimaryId());
                handleDTO.setAgrId(agrChngMainInfo.getAgrId());
                if (Integer.valueOf(DmcAgrChngApplyChngType.PAUSE.getCode()).equals(agrChngMainInfo.getChngType())) {
                    handleDTO.setBansType(Integer.valueOf(DmcCommBansRecordBansTypeEnum.AGR_PAUSE.getCode()));
                } else if (Integer.valueOf(DmcAgrChngApplyChngType.ADJUST_PRICE.getCode()).equals(agrChngMainInfo.getChngType())) {
                    handleDTO.setBansType(Integer.valueOf(DmcCommBansRecordBansTypeEnum.AGR_ADJUST_PRICE.getCode()));
                } else if (Integer.valueOf(DmcAgrChngApplyChngType.SUPPLEMENT.getCode()).equals(agrChngMainInfo.getChngType())) {
                    handleDTO.setBansType(Integer.valueOf(DmcCommBansRecordBansTypeEnum.AGR_SUPPLEMENT.getCode()));
                } else if (Integer.valueOf(DmcAgrChngApplyChngType.TERMINATE.getCode()).equals(agrChngMainInfo.getChngType())) {
                    handleDTO.setBansType(Integer.valueOf(DmcCommBansRecordBansTypeEnum.AGR_TERMINATE.getCode()));
                }
                handleDTOS.add(handleDTO);
                DycProAgrMainDTO clearBansRecordRsp = this.agrChngRepository.clearBansRecordBatchMethed(handleDTOS, true);
                this.sysnUpdateUpcSkuInfo(clearBansRecordRsp, agrChngMainInfo.getAgrId());
            }
        } else {
            throw new ZTBusinessException("\u672a\u77e5\u7684\u786e\u8ba4\u7ed3\u679c");
        }
        if (chngApplyStatus != null) {
            this.updateChngApplyStatus(reqBO, chngApplyStatus);
        }
    }

    private void sysnUpdateUpcSkuInfo(DycProAgrMainDTO clearBansRecordRsp, Long agrId) {
        DycProAgrListQryDTO qryCommSkuDTO = new DycProAgrListQryDTO();
        qryCommSkuDTO.setAgrIds(Collections.singletonList(agrId));
        DycProAgrMainDTO agrSkuDTO = this.agrMainRepository.qrySkuByAgr(qryCommSkuDTO);
        List agrSkuList = agrSkuDTO.getAgrSkuList();
        List<Object> updateUpcSkuList = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)agrSkuList)) {
            updateUpcSkuList = agrSkuList.stream().filter(sku -> sku.getUpcId() != null).collect(Collectors.toList());
        }
        if (!CollectionUtils.isEmpty(updateUpcSkuList)) {
            Map upcSkuMap = updateUpcSkuList.stream().distinct().collect(Collectors.toMap(DycProAgrSkuDTO::getSkuId, Function.identity()));
            if (!CollectionUtils.isEmpty((Collection)clearBansRecordRsp.getBansRecordInfoList())) {
                List bansRecordInfoList = clearBansRecordRsp.getBansRecordInfoList();
                Map<Long, List<DycProAgrBansRecordInfoDTO>> clearBansRecordMap = bansRecordInfoList.stream().collect(Collectors.groupingBy(DycProAgrBansRecordInfoDTO::getSkuId));
                for (Map.Entry<Long, List<DycProAgrBansRecordInfoDTO>> clearBansRecord : clearBansRecordMap.entrySet()) {
                    if (!upcSkuMap.containsKey(clearBansRecord.getKey())) continue;
                    DycProEsIndexMappingSkuInUpcBO updateUpcSkuBO = new DycProEsIndexMappingSkuInUpcBO();
                    updateUpcSkuBO.setSkuId(clearBansRecord.getKey());
                    ArrayList bansRuleList = new ArrayList(JSON.parseArray((String)JSON.toJSONString(clearBansRecord.getValue()), DycProEsIndexMappingBansRuleBO.class));
                    updateUpcSkuBO.setBansRuleList(bansRuleList);
                    this.agrChngRepository.sysnUpdateUpcSkuInfo(updateUpcSkuBO);
                }
            }
        }
    }

    private void updateAgrStatus(DycProAgrDealConfirmReqBO reqBO, Integer agrStatus) {
        if (agrStatus == null) {
            throw new ZTBusinessException("\u66f4\u65b0\u7684\u534f\u8bae\u72b6\u6001\u4e3a\u7a7a");
        }
        ArrayList<DycProAgrMainDTO> updateSTOList = new ArrayList<DycProAgrMainDTO>();
        DycProAgrMainDTO updateDTO = new DycProAgrMainDTO();
        updateDTO.setAgrObjPrimaryId(reqBO.getAgrObjPrimaryId());
        updateDTO.setAgrStatus(agrStatus);
        updateDTO.setUpdateUserId(reqBO.getUserId());
        updateDTO.setUpdateUserName(reqBO.getName());
        updateDTO.setUpdateUserAccount(reqBO.getUserName());
        updateDTO.setUpdateCompanyId(reqBO.getCompanyId());
        updateDTO.setUpdateOrgId(reqBO.getOrgId());
        updateDTO.setUpdateOrgPath(reqBO.getOrgPath());
        updateDTO.setUpdateCompanyName(reqBO.getCompanyName());
        updateDTO.setUpdateOrgName(reqBO.getOrgName());
        updateDTO.setUpdateTime(new Date(System.currentTimeMillis()));
        updateSTOList.add(updateDTO);
        this.agrMainRepository.updateAgrMainByIds(updateSTOList);
    }

    private void updateChngApplyStatus(DycProAgrDealConfirmReqBO reqBO, Integer chngApplyStatus) {
        if (chngApplyStatus == null) {
            throw new ZTBusinessException("\u66f4\u65b0\u7684\u53d8\u66f4\u5355\u72b6\u6001\u4e3a\u7a7a");
        }
        ArrayList<DycProAgrChngMainDTO> updateDTOList = new ArrayList<DycProAgrChngMainDTO>();
        DycProAgrChngMainDTO updateDTO = new DycProAgrChngMainDTO();
        updateDTO.setChngApplyId(reqBO.getChngApplyId());
        updateDTO.setChngApplyStatus(chngApplyStatus);
        updateDTO.setUpdateUserId(reqBO.getUserId());
        updateDTO.setUpdateUserName(reqBO.getName());
        updateDTO.setUpdateUserAccount(reqBO.getUserName());
        updateDTO.setUpdateCompanyId(reqBO.getCompanyId());
        updateDTO.setUpdateOrgId(reqBO.getOrgId());
        updateDTO.setUpdateOrgPath(reqBO.getOrgPath());
        updateDTO.setUpdateCompanyName(reqBO.getCompanyName());
        updateDTO.setUpdateOrgName(reqBO.getOrgName());
        updateDTO.setUpdateTime(new Date(System.currentTimeMillis()));
        updateDTOList.add(updateDTO);
        this.agrChngRepository.updateAgrChngMainByIds(updateDTOList);
    }

    private void judge(DycProAgrDealConfirmReqBO reqBO) {
        if (ObjectUtils.isEmpty((Object)reqBO.getOperType())) {
            throw new ZTBusinessException("\u3010\u786e\u8ba4\u7ed3\u679c\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)reqBO.getConfirmType())) {
            throw new ZTBusinessException("\u3010\u534f\u8bae\u786e\u8ba4\u7c7b\u578b\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)reqBO.getAgrObjPrimaryId())) {
            throw new ZTBusinessException("\u3010\u534f\u8bae\u5bf9\u8c61\u552f\u4e00ID\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getConfirmType().equals(Integer.parseInt(DmcAgrConfirmType.CHANGE.getCode())) && ObjectUtils.isEmpty((Object)reqBO.getChngApplyId())) {
            throw new ZTBusinessException("\u3010\u53d8\u66f4\u7533\u8bf7ID\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

