/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.dmc.service.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.pro.base.bo.esmapping.DycProEsIndexMappingBansRuleBO;
import com.tydic.dyc.pro.base.bo.esmapping.DycProEsIndexMappingSkuInUpcBO;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcAgrMainAgrStatus;
import com.tydic.dyc.pro.dmc.constant.DycProAgrConstants;
import com.tydic.dyc.pro.dmc.repository.agrchng.api.DycProAgrChngRepository;
import com.tydic.dyc.pro.dmc.repository.agreement.api.DycProAgrRepository;
import com.tydic.dyc.pro.dmc.repository.agreement.dto.DycProAgrBansRecordInfoDTO;
import com.tydic.dyc.pro.dmc.repository.agreement.dto.DycProAgrListQryDTO;
import com.tydic.dyc.pro.dmc.repository.agreement.dto.DycProAgrMainDTO;
import com.tydic.dyc.pro.dmc.repository.agreement.dto.DycProAgrMainHandleDTO;
import com.tydic.dyc.pro.dmc.repository.agreement.dto.DycProAgrSkuDTO;
import com.tydic.dyc.pro.dmc.service.api.DycProAgrActiveAndExpiredTimeTaskService;
import com.tydic.dyc.pro.dmc.service.bo.DycProAgrActiveAndExpiredTimeTaskReqBO;
import com.tydic.dyc.pro.dmc.service.bo.DycProAgrActiveAndExpiredTimeTaskRspBO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"DMC_GROUP/4.0.0/com.tydic.dyc.pro.dmc.service.api.DycProAgrActiveAndExpiredTimeTaskService"})
public class DycProAgrActiveAndExpiredTimeTaskServiceImpl
implements DycProAgrActiveAndExpiredTimeTaskService {
    private static final Logger log = LoggerFactory.getLogger(DycProAgrActiveAndExpiredTimeTaskServiceImpl.class);
    @Autowired
    private DycProAgrRepository agrRepository;
    @Autowired
    private DycProAgrChngRepository agrChngRepository;

    @Override
    @PostMapping(value={"dealAgrTimeTask"})
    public DycProAgrActiveAndExpiredTimeTaskRspBO dealAgrTimeTask(@RequestBody DycProAgrActiveAndExpiredTimeTaskReqBO reqBO) {
        Date now = new Date(System.currentTimeMillis());
        this.dealActive(now);
        this.dealExpired(now);
        return new DycProAgrActiveAndExpiredTimeTaskRspBO();
    }

    private void dealActive(Date now) {
        try {
            DycProAgrListQryDTO qryDTO = new DycProAgrListQryDTO();
            qryDTO.setAgrStatus(Integer.valueOf(Integer.parseInt(DmcAgrMainAgrStatus.PENDING_EFFECTIVE.getCode())));
            qryDTO.setEffDateEnd(now);
            qryDTO.setExpDateStart(now);
            List agrMainDTOS = this.agrRepository.selectAgrMainList(qryDTO);
            if (!CollectionUtils.isEmpty((Collection)agrMainDTOS)) {
                ArrayList<DycProAgrMainDTO> updateAgrList = new ArrayList<DycProAgrMainDTO>();
                for (DycProAgrMainDTO each : agrMainDTOS) {
                    DycProAgrMainDTO updateAgrDTO = new DycProAgrMainDTO();
                    updateAgrDTO.setAgrObjPrimaryId(each.getAgrObjPrimaryId());
                    updateAgrDTO.setAgrStatus(Integer.valueOf(Integer.parseInt(DmcAgrMainAgrStatus.ACTIVE.getCode())));
                    updateAgrList.add(updateAgrDTO);
                }
                this.agrRepository.updateAgrMainByIds(updateAgrList);
            }
        }
        catch (Exception e) {
            log.error("\u5904\u7406\u9700\u8981\u542f\u7528\u7684\u534f\u8bae\u62a5\u9519:", (Throwable)e);
        }
    }

    private void dealExpired(Date now) {
        try {
            DycProAgrListQryDTO qryDTO = new DycProAgrListQryDTO();
            qryDTO.setAgrStatusList(Arrays.asList(Integer.parseInt(DmcAgrMainAgrStatus.SUSPENDED.getCode()), Integer.parseInt(DmcAgrMainAgrStatus.ACTIVE.getCode()), Integer.parseInt(DmcAgrMainAgrStatus.FREEZE.getCode())));
            qryDTO.setExpDateEnd(now);
            List agrMainDTOS = this.agrRepository.selectAgrMainList(qryDTO);
            if (!CollectionUtils.isEmpty((Collection)agrMainDTOS)) {
                ArrayList<DycProAgrMainHandleDTO> handleDTOS = new ArrayList<DycProAgrMainHandleDTO>();
                ArrayList<DycProAgrMainHandleDTO> updateAgrList = new ArrayList<DycProAgrMainHandleDTO>();
                for (DycProAgrMainDTO each : agrMainDTOS) {
                    DycProAgrMainHandleDTO handleDTO = new DycProAgrMainHandleDTO();
                    handleDTO.setAgrObjPrimaryId(each.getAgrObjPrimaryId());
                    handleDTO.setAgrId(each.getAgrId());
                    handleDTO.setAgrStatus(Integer.valueOf(Integer.parseInt(DmcAgrMainAgrStatus.EXPIRED.getCode())));
                    handleDTO.setBansType(DycProAgrConstants.BansType.AGR_EXP);
                    handleDTO.setBansReason("\u534f\u8bae\u8fc7\u671f");
                    handleDTOS.add(handleDTO);
                    updateAgrList.add(handleDTO);
                }
                this.agrRepository.updateAgrMainByIds(updateAgrList);
                DycProAgrMainDTO addBansRecordRsp = this.agrChngRepository.addBansRecordBatchAndSyncNosql(handleDTOS, true);
                DycProAgrListQryDTO qryCommSkuDTO = new DycProAgrListQryDTO();
                qryCommSkuDTO.setAgrIds(agrMainDTOS.stream().map(DycProAgrMainDTO::getAgrId).collect(Collectors.toList()));
                DycProAgrMainDTO agrSkuDTO = this.agrRepository.qrySkuByAgr(qryCommSkuDTO);
                List agrSkuList = agrSkuDTO.getAgrSkuList();
                List<Object> updateUpcSkuList = new ArrayList();
                if (!CollectionUtils.isEmpty((Collection)agrSkuList)) {
                    updateUpcSkuList = agrSkuList.stream().filter(sku -> sku.getUpcId() != null).collect(Collectors.toList());
                }
                if (!CollectionUtils.isEmpty(updateUpcSkuList)) {
                    Map upcSkuMap = updateUpcSkuList.stream().distinct().collect(Collectors.toMap(DycProAgrSkuDTO::getSkuId, Function.identity()));
                    if (!CollectionUtils.isEmpty((Collection)addBansRecordRsp.getBansRecordInfoList())) {
                        List bansRecordInfoList = addBansRecordRsp.getBansRecordInfoList();
                        Map<Long, List<DycProAgrBansRecordInfoDTO>> addBansRecordMap = bansRecordInfoList.stream().collect(Collectors.groupingBy(DycProAgrBansRecordInfoDTO::getSkuId));
                        for (Map.Entry<Long, List<DycProAgrBansRecordInfoDTO>> addBansRecord : addBansRecordMap.entrySet()) {
                            if (!upcSkuMap.containsKey(addBansRecord.getKey())) continue;
                            DycProEsIndexMappingSkuInUpcBO updateUpcSkuBO = new DycProEsIndexMappingSkuInUpcBO();
                            updateUpcSkuBO.setSkuId(addBansRecord.getKey());
                            ArrayList bansRuleList = new ArrayList(JSON.parseArray((String)JSON.toJSONString(addBansRecord.getValue()), DycProEsIndexMappingBansRuleBO.class));
                            updateUpcSkuBO.setBansRuleList(bansRuleList);
                            this.agrChngRepository.sysnUpdateUpcSkuInfo(updateUpcSkuBO);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("\u5904\u7406\u9700\u8981\u8fc7\u671f\u7684\u534f\u8bae\u62a5\u9519:", (Throwable)e);
        }
    }
}

