/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.dmc.service.skumanage.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.pro.base.bo.esmapping.DycProEsIndexMappingSkuBO;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcAgrMainTradeMode;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcCommOperateRecordActionTypeEnum;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcCommOperateRecordOperateResultEnum;
import com.tydic.dyc.pro.dmc.constant.DycProCommConstants;
import com.tydic.dyc.pro.dmc.repository.approve.api.DycProCommPublicProcTaskInstRepository;
import com.tydic.dyc.pro.dmc.repository.approve.dto.DycProCommAuditPackageInfoDTO;
import com.tydic.dyc.pro.dmc.repository.approve.dto.DycProCommAuditPakageObjDTO;
import com.tydic.dyc.pro.dmc.repository.managecatalog.api.DycProCommManageCatalogRepository;
import com.tydic.dyc.pro.dmc.repository.managecatalog.dto.DycProCommPropertyTemplateInfoDTO;
import com.tydic.dyc.pro.dmc.repository.operaterecord.api.DycProCommOperateRecordRepository;
import com.tydic.dyc.pro.dmc.repository.operaterecord.dto.DycProCommOperateRecordDTO;
import com.tydic.dyc.pro.dmc.repository.pricerule.api.DycProCommPriceRuleInfoRepository;
import com.tydic.dyc.pro.dmc.repository.pricerule.dto.DycProCommSkuPriceInfoDTO;
import com.tydic.dyc.pro.dmc.repository.pricerule.dto.DycProCommSkuPriceInfoHandleDTO;
import com.tydic.dyc.pro.dmc.repository.sensitiveword.api.DycProCommSensitiveWordInfoRepository;
import com.tydic.dyc.pro.dmc.repository.sensitiveword.dto.DycProCommSensitiveWordInfoDTO;
import com.tydic.dyc.pro.dmc.repository.sku.api.DycProCommSkuRepository;
import com.tydic.dyc.pro.dmc.repository.sku.dto.DycProCommSkuDTO;
import com.tydic.dyc.pro.dmc.repository.stock.dto.DycProCommSkuStockInfoDTO;
import com.tydic.dyc.pro.dmc.service.skumanage.api.DycProCommAgrSkuCreateService;
import com.tydic.dyc.pro.dmc.service.skumanage.bo.DycProCommAgrSkuBO;
import com.tydic.dyc.pro.dmc.service.skumanage.bo.DycProCommAgrSkuCreateReqBO;
import com.tydic.dyc.pro.dmc.service.skumanage.bo.DycProCommAgrSkuCreateRspBO;
import com.tydic.dyc.pro.dmc.service.skumanage.bo.DycProCommSkuPicApiBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"DMC_GROUP/4.0.0/com.tydic.dyc.pro.dmc.service.skumanage.api.DycProCommAgrSkuCreateService"})
public class DycProCommAgrSkuCreateServiceImpl
implements DycProCommAgrSkuCreateService {
    @Autowired
    private DycProCommSkuRepository dycProCommSkuRepository;
    @Autowired
    private DycProCommManageCatalogRepository dycProCommManageCatalogRepository;
    @Autowired
    private DycProCommPublicProcTaskInstRepository dycProCommPublicProcTaskInstRepository;
    @Autowired
    private DycProCommOperateRecordRepository dycProCommOperateRecordRepository;
    @Autowired
    private DycProCommSensitiveWordInfoRepository dycProCommSensitiveWordInfoRepository;
    @Autowired
    private DycProCommPriceRuleInfoRepository dycProCommPriceRuleInfoRepository;

    @PostMapping(value={"createAgrSku"})
    public DycProCommAgrSkuCreateRspBO createAgrSku(@RequestBody DycProCommAgrSkuCreateReqBO reqBO) {
        this.judge(reqBO);
        DycProEsIndexMappingSkuBO agrSkuInfo = this.createAgrSkuInfo(reqBO);
        DycProCommAgrSkuCreateRspBO rspBO = new DycProCommAgrSkuCreateRspBO();
        rspBO.setSkuId(agrSkuInfo.getSkuId());
        if (reqBO.getOperType() == 1 && reqBO.getUccApproveOnShelveAgreementSwitch().booleanValue() && DycProCommConstants.SkuOnShelveWay.AUTO_ON_SHELVE.equals(reqBO.getCreateSkuInfo().getOnShelveWay())) {
            Long auditPackageId = Sequence.getInstance().nextId();
            rspBO.setAuditPackageId(auditPackageId);
            this.insertAuditPackage(auditPackageId, agrSkuInfo);
        }
        return rspBO;
    }

    private DycProEsIndexMappingSkuBO createAgrSkuInfo(DycProCommAgrSkuCreateReqBO reqBO) {
        List sensitiveWordInfoDTOS = this.dycProCommSensitiveWordInfoRepository.verifySensitiveWord(reqBO.getCreateSkuInfo().getSkuName());
        if (!CollectionUtils.isEmpty((Collection)sensitiveWordInfoDTOS)) {
            StringBuilder sensitiveWords = new StringBuilder();
            for (DycProCommSensitiveWordInfoDTO sensitiveWordDto : sensitiveWordInfoDTOS) {
                sensitiveWords.append("[").append(sensitiveWordDto.getSensitiveWordName()).append("],");
            }
            throw new ZTBusinessException("sku\u540d\u79f0\u5b58\u5728\u654f\u611f\u8bcd\uff1a" + sensitiveWords.toString());
        }
        DycProCommSkuDTO skuDTO = (DycProCommSkuDTO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO.getCreateSkuInfo()), DycProCommSkuDTO.class);
        skuDTO.setSkuId(Long.valueOf(Sequence.getInstance().nextId()));
        if (reqBO.getCreateSkuInfo().getManageCatalogId() != null) {
            DycProCommPropertyTemplateInfoDTO queryPropertyTemplateInfoDTO = new DycProCommPropertyTemplateInfoDTO();
            queryPropertyTemplateInfoDTO.setManageCatalogId(reqBO.getCreateSkuInfo().getManageCatalogId());
            DycProCommPropertyTemplateInfoDTO propertyTemplateInfoDTO = this.dycProCommManageCatalogRepository.queryPropertyTemplateOneByCondition(queryPropertyTemplateInfoDTO);
            if (null != propertyTemplateInfoDTO && propertyTemplateInfoDTO.getPropertyTemplateId() != null) {
                skuDTO.setPropertyTemplateId(propertyTemplateInfoDTO.getPropertyTemplateId());
            } else {
                throw new ZTBusinessException(reqBO.getCreateSkuInfo().getManageCatalogId() + "\uff0c\u8be5\u7ba1\u7406\u7c7b\u76eeid\u6ca1\u6709\u5bf9\u5e94\u7684\u5c5e\u6027\u6a21\u677f");
            }
        }
        boolean operateRecordFlag = false;
        if (reqBO.getOperType() == 0) {
            skuDTO.setSkuStatus(DycProCommConstants.SkuStatus.DRAFT);
        } else if (reqBO.getOperType() == 1) {
            if (DycProCommConstants.SkuOnShelveWay.AUTO_ON_SHELVE.equals(reqBO.getCreateSkuInfo().getOnShelveWay())) {
                if (reqBO.getUccApproveOnShelveAgreementSwitch().booleanValue()) {
                    skuDTO.setSkuStatus(DycProCommConstants.SkuStatus.TOBE_ON_SHELVES);
                    skuDTO.setApprovalStatus(DycProCommConstants.ApprovalStatus.ON_SHELVE_IN_APPROVAL);
                } else {
                    operateRecordFlag = true;
                    skuDTO.setSkuStatus(DycProCommConstants.SkuStatus.ON_SHELVES);
                    skuDTO.setOnShelveTime(new Date(System.currentTimeMillis()));
                }
            } else {
                skuDTO.setSkuStatus(DycProCommConstants.SkuStatus.TOBE_ON_SHELVES);
            }
        }
        skuDTO.setSkuSource(DycProCommConstants.SkuSource.AGR_SKU);
        skuDTO.setIsHaveGift(DycProCommConstants.IsHaveGift.NO);
        skuDTO.setDelFlag(DycProCommConstants.DelFlag.NO);
        if (Integer.valueOf(DmcAgrMainTradeMode.MY.getCode()).equals(reqBO.getCreateSkuInfo().getTradeMode())) {
            this.computeSkuPrice(skuDTO);
        } else {
            skuDTO.getPriceInfo().setSalePrice(skuDTO.getPriceInfo().getSupplierPrice());
        }
        if (reqBO.getCreateSkuInfo().getStockInfo() != null && reqBO.getCreateSkuInfo().getStockInfo().getOriginNum() != null) {
            DycProCommSkuStockInfoDTO stockInfo = (DycProCommSkuStockInfoDTO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO.getCreateSkuInfo().getStockInfo()), DycProCommSkuStockInfoDTO.class);
            stockInfo.setOriginNum(reqBO.getCreateSkuInfo().getStockInfo().getOriginNum());
            stockInfo.setTotalNum(reqBO.getCreateSkuInfo().getStockInfo().getOriginNum());
            stockInfo.setUnsaleNum(reqBO.getCreateSkuInfo().getStockInfo().getOriginNum());
            stockInfo.setSaledNum(BigDecimal.ZERO);
            stockInfo.setSkuName(reqBO.getCreateSkuInfo().getSkuName());
            stockInfo.setSupplierId(reqBO.getCreateSkuInfo().getSupplierId());
            stockInfo.setSupplierName(reqBO.getCreateSkuInfo().getSupplierName());
            stockInfo.setSaleMeasureId(reqBO.getCreateSkuInfo().getSaleMeasureId());
            stockInfo.setSaleMeasureName(reqBO.getCreateSkuInfo().getSaleMeasureName());
            stockInfo.setCreateUserId(reqBO.getUserId());
            stockInfo.setCreateUserName(reqBO.getName());
            stockInfo.setCreateUserAccount(reqBO.getUserName());
            stockInfo.setCreateCompanyId(reqBO.getCompanyId());
            stockInfo.setCreateOrgId(reqBO.getOrgId());
            stockInfo.setCreateCompanyName(reqBO.getCompanyName());
            stockInfo.setCreateOrgName(reqBO.getOrgName());
            stockInfo.setCreateTime(new Date(System.currentTimeMillis()));
            skuDTO.setStockInfo(stockInfo);
        }
        skuDTO.setCreateUserId(reqBO.getUserId());
        skuDTO.setCreateUserName(reqBO.getName());
        skuDTO.setCreateUserAccount(reqBO.getUserName());
        skuDTO.setCreateCompanyId(reqBO.getCompanyId());
        skuDTO.setCreateOrgId(reqBO.getOrgId());
        skuDTO.setCreateOrgPath(reqBO.getOrgPath());
        skuDTO.setCreateCompanyName(reqBO.getCompanyName());
        skuDTO.setCreateOrgName(reqBO.getOrgName());
        skuDTO.setCreateTime(new Date(System.currentTimeMillis()));
        DycProEsIndexMappingSkuBO dycProEsIndexMappingSkuBO = this.dycProCommSkuRepository.addSkuCompleteInfoAndSyncNosql(skuDTO);
        if (operateRecordFlag) {
            this.insertOperateRecord(dycProEsIndexMappingSkuBO, reqBO);
        }
        return dycProEsIndexMappingSkuBO;
    }

    private void computeSkuPrice(DycProCommSkuDTO skuDTO) {
        DycProCommSkuPriceInfoHandleDTO handleDTO = new DycProCommSkuPriceInfoHandleDTO();
        handleDTO.setSupplierPrice(skuDTO.getPriceInfo().getSupplierPrice());
        handleDTO.setMarketPrice(skuDTO.getPriceInfo().getMarketPrice());
        handleDTO.setSupplierId(skuDTO.getSupplierId());
        handleDTO.setAgrId(skuDTO.getAgrId());
        handleDTO.setSkuId(skuDTO.getSkuId());
        handleDTO.setManageCatalogPath(skuDTO.getManageCatalogPath());
        handleDTO.setManageCatalogId(skuDTO.getManageCatalogId());
        handleDTO.setPriceRuleType(DycProCommConstants.PriceRuleType.AGR);
        DycProCommSkuPriceInfoDTO dycProCommSkuPriceInfoDTO = this.dycProCommPriceRuleInfoRepository.computeSkuPrice(handleDTO);
        skuDTO.getPriceInfo().setLadderPriceRule(dycProCommSkuPriceInfoDTO.getLadderPriceRule());
        skuDTO.getPriceInfo().setPriceRiseRate(dycProCommSkuPriceInfoDTO.getPriceRiseRate());
        skuDTO.getPriceInfo().setPriceRiseType(dycProCommSkuPriceInfoDTO.getPriceRiseType());
        skuDTO.getPriceInfo().setPriceRuleId(dycProCommSkuPriceInfoDTO.getPriceRuleId());
        skuDTO.getPriceInfo().setPriority(dycProCommSkuPriceInfoDTO.getPriority());
        skuDTO.getPriceInfo().setSalePrice(dycProCommSkuPriceInfoDTO.getSalePrice());
    }

    private void insertAuditPackage(Long auditPackageId, DycProEsIndexMappingSkuBO agrSkuInfo) {
        DycProCommAuditPackageInfoDTO dycProCommAuditPackageInfoDTO = new DycProCommAuditPackageInfoDTO();
        dycProCommAuditPackageInfoDTO.setAuditPackageId(auditPackageId);
        ArrayList<Object> auditPackageObjDTOList = new ArrayList<Object>();
        auditPackageObjDTOList.add(JSON.parseObject((String)JSON.toJSONString((Object)agrSkuInfo), DycProCommAuditPakageObjDTO.class));
        for (DycProCommAuditPakageObjDTO dycProCommAuditPakageObjDTO : auditPackageObjDTOList) {
            dycProCommAuditPakageObjDTO.setCreateTime(new Date(System.currentTimeMillis()));
            dycProCommAuditPakageObjDTO.setAuditPackageId(auditPackageId);
            dycProCommAuditPakageObjDTO.setDelTag(DycProCommConstants.DelFlag.NO);
        }
        dycProCommAuditPackageInfoDTO.setAuditPakageObjDTOList(auditPackageObjDTOList);
        this.dycProCommPublicProcTaskInstRepository.addAuditPackageBatch(dycProCommAuditPackageInfoDTO);
    }

    private void insertOperateRecord(DycProEsIndexMappingSkuBO skuDTO, DycProCommAgrSkuCreateReqBO reqBO) {
        ArrayList<DycProCommOperateRecordDTO> operateRecordPOList = new ArrayList<DycProCommOperateRecordDTO>();
        DycProCommOperateRecordDTO commOperateRecordPO = new DycProCommOperateRecordDTO();
        commOperateRecordPO.setObjId(skuDTO.getSkuId());
        commOperateRecordPO.setObjCode(skuDTO.getSkuCode());
        commOperateRecordPO.setObjType(DycProCommConstants.OperateRecordObjType.SKU);
        commOperateRecordPO.setOperateTime(new Date(System.currentTimeMillis()));
        commOperateRecordPO.setOperateUserId(reqBO.getUserId());
        commOperateRecordPO.setOperateUserAccount(reqBO.getUserName());
        commOperateRecordPO.setOperateUserName(reqBO.getName());
        commOperateRecordPO.setOperateUserType(DycProCommConstants.OperateUserType.USER);
        commOperateRecordPO.setOperateReason("\u521b\u5efa\u5546\u54c1\u65f6\u9009\u62e9\u4e86\u7acb\u5373\u4e0a\u67b6\uff0c\u4e14\u4e0d\u9700\u8981\u4e0a\u67b6\u5ba1\u6279");
        commOperateRecordPO.setActionType(Integer.valueOf(Integer.parseInt(DmcCommOperateRecordActionTypeEnum.ON_SHELVE.getCode())));
        commOperateRecordPO.setActionName(DmcCommOperateRecordActionTypeEnum.ON_SHELVE.getValue());
        commOperateRecordPO.setOperateResult(Integer.valueOf(Integer.parseInt(DmcCommOperateRecordOperateResultEnum.SUCCESS_ON_SHELVE.getCode())));
        commOperateRecordPO.setOperateResultDesc(DmcCommOperateRecordOperateResultEnum.SUCCESS_ON_SHELVE.getValue());
        operateRecordPOList.add(commOperateRecordPO);
        this.dycProCommOperateRecordRepository.addOperateRecordBatch(operateRecordPOList);
    }

    private void judge(DycProCommAgrSkuCreateReqBO reqBO) {
        if (ObjectUtils.isEmpty((Object)reqBO.getOperType())) {
            throw new ZTBusinessException("\u3010\u64cd\u4f5c\u7c7b\u578b\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)reqBO.getMiniFlag())) {
            throw new ZTBusinessException("\u3010\u662f\u5426\u6781\u7b80\u6807\u8bc6\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)reqBO.getUccApproveOnShelveAgreementSwitch())) {
            throw new ZTBusinessException("\u3010\u4e0a\u67b6\u5ba1\u6279\u5f00\u5173\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)reqBO.getCreateSkuInfo())) {
            throw new ZTBusinessException("\u3010sku\u521b\u5efa\u4fe1\u606f\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getOperType() == 1) {
            DycProCommAgrSkuBO createSkuInfo = reqBO.getCreateSkuInfo();
            if (ObjectUtils.isEmpty((Object)createSkuInfo.getManageCatalogId())) {
                throw new ZTBusinessException("\u3010\u540e\u53f0\u7ba1\u7406\u7c7b\u76eeID\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtils.isEmpty((Object)createSkuInfo.getAgrId())) {
                throw new ZTBusinessException("\u3010\u6240\u5c5e\u534f\u8baeid\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtils.isEmpty((Object)createSkuInfo.getTradeMode())) {
                throw new ZTBusinessException("\u3010\u4ea4\u6613\u6a21\u5f0f\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtils.isEmpty((Object)createSkuInfo.getSkuName())) {
                throw new ZTBusinessException("\u3010sku\u540d\u79f0\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtils.isEmpty((Object)createSkuInfo.getSaleMeasureId())) {
                throw new ZTBusinessException("\u3010\u9500\u552e\u8ba1\u91cf\u5355\u4f4did\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtils.isEmpty((Object)createSkuInfo.getSaleMeasureName())) {
                throw new ZTBusinessException("\u3010\u9500\u552e\u8ba1\u91cf\u5355\u4f4d\u6362\u7b97\u7387\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtils.isEmpty((Object)createSkuInfo.getSaleMeasureRate())) {
                createSkuInfo.setSaleMeasureRate(BigDecimal.ONE);
            }
            if (ObjectUtils.isEmpty((Object)createSkuInfo.getSettleMeasureId())) {
                throw new ZTBusinessException("\u3010\u7ed3\u7b97\u8ba1\u91cf\u5355\u4f4did\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtils.isEmpty((Object)createSkuInfo.getSettleMeasureName())) {
                throw new ZTBusinessException("\u3010\u7ed3\u7b97\u8ba1\u91cf\u5355\u4f4d\u540d\u79f0\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtils.isEmpty((Object)createSkuInfo.getMinQuantity())) {
                throw new ZTBusinessException("\u3010\u6700\u5c0f\u8d77\u8ba2\u91cf\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtils.isEmpty((Object)createSkuInfo.getRate())) {
                throw new ZTBusinessException("\u3010\u7a0e\u7387\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtils.isEmpty((Object)createSkuInfo.getOnShelveWay())) {
                throw new ZTBusinessException("\u3010\u4e0a\u67b6\u65b9\u5f0f\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtils.isEmpty((Object)createSkuInfo.getSupplierId())) {
                throw new ZTBusinessException("\u3010\u4f9b\u5e94\u5546id\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtils.isEmpty((Object)createSkuInfo.getSupplierName())) {
                throw new ZTBusinessException("\u3010\u4f9b\u5e94\u5546\u540d\u79f0\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtils.isEmpty((Object)createSkuInfo.getStockInfo())) {
                throw new ZTBusinessException("\u3010\u5546\u54c1\u5e93\u5b58\u4fe1\u606f\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtils.isEmpty((Object)createSkuInfo.getStockInfo().getOriginNum())) {
                throw new ZTBusinessException("\u3010\u539f\u59cb\u5e93\u5b58\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtils.isEmpty((Object)createSkuInfo.getSkuAgrInfo())) {
                throw new ZTBusinessException("\u3010\u5546\u54c1\u5bf9\u5e94\u534f\u8bae\u4fe1\u606f\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtils.isEmpty((Object)createSkuInfo.getSkuAgrInfo().getAgrId())) {
                throw new ZTBusinessException("\u3010\u534f\u8baeID\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtils.isEmpty((Object)createSkuInfo.getSkuAgrInfo().getAgrCode())) {
                throw new ZTBusinessException("\u3010\u534f\u8bae\u7f16\u53f7\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtils.isEmpty((Object)createSkuInfo.getSkuAgrInfo().getAgrName())) {
                throw new ZTBusinessException("\u3010\u534f\u8bae\u540d\u79f0\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtils.isEmpty((Object)createSkuInfo.getSkuDetails())) {
                throw new ZTBusinessException("\u3010sku\u8be6\u60c5\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtils.isEmpty((Object)createSkuInfo.getSkuDetails().getSkuPcDetailContent())) {
                throw new ZTBusinessException("\u3010sku\u8be6\u60c5\u5185\u5bb9\uff08pc\u7aef\uff09\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtils.isEmpty((Object)createSkuInfo.getSkuAfterSaleInfo())) {
                throw new ZTBusinessException("\u3010sku\u552e\u540e\u4fe1\u606f\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtils.isEmpty((Object)createSkuInfo.getSkuAfterSaleInfo().getIsAllowReturn())) {
                throw new ZTBusinessException("\u3010\u662f\u5426\u652f\u6301\u9000\u8d27\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (DycProCommConstants.IsAllowAfterSale.YES.equals(createSkuInfo.getSkuAfterSaleInfo().getIsAllowReturn()) && ObjectUtils.isEmpty((Object)createSkuInfo.getSkuAfterSaleInfo().getReturnTimeLimit())) {
                throw new ZTBusinessException("\u3010\u9000\u8d27\u65f6\u9650\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtils.isEmpty((Object)createSkuInfo.getSkuAfterSaleInfo().getIsAllowChange())) {
                throw new ZTBusinessException("\u3010\u662f\u5426\u652f\u6301\u6362\u8d27\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (DycProCommConstants.IsAllowAfterSale.YES.equals(createSkuInfo.getSkuAfterSaleInfo().getIsAllowChange()) && ObjectUtils.isEmpty((Object)createSkuInfo.getSkuAfterSaleInfo().getChangeTimeLimit())) {
                throw new ZTBusinessException("\u3010\u6362\u8d27\u65f6\u9650\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtils.isEmpty((Object)createSkuInfo.getSkuAfterSaleInfo().getIsAllowMaintain())) {
                throw new ZTBusinessException("\u3010\u662f\u5426\u652f\u6301\u7ef4\u4fee\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (DycProCommConstants.IsAllowAfterSale.YES.equals(createSkuInfo.getSkuAfterSaleInfo().getIsAllowMaintain()) && ObjectUtils.isEmpty((Object)createSkuInfo.getSkuAfterSaleInfo().getMaintainTimeLimit())) {
                throw new ZTBusinessException("\u3010\u7ef4\u4fee\u65f6\u9650\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (CollectionUtils.isEmpty((Collection)createSkuInfo.getSkuPicInfoList())) {
                throw new ZTBusinessException("\u3010sku\u56fe\u7247\u4fe1\u606f\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            for (DycProCommSkuPicApiBO each : createSkuInfo.getSkuPicInfoList()) {
                if (ObjectUtils.isEmpty((Object)each.getPicType())) {
                    throw new ZTBusinessException("\u3010\u56fe\u7247\u7c7b\u578b\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (ObjectUtils.isEmpty((Object)each.getPicUrl())) {
                    throw new ZTBusinessException("\u3010\u56fe\u7247url\u3011\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (!ObjectUtils.isEmpty((Object)each.getShowOrder())) continue;
                throw new ZTBusinessException("\u3010\u56fe\u7247\u5c55\u793a\u987a\u5e8f\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtils.isEmpty((Object)createSkuInfo.getPriceInfo())) {
                throw new ZTBusinessException("\u3010\u4ef7\u683c\u4fe1\u606f\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtils.isEmpty((Object)createSkuInfo.getPriceInfo().getMarketPrice())) {
                throw new ZTBusinessException("\u3010\u5e02\u573a\u4ef7\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (ObjectUtils.isEmpty((Object)createSkuInfo.getPriceInfo().getSupplierPrice())) {
                throw new ZTBusinessException("\u3010\u4f9b\u8d27\u4ef7\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
    }
}

