/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.dmc.repository.spu.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.nosql.NosqlClient;
import com.ohaotian.plugin.nosql.bo.NosqlAddSingleReqBO;
import com.ohaotian.plugin.nosql.bo.NosqlAddSingleRsqBO;
import com.ohaotian.plugin.nosql.bo.NosqlBO;
import com.ohaotian.plugin.nosql.bo.NosqlDeleteSingleReqBO;
import com.ohaotian.plugin.nosql.bo.NosqlQueryBO;
import com.ohaotian.plugin.nosql.bo.NosqlQueryByBuilderReqBO;
import com.ohaotian.plugin.nosql.bo.NosqlQueryByBuilderRsqBO;
import com.ohaotian.plugin.nosql.bo.NosqlQueryGroupBO;
import com.ohaotian.plugin.nosql.bo.NosqlUpdateSingleReqBO;
import com.ohaotian.plugin.nosql.bo.NosqlUpdateSingleRsqBO;
import com.ohaotian.plugin.nosql.constant.NosqlConnetType;
import com.ohaotian.plugin.nosql.constant.NosqlQueryValueType;
import com.ohaotian.plugin.nosql.constant.NosqlSortOrder;
import com.ohaotian.plugin.nosql.impl.NosqlBuilder;
import com.ohaotian.plugin.nosql.impl.NosqlCreateBuilder;
import com.tydic.dyc.pro.base.bo.DycProBaseManagePageRspBO;
import com.tydic.dyc.pro.base.bo.esmapping.DycProEsIndexMappingSkuManageCatalogBO;
import com.tydic.dyc.pro.base.bo.esmapping.DycProExIndexMappingSpuBO;
import com.tydic.dyc.pro.base.common.mybatis.LambdaQueryWrapperX;
import com.tydic.dyc.pro.base.core.dictionary.enums.BooleanFlag;
import com.tydic.dyc.pro.base.core.encode.service.api.DycProEncodeSerialService;
import com.tydic.dyc.pro.base.core.encode.service.bo.DycProEncodeSerialReqBO;
import com.tydic.dyc.pro.base.core.encode.service.bo.DycProEncodeSerialRspBO;
import com.tydic.dyc.pro.dmc.constant.DycProCommConstants;
import com.tydic.dyc.pro.dmc.dao.CommMallPropertyInfoMapper;
import com.tydic.dyc.pro.dmc.dao.CommMallPropertyUseRecordMapper;
import com.tydic.dyc.pro.dmc.dao.CommManageCatalogInfoMapper;
import com.tydic.dyc.pro.dmc.dao.CommPropertyTemplateInfoMapper;
import com.tydic.dyc.pro.dmc.dao.CommSkuDetailsInfoMapper;
import com.tydic.dyc.pro.dmc.dao.CommSkuInfoMapper;
import com.tydic.dyc.pro.dmc.dao.CommSkuPicInfoMapper;
import com.tydic.dyc.pro.dmc.dao.CommSkuPriceInfoMapper;
import com.tydic.dyc.pro.dmc.dao.CommSkuStockInfoMapper;
import com.tydic.dyc.pro.dmc.dao.CommSpuAfterSaleInfoMapper;
import com.tydic.dyc.pro.dmc.dao.CommSpuDetailsInfoMapper;
import com.tydic.dyc.pro.dmc.dao.CommSpuInfoMapper;
import com.tydic.dyc.pro.dmc.dao.CommSpuPicInfoMapper;
import com.tydic.dyc.pro.dmc.po.CommMallPropertyInfoPO;
import com.tydic.dyc.pro.dmc.po.CommMallPropertyUseRecordPO;
import com.tydic.dyc.pro.dmc.po.CommManageCatalogInfoPO;
import com.tydic.dyc.pro.dmc.po.CommPropertyTemplateInfoPO;
import com.tydic.dyc.pro.dmc.po.CommSkuDetailsInfoPO;
import com.tydic.dyc.pro.dmc.po.CommSkuInfoPO;
import com.tydic.dyc.pro.dmc.po.CommSkuPicInfoPO;
import com.tydic.dyc.pro.dmc.po.CommSkuPriceInfoPO;
import com.tydic.dyc.pro.dmc.po.CommSkuStockInfoPO;
import com.tydic.dyc.pro.dmc.po.CommSpuAfterSaleInfoPO;
import com.tydic.dyc.pro.dmc.po.CommSpuDetailsInfoPO;
import com.tydic.dyc.pro.dmc.po.CommSpuInfoPO;
import com.tydic.dyc.pro.dmc.po.CommSpuPicInfoPO;
import com.tydic.dyc.pro.dmc.repository.pricerule.dto.DycProCommSkuPriceInfoDTO;
import com.tydic.dyc.pro.dmc.repository.property.dto.DycProCommSkuPropertyInstDTO;
import com.tydic.dyc.pro.dmc.repository.sku.dto.DycProCommSkuDTO;
import com.tydic.dyc.pro.dmc.repository.sku.dto.DycProCommSkuDetailsInfoDTO;
import com.tydic.dyc.pro.dmc.repository.sku.dto.DycProCommSkuPicInfoDTO;
import com.tydic.dyc.pro.dmc.repository.sku.dto.DycProCommSpuQryDTO;
import com.tydic.dyc.pro.dmc.repository.spu.api.DycProCommSpuRepository;
import com.tydic.dyc.pro.dmc.repository.spu.dto.DycProCommSpuAfterSaleInfoDTO;
import com.tydic.dyc.pro.dmc.repository.spu.dto.DycProCommSpuInfoDTO;
import com.tydic.dyc.pro.dmc.repository.spu.dto.DycProCommSpuPicInfoDTO;
import com.tydic.dyc.pro.dmc.repository.spu.dto.DycPrpCommSpuDetailsInfoDTO;
import com.tydic.dyc.pro.dmc.repository.stock.dto.DycProCommSkuStockInfoDTO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class DycProCommSpuRepositoryImpl
implements DycProCommSpuRepository {
    private static final Logger log = LoggerFactory.getLogger(DycProCommSpuRepositoryImpl.class);
    @Value(value="${ucc.es.spu.index}")
    private String uccEsSpuIndex;
    @Autowired
    private DycProEncodeSerialService dycProEncodeSerialService;
    @Autowired
    private CommSpuInfoMapper commSpuInfoMapper;
    @Autowired
    private CommSpuDetailsInfoMapper commSpuDetailsInfoMapper;
    @Autowired
    private CommSpuPicInfoMapper commSpuPicInfoMapper;
    @Autowired
    private CommSpuAfterSaleInfoMapper commSpuAfterSaleInfoMapper;
    @Autowired
    private CommSkuInfoMapper commSkuInfoMapper;
    @Autowired
    private CommSkuPicInfoMapper commSkuPicInfoMapper;
    @Autowired
    private CommSkuDetailsInfoMapper commSkuDetailsInfoMapper;
    @Autowired
    private CommSkuStockInfoMapper commSkuStockInfoMapper;
    @Autowired
    private CommSkuPriceInfoMapper commSkuPriceInfoMapper;
    @Autowired
    private CommPropertyTemplateInfoMapper commPropertyTemplateInfoMapper;
    @Autowired
    private CommManageCatalogInfoMapper commManageCatalogInfoMapper;
    @Autowired
    private CommMallPropertyInfoMapper commMallPropertyInfoMapper;
    @Autowired
    private CommMallPropertyUseRecordMapper commMallPropertyUseRecordMapper;
    @Autowired
    private NosqlClient nosqlClient;

    @Override
    public DycProCommSpuInfoDTO querySpuAndSkuAllInfoById(DycProCommSpuInfoDTO reqDto) {
        List skuInfoList;
        List spuPicInfoPOS;
        CommSpuAfterSaleInfoPO spuAfterSaleInfoPo;
        CommSpuDetailsInfoPO spuDetailsInfoPo;
        DycProCommSpuInfoDTO spuInfoDto = new DycProCommSpuInfoDTO();
        CommSpuInfoPO spuInfoPO = (CommSpuInfoPO)this.commSpuInfoMapper.selectOne((Wrapper)Wrappers.lambdaQuery().eq(null != reqDto.getSpuId(), CommSpuInfoPO::getSpuId, (Object)reqDto.getSpuId()));
        if (null != spuInfoPO) {
            BeanUtils.copyProperties((Object)spuInfoPO, (Object)spuInfoDto);
            CommPropertyTemplateInfoPO commPropertyTemplateInfoPO = (CommPropertyTemplateInfoPO)this.commPropertyTemplateInfoMapper.selectOne((Wrapper)Wrappers.lambdaQuery().eq(CommPropertyTemplateInfoPO::getPropertyTemplateId, (Object)spuInfoPO.getPropertyTemplateId()));
            if (commPropertyTemplateInfoPO != null) {
                spuInfoDto.setManageCatalogId(commPropertyTemplateInfoPO.getManageCatalogId());
            }
        }
        if (null != (spuDetailsInfoPo = (CommSpuDetailsInfoPO)this.commSpuDetailsInfoMapper.selectOne((Wrapper)Wrappers.lambdaQuery().eq(null != reqDto.getSpuId(), CommSpuDetailsInfoPO::getSpuId, (Object)reqDto.getSpuId())))) {
            DycPrpCommSpuDetailsInfoDTO spuDetails = new DycPrpCommSpuDetailsInfoDTO();
            BeanUtils.copyProperties((Object)spuDetailsInfoPo, (Object)spuDetails);
            spuInfoDto.setSpuDetails(spuDetails);
        }
        if (null != (spuAfterSaleInfoPo = (CommSpuAfterSaleInfoPO)this.commSpuAfterSaleInfoMapper.selectOne((Wrapper)Wrappers.lambdaQuery().eq(null != reqDto.getSpuId(), CommSpuAfterSaleInfoPO::getSpuId, (Object)reqDto.getSpuId())))) {
            DycProCommSpuAfterSaleInfoDTO spuAfterSaleInfo = new DycProCommSpuAfterSaleInfoDTO();
            BeanUtils.copyProperties((Object)spuAfterSaleInfoPo, (Object)spuAfterSaleInfo);
            spuInfoDto.setSpuAfterSaleInfo(spuAfterSaleInfo);
        }
        if (!CollectionUtils.isEmpty((Collection)(spuPicInfoPOS = this.commSpuPicInfoMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(null != reqDto.getSpuId(), CommSpuPicInfoPO::getSpuId, (Object)reqDto.getSpuId()))))) {
            List spuPicList = JSONArray.parseArray((String)JSON.toJSONString((Object)spuPicInfoPOS)).toJavaList(DycProCommSpuPicInfoDTO.class);
            spuInfoDto.setSpuPicList(spuPicList);
        }
        if (!CollectionUtils.isEmpty((Collection)(skuInfoList = this.commSkuInfoMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(null != reqDto.getSpuId(), CommSkuInfoPO::getSpuId, (Object)reqDto.getSpuId()))))) {
            List skuStockInfoPOS;
            List skuPriceInfoPOS;
            List skuDetailsInfoPOS;
            List skuIds = skuInfoList.stream().map(CommSkuInfoPO::getSkuId).collect(Collectors.toList());
            Map<Object, Object> skuPicInfoPOMap = new HashMap();
            Map<Object, Object> skuDetailsInfoPoMap = new HashMap();
            Map<Object, Object> skuPriceInfoPOMap = new HashMap();
            Map<Object, Object> skuStockInfoPOMap = new HashMap();
            List skuPicInfoPoList = this.commSkuPicInfoMapper.selectList((Wrapper)Wrappers.lambdaQuery().in(CommSkuPicInfoPO::getSkuId, skuIds));
            if (!CollectionUtils.isEmpty((Collection)skuPicInfoPoList)) {
                skuPicInfoPOMap = skuPicInfoPoList.stream().collect(Collectors.groupingBy(CommSkuPicInfoPO::getSkuId));
            }
            if (!CollectionUtils.isEmpty((Collection)(skuDetailsInfoPOS = this.commSkuDetailsInfoMapper.selectList((Wrapper)Wrappers.lambdaQuery().in(CommSkuDetailsInfoPO::getSkuId, skuIds))))) {
                skuDetailsInfoPoMap = skuDetailsInfoPOS.stream().collect(Collectors.toMap(CommSkuDetailsInfoPO::getSkuId, Function.identity(), (o1, o2) -> o1));
            }
            if (!CollectionUtils.isEmpty((Collection)(skuPriceInfoPOS = this.commSkuPriceInfoMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(CommSkuPriceInfoPO::getSkuId, skuIds)).eq(CommSkuPriceInfoPO::getPriority, (Object)0))))) {
                skuPriceInfoPOMap = skuPriceInfoPOS.stream().collect(Collectors.groupingBy(CommSkuPriceInfoPO::getSkuId));
            }
            if (!CollectionUtils.isEmpty((Collection)(skuStockInfoPOS = this.commSkuStockInfoMapper.selectList((Wrapper)Wrappers.lambdaQuery().in(CommSkuStockInfoPO::getSkuId, skuIds))))) {
                skuStockInfoPOMap = skuStockInfoPOS.stream().collect(Collectors.toMap(CommSkuStockInfoPO::getSkuId, Function.identity(), (o1, o2) -> o1));
            }
            ArrayList<DycProCommSkuDTO> skuList = new ArrayList<DycProCommSkuDTO>();
            for (CommSkuInfoPO skuPo : skuInfoList) {
                DycProCommSkuDTO skuDto = new DycProCommSkuDTO();
                BeanUtils.copyProperties((Object)skuPo, (Object)skuDto);
                if (skuPicInfoPOMap.containsKey(skuDto.getSkuId())) {
                    skuDto.setSkuPicInfoList(JSON.parseArray((String)JSON.toJSONString((Object)skuPicInfoPOMap.get(skuDto.getSkuId())), DycProCommSkuPicInfoDTO.class));
                }
                if (skuDetailsInfoPoMap.containsKey(skuDto.getSkuId())) {
                    skuDto.setSkuDetails((DycProCommSkuDetailsInfoDTO)JSON.parseObject((String)JSON.toJSONString((Object)skuDetailsInfoPoMap.get(skuDto.getSkuId())), DycProCommSkuDetailsInfoDTO.class));
                }
                if (skuPriceInfoPOMap.containsKey(skuDto.getSkuId())) {
                    skuDto.setPriceInfo((DycProCommSkuPriceInfoDTO)JSON.parseObject((String)JSON.toJSONString(((List)skuPriceInfoPOMap.get(skuDto.getSkuId())).get(0)), DycProCommSkuPriceInfoDTO.class));
                }
                if (skuStockInfoPOMap.containsKey(skuDto.getSkuId())) {
                    skuDto.setStockInfo((DycProCommSkuStockInfoDTO)((Object)JSON.parseObject((String)JSON.toJSONString((Object)skuStockInfoPOMap.get(skuDto.getSkuId())), DycProCommSkuStockInfoDTO.class)));
                }
                skuList.add(skuDto);
            }
            spuInfoDto.setSkuList(skuList);
        }
        return spuInfoDto;
    }

    @Override
    public void updateSpuAllInfoAndSyncNosql(DycProCommSpuInfoDTO reqDto) {
        CommSpuInfoPO updateSpuInfoPo = new CommSpuInfoPO();
        BeanUtils.copyProperties((Object)reqDto, (Object)updateSpuInfoPo);
        updateSpuInfoPo.setUpdateTime(new Date());
        this.commSpuInfoMapper.updateById((Object)updateSpuInfoPo);
        if (null != reqDto.getSpuDetails()) {
            CommSpuDetailsInfoPO updateSpuDetailPo = new CommSpuDetailsInfoPO();
            BeanUtils.copyProperties((Object)reqDto.getSpuDetails(), (Object)updateSpuDetailPo);
            this.commSpuDetailsInfoMapper.updateById((Object)updateSpuDetailPo);
            this.addPropertyRecord(reqDto, updateSpuDetailPo, updateSpuInfoPo, 2);
        }
        this.commSpuPicInfoMapper.delete((Wrapper)Wrappers.lambdaQuery().eq(null != reqDto.getSpuId(), CommSpuPicInfoPO::getSpuId, (Object)reqDto.getSpuId()));
        if (!CollectionUtils.isEmpty(reqDto.getSpuPicList())) {
            ArrayList<CommSpuPicInfoPO> addSpuPicPoList = new ArrayList<CommSpuPicInfoPO>();
            for (DycProCommSpuPicInfoDTO spuPicInfoDto : reqDto.getSpuPicList()) {
                CommSpuPicInfoPO addSpuPicPo = new CommSpuPicInfoPO();
                BeanUtils.copyProperties((Object)spuPicInfoDto, (Object)addSpuPicPo);
                addSpuPicPo.setPicId(Long.valueOf(Sequence.getInstance().nextId()));
                addSpuPicPo.setSpuId(reqDto.getSpuId());
                addSpuPicPoList.add(addSpuPicPo);
            }
            this.commSpuPicInfoMapper.insertBatch(addSpuPicPoList);
        }
        this.commSpuAfterSaleInfoMapper.delete((Wrapper)Wrappers.lambdaQuery().eq(null != reqDto.getSpuId(), CommSpuAfterSaleInfoPO::getSpuId, (Object)reqDto.getSpuId()));
        if (null != reqDto.getSpuAfterSaleInfo()) {
            CommSpuAfterSaleInfoPO addSpuAfterSalePo = new CommSpuAfterSaleInfoPO();
            BeanUtils.copyProperties((Object)reqDto.getSpuAfterSaleInfo(), (Object)addSpuAfterSalePo);
            addSpuAfterSalePo.setAfterSaleId(Long.valueOf(Sequence.getInstance().nextId()));
            addSpuAfterSalePo.setSpuId(reqDto.getSpuId());
            this.commSpuAfterSaleInfoMapper.insert((Object)addSpuAfterSalePo);
        }
        NosqlUpdateSingleReqBO nosqlUpdateSingleReqBO = new NosqlUpdateSingleReqBO();
        nosqlUpdateSingleReqBO.setIndex(this.uccEsSpuIndex);
        NosqlBO nosqlBO = new NosqlBO();
        nosqlBO.setId(String.valueOf(reqDto.getSpuId()));
        DycProExIndexMappingSpuBO updateSpuEsBO = new DycProExIndexMappingSpuBO();
        BeanUtils.copyProperties((Object)updateSpuInfoPo, (Object)updateSpuEsBO);
        BeanUtils.copyProperties((Object)reqDto.getSpuAgrInfo(), (Object)updateSpuEsBO);
        nosqlBO.setObject((Object)updateSpuEsBO);
        nosqlUpdateSingleReqBO.setNosqlBO(nosqlBO);
        NosqlUpdateSingleRsqBO nosqlUpdateSingleRsqBO = this.nosqlClient.updateSingle(nosqlUpdateSingleReqBO);
        if (!"0000".equals(nosqlUpdateSingleRsqBO.getRespCode())) {
            throw new ZTBusinessException("spu\u4fe1\u606f\u540c\u6b65nosql\u5f02\u5e38:" + nosqlUpdateSingleRsqBO.getRespDesc());
        }
    }

    @Override
    public void updateSpuDetailsInfo(DycProCommSpuInfoDTO reqDto) {
        CommSpuDetailsInfoPO updateSpuDetailPo = new CommSpuDetailsInfoPO();
        BeanUtils.copyProperties((Object)reqDto.getSpuDetails(), (Object)updateSpuDetailPo);
        this.commSpuDetailsInfoMapper.update((Object)updateSpuDetailPo, (Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().eq(null != reqDto.getSpuDetails().getDetailId(), CommSpuDetailsInfoPO::getDetailId, (Object)reqDto.getSpuDetails().getDetailId())).eq(null != reqDto.getSpuId(), CommSpuDetailsInfoPO::getSpuId, (Object)reqDto.getSpuId()));
        this.addPropertyRecord(reqDto, updateSpuDetailPo, null, 2);
    }

    @Override
    public DycProCommSpuInfoDTO addSpuAllInfoAndSyncNosql(DycProCommSpuInfoDTO reqDto) {
        DycProCommSpuInfoDTO resultSpuDto = new DycProCommSpuInfoDTO();
        BeanUtils.copyProperties((Object)reqDto, (Object)resultSpuDto);
        Long spuId = Sequence.getInstance().nextId();
        DycProEncodeSerialReqBO encodeSerialReqBO = new DycProEncodeSerialReqBO();
        encodeSerialReqBO.setCenterCode("UCC");
        encodeSerialReqBO.setEncodeRuleCode("COMM_SPU_INFO_SPU_CODE");
        DycProEncodeSerialRspBO encode = this.dycProEncodeSerialService.getEncode(encodeSerialReqBO);
        String spuCode = (String)encode.getSerialNoList().get(0);
        CommSpuInfoPO addSpuInfoPo = new CommSpuInfoPO();
        BeanUtils.copyProperties((Object)reqDto, (Object)addSpuInfoPo);
        addSpuInfoPo.setSpuId(spuId);
        addSpuInfoPo.setSpuCode(spuCode);
        addSpuInfoPo.setCreateTime(new Date());
        addSpuInfoPo.setDelFlag(DycProCommConstants.DelFlag.NO);
        this.commSpuInfoMapper.insert((Object)addSpuInfoPo);
        if (null != reqDto.getSpuDetails()) {
            CommSpuDetailsInfoPO addSpuDetailPo = new CommSpuDetailsInfoPO();
            BeanUtils.copyProperties((Object)reqDto.getSpuDetails(), (Object)addSpuDetailPo);
            addSpuDetailPo.setDetailId(Long.valueOf(Sequence.getInstance().nextId()));
            addSpuDetailPo.setSpuId(spuId);
            this.commSpuDetailsInfoMapper.insert((Object)addSpuDetailPo);
            this.addPropertyRecord(reqDto, addSpuDetailPo, addSpuInfoPo, 1);
        }
        if (!CollectionUtils.isEmpty(reqDto.getSpuPicList())) {
            ArrayList<CommSpuPicInfoPO> addSpuPicPoList = new ArrayList<CommSpuPicInfoPO>();
            for (DycProCommSpuPicInfoDTO spuPicInfoDto : reqDto.getSpuPicList()) {
                CommSpuPicInfoPO addSpuPicPo = new CommSpuPicInfoPO();
                BeanUtils.copyProperties((Object)spuPicInfoDto, (Object)addSpuPicPo);
                addSpuPicPo.setPicId(Long.valueOf(Sequence.getInstance().nextId()));
                addSpuPicPo.setSpuId(spuId);
                addSpuPicPoList.add(addSpuPicPo);
            }
            this.commSpuPicInfoMapper.insertBatch(addSpuPicPoList);
        }
        if (null != reqDto.getSpuAfterSaleInfo()) {
            CommSpuAfterSaleInfoPO addSpuAfterSalePo = new CommSpuAfterSaleInfoPO();
            BeanUtils.copyProperties((Object)reqDto.getSpuAfterSaleInfo(), (Object)addSpuAfterSalePo);
            addSpuAfterSalePo.setAfterSaleId(Long.valueOf(Sequence.getInstance().nextId()));
            addSpuAfterSalePo.setSpuId(spuId);
            this.commSpuAfterSaleInfoMapper.insert((Object)addSpuAfterSalePo);
        }
        DycProExIndexMappingSpuBO syncSpuEsBo = new DycProExIndexMappingSpuBO();
        BeanUtils.copyProperties((Object)addSpuInfoPo, (Object)syncSpuEsBo);
        BeanUtils.copyProperties((Object)reqDto.getSpuAgrInfo(), (Object)syncSpuEsBo);
        NosqlAddSingleReqBO nosqlAddSingleReqBO = new NosqlAddSingleReqBO();
        nosqlAddSingleReqBO.setIndex(this.uccEsSpuIndex);
        NosqlBO nosqlBO = new NosqlBO();
        nosqlBO.setId(String.valueOf(spuId));
        nosqlBO.setObject((Object)syncSpuEsBo);
        nosqlAddSingleReqBO.setNosqlBO(nosqlBO);
        NosqlAddSingleRsqBO nosqlAddSingleRsqBO = this.nosqlClient.addSingle(nosqlAddSingleReqBO);
        if (!"0000".equals(nosqlAddSingleRsqBO.getRespCode())) {
            throw new ZTBusinessException("\u65b0\u589espu\u540c\u6b65nosql\u5f02\u5e38:" + nosqlAddSingleRsqBO.getRespDesc());
        }
        resultSpuDto.setSpuId(spuId);
        resultSpuDto.setSpuCode(spuCode);
        return resultSpuDto;
    }

    @Override
    public void deleteSpuByIdAndSyncNosql(DycProCommSpuInfoDTO reqDto) {
        CommSpuInfoPO deleteCommSpuPo = new CommSpuInfoPO();
        deleteCommSpuPo.setSpuId(reqDto.getSpuId());
        deleteCommSpuPo.setDelFlag(DycProCommConstants.DelFlag.YES);
        this.commSpuInfoMapper.updateById((Object)deleteCommSpuPo);
        CommSkuInfoPO commSkuInfoPO = new CommSkuInfoPO();
        commSkuInfoPO.setDelFlag(DycProCommConstants.DelFlag.YES);
        this.commSkuInfoMapper.update((Object)commSkuInfoPO, (Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(CommSkuInfoPO::getSpuId, new Object[]{reqDto.getSpuId()})).ne(CommSkuInfoPO::getSkuStatus, (Object)DycProCommConstants.SkuStatus.DRAFT));
        List commSkuInfoPOS = this.commSkuInfoMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(CommSkuInfoPO::getSpuId, new Object[]{reqDto.getSpuId()})).eq(CommSkuInfoPO::getSkuStatus, (Object)DycProCommConstants.SkuStatus.DRAFT));
        if (!CollectionUtils.isEmpty((Collection)commSkuInfoPOS)) {
            List skuIds = commSkuInfoPOS.stream().map(CommSkuInfoPO::getSkuId).collect(Collectors.toList());
            this.commSkuInfoMapper.delete((Wrapper)Wrappers.lambdaQuery().in(CommSkuInfoPO::getSkuId, skuIds));
            this.commSkuStockInfoMapper.delete((Wrapper)Wrappers.lambdaQuery().in(CommSkuStockInfoPO::getSkuId, skuIds));
            List agrItemIds = commSkuInfoPOS.stream().map(CommSkuInfoPO::getAgrItemId).filter(Objects::nonNull).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(agrItemIds)) {
                this.commSkuInfoMapper.updateAgrItemInitCommFlag(agrItemIds, Integer.valueOf(BooleanFlag.NO.getCode()));
            }
        }
        NosqlDeleteSingleReqBO nosqlDeleteSingleReqBO = new NosqlDeleteSingleReqBO();
        nosqlDeleteSingleReqBO.setId(String.valueOf(reqDto.getSpuId()));
        nosqlDeleteSingleReqBO.setIndex(this.uccEsSpuIndex);
        this.nosqlClient.deleteSingle(nosqlDeleteSingleReqBO);
    }

    @Override
    public DycProBaseManagePageRspBO<DycProExIndexMappingSpuBO> qryEsSpuListPage(DycProCommSpuQryDTO reqDto) {
        NosqlQueryByBuilderReqBO nosqlQueryByBuilderReqBO = new NosqlQueryByBuilderReqBO();
        nosqlQueryByBuilderReqBO.setIndex(this.uccEsSpuIndex);
        nosqlQueryByBuilderReqBO.setNosqlBuilder(this.getSpuNosqlBuilder(reqDto));
        log.debug("es\u67e5\u8be2\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)nosqlQueryByBuilderReqBO));
        NosqlQueryByBuilderRsqBO nosqlQueryByBuilderRsqBO = this.nosqlClient.queryByBuilder(nosqlQueryByBuilderReqBO);
        log.debug("es\u67e5\u8be2\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)nosqlQueryByBuilderRsqBO));
        if (!"0000".equals(nosqlQueryByBuilderRsqBO.getRespCode())) {
            throw new ZTBusinessException("\u67e5\u8be2nosql\u5f02\u5e38:" + nosqlQueryByBuilderRsqBO.getRespDesc());
        }
        DycProBaseManagePageRspBO rspBO = new DycProBaseManagePageRspBO();
        rspBO.setPageNo(nosqlQueryByBuilderRsqBO.getPageNo().intValue());
        rspBO.setTotal(nosqlQueryByBuilderRsqBO.getTotal().intValue());
        rspBO.setRecordsTotal(nosqlQueryByBuilderRsqBO.getRecordsTotal().intValue());
        rspBO.setRows(JSON.parseArray((String)nosqlQueryByBuilderRsqBO.getDocumentStr(), DycProExIndexMappingSpuBO.class));
        return rspBO;
    }

    public void addPropertyRecord(DycProCommSpuInfoDTO reqDto, CommSpuDetailsInfoPO spuDetailPo, CommSpuInfoPO spuInfoPo, Integer type) {
        if (!StringUtils.isEmpty((Object)spuDetailPo.getPropertyInstInfo())) {
            List propertyInstDTOS = JSONArray.parseArray((String)spuDetailPo.getPropertyInstInfo(), DycProCommSkuPropertyInstDTO.class);
            List propertyIds = propertyInstDTOS.stream().map(DycProCommSkuPropertyInstDTO::getPropertyId).collect(Collectors.toList());
            List commMallPropertyInfoPOS = this.commMallPropertyInfoMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(CommMallPropertyInfoPO::getMallPropertyId, propertyIds)).eq(CommMallPropertyInfoPO::getMallPropertyFlag, (Object)DycProCommConstants.MallPropertyFlagConstant.TEMPORARY_PROPERTY));
            if (!CollectionUtils.isEmpty((Collection)commMallPropertyInfoPOS)) {
                List propertyUseRecordPOS1 = this.commMallPropertyUseRecordMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(CommMallPropertyUseRecordPO::getMallPropertyId, (Collection)commMallPropertyInfoPOS.stream().map(CommMallPropertyInfoPO::getMallPropertyId).collect(Collectors.toList()))).eq(CommMallPropertyUseRecordPO::getCreateCompanyId, (Object)reqDto.getUpdateCompanyId())).eq(CommMallPropertyUseRecordPO::getSpuId, (Object)reqDto.getSpuId()));
                if (!CollectionUtils.isEmpty((Collection)propertyUseRecordPOS1)) {
                    Set mallPropertyIds = propertyUseRecordPOS1.stream().map(CommMallPropertyUseRecordPO::getMallPropertyId).collect(Collectors.toSet());
                    commMallPropertyInfoPOS.removeIf(e -> mallPropertyIds.contains(e.getMallPropertyId()));
                }
                if (!CollectionUtils.isEmpty((Collection)commMallPropertyInfoPOS)) {
                    CommPropertyTemplateInfoPO propertyTemplateInfoPO = (CommPropertyTemplateInfoPO)this.commPropertyTemplateInfoMapper.selectById((Serializable)reqDto.getPropertyTemplateId());
                    Long manageCatalogId = null;
                    String manageCatalogName = "";
                    String manageCatalogPath = "";
                    String manageCatalogPathName = "";
                    if (null != propertyTemplateInfoPO) {
                        CommManageCatalogInfoPO manageCatalogInfoPO = (CommManageCatalogInfoPO)this.commManageCatalogInfoMapper.selectById((Serializable)propertyTemplateInfoPO.getManageCatalogId());
                        if (manageCatalogInfoPO == null) {
                            throw new ZTBusinessException("\u672a\u67e5\u8be2\u5230\u8be5\u540e\u53f0\u7ba1\u7406\u7c7b\u76ee");
                        }
                        manageCatalogId = manageCatalogInfoPO.getManageCatalogId();
                        manageCatalogName = manageCatalogInfoPO.getManageCatalogName();
                        List manageCatalogIds = Arrays.stream(manageCatalogInfoPO.getManageCatalogPath().split("-")).map(Long::valueOf).collect(Collectors.toList());
                        List ManageCatalogInfoList = this.commManageCatalogInfoMapper.selectList((Wrapper)new LambdaQueryWrapperX().in(CommManageCatalogInfoPO::getManageCatalogId, (Collection)manageCatalogIds.stream().distinct().collect(Collectors.toList())));
                        Map ManageCatalogInfoMap = ManageCatalogInfoList.stream().collect(Collectors.toMap(CommManageCatalogInfoPO::getManageCatalogId, Function.identity()));
                        ArrayList<DycProEsIndexMappingSkuManageCatalogBO> esManageCatalogList = new ArrayList<DycProEsIndexMappingSkuManageCatalogBO>();
                        for (Long each : manageCatalogIds) {
                            DycProEsIndexMappingSkuManageCatalogBO esManageCatalogBo = new DycProEsIndexMappingSkuManageCatalogBO();
                            esManageCatalogBo.setManageCatalogId(each);
                            esManageCatalogBo.setManageCatalogName(((CommManageCatalogInfoPO)ManageCatalogInfoMap.get(each)).getManageCatalogName());
                            esManageCatalogBo.setManageCatalogLevel(((CommManageCatalogInfoPO)ManageCatalogInfoMap.get(each)).getManageCatalogLevel());
                            esManageCatalogList.add(esManageCatalogBo);
                            manageCatalogPathName = manageCatalogPathName + esManageCatalogBo.getManageCatalogName() + ">";
                        }
                        manageCatalogPath = manageCatalogInfoPO.getManageCatalogPath();
                        manageCatalogPathName = manageCatalogPathName.substring(0, manageCatalogPathName.length() - 1);
                    }
                    ArrayList<CommMallPropertyUseRecordPO> propertyUseRecordPOS = new ArrayList<CommMallPropertyUseRecordPO>();
                    for (CommMallPropertyInfoPO each : commMallPropertyInfoPOS) {
                        CommMallPropertyUseRecordPO commMallPropertyUseRecordPO = new CommMallPropertyUseRecordPO();
                        BeanUtils.copyProperties((Object)reqDto, (Object)commMallPropertyUseRecordPO);
                        commMallPropertyUseRecordPO.setRecordId(Long.valueOf(Sequence.getInstance().nextId()));
                        if (spuInfoPo != null) {
                            if (!ObjectUtils.isEmpty((Object)spuInfoPo.getSpuId())) {
                                commMallPropertyUseRecordPO.setSpuId(spuInfoPo.getSpuId());
                            }
                            if (!ObjectUtils.isEmpty((Object)spuInfoPo.getSpuCode())) {
                                commMallPropertyUseRecordPO.setSpuCode(spuInfoPo.getSpuCode());
                            }
                            if (!ObjectUtils.isEmpty((Object)spuInfoPo.getSpuName())) {
                                commMallPropertyUseRecordPO.setSpuName(spuInfoPo.getSpuName());
                            }
                        }
                        commMallPropertyUseRecordPO.setMallPropertyId(each.getMallPropertyId());
                        commMallPropertyUseRecordPO.setManageCatalogId(manageCatalogId);
                        commMallPropertyUseRecordPO.setManageCatalogName(manageCatalogName);
                        commMallPropertyUseRecordPO.setManageCatalogPath(manageCatalogPath);
                        commMallPropertyUseRecordPO.setManageCatalogPathName(manageCatalogPathName);
                        if (type == 1) {
                            commMallPropertyUseRecordPO.setCreateUserId(reqDto.getCreateUserId());
                            commMallPropertyUseRecordPO.setCreateUserName(reqDto.getCreateUserName());
                            commMallPropertyUseRecordPO.setCreateUserAccount(reqDto.getCreateUserAccount());
                            commMallPropertyUseRecordPO.setCreateCompanyId(reqDto.getCreateCompanyId());
                            commMallPropertyUseRecordPO.setCreateCompanyName(reqDto.getCreateCompanyName());
                            commMallPropertyUseRecordPO.setCreateOrgId(reqDto.getCreateOrgId());
                            commMallPropertyUseRecordPO.setCreateOrgName(reqDto.getCreateOrgName());
                            commMallPropertyUseRecordPO.setCreateOrgPath(reqDto.getCreateOrgPath());
                        } else {
                            commMallPropertyUseRecordPO.setCreateUserId(reqDto.getUpdateUserId());
                            commMallPropertyUseRecordPO.setCreateUserName(reqDto.getUpdateUserName());
                            commMallPropertyUseRecordPO.setCreateUserAccount(reqDto.getUpdateUserAccount());
                            commMallPropertyUseRecordPO.setCreateCompanyId(reqDto.getUpdateCompanyId());
                            commMallPropertyUseRecordPO.setCreateCompanyName(reqDto.getUpdateCompanyName());
                            commMallPropertyUseRecordPO.setCreateOrgId(reqDto.getUpdateOrgId());
                            commMallPropertyUseRecordPO.setCreateOrgName(reqDto.getUpdateOrgName());
                            commMallPropertyUseRecordPO.setCreateOrgPath(reqDto.getUpdateOrgPath());
                        }
                        commMallPropertyUseRecordPO.setCreateTime(new Date(System.currentTimeMillis()));
                        propertyUseRecordPOS.add(commMallPropertyUseRecordPO);
                    }
                    this.commMallPropertyUseRecordMapper.insertBatch(propertyUseRecordPOS);
                }
            }
        }
    }

    private NosqlBuilder getSpuNosqlBuilder(DycProCommSpuQryDTO reqDto) {
        NosqlCreateBuilder nosqlCreateBuilder = new NosqlCreateBuilder();
        nosqlCreateBuilder.pageNo(Integer.valueOf(reqDto.getPageNo()));
        nosqlCreateBuilder.pageSize(Integer.valueOf(reqDto.getPageSize()));
        nosqlCreateBuilder.orderBy("createTime", NosqlSortOrder.DESC);
        ArrayList<NosqlQueryGroupBO> nosqlQueryGroupBOList = new ArrayList<NosqlQueryGroupBO>();
        ArrayList<NosqlQueryBO> nosqlQueryBOList = new ArrayList<NosqlQueryBO>();
        NosqlQueryGroupBO subQueryGroupBO = new NosqlQueryGroupBO();
        subQueryGroupBO.setNosqlQueryList(nosqlQueryBOList);
        subQueryGroupBO.setConnetType(NosqlConnetType.AND);
        ArrayList<NosqlQueryGroupBO> subnosqlQueryGroupBOList = new ArrayList<NosqlQueryGroupBO>();
        subnosqlQueryGroupBOList.add(subQueryGroupBO);
        NosqlQueryGroupBO queryGroupBO = new NosqlQueryGroupBO(subnosqlQueryGroupBOList, NosqlConnetType.AND);
        nosqlQueryGroupBOList.add(queryGroupBO);
        if (null != reqDto.getCreateCompanyId()) {
            NosqlQueryBO createCompanyId = new NosqlQueryBO("createCompanyId", reqDto.getCreateCompanyId().toString(), NosqlQueryValueType.ACCURATE);
            nosqlQueryBOList.add(createCompanyId);
        }
        if (null != reqDto.getSpuStatus()) {
            NosqlQueryBO spuStatus = new NosqlQueryBO("spuStatus", reqDto.getSpuStatus().toString(), NosqlQueryValueType.ACCURATE);
            nosqlQueryBOList.add(spuStatus);
        }
        NosqlQueryBO spuName = new NosqlQueryBO("spuName", reqDto.getSpuName(), NosqlQueryValueType.WILD_CARD);
        nosqlQueryBOList.add(spuName);
        NosqlQueryBO spuCode = new NosqlQueryBO("spuCode", reqDto.getSpuCode(), NosqlQueryValueType.WILD_CARD);
        nosqlQueryBOList.add(spuCode);
        NosqlQueryBO agrName = new NosqlQueryBO("agrName", reqDto.getAgrName(), NosqlQueryValueType.WILD_CARD);
        nosqlQueryBOList.add(agrName);
        NosqlQueryBO agrCode = new NosqlQueryBO("agrCode", reqDto.getAgrCode(), NosqlQueryValueType.WILD_CARD);
        nosqlQueryBOList.add(agrCode);
        NosqlQueryBO enAgrCode = new NosqlQueryBO("enAgrCode", reqDto.getEnAgrCode(), NosqlQueryValueType.WILD_CARD);
        nosqlQueryBOList.add(enAgrCode);
        NosqlQueryBO supplierName = new NosqlQueryBO("supplierName", reqDto.getSupplierName(), NosqlQueryValueType.WILD_CARD);
        nosqlQueryBOList.add(supplierName);
        nosqlCreateBuilder.queryGroupList(nosqlQueryGroupBOList);
        return nosqlCreateBuilder.build();
    }
}

