/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.dmc.ecs.mq.consumer;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageConsumer;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.ohaotian.plugin.mq.proxy.status.ProxyConsumerStatus;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcCommCheckObjEnum;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcCommCheckRuleTypeEnum;
import com.tydic.dyc.pro.base.core.dictionary.enums.DmcCommCheckSenceEnum;
import com.tydic.dyc.pro.dmc.ecs.service.api.DycProCommDealWaitMsgService;
import com.tydic.dyc.pro.dmc.ecs.service.api.DycProCommUpdateUserTaskProcessService;
import com.tydic.dyc.pro.dmc.ecs.service.bo.DycProCommDealWaitMsgReqBO;
import com.tydic.dyc.pro.dmc.ecs.service.bo.DycProCommDealWaitMsgRspBO;
import com.tydic.dyc.pro.dmc.ecs.service.bo.DycProCommDealWaitMsgSkuInfoBO;
import com.tydic.dyc.pro.dmc.ecs.service.bo.DycProCommReceiveWaitMqContentBO;
import com.tydic.dyc.pro.dmc.ecs.service.bo.DycProCommUpdateUserTaskProcessReqBO;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;

public class DycProCommDealWaitMsgConsumer
extends DefaultProxyMessageConfig
implements ProxyMessageConsumer {
    private static final Logger log = LoggerFactory.getLogger(DycProCommDealWaitMsgConsumer.class);
    @Autowired
    private DycProCommDealWaitMsgService dycProCommDealWaitMsgService;
    @Autowired
    private DycProCommUpdateUserTaskProcessService dycProCommUpdateUserTaskProcessService;
    @Value(value="${is.need.image-text.check}")
    private String isNeedImageTextCheck;
    @Value(value="${is.need.price.check}")
    private String isNeedPriceCheck;
    @Value(value="${comm.checkrule.topic}")
    private String commCheckRuleTopic;
    @Value(value="${comm.checkrule.tag}")
    private String commCheckRuleTag;
    @Resource(name="dycProCmmCheckRuleMqServiceProvider")
    private ProxyMessageProducer dycProCmmCheckRuleMqServiceProvider;

    public ProxyConsumerStatus onMessage(ProxyMessage message) {
        try {
            Integer totalDealCount = 0;
            Integer totalSuccessCount = 0;
            Integer totalFailCount = 0;
            DycProCommReceiveWaitMqContentBO receiveWaitMqContentBo = (DycProCommReceiveWaitMqContentBO)JSONObject.parseObject((String)message.getContent(), DycProCommReceiveWaitMqContentBO.class);
            for (DycProCommDealWaitMsgSkuInfoBO dealWaitMsgSkuInfoBo : receiveWaitMqContentBo.getSkuList()) {
                DycProCommDealWaitMsgReqBO dealWaitMsgReqBO = new DycProCommDealWaitMsgReqBO();
                BeanUtils.copyProperties((Object)dealWaitMsgSkuInfoBo, (Object)dealWaitMsgReqBO);
                DycProCommDealWaitMsgRspBO dealWaitMsgRspBo = this.dycProCommDealWaitMsgService.dealWaitMsg(dealWaitMsgReqBO);
                totalDealCount = totalDealCount + 1;
                if ("0000".equals(dealWaitMsgRspBo.getRespCode())) {
                    totalSuccessCount = totalSuccessCount + 1;
                } else {
                    totalFailCount = totalFailCount + 1;
                }
                if (CollectionUtils.isEmpty(dealWaitMsgRspBo.getDealSkuMsgForCheckParamBOS())) continue;
                if ("YES".equals(this.isNeedPriceCheck)) {
                    dealWaitMsgRspBo.getDealSkuMsgForCheckParamBOS().forEach(dealSkuMsgForCheckParamBO -> {
                        if (dealSkuMsgForCheckParamBO.getCheckSceneCode().equals(DmcCommCheckSenceEnum.ADD_GOODS.getCode()) || dealSkuMsgForCheckParamBO.getCheckSceneCode().equals(DmcCommCheckSenceEnum.CHANGE_GOODS_PRICE.getCode())) {
                            dealSkuMsgForCheckParamBO.setCheckObjType(Integer.parseInt(DmcCommCheckObjEnum.EC_GOODS.getCode()));
                            dealSkuMsgForCheckParamBO.setCheckRuleType(Integer.parseInt(DmcCommCheckRuleTypeEnum.PRICE_CHECK.getCode()));
                            JSONObject jsonObject = new JSONObject();
                            jsonObject.put("type", (Object)"addCheckRecord");
                            jsonObject.put("execCheckRuleParamBO", dealSkuMsgForCheckParamBO);
                            this.dycProCmmCheckRuleMqServiceProvider.send(new ProxyMessage(this.commCheckRuleTopic, this.commCheckRuleTag, jsonObject.toJSONString()));
                        }
                    });
                }
                if (!"YES".equals(this.isNeedImageTextCheck)) continue;
                dealWaitMsgRspBo.getDealSkuMsgForCheckParamBOS().forEach(dealSkuMsgForCheckParamBO -> {
                    if (dealSkuMsgForCheckParamBO.getCheckSceneCode().equals(DmcCommCheckSenceEnum.ADD_GOODS.getCode()) || dealSkuMsgForCheckParamBO.getCheckSceneCode().equals(DmcCommCheckSenceEnum.CHANGE_GOODS.getCode())) {
                        dealSkuMsgForCheckParamBO.setCheckObjType(Integer.parseInt(DmcCommCheckObjEnum.EC_GOODS.getCode()));
                        dealSkuMsgForCheckParamBO.setCheckRuleType(Integer.parseInt(DmcCommCheckRuleTypeEnum.IMAGE_CHECK.getCode()));
                        JSONObject jsonObject = new JSONObject();
                        jsonObject.put("type", (Object)"addCheckRecord");
                        jsonObject.put("execCheckRuleParamBO", dealSkuMsgForCheckParamBO);
                        this.dycProCmmCheckRuleMqServiceProvider.send(new ProxyMessage(this.commCheckRuleTopic, this.commCheckRuleTag, jsonObject.toJSONString()));
                    }
                });
            }
            DycProCommUpdateUserTaskProcessReqBO dycProCommUpdateUserTaskProcessReqBO = new DycProCommUpdateUserTaskProcessReqBO();
            dycProCommUpdateUserTaskProcessReqBO.setId(receiveWaitMqContentBo.getId());
            dycProCommUpdateUserTaskProcessReqBO.setProcFailNum(totalFailCount);
            dycProCommUpdateUserTaskProcessReqBO.setProcSuccessNum(totalSuccessCount);
            this.dycProCommUpdateUserTaskProcessService.updateUserTaskProcess(dycProCommUpdateUserTaskProcessReqBO);
            return ProxyConsumerStatus.CONSUME_SUCCESS;
        }
        catch (Exception e) {
            log.error("\u5546\u54c1\u6d88\u8d39\u8005\u5f02\u5e38\uff1a" + e.getMessage(), (Throwable)e);
            return ProxyConsumerStatus.CONSUME_SUCCESS;
        }
    }
}

