/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.dmc.service.consult.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.file.FileClient;
import com.tydic.dyc.pro.dmc.constant.DycProSscConstants;
import com.tydic.dyc.pro.dmc.repository.api.DycProSscConsultRepository;
import com.tydic.dyc.pro.dmc.repository.dto.DycProSscConsultDTO;
import com.tydic.dyc.pro.dmc.repository.dto.DycProSscConsultHandleDTO;
import com.tydic.dyc.pro.dmc.repository.dto.DycProSscConsultQuoteInfoDTO;
import com.tydic.dyc.pro.dmc.repository.dto.DycProSscConsultQuoteItemInfoDTO;
import com.tydic.dyc.pro.dmc.repository.dto.DycProSscConsultSupplierInfoDTO;
import com.tydic.dyc.pro.dmc.repository.dto.DycProSscFileInfoDTO;
import com.tydic.dyc.pro.dmc.service.consult.api.DycProSscCutPointService;
import com.tydic.dyc.pro.dmc.service.consult.api.DycProSscReleaseConsultResultNoticeService;
import com.tydic.dyc.pro.dmc.service.consult.bo.CreatePDFBO;
import com.tydic.dyc.pro.dmc.service.consult.bo.DycProSscBuildAndQueryConsultResultNoticeReqBO;
import com.tydic.dyc.pro.dmc.service.consult.bo.DycProSscCutPointReqBO;
import com.tydic.dyc.pro.dmc.service.consult.bo.DycProSscReleaseConsultResultNoticeReqBO;
import com.tydic.dyc.pro.dmc.service.consult.bo.DycProSscReleaseConsultResultNoticeRspBO;
import com.tydic.dyc.pro.dmc.service.consult.bo.UocFile;
import com.tydic.dyc.pro.dmc.service.consult.impl.PDFTemplateUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.xhtmlrenderer.pdf.ITextRenderer;

@RestController
@RequestMapping(value={"DMC_GROUP/4.0.0/com.tydic.dyc.pro.dmc.service.consult.api.DycProSscReleaseConsultResultNoticeService"})
public class DycProSscReleaseConsultResultNoticeServiceImpl
implements DycProSscReleaseConsultResultNoticeService {
    private static final Logger log = LoggerFactory.getLogger(DycProSscReleaseConsultResultNoticeServiceImpl.class);
    @Autowired
    private DycProSscConsultRepository dycProSscConsultRepository;
    @Autowired
    private DycProSscCutPointService dycProSscCutPointService;
    @Value(value="${dyc.file.inst.data.path:dyc/file/instData}")
    private String instDataPath;
    @Autowired
    private FileClient fileClient;

    @Override
    @PostMapping(value={"releaseConsultResultNotice"})
    public DycProSscReleaseConsultResultNoticeRspBO releaseConsultResultNotice(@RequestBody DycProSscReleaseConsultResultNoticeReqBO reqBO) {
        if (CollectionUtils.isEmpty(reqBO.getList())) {
            throw new ZTBusinessException("\u5bf9\u8c61\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        }
        log.info("releaseConsultResultNotice reqBO =" + JSON.toJSONString((Object)((Object)reqBO)));
        Date now = new Date();
        for (DycProSscBuildAndQueryConsultResultNoticeReqBO dycProSscBuildAndQueryConsultResultNoticeReqBO : reqBO.getList()) {
            if (StringUtils.isBlank((CharSequence)dycProSscBuildAndQueryConsultResultNoticeReqBO.getModelInfo())) {
                this.buildAndQueryConsultResultNotice(dycProSscBuildAndQueryConsultResultNoticeReqBO, now);
            } else {
                this.updateConsultResultNotice(dycProSscBuildAndQueryConsultResultNoticeReqBO);
            }
            DycProSscConsultSupplierInfoDTO dycProSscConsultSupplierInfoDTO = new DycProSscConsultSupplierInfoDTO();
            dycProSscConsultSupplierInfoDTO.setInvitedId(dycProSscBuildAndQueryConsultResultNoticeReqBO.getInvitedId());
            dycProSscConsultSupplierInfoDTO.setNotificationReleaseTime(now);
            this.dycProSscConsultRepository.updateConsultSupplier(dycProSscConsultSupplierInfoDTO);
            DycProSscConsultDTO consultDTO = new DycProSscConsultDTO();
            consultDTO.setConsultId(dycProSscBuildAndQueryConsultResultNoticeReqBO.getConsultId());
            DycProSscConsultDTO dycProSscConsultDTO = this.dycProSscConsultRepository.queryConsultBaseInfo(consultDTO);
            DycProSscCutPointReqBO dycProSscCutPointReqBO = new DycProSscCutPointReqBO();
            dycProSscCutPointReqBO.setConsultId(dycProSscBuildAndQueryConsultResultNoticeReqBO.getConsultId());
            dycProSscCutPointReqBO.setSupplierId(dycProSscBuildAndQueryConsultResultNoticeReqBO.getSupplierId());
            if (DycProSscConstants.ConsultType.CONSULT_TYPE_XJ.equals(dycProSscConsultDTO.getConsultType())) {
                dycProSscCutPointReqBO.setTodoType("SendInquiryResult");
            } else if (DycProSscConstants.ConsultType.CONSULT_TYPE_JJ.equals(dycProSscConsultDTO.getConsultType())) {
                dycProSscCutPointReqBO.setTodoType("SendBiddingResult");
            }
            dycProSscCutPointReqBO.setCenter("SSC");
            dycProSscCutPointReqBO.setShareId(dycProSscCutPointReqBO.getConsultId());
            dycProSscCutPointReqBO.setObjId(dycProSscCutPointReqBO.getConsultId());
            dycProSscCutPointReqBO.setObjType("2");
            dycProSscCutPointReqBO.setBusiType(dycProSscCutPointReqBO.getTodoType());
            log.info("releaseConsultResultNotice dycProSscCutPointReqBO =" + JSON.toJSONString((Object)((Object)dycProSscCutPointReqBO)));
            this.dycProSscCutPointService.todoCutPoint(dycProSscCutPointReqBO);
        }
        return new DycProSscReleaseConsultResultNoticeRspBO();
    }

    private void updateConsultResultNotice(DycProSscBuildAndQueryConsultResultNoticeReqBO reqBO) {
        this.paramCheck(reqBO);
        UocFile uocFile = this.convertHtmlToPdfBytes(reqBO);
        DycProSscConsultHandleDTO dto = new DycProSscConsultHandleDTO();
        dto.setObjId(reqBO.getInvitedId());
        dto.setObjType(DycProSscConstants.SscFileObjType.CONSULT_RESULT_NOTICE);
        ArrayList<DycProSscFileInfoDTO> fileInfoList = new ArrayList<DycProSscFileInfoDTO>();
        DycProSscFileInfoDTO dycProSscFileInfoDTO = new DycProSscFileInfoDTO();
        dycProSscFileInfoDTO.setFileUrl(uocFile.getUrl());
        dycProSscFileInfoDTO.setFileName(uocFile.getFilename());
        dycProSscFileInfoDTO.setModelInfo(reqBO.getModelInfo());
        fileInfoList.add(dycProSscFileInfoDTO);
        dto.setFileInfoList(fileInfoList);
        this.dycProSscConsultRepository.updateFileByObj(dto);
    }

    private void buildAndQueryConsultResultNotice(DycProSscBuildAndQueryConsultResultNoticeReqBO reqBO, Date now) {
        this.paramCheck(reqBO);
        DycProSscFileInfoDTO dycProSscFileInfoDTO = new DycProSscFileInfoDTO();
        dycProSscFileInfoDTO.setObjId(reqBO.getInvitedId());
        dycProSscFileInfoDTO.setObjType(DycProSscConstants.SscFileObjType.CONSULT_RESULT_NOTICE);
        List dycProSscFileInfoDTOS = this.dycProSscConsultRepository.qryFileByObj(dycProSscFileInfoDTO);
        if (CollectionUtils.isEmpty((Collection)dycProSscFileInfoDTOS)) {
            UocFile uocFile = this.buildPdfFile(reqBO, now);
            DycProSscConsultHandleDTO dto = this.getDycProSscConsultHandleDTO(uocFile, reqBO.getInvitedId());
            this.dycProSscConsultRepository.createFile(dto);
        }
    }

    private DycProSscConsultHandleDTO getDycProSscConsultHandleDTO(UocFile uocFile, Long invitedId) {
        ArrayList<DycProSscFileInfoDTO> fileInfoList = new ArrayList<DycProSscFileInfoDTO>();
        DycProSscFileInfoDTO dycProSscFileInfoBO = new DycProSscFileInfoDTO();
        dycProSscFileInfoBO.setFileName(uocFile.getFilename());
        dycProSscFileInfoBO.setFileUrl(uocFile.getUrl());
        dycProSscFileInfoBO.setModelInfo(uocFile.getModelInfo());
        fileInfoList.add(dycProSscFileInfoBO);
        DycProSscConsultHandleDTO dto = new DycProSscConsultHandleDTO();
        dto.setObjId(invitedId);
        dto.setObjType(DycProSscConstants.SscFileObjType.CONSULT_RESULT_NOTICE);
        dto.setFileInfoList(fileInfoList);
        return dto;
    }

    private UocFile buildPdfFile(DycProSscBuildAndQueryConsultResultNoticeReqBO reqBO, Date now) {
        DycProSscConsultDTO dycProSscConsultDTO = new DycProSscConsultDTO();
        dycProSscConsultDTO.setConsultId(reqBO.getConsultId());
        dycProSscConsultDTO = this.dycProSscConsultRepository.queryConsultBaseInfo(dycProSscConsultDTO);
        HashMap<String, Object> data = new HashMap<String, Object>();
        if (dycProSscConsultDTO.getConsultType().equals(DycProSscConstants.ConsultType.CONSULT_TYPE_XJ)) {
            data.put("consultName", dycProSscConsultDTO.getConsultName() + "\u8be2\u4ef7");
        } else if (dycProSscConsultDTO.getConsultType().equals(DycProSscConstants.ConsultType.CONSULT_TYPE_JJ)) {
            data.put("consultName", dycProSscConsultDTO.getConsultName() + "\u7ade\u4ef7");
        } else if (dycProSscConsultDTO.getConsultType().equals(DycProSscConstants.ConsultType.CONSULT_TYPE_YJ)) {
            data.put("consultName", dycProSscConsultDTO.getConsultName() + "\u8bae\u4ef7");
        }
        data.put("consultNo", dycProSscConsultDTO.getConsultNo());
        data.put("companyName", dycProSscConsultDTO.getPurchaseCompanyName());
        data.put("supplierName", reqBO.getSupplierName());
        data.put("nowTime", now);
        String filetemplateName = "";
        if ("0".equals(String.valueOf(reqBO.getIsChosen()))) {
            DycProSscConsultQuoteInfoDTO dycProSscConsultQuoteInfoDTO = (DycProSscConsultQuoteInfoDTO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), DycProSscConsultQuoteInfoDTO.class);
            if (dycProSscConsultDTO.getConsultType().equals(DycProSscConstants.ConsultType.CONSULT_TYPE_JJ)) {
                dycProSscConsultQuoteInfoDTO.setQuoteStatus(DycProSscConstants.QuoteStatus.HAS_QUOTE);
            } else if (dycProSscConsultDTO.getConsultType().equals(DycProSscConstants.ConsultType.CONSULT_TYPE_XJ)) {
                dycProSscConsultQuoteInfoDTO.setQuoteStatus(DycProSscConstants.QuoteStatus.HAS_QUOTE);
            }
            List dycProSscConsultQuoteInfoDTOS = this.dycProSscConsultRepository.queryConsultQuoteInfoList(dycProSscConsultQuoteInfoDTO);
            if (CollectionUtils.isEmpty((Collection)dycProSscConsultQuoteInfoDTOS)) {
                throw new ZTBusinessException("\u4f9b\u5e94\u5546\u672a\u62a5\u4ef7");
            }
            if (dycProSscConsultQuoteInfoDTOS.size() > 1) {
                throw new ZTBusinessException("\u67e5\u8be2\u6570\u636e\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u5e93\u6570\u636e");
            }
            DycProSscConsultQuoteItemInfoDTO dto = (DycProSscConsultQuoteItemInfoDTO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), DycProSscConsultQuoteItemInfoDTO.class);
            dto.setQuoteId(((DycProSscConsultQuoteInfoDTO)dycProSscConsultQuoteInfoDTOS.get(0)).getQuoteId());
            List dycProSscQryConsultAndItemAndSupplierListDTOS = this.dycProSscConsultRepository.qryConsultAndItemAndSupplierList(dto);
            data.put("consultItemInfoList", dycProSscQryConsultAndItemAndSupplierListDTOS);
            if (dycProSscConsultDTO.getConsultType().equals(DycProSscConstants.ConsultType.CONSULT_TYPE_XJ)) {
                filetemplateName = "consultResultNoticeYes.ftl";
            } else if (dycProSscConsultDTO.getConsultType().equals(DycProSscConstants.ConsultType.CONSULT_TYPE_JJ)) {
                filetemplateName = "consultResultNoticeYesJJ.ftl";
            }
        } else if (dycProSscConsultDTO.getConsultType().equals(DycProSscConstants.ConsultType.CONSULT_TYPE_XJ)) {
            filetemplateName = "consultResultNoticeNo.ftl";
        } else if (dycProSscConsultDTO.getConsultType().equals(DycProSscConstants.ConsultType.CONSULT_TYPE_JJ)) {
            filetemplateName = "consultResultNoticeNoJJ.ftl";
        }
        ByteArrayOutputStream baos = null;
        OutputStream out = null;
        try {
            CreatePDFBO createPDFBo = PDFTemplateUtil.createPDF(data, filetemplateName);
            baos = createPDFBo.getByteArrayOutputStream();
            byte[] pdfBytes = baos.toByteArray();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(pdfBytes);
            UocFile uocFile = new UocFile();
            uocFile.setPath(this.instDataPath);
            uocFile.setInputStream(inputStream);
            if (dycProSscConsultDTO.getConsultType().equals(DycProSscConstants.ConsultType.CONSULT_TYPE_XJ)) {
                uocFile.setFilename(dycProSscConsultDTO.getPurchaseCompanyName() + "_" + dycProSscConsultDTO.getConsultName() + "\u8be2\u4ef7\u7ed3\u679c\u901a\u77e5.pdf");
            } else if (dycProSscConsultDTO.getConsultType().equals(DycProSscConstants.ConsultType.CONSULT_TYPE_JJ)) {
                uocFile.setFilename(dycProSscConsultDTO.getPurchaseCompanyName() + "_" + dycProSscConsultDTO.getConsultName() + "\u7ade\u4ef7\u7ed3\u679c\u901a\u77e5.pdf");
            }
            UocFile uocFile1 = this.uploadFile(uocFile);
            uocFile1.setModelInfo(createPDFBo.getModelInfo());
            baos.close();
            UocFile uocFile2 = uocFile1;
            return uocFile2;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ZTBusinessException("\u5bfc\u51fa\u5931\u8d25\uff1a" + e.getMessage());
        }
        finally {
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UocFile convertHtmlToPdfBytes(DycProSscBuildAndQueryConsultResultNoticeReqBO reqBO) {
        DycProSscConsultDTO dycProSscConsultDTO = new DycProSscConsultDTO();
        dycProSscConsultDTO.setConsultId(reqBO.getConsultId());
        dycProSscConsultDTO = this.dycProSscConsultRepository.queryConsultBaseInfo(dycProSscConsultDTO);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        String html = reqBO.getModelInfo();
        UocFile uocFile1 = new UocFile();
        try {
            ITextRenderer renderer = new ITextRenderer();
            renderer.getFontResolver().addFont("templates/font/simsun.ttc", "Identity-H", false);
            renderer.setDocumentFromString(html);
            renderer.layout();
            renderer.getSharedContext().getTextRenderer().setSmoothingThreshold(0.0f);
            renderer.createPDF((OutputStream)os, false);
            renderer.finishPDF();
            os.flush();
            byte[] pdfBytes = os.toByteArray();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(pdfBytes);
            UocFile uocFile = new UocFile();
            uocFile.setPath(this.instDataPath);
            uocFile.setInputStream(inputStream);
            if (dycProSscConsultDTO.getConsultType().equals(DycProSscConstants.ConsultType.CONSULT_TYPE_XJ)) {
                uocFile.setFilename(dycProSscConsultDTO.getPurchaseCompanyName() + "_" + dycProSscConsultDTO.getConsultName() + "\u8be2\u4ef7\u7ed3\u679c\u901a\u77e5.pdf");
            } else if (dycProSscConsultDTO.getConsultType().equals(DycProSscConstants.ConsultType.CONSULT_TYPE_JJ)) {
                uocFile.setFilename(dycProSscConsultDTO.getPurchaseCompanyName() + "_" + dycProSscConsultDTO.getConsultName() + "\u7ade\u4ef7\u7ed3\u679c\u901a\u77e5.pdf");
            }
            uocFile1 = this.uploadFile(uocFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                os.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return uocFile1;
    }

    private UocFile uploadFile(UocFile uocFile) {
        String fileUrl = this.fileClient.uploadFileByInputStream(uocFile.getPath() + "/" + UUID.randomUUID().toString().replace("-", ""), uocFile.getFilename(), uocFile.getInputStream());
        UocFile uocF = new UocFile();
        uocF.setUrl(fileUrl);
        uocF.setInputStream(uocFile.getInputStream());
        uocF.setFilename(uocFile.getFilename());
        return uocF;
    }

    private void paramCheck(DycProSscBuildAndQueryConsultResultNoticeReqBO reqBO) {
        if (reqBO.getConsultId() == null) {
            throw new ZTBusinessException("\u534f\u5546\u5355Id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getQuoteTurn() == null) {
            throw new ZTBusinessException("\u62a5\u4ef7\u8f6e\u6b21\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getSupplierId() == null) {
            throw new ZTBusinessException("\u4f9b\u5e94\u5546Id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getSupplierName())) {
            throw new ZTBusinessException("\u4f9b\u5e94\u5546Id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getIsChosen() == null) {
            throw new ZTBusinessException("\u662f\u5426\u88ab\u9009\u4e2d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getInvitedId() == null) {
            throw new ZTBusinessException("\u88ab\u9080\u8bf7Id\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

