/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.egc.service.saleorder.impl;

import com.alibaba.fastjson.JSONArray;
import com.alipay.sofa.sofamq.com.shade.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.pro.base.core.flow.repository.api.DycProPublicProcInstRepository;
import com.tydic.dyc.pro.base.core.flow.repository.api.DycProPublicTaskInstRepository;
import com.tydic.dyc.pro.base.core.flow.repository.dto.DycProPublicProcInstDTO;
import com.tydic.dyc.pro.base.core.flow.repository.dto.DycProPublicTaskInstDTO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtil;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilCancelReqBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilCancelRspBO;
import com.tydic.dyc.pro.egc.repository.approve.api.DycProOrderApproveRepository;
import com.tydic.dyc.pro.egc.repository.approve.dto.DycProOrderApprovalObjDTO;
import com.tydic.dyc.pro.egc.repository.order.api.DycProOrderOrderRepository;
import com.tydic.dyc.pro.egc.repository.order.dto.DycProOrderOrderAccessoryDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.api.DycProOrderSaleOrderRepository;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleOrderDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleOrderItemQryDTO;
import com.tydic.dyc.pro.egc.service.constants.DycProOrderApiServiceConstant;
import com.tydic.dyc.pro.egc.service.saleorder.api.DycProOrderCancelAllOrderService;
import com.tydic.dyc.pro.egc.service.saleorder.bo.DycProOrderAccessoryApiBO;
import com.tydic.dyc.pro.egc.service.saleorder.bo.DycProOrderCancelAllOrderReqBO;
import com.tydic.dyc.pro.egc.service.saleorder.bo.DycProOrderCancelAllOrderRspBO;
import com.tydic.dyc.pro.egc.service.saleorder.bo.DycProOrderSaleOrderItemApiBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"EGC_GROUP/4.0.0/com.tydic.dyc.pro.egc.service.saleorder.api.DycProOrderCancelAllOrderService"})
public class DycProOrderCancelAllOrderServiceImpl
implements DycProOrderCancelAllOrderService {
    @Value(value="${call.esb.url.cancel}")
    private String callEsbUrlCancel;
    @Autowired
    private Environment environment;
    @Autowired
    private DycProOrderSaleOrderRepository dycProOrderSaleOrderRepository;
    @Autowired
    private DycProOrderOrderRepository dycProOrderOrderRepository;
    @Autowired
    private DycProPublicTaskInstRepository dycProPublicTaskInstRepository;
    @Autowired
    private DycProPublicProcInstRepository dycProPublicProcInstRepository;
    @Autowired
    private DycProOrderApproveRepository dycProOrderApproveRepository;

    @PostMapping(value={"cancelAllOrder"})
    public DycProOrderCancelAllOrderRspBO cancelAllOrder(@RequestBody DycProOrderCancelAllOrderReqBO reqBO) {
        DycProOrderCancelAllOrderRspBO rspBO = new DycProOrderCancelAllOrderRspBO();
        DycProOrderSaleOrderDTO querySaleOrderDto = new DycProOrderSaleOrderDTO();
        querySaleOrderDto.setOrderId(reqBO.getOrderId());
        querySaleOrderDto.setSaleOrderState("XS_SP_SPZ");
        List saleOrderDTOList = this.dycProOrderSaleOrderRepository.querySaleOrderListByCondition(querySaleOrderDto);
        if (CollectionUtils.isEmpty((Collection)saleOrderDTOList)) {
            throw new ZTBusinessException("\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u5217\u8868\u4e3a\u7a7a\uff01");
        }
        ArrayList<String> procInstIdList = new ArrayList<String>();
        ArrayList saleOrderItemList = new ArrayList();
        for (DycProOrderSaleOrderDTO saleOrderDTO : saleOrderDTOList) {
            if ("XS_QX_QX".equals(saleOrderDTO.getSaleOrderState()) || "XS_XD_SB".equals(saleOrderDTO.getSaleOrderState())) continue;
            if (DycProOrderApiServiceConstant.OrderSource.E_ORDER.equals(saleOrderDTO.getOrderSource())) {
                DycProOrderSaleOrderDTO queryStakeholderDto = new DycProOrderSaleOrderDTO();
                queryStakeholderDto.setStakeholderId(saleOrderDTO.getStakeholderId());
                DycProOrderSaleOrderDTO saleOrderStakeholderDto = this.dycProOrderSaleOrderRepository.querySaleOrderStakeholderByCondition(queryStakeholderDto);
                if (null != saleOrderStakeholderDto) {
                    DycProBaseCallEsbUtilCancelReqBO callEsbReqBo = new DycProBaseCallEsbUtilCancelReqBO();
                    callEsbReqBo.setUrl(this.callEsbUrlCancel);
                    callEsbReqBo.setOrderId(saleOrderDTO.getSaleOrderNoExt());
                    String hsn = this.environment.getProperty("SUPPLIER_ID_" + saleOrderStakeholderDto.getSaleStakeholder().getSupId());
                    callEsbReqBo.setHsn(hsn);
                    DycProBaseCallEsbUtilCancelRspBO callEsbRspBo = DycProBaseCallEsbUtil.cancel((DycProBaseCallEsbUtilCancelReqBO)callEsbReqBo);
                    if (!callEsbRspBo.getSuccess().booleanValue() || !"0000".equals(callEsbRspBo.getResultCode())) {
                        throw new ZTBusinessException(callEsbRspBo.getResultMessage());
                    }
                } else {
                    throw new ZTBusinessException("\u8be5\u9500\u552e\u8ba2\u5355\u4e0d\u5b58\u5728\u4e09\u65b9\u4fe1\u606f");
                }
            }
            DycProOrderSaleOrderDTO updateSaleOrderDto = new DycProOrderSaleOrderDTO();
            updateSaleOrderDto.setSaleOrderState("XS_QX_QX");
            updateSaleOrderDto.setSaleOrderId(saleOrderDTO.getSaleOrderId());
            updateSaleOrderDto.setCancelReasonFlag(DycProOrderApiServiceConstant.CancelReasonFlag.USER_CANCEL);
            updateSaleOrderDto.setCancelTime(new Date());
            updateSaleOrderDto.setCancelOperId(String.valueOf(reqBO.getUserId()));
            updateSaleOrderDto.setCancelOperName(reqBO.getName());
            updateSaleOrderDto.setCancelReason(reqBO.getCancelReason());
            updateSaleOrderDto.setOrderStage(DycProOrderApiServiceConstant.ORDER_STAPE.TRADE_CLOSE);
            this.dycProOrderSaleOrderRepository.updateSaleOrderByCondition(updateSaleOrderDto, true);
            if (!CollectionUtils.isEmpty((Collection)reqBO.getCancelOrderFileList())) {
                ArrayList<DycProOrderOrderAccessoryDTO> cancelOrderFileList = new ArrayList<DycProOrderOrderAccessoryDTO>();
                for (DycProOrderAccessoryApiBO accessoryBO : reqBO.getCancelOrderFileList()) {
                    DycProOrderOrderAccessoryDTO addAccessoryDTO = new DycProOrderOrderAccessoryDTO();
                    BeanUtils.copyProperties((Object)accessoryBO, (Object)addAccessoryDTO);
                    addAccessoryDTO.setObjId(saleOrderDTO.getSaleOrderId());
                    addAccessoryDTO.setOrderId(saleOrderDTO.getSaleOrderId());
                    addAccessoryDTO.setObjType(DycProOrderApiServiceConstant.AccessoryObjType.SALE_ORDER_CANCEL);
                    cancelOrderFileList.add(addAccessoryDTO);
                }
                this.dycProOrderOrderRepository.addAllKindsAccessoryBatch(cancelOrderFileList);
            }
            DycProPublicTaskInstDTO taskInstDTO = new DycProPublicTaskInstDTO();
            taskInstDTO.setObjId(saleOrderDTO.getSaleOrderId());
            taskInstDTO.setObjType("salesOrder");
            taskInstDTO.setFinishTag(Integer.valueOf(0));
            List dycProPublicTaskInstDTOS = this.dycProPublicTaskInstRepository.queryFlowTaskList(taskInstDTO);
            if (CollectionUtils.isEmpty((Collection)dycProPublicTaskInstDTOS) || dycProPublicTaskInstDTOS.size() != 1) {
                throw new ZTBusinessException("\u67e5\u8be2\u6d41\u7a0b\u4efb\u52a1\u5b9e\u4f8b\u9519\u8bef!");
            }
            DycProPublicProcInstDTO cancelFlowProcInstDto = new DycProPublicProcInstDTO();
            cancelFlowProcInstDto.setProcInstId(((DycProPublicTaskInstDTO)dycProPublicTaskInstDTOS.get(0)).getProcInstId());
            this.dycProPublicProcInstRepository.cancelFlow(cancelFlowProcInstDto);
            procInstIdList.add(((DycProPublicTaskInstDTO)dycProPublicTaskInstDTOS.get(0)).getProcInstId());
            if (!DycProOrderApiServiceConstant.OrderSource.AGR_ORDER.equals(saleOrderDTO.getOrderSource())) continue;
            DycProOrderSaleOrderItemQryDTO querySaleOrderItemDto = new DycProOrderSaleOrderItemQryDTO();
            querySaleOrderItemDto.setSaleOrderId(saleOrderDTO.getSaleOrderId());
            List saleOrderItemDtoList = this.dycProOrderSaleOrderRepository.querySaleOrderItemListByCondition(querySaleOrderItemDto);
            if (CollectionUtils.isEmpty((Collection)saleOrderItemDtoList)) continue;
            List saleOrderItems = JSONArray.parseArray((String)JSON.toJSONString((Object)saleOrderItemDtoList)).toJavaList(DycProOrderSaleOrderItemApiBO.class);
            saleOrderItemList.addAll(saleOrderItems);
        }
        DycProOrderApprovalObjDTO dycProOrderApprovalObjDTO = new DycProOrderApprovalObjDTO();
        dycProOrderApprovalObjDTO.setObjId(((DycProOrderSaleOrderDTO)saleOrderDTOList.get(0)).getOrderId().toString());
        dycProOrderApprovalObjDTO.setObjType(DycProOrderApiServiceConstant.ObjType.ORDER);
        dycProOrderApprovalObjDTO.setObjBusiType(DycProOrderApiServiceConstant.OBJ_BUSI_TYPE.ORDER);
        DycProOrderApprovalObjDTO approvalObjDTO = this.dycProOrderApproveRepository.queryApprovalObjOneByCondition(dycProOrderApprovalObjDTO);
        if (null == approvalObjDTO) {
            throw new ZTBusinessException("\u67e5\u8be2\u5ba1\u6279\u5bf9\u8c61\u4e3a\u7a7a\uff01");
        }
        DycProPublicTaskInstDTO taskInstDTO = new DycProPublicTaskInstDTO();
        taskInstDTO.setObjId(approvalObjDTO.getAuditOrderId());
        taskInstDTO.setObjType("auditOrder");
        taskInstDTO.setFinishTag(Integer.valueOf(0));
        List dycProPublicTaskInstDTOS = this.dycProPublicTaskInstRepository.queryFlowTaskList(taskInstDTO);
        if (CollectionUtils.isEmpty((Collection)dycProPublicTaskInstDTOS)) {
            throw new ZTBusinessException("\u67e5\u8be2\u6d41\u7a0b\u4efb\u52a1\u5b9e\u4f8b\u9519\u8bef!");
        }
        DycProPublicProcInstDTO cancelFlowProcInstDto = new DycProPublicProcInstDTO();
        cancelFlowProcInstDto.setProcInstId(((DycProPublicTaskInstDTO)dycProPublicTaskInstDTOS.get(0)).getProcInstId());
        this.dycProPublicProcInstRepository.cancelFlow(cancelFlowProcInstDto);
        rspBO.setSaleOrderItemList(saleOrderItemList);
        rspBO.setProcInstIdList(procInstIdList);
        rspBO.setAuditProcInstId(((DycProPublicTaskInstDTO)dycProPublicTaskInstDTOS.get(0)).getProcInstId());
        return rspBO;
    }
}

