/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.egc.service.aforder.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.bo.RspPage;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.pro.base.core.dictionary.utils.DictionaryFrameworkUtils;
import com.tydic.dyc.pro.egc.constant.DycProOrderManageServiceConstant;
import com.tydic.dyc.pro.egc.repository.aforder.api.DycProOrderAfOrderRepository;
import com.tydic.dyc.pro.egc.repository.aforder.dto.DycProOrderAfOrderQryDTO;
import com.tydic.dyc.pro.egc.service.aforder.api.DycProOrderQryAfOrderListPageForPurchaseService;
import com.tydic.dyc.pro.egc.service.aforder.bo.DycProOrderAfOrderEsBO;
import com.tydic.dyc.pro.egc.service.aforder.bo.DycProOrderQryAfOrderListPageForPurchaseReqBO;
import com.tydic.dyc.pro.egc.service.aforder.bo.DycProOrderQryAfOrderListPageForPurchaseRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"EGC_GROUP/4.0.0/com.tydic.dyc.pro.egc.service.aforder.api.DycProOrderQryAfOrderListPageForPurchaseService"})
public class DycProOrderQryAfOrderListPageForPurchaseServiceImpl
implements DycProOrderQryAfOrderListPageForPurchaseService {
    @Autowired
    private DycProOrderAfOrderRepository dycProOrderAfOrderRepository;

    @Override
    @PostMapping(value={"qryAfOrderListPageForPurchase"})
    public DycProOrderQryAfOrderListPageForPurchaseRspBO qryAfOrderListPageForPurchase(@RequestBody DycProOrderQryAfOrderListPageForPurchaseReqBO reqBO) {
        this.paramVerify(reqBO);
        DycProOrderAfOrderQryDTO qryDTO = (DycProOrderAfOrderQryDTO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), DycProOrderAfOrderQryDTO.class);
        qryDTO.setPickwareTypeList(this.getTabPickwareType(reqBO.getTabId()));
        RspPage rspPage = this.dycProOrderAfOrderRepository.queryAfOrderEsPageListByCondition(qryDTO);
        DycProOrderQryAfOrderListPageForPurchaseRspBO rspBO = (DycProOrderQryAfOrderListPageForPurchaseRspBO)((Object)JSON.parseObject((String)JSON.toJSONString((Object)rspPage), DycProOrderQryAfOrderListPageForPurchaseRspBO.class));
        this.buildRspData(rspBO);
        this.translationRspData(rspBO);
        return rspBO;
    }

    private void paramVerify(DycProOrderQryAfOrderListPageForPurchaseReqBO reqBO) {
        if (null == reqBO) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getPageNo() < 1) {
            throw new ZTBusinessException("\u9875\u7801\u4e0d\u80fd\u5c0f\u4e8e1");
        }
        if (reqBO.getPageSize() < 1) {
            throw new ZTBusinessException("\u6bcf\u9875\u8bb0\u5f55\u6570\u4e0d\u80fd\u5c0f\u4e8e1");
        }
        if (null == reqBO.getTabId()) {
            throw new ZTBusinessException("\u9875\u7b7eID\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private List<Integer> getTabPickwareType(String tabId) {
        ArrayList<Integer> pickwareTypeList = new ArrayList<Integer>(1);
        if ("1001".equals(tabId)) {
            pickwareTypeList.add(DycProOrderManageServiceConstant.PickWareType.UP_DOOR_PICK);
            pickwareTypeList.add(DycProOrderManageServiceConstant.AfterOrderPickWareType.UP_DOOR_PICK);
        } else if ("1002".equals(tabId)) {
            pickwareTypeList.add(DycProOrderManageServiceConstant.PickWareType.CUSTOM_SHIP);
            pickwareTypeList.add(DycProOrderManageServiceConstant.AfterOrderPickWareType.CUSTOM_SHIP);
        } else {
            throw new ZTBusinessException("\u9519\u8bef\u7684\u9875\u7b7eid,\u65e0\u6cd5\u8bc6\u522b");
        }
        return pickwareTypeList;
    }

    private void buildRspData(DycProOrderQryAfOrderListPageForPurchaseRspBO rspBO) {
        if (!CollectionUtils.isEmpty((Collection)rspBO.getRows())) {
            for (DycProOrderAfOrderEsBO row : rspBO.getRows()) {
                row.setPurCompanyName(row.getSaleStakeholder().getPurCompanyName());
                row.setSupName(row.getSaleStakeholder().getSupName());
            }
        }
    }

    private void translationRspData(DycProOrderQryAfOrderListPageForPurchaseRspBO rspBO) {
        if (!CollectionUtils.isEmpty((Collection)rspBO.getRows())) {
            for (DycProOrderAfOrderEsBO row : rspBO.getRows()) {
                if (null != row.getServState()) {
                    row.setServStateStr(DictionaryFrameworkUtils.getDicDataByCode((String)"EgcAfOrderServState", (String)String.valueOf(row.getServState())));
                }
                if (null != row.getServType()) {
                    row.setServTypeStr(DictionaryFrameworkUtils.getDicDataByCode((String)"EgcAfOrderServType", (String)String.valueOf(row.getServType())));
                }
                if (null != row.getPickwareType()) {
                    row.setPickwareTypeStr(DictionaryFrameworkUtils.getDicDataByCode((String)"EgcAfOrderPickwareType", (String)String.valueOf(row.getPickwareType())));
                }
                if (null == row.getWaybillFlag()) continue;
                row.setWaybillFlagStr(DictionaryFrameworkUtils.getDicDataByCode((String)"EgcAfOrderWaybillFlag", (String)String.valueOf(row.getWaybillFlag())));
            }
        }
    }
}

