/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.egc.service.aforder.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.pro.base.core.dictionary.utils.DictionaryFrameworkUtils;
import com.tydic.dyc.pro.egc.repository.aforder.api.DycProOrderAfOrderRepository;
import com.tydic.dyc.pro.egc.repository.aforder.dto.DycProOrderAfOrderDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleOrderItemDTO;
import com.tydic.dyc.pro.egc.repository.shiporder.dto.DycProOrderShipOrderItemDTO;
import com.tydic.dyc.pro.egc.service.aforder.api.DycProOrderQueryAfOrderDetailService;
import com.tydic.dyc.pro.egc.service.aforder.bo.DycProOrderAfOrderItemBO;
import com.tydic.dyc.pro.egc.service.aforder.bo.DycProOrderAfOrderObjBO;
import com.tydic.dyc.pro.egc.service.aforder.bo.DycProOrderQueryAfOrderDetailServiceReqBO;
import com.tydic.dyc.pro.egc.service.aforder.bo.DycProOrderQueryAfOrderDetailServiceRspBO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"EGC_GROUP/4.0.0/com.tydic.dyc.pro.egc.service.aforder.api.DycProOrderQueryAfOrderDetailService"})
public class DycProOrderQueryAfOrderDetailServiceImpl
implements DycProOrderQueryAfOrderDetailService {
    @Autowired
    private DycProOrderAfOrderRepository dycProOrderAfOrderRepository;

    @Override
    @PostMapping(value={"queryAfOrderDetail"})
    public DycProOrderQueryAfOrderDetailServiceRspBO queryAfOrderDetail(@RequestBody DycProOrderQueryAfOrderDetailServiceReqBO reqBO) {
        this.paramVerify(reqBO);
        DycProOrderAfOrderDTO reqDto = new DycProOrderAfOrderDTO();
        reqDto.setAfOrderId(reqBO.getAfOrderId());
        DycProOrderAfOrderDTO afOrderDto = this.dycProOrderAfOrderRepository.queryAfOrderAllInfoById(reqDto);
        DycProOrderQueryAfOrderDetailServiceRspBO rspBO = new DycProOrderQueryAfOrderDetailServiceRspBO();
        if (null != afOrderDto) {
            rspBO = (DycProOrderQueryAfOrderDetailServiceRspBO)((Object)JSON.parseObject((String)JSON.toJSONString((Object)afOrderDto), DycProOrderQueryAfOrderDetailServiceRspBO.class));
            rspBO.setAfOrderObj((DycProOrderAfOrderObjBO)JSON.parseObject((String)JSON.toJSONString(afOrderDto.getAfOrderObjList().get(0)), DycProOrderAfOrderObjBO.class));
            rspBO.setOrderSource(afOrderDto.getOrderSource());
            Map<Long, DycProOrderShipOrderItemDTO> shipOrderItemMap = afOrderDto.getShipItemList().stream().collect(Collectors.toMap(DycProOrderShipOrderItemDTO::getShipOrderItemId, item -> item));
            Map<Long, DycProOrderSaleOrderItemDTO> saleOrderItemMap = afOrderDto.getSaleItemList().stream().collect(Collectors.toMap(DycProOrderSaleOrderItemDTO::getSaleOrderItemId, item -> item));
            for (DycProOrderAfOrderItemBO dycProOrderAfOrderItemBO : rspBO.getAfItemList()) {
                DycProOrderShipOrderItemDTO shipOrderItemDTO = shipOrderItemMap.get(dycProOrderAfOrderItemBO.getShipItemId());
                DycProOrderSaleOrderItemDTO saleOrderItemDTO = saleOrderItemMap.get(dycProOrderAfOrderItemBO.getSaleOrderItemId());
                BigDecimal sendCount = null == shipOrderItemDTO.getSendCount() ? BigDecimal.ZERO : shipOrderItemDTO.getSendCount();
                BigDecimal shipReturnCount = null == shipOrderItemDTO.getReturnCount() ? BigDecimal.ZERO : shipOrderItemDTO.getReturnCount();
                BigDecimal afterServingCount = null == shipOrderItemDTO.getAfterServingCount() ? BigDecimal.ZERO : shipOrderItemDTO.getAfterServingCount();
                dycProOrderAfOrderItemBO.setSendCount(sendCount);
                dycProOrderAfOrderItemBO.setShipReturnCount(shipReturnCount);
                dycProOrderAfOrderItemBO.setAfterServingCount(afterServingCount);
                dycProOrderAfOrderItemBO.setAvailableAfServCount(sendCount.subtract(shipReturnCount).subtract(afterServingCount));
                this.buildAfOrderItemNumValue(dycProOrderAfOrderItemBO, saleOrderItemDTO.getUnitDigit());
            }
            rspBO.setServTypeStr(DictionaryFrameworkUtils.getDicDataByCode((String)"EgcAfOrderServType", (String)rspBO.getServType().toString()));
            rspBO.setServStateStr(DictionaryFrameworkUtils.getDicDataByCode((String)"EgcAfOrderServState", (String)rspBO.getServState().toString()));
            rspBO.setAfsReasonStr(DictionaryFrameworkUtils.getDicDataByCode((String)"EgcAfOrderAfsReason", (String)rspBO.getAfsReason().toString()));
            rspBO.setPickwareTypeStr(DictionaryFrameworkUtils.getDicDataByCode((String)"EgcAfOrderPickwareType", (String)rspBO.getPickwareType().toString()));
            rspBO.getShipOrderMessage().setShipOrderStateStr(DictionaryFrameworkUtils.getDicDataByCode((String)"EgcShipOrderShipOrderState", (String)rspBO.getShipOrderMessage().getShipOrderState()));
        }
        return rspBO;
    }

    private void buildAfOrderItemNumValue(DycProOrderAfOrderItemBO afOrderItemBO, String unitDigit) {
        if (StringUtils.isNotBlank((CharSequence)unitDigit)) {
            if (null != afOrderItemBO.getReturnCount()) {
                afOrderItemBO.setReturnCount(afOrderItemBO.getReturnCount().setScale(Integer.parseInt(unitDigit), RoundingMode.DOWN));
            }
            if (null != afOrderItemBO.getSendCount()) {
                afOrderItemBO.setSendCount(afOrderItemBO.getSendCount().setScale(Integer.parseInt(unitDigit), RoundingMode.DOWN));
            }
            if (null != afOrderItemBO.getShipReturnCount()) {
                afOrderItemBO.setShipReturnCount(afOrderItemBO.getShipReturnCount().setScale(Integer.parseInt(unitDigit), RoundingMode.DOWN));
            }
            if (null != afOrderItemBO.getAfterServingCount()) {
                afOrderItemBO.setAfterServingCount(afOrderItemBO.getAfterServingCount().setScale(Integer.parseInt(unitDigit), RoundingMode.DOWN));
            }
            if (null != afOrderItemBO.getAvailableAfServCount()) {
                afOrderItemBO.setAvailableAfServCount(afOrderItemBO.getAvailableAfServCount().setScale(Integer.parseInt(unitDigit), RoundingMode.DOWN));
            }
        }
    }

    private void paramVerify(DycProOrderQueryAfOrderDetailServiceReqBO reqBO) {
        if (null == reqBO) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getAfOrderId()) {
            throw new ZTBusinessException("\u552e\u540e\u670d\u52a1\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

