/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.pro.egc.service.chngorder.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtil;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilCancelSendOrderConfirmReqBO;
import com.tydic.dyc.pro.base.utils.esb.DycProBaseCallEsbUtilCancelSendOrderConfirmRspBO;
import com.tydic.dyc.pro.egc.constant.DycProOrderManageServiceConstant;
import com.tydic.dyc.pro.egc.repository.chngorder.api.DycProOrderChngOrderRepository;
import com.tydic.dyc.pro.egc.repository.chngorder.dto.DycProOrderChngOrderDTO;
import com.tydic.dyc.pro.egc.repository.chngorder.dto.DycProOrderChngOrderObjDTO;
import com.tydic.dyc.pro.egc.repository.order.dto.DycProOrderOrderAccessoryDTO;
import com.tydic.dyc.pro.egc.repository.saleorder.api.DycProOrderSaleOrderRepository;
import com.tydic.dyc.pro.egc.repository.saleorder.dto.DycProOrderSaleOrderDTO;
import com.tydic.dyc.pro.egc.service.chngorder.api.DycProOrderApplyCancelSaleOrderService;
import com.tydic.dyc.pro.egc.service.chngorder.bo.DycProOrderApplyCancelSaleOrderReqBO;
import com.tydic.dyc.pro.egc.service.chngorder.bo.DycProOrderApplyCancelSaleOrderRspBO;
import com.tydic.dyc.pro.egc.service.order.bo.DycProOrderOrderAccessoryBO;
import java.util.ArrayList;
import java.util.Date;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"EGC_GROUP/4.0.0/com.tydic.dyc.pro.egc.service.chngorder.api.DycProOrderApplyCancelSaleOrderService"})
public class DycProOrderApplyCancelSaleOrderServiceImpl
implements DycProOrderApplyCancelSaleOrderService {
    @Value(value="${call.esb.url.cancelSendOrderConfirm}")
    private String callEsbUrlCancelSendOrderConfirm;
    @Autowired
    private Environment environment;
    @Autowired
    private DycProOrderSaleOrderRepository dycProOrderSaleOrderRepository;
    @Autowired
    private DycProOrderChngOrderRepository dycProOrderChngOrderRepository;

    @Override
    @PostMapping(value={"applyCancelSaleOrder"})
    public DycProOrderApplyCancelSaleOrderRspBO applyCancelSaleOrder(@RequestBody DycProOrderApplyCancelSaleOrderReqBO reqBO) {
        this.paramVerify(reqBO);
        if (DycProOrderManageServiceConstant.OrderSource.E_ORDER.equals(reqBO.getOrderSource())) {
            DycProBaseCallEsbUtilCancelSendOrderConfirmReqBO callEsbReqBo = new DycProBaseCallEsbUtilCancelSendOrderConfirmReqBO();
            callEsbReqBo.setUrl(this.callEsbUrlCancelSendOrderConfirm);
            callEsbReqBo.setOrderId(reqBO.getSaleOrderNoExt());
            callEsbReqBo.setCancelFlag(Integer.valueOf(0));
            String hsn = this.environment.getProperty("SUPPLIER_ID_" + reqBO.getSupId());
            callEsbReqBo.setHsn(hsn);
            DycProBaseCallEsbUtilCancelSendOrderConfirmRspBO callEsbRspBo = DycProBaseCallEsbUtil.cancelSendOrderConfirm((DycProBaseCallEsbUtilCancelSendOrderConfirmReqBO)callEsbReqBo);
            if (!callEsbRspBo.getSuccess().booleanValue() || !"0000".equals(callEsbRspBo.getResultCode())) {
                throw new ZTBusinessException(callEsbRspBo.getResultMessage());
            }
        }
        DycProOrderChngOrderDTO addChngOrderDto = new DycProOrderChngOrderDTO();
        addChngOrderDto.setCancelReason(reqBO.getCancelReason());
        addChngOrderDto.setOrderId(reqBO.getOrderId());
        addChngOrderDto.setSaleOrderId(reqBO.getSaleOrderId());
        addChngOrderDto.setCreateOperId(String.valueOf(reqBO.getUserId()));
        addChngOrderDto.setCreateOperName(reqBO.getName());
        addChngOrderDto.setBusiType(DycProOrderManageServiceConstant.ChngOrderBusiType.APPLY_CANCEL);
        addChngOrderDto.setChngOrderState("CHNG_XS_QXSQZ");
        ArrayList<DycProOrderChngOrderObjDTO> uocChngOrderObjList = new ArrayList<DycProOrderChngOrderObjDTO>();
        DycProOrderChngOrderObjDTO chngOrderObjDto = new DycProOrderChngOrderObjDTO();
        chngOrderObjDto.setOrderId(reqBO.getOrderId());
        chngOrderObjDto.setSaleOrderId(reqBO.getSaleOrderId());
        uocChngOrderObjList.add(chngOrderObjDto);
        addChngOrderDto.setUocChngOrderObjList(uocChngOrderObjList);
        if (!CollectionUtils.isEmpty(reqBO.getChngOrderAccessoryList())) {
            ArrayList<DycProOrderOrderAccessoryDTO> chngOrderAccessoryList = new ArrayList<DycProOrderOrderAccessoryDTO>();
            for (DycProOrderOrderAccessoryBO accessoryBO : reqBO.getChngOrderAccessoryList()) {
                DycProOrderOrderAccessoryDTO chngOrderAccessoryDto = new DycProOrderOrderAccessoryDTO();
                BeanUtils.copyProperties((Object)accessoryBO, (Object)chngOrderAccessoryDto);
                chngOrderAccessoryDto.setObjType(DycProOrderManageServiceConstant.OrderAccessoryObjType.APPLY_CANCEL_FILE);
                chngOrderAccessoryList.add(chngOrderAccessoryDto);
            }
            addChngOrderDto.setChngOrderAccessoryList(chngOrderAccessoryList);
        }
        DycProOrderChngOrderDTO dycProOrderChngOrderDTO = this.dycProOrderChngOrderRepository.createChngOrderAllInfoAndSyncNosql(addChngOrderDto);
        DycProOrderSaleOrderDTO updateSaleOrderDto = new DycProOrderSaleOrderDTO();
        updateSaleOrderDto.setSaleOrderId(reqBO.getSaleOrderId());
        updateSaleOrderDto.setSaleOrderState("XS_QX_QXSQ");
        updateSaleOrderDto.setCancelApplyId(dycProOrderChngOrderDTO.getChngOrderId());
        updateSaleOrderDto.setRejectReason(reqBO.getCancelReason());
        updateSaleOrderDto.setRejectOperId(String.valueOf(reqBO.getUserId()));
        updateSaleOrderDto.setRejectOperName(reqBO.getName());
        updateSaleOrderDto.setRejectTime(new Date());
        this.dycProOrderSaleOrderRepository.updateSaleOrderByCondition(updateSaleOrderDto, true);
        return new DycProOrderApplyCancelSaleOrderRspBO();
    }

    private void paramVerify(DycProOrderApplyCancelSaleOrderReqBO reqBO) {
        if (null == reqBO) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getSaleOrderId()) {
            throw new ZTBusinessException("\u9500\u552e\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getOrderSource()) {
            throw new ZTBusinessException("\u8ba2\u5355\u6765\u6e90\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

