/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.serializer.ValueFilter;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.cfc.ability.api.CfcUniteParamQryListDetailAbilityService;
import com.tydic.cfc.ability.bo.CfcUniteParamQryListDetailAbilityReqBO;
import com.tydic.cfc.ability.bo.CfcUniteParamQryListDetailAbilityRspBO;
import com.tydic.fsc.bill.ability.bo.checkApplyWrap.FscCfcUniteParamQryListDetailRspBO;
import com.tydic.fsc.bill.ability.bo.checkApplyWrap.FscUocAcceptOrderInfoBO;
import com.tydic.fsc.bill.ability.bo.checkApplyWrap.FscUocQryAcceptOrderListReqBO;
import com.tydic.fsc.bill.ability.bo.checkApplyWrap.FscUocQryAcceptOrderListRspBO;
import com.tydic.fsc.bill.ability.bo.checkApplyWrap.PebExtOrderListQryForFscReqBO;
import com.tydic.fsc.bill.busi.api.FscBillEcomCheckApplyBusiService;
import com.tydic.fsc.bill.busi.api.FscBillEcomCheckApplyWrapBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillEcomCheckApplyBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillEcomCheckApplyBusiRspBO;
import com.tydic.fsc.bill.busi.bo.checkApplyWrap.FscBillEcomCheckApplyWrapBusiReqBO;
import com.tydic.fsc.bill.busi.bo.checkApplyWrap.FscBillEcomCheckApplyWrapBusiRspBO;
import com.tydic.fsc.bo.RelOrderBO;
import com.tydic.fsc.busibase.atom.api.FscGeneralQueryAtomService;
import com.tydic.fsc.busibase.atom.bo.FscGeneralQueryAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscGeneralQueryAtomRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.exception.FscBusinessException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscBillEcomCheckApplyWrapBusiServiceImpl
implements FscBillEcomCheckApplyWrapBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscBillEcomCheckApplyWrapBusiServiceImpl.class);
    private static final Integer ALLOW_UP_NOT_SIGN_DOWN_LAUNCH = 1;
    public static final String OPERATE = "0";
    @Value(value="${qry.pageSize:1000}")
    private Integer pageSize;
    @Autowired
    private FscBillEcomCheckApplyBusiService fscBillEcomCheckApplyBusiService;
    @Autowired
    private CfcUniteParamQryListDetailAbilityService cfcUniteParamQryListDetailAbilityService;
    @Autowired
    private FscGeneralQueryAtomService fscGeneralQueryAtomService;
    ValueFilter propertyFilter = (object, name, value) -> {
        if (value != null && value.getClass().equals(String.class) && "".equals(value)) {
            value = null;
        }
        return value;
    };

    @Override
    public FscBillEcomCheckApplyWrapBusiRspBO dealEcomCheckApplyWrap(FscBillEcomCheckApplyWrapBusiReqBO reqBO) {
        FscBillEcomCheckApplyWrapBusiRspBO rspBO = new FscBillEcomCheckApplyWrapBusiRspBO();
        Long operSn = Sequence.getInstance().nextId();
        reqBO.setOperSn(operSn);
        if (FscConstants.NumType.total.equals(reqBO.getNumType())) {
            int total;
            FscUocQryAcceptOrderListReqBO qryBO = this.convertData(reqBO.getQryBO());
            if (ObjectUtil.isNull((Object)qryBO)) {
                throw new FscBusinessException("191000", "\u8ba2\u5355\u9a8c\u6536\u5355\u67e5\u8be2\u6761\u4ef6\u4e3a\u7a7a");
            }
            int pageNo = 1;
            do {
                qryBO.setPageNo(Integer.valueOf(pageNo));
                qryBO.setPageSize(this.pageSize);
                FscUocQryAcceptOrderListRspBO qryInfoRsp = this.qry(qryBO);
                if (ObjectUtil.isNull((Object)qryInfoRsp) || CollectionUtil.isEmpty((Collection)qryInfoRsp.getRows())) {
                    rspBO.setRespCode("0000");
                    rspBO.setRespDesc("\u6210\u529f");
                    return rspBO;
                }
                Map<String, List<FscUocAcceptOrderInfoBO>> suppIdBoMap = qryInfoRsp.getRows().stream().collect(Collectors.groupingBy(FscUocAcceptOrderInfoBO::getSupplierId));
                suppIdBoMap.forEach((supplierId, fscUocAcceptOrderInfoList) -> {
                    FscBillEcomCheckApplyBusiReqBO checkApplyBusiReqBO = new FscBillEcomCheckApplyBusiReqBO();
                    checkApplyBusiReqBO.setCheckEqualsFlag(reqBO.getCheckEqualsFlag());
                    checkApplyBusiReqBO.setSupplierId(Long.valueOf(supplierId));
                    List<RelOrderBO> relOrderList = fscUocAcceptOrderInfoList.stream().map(e -> {
                        RelOrderBO relOrderBO = new RelOrderBO();
                        relOrderBO.setAcceptOrderId(e.getAcceptOrderId());
                        relOrderBO.setMyAmount(e.getInspTotalSalefee());
                        relOrderBO.setOtherNo(e.getSaleOrderNoExt());
                        relOrderBO.setOrderId(e.getOrderId());
                        relOrderBO.setSaleAmount(e.getInspTotalSalefee());
                        relOrderBO.setSupId(Convert.toLong((Object)e.getSupplierId()));
                        relOrderBO.setSupName(e.getSupplierName());
                        return relOrderBO;
                    }).collect(Collectors.toList());
                    checkApplyBusiReqBO.setRelOrderList(relOrderList);
                    this.fscBillEcomCheckApplyBusiService.dealEcomCheckApply(checkApplyBusiReqBO);
                });
                total = qryInfoRsp.getTotal();
                log.info("\u5168\u91cf\u5bf9\u8d26\u7533\u8bf7mq\u53d1\u9001\u8005\u6d41\u6c34\u53f7={}, \u603b\u9875\u6570={}, \u5f53\u524d\u9875\u6570\u4e3a={}", new Object[]{operSn, total, pageNo});
            } while (total > 1 && ++pageNo <= total);
            rspBO.setOperSn(operSn);
        } else {
            if (reqBO.getRelOrderList().stream().anyMatch(e -> null == e.getSupId())) {
                FscUocQryAcceptOrderListReqBO fscUocQryAcceptOrderListReqBO = new FscUocQryAcceptOrderListReqBO();
                fscUocQryAcceptOrderListReqBO.setInspOrderIdList(reqBO.getRelOrderList().stream().map(RelOrderBO::getAcceptOrderId).collect(Collectors.toList()));
                FscUocQryAcceptOrderListRspBO fscUocQryAcceptOrderListRspBO = this.qry(fscUocQryAcceptOrderListReqBO);
                if (!CollectionUtils.isEmpty((Collection)fscUocQryAcceptOrderListRspBO.getRows())) {
                    Map acceptOrderInfoBOMap = fscUocQryAcceptOrderListRspBO.getRows().stream().collect(Collectors.toMap(FscUocAcceptOrderInfoBO::getAcceptOrderId, Function.identity()));
                    reqBO.getRelOrderList().forEach(e -> e.setSupId(Convert.toLong((Object)((FscUocAcceptOrderInfoBO)acceptOrderInfoBOMap.get(e.getAcceptOrderId())).getSupplierId())));
                }
            }
            FscBillEcomCheckApplyBusiRspBO checkApplyBusiRspBO = this.fscBillEcomCheckApplyBusiService.dealEcomCheckApply((FscBillEcomCheckApplyBusiReqBO)((Object)JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), FscBillEcomCheckApplyBusiReqBO.class)));
            rspBO.setSendMqOrderIds(checkApplyBusiRspBO.getSendMqOrderIds());
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private FscUocQryAcceptOrderListReqBO convertData(PebExtOrderListQryForFscReqBO reqBO) {
        FscCfcUniteParamQryListDetailRspBO dycFscCfcUniteParamQryListDetailRspBO;
        FscUocQryAcceptOrderListReqBO uocInspectionDetailsListPageQueryReqBO = (FscUocQryAcceptOrderListReqBO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO, (SerializeFilter)this.propertyFilter, (SerializerFeature[])new SerializerFeature[0]), FscUocQryAcceptOrderListReqBO.class);
        this.createBoundVerifyParam(uocInspectionDetailsListPageQueryReqBO, reqBO);
        if (null != reqBO.getInspSaleFeeBegin()) {
            uocInspectionDetailsListPageQueryReqBO.setTotalSaleFeeLongBegin(reqBO.getInspSaleFeeBegin().multiply(new BigDecimal(10000)));
        }
        if (null != reqBO.getInspSaleFeeEnd()) {
            uocInspectionDetailsListPageQueryReqBO.setTotalSaleFeeLongEnd(reqBO.getInspSaleFeeEnd().multiply(new BigDecimal(10000)));
        }
        uocInspectionDetailsListPageQueryReqBO.setSupNo(reqBO.getSupNo());
        uocInspectionDetailsListPageQueryReqBO.setSupName(reqBO.getSupNameWeb());
        uocInspectionDetailsListPageQueryReqBO.setCompanyId(reqBO.getCompanyId());
        uocInspectionDetailsListPageQueryReqBO.setSaleOrderNoExt(reqBO.getOutOrderNo());
        uocInspectionDetailsListPageQueryReqBO.setSaleOrderId(Convert.toStr((Object)reqBO.getSaleVoucherId()));
        uocInspectionDetailsListPageQueryReqBO.setSaleOrderNo(Optional.ofNullable(reqBO.getSaleOrderNo()).orElse(Optional.ofNullable(reqBO.getSaleVoucherNo()).orElse(reqBO.getPurchaseVoucherNo())));
        uocInspectionDetailsListPageQueryReqBO.setInspOrderId(reqBO.getInspectionVoucherId());
        uocInspectionDetailsListPageQueryReqBO.setInspOrderNo(reqBO.getInspectionVoucherCode());
        uocInspectionDetailsListPageQueryReqBO.setInspOrderIdList(reqBO.getInspectionVoucherIdList());
        uocInspectionDetailsListPageQueryReqBO.setInspOrderNoList(reqBO.getInspectionVoucherCodeList());
        uocInspectionDetailsListPageQueryReqBO.setOrderCreateUserType(Convert.toInt((Object)reqBO.getUserType()));
        uocInspectionDetailsListPageQueryReqBO.setOrderCreateOperName(reqBO.getPurPlaceOrderName());
        if (FscConstants.FscRelType.TRADE_INVOICE.equals(reqBO.getRelType())) {
            dycFscCfcUniteParamQryListDetailRspBO = this.queryConfig(reqBO, "individual_settle");
            if (!StringUtils.isBlank((CharSequence)dycFscCfcUniteParamQryListDetailRspBO.getAllowSettle())) {
                List<String> allowAssemble = this.isAllowAssemble(ALLOW_UP_NOT_SIGN_DOWN_LAUNCH.equals(Integer.parseInt(dycFscCfcUniteParamQryListDetailRspBO.getAllowSettle())));
                uocInspectionDetailsListPageQueryReqBO.setRelInfo(allowAssemble);
            } else {
                throw new ZTBusinessException("\u67e5\u8be2\u914d\u7f6e\u4e2d\u5fc3[allowSettle]\u8fd4\u56de\u4e3a\u7a7a");
            }
        }
        if (StringUtils.isBlank((CharSequence)(dycFscCfcUniteParamQryListDetailRspBO = this.queryConfig(reqBO, "bill_auth")).getSettleReq())) {
            throw new ZTBusinessException("\u67e5\u8be2\u914d\u7f6e\u4e2d\u5fc3[settleReq]\u8fd4\u56de\u4e3a\u7a7a");
        }
        if ("1".equals(reqBO.getIsProfessionalOrgExt()) && !OPERATE.equals(dycFscCfcUniteParamQryListDetailRspBO.getSettleReq())) {
            if (null == reqBO.getUserId()) {
                return null;
            }
            uocInspectionDetailsListPageQueryReqBO.setCreateOperId(reqBO.getUserId().toString());
        }
        if (null != reqBO.getRelState() && null != reqBO.getRelType()) {
            ArrayList<String> relInfo = new ArrayList<String>(1);
            relInfo.add(reqBO.getRelState() + "," + reqBO.getRelType());
            if (!CollectionUtils.isEmpty((Collection)uocInspectionDetailsListPageQueryReqBO.getRelInfo())) {
                uocInspectionDetailsListPageQueryReqBO.getRelInfo().addAll(relInfo);
            } else {
                uocInspectionDetailsListPageQueryReqBO.setRelInfo(relInfo);
            }
        }
        if (null != reqBO.getPurAccount() && !"".equals(reqBO.getPurAccount())) {
            uocInspectionDetailsListPageQueryReqBO.setPurAccountList(Collections.singletonList(reqBO.getPurAccount()));
        }
        return uocInspectionDetailsListPageQueryReqBO;
    }

    private void createBoundVerifyParam(FscUocQryAcceptOrderListReqBO uocInspectionDetailsListPageQueryReqBO, PebExtOrderListQryForFscReqBO reqBO) {
        if (OPERATE.equals(reqBO.getIsprofess())) {
            if (null != reqBO.getPayAccountDay()) {
                uocInspectionDetailsListPageQueryReqBO.setProPayAccountDay(reqBO.getPayAccountDay());
            }
            if (null != reqBO.getPayAccountDayRule()) {
                uocInspectionDetailsListPageQueryReqBO.setProPayAccountDayRule(reqBO.getPayAccountDayRule());
            }
            if (null != reqBO.getPayNodeAccountDay()) {
                uocInspectionDetailsListPageQueryReqBO.setProPaymentDays(reqBO.getPayNodeAccountDay());
            }
            if (null != reqBO.getPayNodeRule()) {
                uocInspectionDetailsListPageQueryReqBO.setProPayNodeRule(reqBO.getPayNodeRule());
            }
            if (null != reqBO.getPayRule()) {
                uocInspectionDetailsListPageQueryReqBO.setProPayRule(reqBO.getPayRule());
            }
        } else {
            if (null != reqBO.getPayAccountDay()) {
                uocInspectionDetailsListPageQueryReqBO.setPayAccountDay(reqBO.getPayAccountDay());
            }
            if (null != reqBO.getPayAccountDayRule()) {
                uocInspectionDetailsListPageQueryReqBO.setPayAccountDayRule(reqBO.getPayAccountDayRule());
            }
            if (null != reqBO.getPayNodeAccountDay()) {
                uocInspectionDetailsListPageQueryReqBO.setPaymentDays(reqBO.getPayNodeAccountDay());
            }
            if (null != reqBO.getPayNodeRule()) {
                uocInspectionDetailsListPageQueryReqBO.setPayNodeRule(reqBO.getPayNodeRule());
            }
            if (null != reqBO.getPayRule()) {
                uocInspectionDetailsListPageQueryReqBO.setPayRule(reqBO.getPayRule());
            }
        }
    }

    private FscCfcUniteParamQryListDetailRspBO queryConfig(PebExtOrderListQryForFscReqBO reqBO, String cfcParamCodes) {
        CfcUniteParamQryListDetailAbilityReqBO cfcUniteParamQryListDetailAbilityReqBO = new CfcUniteParamQryListDetailAbilityReqBO();
        cfcUniteParamQryListDetailAbilityReqBO.setParamCode(cfcParamCodes);
        cfcUniteParamQryListDetailAbilityReqBO.setRelId(String.valueOf(reqBO.getCompanyId()));
        cfcUniteParamQryListDetailAbilityReqBO.setCenter("FSC");
        CfcUniteParamQryListDetailAbilityRspBO cfcUniteParamQryListDetailAbilityRspBO = this.cfcUniteParamQryListDetailAbilityService.qryListDetail(cfcUniteParamQryListDetailAbilityReqBO);
        if (null == cfcUniteParamQryListDetailAbilityRspBO || null == cfcUniteParamQryListDetailAbilityRspBO.getJsonObject() || cfcUniteParamQryListDetailAbilityRspBO.getJsonObject().isEmpty()) {
            throw new ZTBusinessException("\u67e5\u8be2\u914d\u7f6e\u4e2d\u5fc3\u8fd4\u56de\u4e3a\u7a7a");
        }
        return (FscCfcUniteParamQryListDetailRspBO)JSON.parseObject((String)cfcUniteParamQryListDetailAbilityRspBO.getJsonObject().toJSONString(), FscCfcUniteParamQryListDetailRspBO.class);
    }

    private List<String> isAllowAssemble(boolean flag) {
        ArrayList<String> relInfos = new ArrayList<String>();
        if (!flag) {
            relInfos.add(FscConstants.FscRelStatus.SIGN + "," + FscConstants.FscRelType.PRO_INVOICE);
        }
        return relInfos;
    }

    private FscUocQryAcceptOrderListRspBO qry(FscUocQryAcceptOrderListReqBO qryInfo) {
        FscGeneralQueryAtomReqBO fscGeneralQueryAtomReqBO = new FscGeneralQueryAtomReqBO();
        fscGeneralQueryAtomReqBO.setQueryCountFlag(Boolean.valueOf(false));
        fscGeneralQueryAtomReqBO.setReqParams(JSON.toJSONString((Object)qryInfo));
        FscGeneralQueryAtomRspBO fscGeneralQueryAtomRspBO = this.fscGeneralQueryAtomService.generalQuery(fscGeneralQueryAtomReqBO);
        return (FscUocQryAcceptOrderListRspBO)JSON.parseObject((String)fscGeneralQueryAtomRspBO.getRspJsonStr(), FscUocQryAcceptOrderListRspBO.class);
    }
}

