/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.consumer;

import cn.hutool.core.exceptions.ExceptionUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageConsumer;
import com.ohaotian.plugin.mq.proxy.status.ProxyConsumerStatus;
import com.tydic.fsc.bill.ability.api.FscBillOrderCreateAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillOrderCreateAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillOrderCreateAbilityRspBO;
import com.tydic.fsc.busibase.busi.api.FscOrderFailLogUpdateBusiService;
import com.tydic.fsc.busibase.busi.api.FscSystemBusiLogBusiService;
import com.tydic.fsc.busibase.busi.bo.FscOrderFailLogUpdateBusiReqBO;
import com.tydic.fsc.busibase.busi.bo.FscSystemBusiLogBusiServiceReqBo;
import com.tydic.fsc.constants.FscConstants;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class FscDownTakeUpCreateOrderServiceConsumer
extends DefaultProxyMessageConfig
implements ProxyMessageConsumer {
    private static final Logger log = LoggerFactory.getLogger(FscDownTakeUpCreateOrderServiceConsumer.class);
    @Autowired
    private FscBillOrderCreateAbilityService fscBillOrderCreateAbilityService;
    @Autowired
    private FscOrderFailLogUpdateBusiService fscOrderFailLogUpdateBusiService;
    @Autowired
    private FscSystemBusiLogBusiService fscSystemBusiLogBusiService;

    public ProxyConsumerStatus onMessage(ProxyMessage message) {
        FscBillOrderCreateAbilityRspBO rspBO = null;
        try {
            FscBillOrderCreateAbilityReqBO reqBO = (FscBillOrderCreateAbilityReqBO)JSON.parseObject((String)message.getContent(), FscBillOrderCreateAbilityReqBO.class);
            if (log.isDebugEnabled()) {
                log.debug("\u4e0b\u6e38\u5e26\u52a8\u4e0a\u6e38\u5f00\u7968\u6d88\u8d39\u8005\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)reqBO));
            }
            if (!"0000".equals((rspBO = this.fscBillOrderCreateAbilityService.dealCreate(reqBO)).getRespCode())) {
                this.systemBusiLog(FscConstants.SystemLogFlag.FAIL, JSON.toJSONString((Object)reqBO), JSON.toJSONString((Object)rspBO), new Date(), rspBO.getRespDesc());
                this.writeFailLog(reqBO, rspBO.getRespDesc());
            }
            this.systemBusiLog(FscConstants.SystemLogFlag.SUCCESS, JSON.toJSONString((Object)reqBO), JSON.toJSONString((Object)rspBO), new Date(), null);
        }
        catch (Exception e) {
            this.systemBusiLog(FscConstants.SystemLogFlag.FAIL, message.getContent(), JSON.toJSONString(rspBO), new Date(), ExceptionUtil.stacktraceToString((Throwable)e));
            return ProxyConsumerStatus.CONSUME_SUCCESS;
        }
        return ProxyConsumerStatus.CONSUME_SUCCESS;
    }

    private void writeFailLog(FscBillOrderCreateAbilityReqBO reqBO, String failDesc) {
        FscOrderFailLogUpdateBusiReqBO fscOrderFailLogUpdateBusiReqBO = new FscOrderFailLogUpdateBusiReqBO();
        fscOrderFailLogUpdateBusiReqBO.setBusiFailReq(JSON.toJSONString((Object)reqBO));
        fscOrderFailLogUpdateBusiReqBO.setBusiFailDesc(failDesc);
        fscOrderFailLogUpdateBusiReqBO.setBusiFailTime(new Date());
        fscOrderFailLogUpdateBusiReqBO.setBusiType(FscConstants.FscOrderFailRetansBusiType.FSC_DOWN_TAKE_UP_FAIL);
        this.fscOrderFailLogUpdateBusiService.dealInsert(fscOrderFailLogUpdateBusiReqBO);
    }

    private void systemBusiLog(Integer logFlag, String reqStr, String rspStr, Date createTime, String failureReason) {
        FscSystemBusiLogBusiServiceReqBo logBusiServiceReqBo = new FscSystemBusiLogBusiServiceReqBo();
        logBusiServiceReqBo.setSystemType(FscConstants.SystemType.INNER);
        logBusiServiceReqBo.setLogType(FscConstants.SystemLogType.FORWARD);
        logBusiServiceReqBo.setLogFlag(logFlag);
        logBusiServiceReqBo.setBusiType(FscConstants.SystemLogBusiType.DOWN_TACK_UP);
        logBusiServiceReqBo.setCallService("FscBillOrderCreateAbilityService");
        logBusiServiceReqBo.setSendService("FscBillOrderCreateAbilityService");
        logBusiServiceReqBo.setReqParam(reqStr);
        logBusiServiceReqBo.setRspParam(rspStr);
        logBusiServiceReqBo.setCreateTime(createTime);
        logBusiServiceReqBo.setFailureReason(failureReason);
        this.fscSystemBusiLogBusiService.systemBusiLog(logBusiServiceReqBo);
    }
}

