/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.busibase.atom.impl;

import com.tydic.fsc.bo.FscAuditBaseBo;
import com.tydic.fsc.busibase.atom.api.FscAuditOrderCreateAtomService;
import com.tydic.fsc.busibase.atom.api.FscPayBillCreateAuditAtomService;
import com.tydic.fsc.busibase.atom.bo.FscAuditOrderCreateAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscAuditOrderCreateAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscPayBillCreateAuditAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscPayBillCreateAuditAtomRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscOsWorkFlowReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscOsWorkFlowRspBO;
import com.tydic.fsc.busibase.external.api.osworkflow.FscOsworkflowWhetherChartAtomService;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.exception.FscBusinessException;
import java.util.ArrayList;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class FscPayBillCreateAuditAtomServiceImpl
implements FscPayBillCreateAuditAtomService {
    @Autowired
    private FscOsworkflowWhetherChartAtomService fscOsworkflowWhetherChartAtomService;
    @Autowired
    private FscAuditOrderCreateAtomService fscAuditOrderCreateAtomService;
    private static final String CREATE_FSC_PROCESS_KEY = "FSC_PAY_AUDIT";
    @Value(value="${process.sysCode}")
    private String processSysCode;

    @Override
    public FscPayBillCreateAuditAtomRspBO dealCreateAudit(FscPayBillCreateAuditAtomReqBO reqBO) {
        FscPayBillCreateAuditAtomRspBO rspBO = new FscPayBillCreateAuditAtomRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        if (!this.qryAuditFlow(this.processSysCode)) {
            return rspBO;
        }
        FscAuditOrderCreateAtomRspBO fscAuditOrderCreateAtomRspBO = this.createAudit(reqBO);
        this.startAuditFlow(reqBO.getFscOrderId(), fscAuditOrderCreateAtomRspBO);
        return rspBO;
    }

    private FscAuditOrderCreateAtomRspBO createAudit(FscPayBillCreateAuditAtomReqBO reqBO) {
        FscAuditOrderCreateAtomReqBO fscAuditOrderCreateAtomReqBO = new FscAuditOrderCreateAtomReqBO();
        fscAuditOrderCreateAtomReqBO.setOrderId(reqBO.getFscOrderId());
        fscAuditOrderCreateAtomReqBO.setObjId(reqBO.getFscOrderId());
        fscAuditOrderCreateAtomReqBO.setObjType(FscConstants.OBJ_TYPE.FSC_ORDER);
        fscAuditOrderCreateAtomReqBO.setObjBusiType(FscConstants.AuditObjType.PAY_APPLY_ORDER);
        fscAuditOrderCreateAtomReqBO.setUserId(reqBO.getUserId());
        fscAuditOrderCreateAtomReqBO.setUserName(reqBO.getName());
        return this.fscAuditOrderCreateAtomService.dealAuditOrderCreate(fscAuditOrderCreateAtomReqBO);
    }

    private boolean qryAuditFlow(String sysCode) {
        FscOsWorkFlowReqBO osWorkFlowReqBO = new FscOsWorkFlowReqBO();
        osWorkFlowReqBO.setSysCode(sysCode);
        osWorkFlowReqBO.setProcDefKey(CREATE_FSC_PROCESS_KEY);
        FscOsWorkFlowRspBO osWorkflow = this.fscOsworkflowWhetherChartAtomService.findOsWorkflow(osWorkFlowReqBO);
        if (!"0000".equals(osWorkflow.getRespCode())) {
            throw new FscBusinessException(osWorkflow.getRespCode(), osWorkflow.getRespDesc());
        }
        return null != osWorkflow.getFindFlag() && osWorkflow.getFindFlag() != false;
    }

    private void startAuditFlow(Long fscOrderId, FscAuditOrderCreateAtomRspBO atomRspBO) {
        FscAuditBaseBo fscAuditBaseBo = new FscAuditBaseBo();
        fscAuditBaseBo.setProcDefKey(CREATE_FSC_PROCESS_KEY);
        fscAuditBaseBo.setPartitionKey(fscOrderId.toString());
        HashMap<String, Long> variables = new HashMap<String, Long>();
        variables.put("auditId", atomRspBO.getAuditOrderId());
        fscAuditBaseBo.setVariables(variables);
        ArrayList<String> strings = new ArrayList<String>();
        strings.add(fscOrderId.toString());
        fscAuditBaseBo.setBusinessIdList(strings);
    }
}

