/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import com.tydic.fsc.busibase.atom.api.FscMerchantAtomService;
import com.tydic.fsc.busibase.atom.bo.FscMerchantAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscMerchantAtomRspBo;
import com.tydic.fsc.common.busi.api.FscMerchantDeleteBusiService;
import com.tydic.fsc.common.busi.bo.FscMerchantDeleteBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscMerchantDeleteBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscMerchantMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscMerchantPO;
import com.tydic.fsc.util.FscRspUtil;
import com.tydic.payment.pay.dao.BillCheckConfigMapper;
import com.tydic.payment.pay.dao.MerChantInfoMapper;
import com.tydic.payment.pay.dao.po.BillCheckConfigPO;
import com.tydic.payment.pay.dao.po.MerChantInfoPo;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscMerchantDeleteBusiServiceImpl
implements FscMerchantDeleteBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscMerchantDeleteBusiServiceImpl.class);
    @Autowired
    private FscMerchantAtomService fscMerchantAtomService;
    @Autowired
    private MerChantInfoMapper merChantInfoMapper;
    @Autowired
    private FscMerchantMapper fscMerchantMapper;
    @Autowired
    private BillCheckConfigMapper billCheckConfigMapper;

    @Override
    public FscMerchantDeleteBusiRspBO deleteMerchant(FscMerchantDeleteBusiReqBO reqBO) {
        FscMerchantDeleteBusiRspBO retBo = (FscMerchantDeleteBusiRspBO)FscRspUtil.getSuccessRspBo(FscMerchantDeleteBusiRspBO.class);
        FscMerchantPO merchantPO = new FscMerchantPO();
        merchantPO.setMerchantId(reqBO.getMerchantId());
        merchantPO.setDelFlag(FscConstants.MerchantDeleteFlag.NO);
        merchantPO = this.fscMerchantMapper.getModelBy(merchantPO);
        if (merchantPO == null) {
            retBo.setRespCode("193121");
            retBo.setRespDesc("\u4e0d\u5b58\u5728\u6709\u6548\u7684\u5546\u6237[" + reqBO.getMerchantId() + "]");
            return retBo;
        }
        if (FscConstants.MerchantIsException.MERCHANT_NOT_EXCEPTION.equals(merchantPO.getExceptionFlag()) && !StringUtils.isEmpty((Object)merchantPO.getPayMerchantId())) {
            MerChantInfoPo payMerchantPo = new MerChantInfoPo();
            payMerchantPo.setMerchantId(Long.valueOf(merchantPO.getPayMerchantId()));
            int result = this.merChantInfoMapper.deleteMerChantInfo(payMerchantPo);
            if (result < 1) {
                throw new FscBusinessException("193121", "\u5220\u9664\u652f\u4ed8\u4e2d\u5fc3\u5546\u6237\u4fe1\u606f\u5931\u8d25");
            }
            BillCheckConfigPO configPO = new BillCheckConfigPO();
            configPO.setPayCenterMerchant(Long.valueOf(merchantPO.getPayMerchantId()));
            result = this.billCheckConfigMapper.deleteByCondition(configPO);
            if (result < 1) {
                log.error("\u5220\u9664\u5546\u6237[{}]\uff0c\u652f\u4ed8\u4e2d\u5fc3\u5546\u6237[{}],\u5bf9\u8d26\u914d\u7f6e\u4fe1\u606f\u5931\u8d25\uff01\uff01\uff01", (Object)reqBO.getMerchantId(), (Object)merchantPO.getPayMerchantId());
            }
        }
        FscMerchantAtomReqBO atomReqBo = new FscMerchantAtomReqBO();
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)atomReqBo);
        atomReqBo.setDelFlag(FscConstants.MerchantDeleteFlag.YES);
        FscMerchantAtomRspBo atomRetBo = this.fscMerchantAtomService.updateMerchant(atomReqBo);
        if (!"0000".equals(atomRetBo.getRespCode())) {
            throw new FscBusinessException("193121", "\u4fee\u6539\u7ed3\u7b97\u4e2d\u5fc3\u5546\u6237\u4e3a\u5df2\u5220\u9664\u5931\u8d25");
        }
        FscMerchantPO fscMerchantPO = new FscMerchantPO();
        fscMerchantPO.setParentId(reqBO.getMerchantId());
        fscMerchantPO.setDelFlag(FscConstants.MerchantDeleteFlag.NO);
        List fscMerchantPoList = this.fscMerchantMapper.getList(fscMerchantPO);
        if (!CollectionUtils.isEmpty((Collection)fscMerchantPoList)) {
            FscMerchantPO set = new FscMerchantPO();
            set.setDelFlag(FscConstants.MerchantDeleteFlag.YES);
            set.setUpdateTime(new Date());
            set.setUpdateOperId(reqBO.getUserId().toString());
            set.setUpdateOperName(reqBO.getName());
            FscMerchantPO where = new FscMerchantPO();
            where.setMerchantIds(fscMerchantPoList.stream().map(FscMerchantPO::getMerchantId).collect(Collectors.toList()));
            this.fscMerchantMapper.updateBy(set, where);
        }
        return retBo;
    }
}

