/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.config;

import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.impl.ProxyProducerFactoryBean;
import com.ohaotian.plugin.mq.proxy.internal.ProxyMessageConfig;
import com.tydic.fsc.common.consumer.FscTodoSyncServiceConsumer;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class MqTodoSyncServiceConfiguration {
    @Value(value="${FSC_TODO_SYNC_PID:FSC_TODO_SYNC_PID}")
    private String fscTodoSyncPid;
    @Value(value="${FSC_TODO_SYNC_CID:FSC_TODO_SYNC_CID}")
    private String fscTodoSyncCid;
    @Value(value="${FSC_TODO_SYNC_TOPIC:FSC_TODO_SYNC_TOPIC}")
    private String fscTodoSyncTopic;
    @Value(value="${FSC_TODO_SYNC_TAG:FSC_TODO_SYNC_TAG}")
    private String fscTodoSyncTag;

    @Bean(value={"fscTodoSyncConfig"})
    public DefaultProxyMessageConfig defaultProxyMessageConfig() {
        DefaultProxyMessageConfig defaultProxyMessageConfig = new DefaultProxyMessageConfig();
        defaultProxyMessageConfig.setId(this.fscTodoSyncPid);
        return defaultProxyMessageConfig;
    }

    @Bean(value={"fscTodoSyncProvider"}, initMethod="startup", destroyMethod="shutdown")
    public ProxyProducerFactoryBean proxyProducerFactoryBean() {
        ProxyProducerFactoryBean proxyProducerFactoryBean = new ProxyProducerFactoryBean();
        proxyProducerFactoryBean.setMessageConfig((ProxyMessageConfig)this.defaultProxyMessageConfig());
        return proxyProducerFactoryBean;
    }

    @Bean(value={"fscTodoSyncServiceConsumer"})
    public FscTodoSyncServiceConsumer fscTodoSyncServiceConsumer() {
        FscTodoSyncServiceConsumer fscTodoSyncServiceConsumer = new FscTodoSyncServiceConsumer();
        fscTodoSyncServiceConsumer.setId(this.fscTodoSyncCid);
        fscTodoSyncServiceConsumer.setSubject(this.fscTodoSyncTopic);
        String[] tags = new String[]{this.fscTodoSyncTag};
        fscTodoSyncServiceConsumer.setTags(tags);
        return fscTodoSyncServiceConsumer;
    }
}

