/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.consumer;

import cn.hutool.core.exceptions.ExceptionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageConsumer;
import com.ohaotian.plugin.mq.proxy.status.ProxyConsumerStatus;
import com.tydic.fsc.busibase.atom.api.FscTodoSendAtomService;
import com.tydic.fsc.busibase.atom.bo.FscTodoSendAtomServiceReqBo;
import com.tydic.fsc.busibase.atom.bo.FscTodoSendAtomServiceRspBo;
import com.tydic.fsc.busibase.busi.api.FscSystemBusiLogBusiService;
import com.tydic.fsc.busibase.busi.bo.FscSystemBusiLogBusiServiceReqBo;
import com.tydic.fsc.constants.FscConstants;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class FscTodoSyncServiceConsumer
extends DefaultProxyMessageConfig
implements ProxyMessageConsumer {
    private static final Logger log = LoggerFactory.getLogger(FscTodoSyncServiceConsumer.class);
    @Autowired
    private FscTodoSendAtomService fscTodoSendAtomService;
    @Autowired
    private FscSystemBusiLogBusiService fscSystemBusiLogBusiService;

    public ProxyConsumerStatus onMessage(ProxyMessage proxyMessage) {
        JSONObject jsonObject = JSON.parseObject((String)proxyMessage.getContent());
        Date createTime = jsonObject.getDate("createTime");
        String sendService = jsonObject.getString("sendService");
        try {
            log.info("\u53d1\u9001\u5f85\u529e\u6d88\u8d39\u8005\u5165\u53c2\uff1a{}", (Object)proxyMessage.getContent());
            FscTodoSendAtomServiceReqBo fscTodoSendAbilityServiceReqBo = (FscTodoSendAtomServiceReqBo)JSON.parseObject((String)proxyMessage.getContent(), FscTodoSendAtomServiceReqBo.class);
            FscTodoSendAtomServiceRspBo fscTodoSendAbilityServiceRspBo = this.fscTodoSendAtomService.sendTodo(fscTodoSendAbilityServiceReqBo);
            if ("0000".equals(fscTodoSendAbilityServiceRspBo.getRespCode())) {
                this.systemBusiLog(FscConstants.SystemLogFlag.SUCCESS, proxyMessage.getContent(), JSON.toJSONString((Object)fscTodoSendAbilityServiceRspBo), createTime, fscTodoSendAbilityServiceRspBo.getRespDesc(), sendService);
                log.info("\u53d1\u9001\u5f85\u529e\u6210\u529f");
            } else {
                this.systemBusiLog(FscConstants.SystemLogFlag.FAIL, proxyMessage.getContent(), JSON.toJSONString((Object)fscTodoSendAbilityServiceRspBo), createTime, fscTodoSendAbilityServiceRspBo.getRespDesc(), sendService);
            }
        }
        catch (Exception e) {
            this.systemBusiLog(FscConstants.SystemLogFlag.FAIL, proxyMessage.getContent(), null, createTime, ExceptionUtil.stacktraceToString((Throwable)e), null);
            return ProxyConsumerStatus.CONSUME_SUCCESS;
        }
        return ProxyConsumerStatus.CONSUME_SUCCESS;
    }

    private void systemBusiLog(Integer logFlag, String reqStr, String rspStr, Date createTime, String failureReason, String sendService) {
        FscSystemBusiLogBusiServiceReqBo logBusiServiceReqBo = new FscSystemBusiLogBusiServiceReqBo();
        logBusiServiceReqBo.setSystemType(FscConstants.SystemType.EXT);
        logBusiServiceReqBo.setLogType(FscConstants.SystemLogType.FORWARD);
        logBusiServiceReqBo.setLogFlag(logFlag);
        logBusiServiceReqBo.setBusiType(FscConstants.SystemLogBusiType.SYNC_TODO_OR_NOTICE);
        logBusiServiceReqBo.setCallService("FscTodoSendAtomService");
        logBusiServiceReqBo.setSendService(sendService);
        logBusiServiceReqBo.setReqParam(reqStr);
        logBusiServiceReqBo.setRspParam(rspStr);
        logBusiServiceReqBo.setCreateTime(createTime);
        logBusiServiceReqBo.setFailureReason(failureReason);
        this.fscSystemBusiLogBusiService.systemBusiLog(logBusiServiceReqBo);
    }
}

