/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.base.core.dictionary.utils.DictFrameworkUtils;
import com.tydic.fsc.bo.FscComAccountListBO;
import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.common.ability.api.FscComAccountListQueryAbilityService;
import com.tydic.fsc.common.ability.bo.FscComAccountListQueryAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComAccountListQueryAbilityRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAccountMapper;
import com.tydic.fsc.dao.FscMerchantMapper;
import com.tydic.fsc.po.FscAccountPO;
import com.tydic.fsc.po.FscMerchantPO;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscComAccountListQueryAbilityService"})
public class FscComAccountListQueryAbilityServiceImpl
implements FscComAccountListQueryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscComAccountListQueryAbilityServiceImpl.class);
    @Autowired
    private FscAccountMapper fscAccountMapper;
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;
    @Autowired
    private FscMerchantMapper fscMerchantMapper;

    @PostMapping(value={"qryAccountList"})
    public FscComAccountListQueryAbilityRspBO qryAccountList(@RequestBody FscComAccountListQueryAbilityReqBO reqBO) {
        FscAccountPO fscAccountPO = new FscAccountPO();
        Page page = new Page();
        page.setPageNo(reqBO.getPageNo().intValue());
        page.setPageSize(reqBO.getPageSize().intValue());
        if (null != reqBO.getAccountName()) {
            fscAccountPO.setAccountName(reqBO.getAccountName());
        }
        if (null != reqBO.getAccountNo()) {
            fscAccountPO.setAccountNo(reqBO.getAccountNo());
        }
        if (null != reqBO.getStatus()) {
            fscAccountPO.setStatus(reqBO.getStatus());
        }
        if (null != reqBO.getCreateTimeStart()) {
            fscAccountPO.setCreateTimeStart(reqBO.getCreateTimeStart());
        }
        if (null != reqBO.getCreateTimeEnd()) {
            fscAccountPO.setCreateTimeEnd(reqBO.getCreateTimeEnd());
        }
        if (null != reqBO.getAccountCategory()) {
            fscAccountPO.setAccountCategory(reqBO.getAccountCategory());
        }
        if (null != reqBO.getCreateMethod()) {
            fscAccountPO.setCreateMethod(reqBO.getCreateMethod());
        }
        if (null != reqBO.getIsprofess() && !"0".equals(reqBO.getIsprofess())) {
            if (null != reqBO.getMechanismOrgId()) {
                fscAccountPO.setOrgId(reqBO.getMechanismOrgId());
            }
            if (reqBO.getMechanismOrgId() == null) {
                fscAccountPO.setOrgId(reqBO.getCompanyId());
            }
        } else if (null != reqBO.getIsprofess() && "0".equals(reqBO.getIsprofess())) {
            if (null != reqBO.getMechanismOrgId()) {
                fscAccountPO.setOrgId(reqBO.getMechanismOrgId());
            }
            if (reqBO.getMechanismOrgId() == null) {
                fscAccountPO.setOrgId(null);
                fscAccountPO.setOrgName(null);
            }
        }
        String orderBy = "create_time desc";
        fscAccountPO.setOrderBy(orderBy);
        List fscAccountPOList = this.fscAccountMapper.getListPage(fscAccountPO, page);
        if (CollectionUtils.isEmpty((Collection)fscAccountPOList)) {
            return new FscComAccountListQueryAbilityRspBO();
        }
        List fscComAccountListBOS = JSON.parseArray((String)JSON.toJSONString((Object)fscAccountPOList), FscComAccountListBO.class);
        DictFrameworkUtils.translateListByAnnotation((List)fscComAccountListBOS);
        FscComAccountListQueryAbilityRspBO rspBO = new FscComAccountListQueryAbilityRspBO();
        this.peekShowCreditButtonFlag(fscComAccountListBOS);
        rspBO.setRows(fscComAccountListBOS);
        rspBO.setPageNo(reqBO.getPageNo());
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        return rspBO;
    }

    private void peekShowCreditButtonFlag(List<FscComAccountListBO> fscAccountPOList) {
        if (!CollectionUtils.isEmpty(fscAccountPOList)) {
            if (this.isPayByPeriodAndNotException()) {
                fscAccountPOList.forEach(e -> e.setShowCreditButtonFlag(FscConstants.YesOrNoEnum.YES.getCode()));
            } else {
                List fscMerchantPOS;
                FscMerchantPO fscMerchantPO = new FscMerchantPO();
                fscMerchantPO.setPayType(FscConstants.PAY_TYPE.PAY_BY_PERIOD);
                fscMerchantPO.setExceptionFlag(FscConstants.MerchantIsException.MERCHANT_IS_EXCEPTION);
                fscMerchantPO.setDelFlag(FscConstants.YesOrNoEnum.NO.getCode());
                fscMerchantPO.setPayObjIds(fscAccountPOList.stream().map(FscComAccountListBO::getOrgId).collect(Collectors.toList()));
                if (!CollectionUtils.isEmpty((Collection)fscMerchantPO.getPayObjIds()) && !CollectionUtils.isEmpty((Collection)(fscMerchantPOS = this.fscMerchantMapper.getList(fscMerchantPO)))) {
                    Map<Long, List<FscMerchantPO>> payObjMerchantList = fscMerchantPOS.stream().collect(Collectors.groupingBy(FscMerchantPO::getPayObjId));
                    fscAccountPOList.forEach(e -> e.setShowCreditButtonFlag(payObjMerchantList.containsKey(e.getOrgId()) ? FscConstants.YesOrNoEnum.YES.getCode() : FscConstants.YesOrNoEnum.NO.getCode()));
                }
            }
        }
    }

    private boolean isPayByPeriodAndNotException() {
        FscMerchantPO fscMerchantPO = new FscMerchantPO();
        fscMerchantPO.setPayType(FscConstants.PAY_TYPE.PAY_BY_PERIOD);
        fscMerchantPO.setExceptionFlag(FscConstants.MerchantIsException.MERCHANT_NOT_EXCEPTION);
        fscMerchantPO.setDelFlag(FscConstants.YesOrNoEnum.NO.getCode());
        return this.fscMerchantMapper.getCheckBy(fscMerchantPO) > 0;
    }
}

