/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.tydic.fsc.bo.FscShouldPayBO;
import com.tydic.fsc.bo.FscShouldPayRspBO;
import com.tydic.fsc.busibase.comb.api.FscPayShouldPayCreateTodoAbilityService;
import com.tydic.fsc.common.ability.api.FscComOrderConfirmAbilityService;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscComOrderConfirmAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComOrderConfirmAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.common.busi.api.FscComOrderConfirmBusiService;
import com.tydic.fsc.common.busi.bo.FscComOrderConfirmBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscComOrderConfirmBusiRspBO;
import com.tydic.fsc.constants.FscBillStatus;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscComOrderConfirmAbilityService"})
public class FscComOrderConfirmAbilityServiceImpl
implements FscComOrderConfirmAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscComOrderConfirmAbilityServiceImpl.class);
    @Autowired
    private FscComOrderConfirmBusiService fscComOrderConfirmBusiService;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;
    @Autowired
    private FscPayShouldPayCreateTodoAbilityService fscPayShouldPayCreateTodoAbilityService;

    @PostMapping(value={"dealOrderConfirm"})
    public FscComOrderConfirmAbilityRspBO dealOrderConfirm(@RequestBody FscComOrderConfirmAbilityReqBO reqBO) {
        this.val(reqBO);
        FscOrderPO fscOrderPo = new FscOrderPO();
        fscOrderPo.setFscOrderId(reqBO.getOrderId());
        FscOrderPO fscOrder = this.fscOrderMapper.getModelBy(fscOrderPo);
        if (!FscBillStatus.TO_BE_CONFIRM.getCode().equals(fscOrder.getOrderState())) {
            throw new FscBusinessException("191126", "\u5f53\u524d\u7ed3\u7b97\u5355\u72b6\u6001\u4e0d\u80fd\u786e\u8ba4");
        }
        this.verifyServiceFeeConfirmTime(fscOrderPo);
        String jsonString = JSON.toJSONString((Object)reqBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
        FscComOrderConfirmBusiReqBO busiReqBO = (FscComOrderConfirmBusiReqBO)((Object)JSON.parseObject((String)jsonString, FscComOrderConfirmBusiReqBO.class));
        this.calShouldPayInfo(fscOrder, busiReqBO);
        FscComOrderConfirmBusiRspBO busiRspBO = this.fscComOrderConfirmBusiService.dealOrderConfirm(busiReqBO);
        if (!"0000".equals(busiRspBO.getRespCode())) {
            throw new FscBusinessException("191126", busiRspBO.getRespDesc());
        }
        this.sendMq(reqBO);
        this.dealTodo(reqBO, busiRspBO);
        return new FscComOrderConfirmAbilityRspBO();
    }

    private void dealTodo(FscComOrderConfirmAbilityReqBO reqBO, FscComOrderConfirmBusiRspBO busiRspBO) {
        try {
            if (!CollectionUtils.isEmpty(busiRspBO.getFscShouldPayRspBOs())) {
                FscShouldPayRspBO bo = busiRspBO.getFscShouldPayRspBOs().get(0);
                JSONObject req = new JSONObject();
                req.put("shouldPayId", (Object)bo.getShouldPayId());
                req.put("userId", (Object)reqBO.getUserId());
                req.put("payerUserTag", (Object)2);
                req.put("proOrgId", (Object)bo.getPayerId());
                req.put("purOrgId", (Object)bo.getPayerId());
                req.put("supOrgId", (Object)bo.getPayerId());
                this.fscPayShouldPayCreateTodoAbilityService.dealShouldPayCreateTodo(req);
            }
        }
        catch (Exception e) {
            log.error("\u5904\u7406\u4ee3\u529e\u5f02\u5e38\uff1a", (Throwable)e);
        }
    }

    private void verifyServiceFeeConfirmTime(FscOrderPO fscOrderPo) {
        if ((FscConstants.OrderFlow.MONTH_SERVICE_FEE.equals(fscOrderPo.getOrderFlow()) || FscConstants.OrderFlow.YEAR_ORDER_SERVICE_FEE.equals(fscOrderPo.getOrderFlow()) || FscConstants.OrderFlow.YEAR_ACCEPT_SERVICE_FEE.equals(fscOrderPo.getOrderFlow())) && System.currentTimeMillis() > fscOrderPo.getCreditConfirmDueDate().getTime()) {
            throw new FscBusinessException("191126", "\u8d85\u8fc7\u786e\u8ba4\u65f6\u9650\u65f6\u9650");
        }
    }

    private void val(FscComOrderConfirmAbilityReqBO reqBO) {
        if (null == reqBO.getOrderId()) {
            throw new FscBusinessException("191000", "\u5165\u53c2[orderId]\u4e3a\u7a7a");
        }
    }

    private void sendMq(FscComOrderConfirmAbilityReqBO reqBO) {
        FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
        fscComOrderListSyncAbilityReqBO.setFscOrderId(reqBO.getOrderId());
        fscComOrderListSyncAbilityReqBO.setCreateTime(new Date());
        fscComOrderListSyncAbilityReqBO.setSendService(this.getClass().getName());
        this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
    }

    private void calShouldPayInfo(FscOrderPO fscOrderPO, FscComOrderConfirmBusiReqBO fscComOrderConfirmBusiReqBO) {
        ArrayList<FscShouldPayBO> fscShouldPayBOS = new ArrayList<FscShouldPayBO>();
        FscShouldPayBO fscShouldPayBO = new FscShouldPayBO();
        if (FscConstants.OrderFlow.PL_SERVICE_FEE.equals(fscOrderPO.getOrderFlow())) {
            fscShouldPayBO.setShouldPayType(FscConstants.ShouldPayType.PALATFORM_USE_PAY);
            fscShouldPayBO.setObjectType(FscConstants.ShouldObjectType.USR_ORDER);
            fscShouldPayBO.setPayType(FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PREP);
        } else {
            fscShouldPayBO.setShouldPayType(FscConstants.ShouldPayType.DEAL_PAY);
            fscShouldPayBO.setObjectType(FscConstants.ShouldObjectType.DEAL_ORDER);
            fscShouldPayBO.setPayType(FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PERIOD);
        }
        fscShouldPayBO.setObjectId(fscOrderPO.getFscOrderId());
        fscShouldPayBO.setObjectNo(fscOrderPO.getOrderNo());
        if (fscOrderPO.getActualAmount() == null || BigDecimal.ZERO.compareTo(fscOrderPO.getActualAmount()) == 0) {
            fscShouldPayBO.setShouldPayAmount(fscOrderPO.getTotalCharge());
        } else {
            fscShouldPayBO.setShouldPayAmount(fscOrderPO.getActualAmount());
        }
        fscShouldPayBO.setPayeeId(fscOrderPO.getProOrgId());
        fscShouldPayBO.setPayeeName(fscOrderPO.getProOrgName());
        fscShouldPayBO.setPayerId(fscOrderPO.getSupplierId());
        fscShouldPayBO.setPayerName(fscOrderPO.getSupplierName());
        fscShouldPayBOS.add(fscShouldPayBO);
        fscComOrderConfirmBusiReqBO.setFscShouldPayBOS(fscShouldPayBOS);
        fscComOrderConfirmBusiReqBO.setOrderFlow(fscOrderPO.getOrderFlow());
    }
}

