/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.ability.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.dyc.base.core.approve.repository.api.ApproveRepository;
import com.tydic.dyc.base.core.dictionary.utils.DictFrameworkUtils;
import com.tydic.dyc.base.utils.JUtil;
import com.tydic.fsc.bo.AttachmentBO;
import com.tydic.fsc.bo.FscOrderExtFieldBo;
import com.tydic.fsc.bo.InvoicePostBO;
import com.tydic.fsc.bo.OrderInvoiceBO;
import com.tydic.fsc.bo.OrderPayBO;
import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.busibase.external.api.bo.FscPebExtOrdStatisticReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscPebExtOrdStatisticRspBO;
import com.tydic.fsc.busibase.external.api.pay.FscPayTransPayInsService;
import com.tydic.fsc.busibase.external.api.pay.bo.FscPayTransPayInsReqBo;
import com.tydic.fsc.busibase.external.api.pay.bo.FscPayTransPayInsRspBo;
import com.tydic.fsc.busibase.external.api.uoc.FscPebExtOrdStatisticAbilityService;
import com.tydic.fsc.common.ability.api.FscComOrderDetailQueryAbilityService;
import com.tydic.fsc.common.ability.bo.FscComOrderDetailQueryAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComOrderDetailQueryAbilityRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.constants.FscOrderFlowEnum;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscCheckResultMapper;
import com.tydic.fsc.dao.FscInvoiceMapper;
import com.tydic.fsc.dao.FscInvoicePostMapper;
import com.tydic.fsc.dao.FscOrderExtFieldMapper;
import com.tydic.fsc.dao.FscOrderInvoiceMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderPayItemMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.dao.UocApprovalObjMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAttachmentPO;
import com.tydic.fsc.po.FscCheckResultPO;
import com.tydic.fsc.po.FscInvoicePO;
import com.tydic.fsc.po.FscOrderExtFieldPo;
import com.tydic.fsc.po.FscOrderInvoicePO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderPayItemPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import com.tydic.fsc.po.FscShouldPayPO;
import com.tydic.fsc.utils.BigDecimalConvert;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.common.ability.api.FscComOrderDetailQueryAbilityService"})
public class FscComOrderDetailQueryAbilityServiceImpl
implements FscComOrderDetailQueryAbilityService {
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderInvoiceMapper fscOrderInvoiceMapper;
    @Autowired
    private FscAttachmentMapper fscAttachmentMapper;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private FscCheckResultMapper fscCheckResultMapper;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Autowired
    private FscOrderPayItemMapper fscOrderPayItemMapper;
    @Autowired
    private FscInvoiceMapper fscInvoiceMapper;
    @Autowired
    private FscInvoicePostMapper fscInvoicePostMapper;
    @Autowired
    private FscPayTransPayInsService fscPayTransPayInsService;
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;
    @Autowired
    private UocApprovalObjMapper uocApprovalObjMapper;
    @Autowired
    private FscOrderExtFieldMapper fscOrderExtFieldMapper;
    @Autowired
    private FscPebExtOrdStatisticAbilityService fscPebExtOrdStatisticAbilityService;
    @Autowired
    private ApproveRepository approveRepository;
    private static final String YEAR_FIRST_TIME = "00:00:00";
    private static final String YEAR_LAST_TIME = "23:59:59";
    @Value(value="${fsc.dataAchiveFlag:false}")
    private Boolean dataAchiveFlag;

    @BigDecimalConvert(value=2)
    @PostMapping(value={"qryOrderDetail"})
    public FscComOrderDetailQueryAbilityRspBO qryOrderDetail(@RequestBody FscComOrderDetailQueryAbilityReqBO reqBO) {
        List payFscAttachmentPOS;
        if (null == reqBO) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (null == reqBO.getOrderId()) {
            throw new FscBusinessException("191000", "\u5165\u53c2OrderId\u4e3a\u7a7a");
        }
        FscOrderPO fscOrderPo = new FscOrderPO();
        fscOrderPo.setFscOrderId(reqBO.getOrderId());
        fscOrderPo = this.fscOrderMapper.getModelBy(fscOrderPo);
        String dataAchiveTabSuffix = null;
        if (this.dataAchiveFlag.booleanValue() && Objects.isNull(fscOrderPo)) {
            dataAchiveTabSuffix = "_" + new SimpleDateFormat("yyyy").format((reqBO.getOrderId() >> 22) + 1480166465631L);
            FscOrderPO fscOrderPo1 = new FscOrderPO();
            fscOrderPo1.setFscOrderId(reqBO.getOrderId());
            fscOrderPo1.setDataAchiveTabSuffix(dataAchiveTabSuffix);
            fscOrderPo = this.fscOrderMapper.getModelBy(fscOrderPo1);
        }
        if (null == fscOrderPo) {
            return new FscComOrderDetailQueryAbilityRspBO();
        }
        FscOrderExtFieldPo fscOrderExtFieldPo = new FscOrderExtFieldPo();
        fscOrderExtFieldPo.setFscOrderId(fscOrderPo.getFscOrderId());
        fscOrderExtFieldPo = this.fscOrderExtFieldMapper.getModelBy(fscOrderExtFieldPo);
        FscComOrderDetailQueryAbilityRspBO rspBO = (FscComOrderDetailQueryAbilityRspBO)JSON.parseObject((String)JSON.toJSONString((Object)fscOrderPo), FscComOrderDetailQueryAbilityRspBO.class);
        if (null != fscOrderExtFieldPo) {
            rspBO.setFscOrderExtFieldBo((FscOrderExtFieldBo)JUtil.js((Object)fscOrderExtFieldPo, FscOrderExtFieldBo.class));
        }
        rspBO.setOrderFlowStr(Objects.requireNonNull(FscOrderFlowEnum.getInstance((Integer)rspBO.getOrderFlow())).getDescr());
        if (!StringUtils.isEmpty((Object)rspBO.getPayChannel())) {
            FscPayTransPayInsReqBo fscPayTransPayInsReqBo = new FscPayTransPayInsReqBo();
            fscPayTransPayInsReqBo.setPaymentInsId(Collections.singletonList(Long.parseLong(rspBO.getPayChannel())));
            FscPayTransPayInsRspBo fscPayTransPayInsRspBo = this.fscPayTransPayInsService.tranPayIns(fscPayTransPayInsReqBo);
            if (!StringUtils.isEmpty((Object)fscPayTransPayInsRspBo)) {
                if (!StringUtils.isEmpty((Object)fscPayTransPayInsRspBo.getPayInsMap())) {
                    rspBO.setPayChannelStr((String)fscPayTransPayInsRspBo.getPayInsMap().get(rspBO.getPayChannel()));
                }
                if (!StringUtils.isEmpty((Object)fscPayTransPayInsRspBo.getPayMethodMap())) {
                    rspBO.setPayMethodStr((String)fscPayTransPayInsRspBo.getPayMethodMap().get(rspBO.getPayMethod()));
                }
            }
        }
        if (0 == fscOrderPo.getOrderFlow()) {
            rspBO.setOrderStateStr(DictFrameworkUtils.getDictDataByCode((String)"FSC", (String)"FSC_ORDER_LIST_STATE", (String)String.valueOf(rspBO.getOrderState())) == null ? null : DictFrameworkUtils.getDictDataByCode((String)"FSC", (String)"FSC_ORDER_LIST_STATE", (String)String.valueOf(rspBO.getOrderState())).getValue());
        } else {
            rspBO.setOrderStateStr(DictFrameworkUtils.getDictDataByCode((String)"FSC", (String)"FSC_ORDER_SERVICE_LIST_STATE", (String)String.valueOf(rspBO.getOrderState())) == null ? null : DictFrameworkUtils.getDictDataByCode((String)"FSC", (String)"FSC_ORDER_SERVICE_LIST_STATE", (String)String.valueOf(rspBO.getOrderState())).getValue());
        }
        DictFrameworkUtils.translateByAnnotation((Object)rspBO);
        FscOrderInvoicePO fscOrderInvoicePo = new FscOrderInvoicePO();
        fscOrderInvoicePo.setFscOrderId(reqBO.getOrderId());
        fscOrderInvoicePo.setDataAchiveTabSuffix(dataAchiveTabSuffix);
        fscOrderInvoicePo = this.fscOrderInvoiceMapper.getModelBy(fscOrderInvoicePo);
        FscInvoicePO fscInvoicePO = new FscInvoicePO();
        fscInvoicePO.setFscOrderId(reqBO.getOrderId());
        fscInvoicePO.setDataAchiveTabSuffix(dataAchiveTabSuffix);
        List fscInvoicePOS = this.fscInvoiceMapper.getList(fscInvoicePO);
        OrderInvoiceBO orderInvoiceBO = new OrderInvoiceBO();
        if (!StringUtils.isEmpty((Object)fscOrderInvoicePo)) {
            rspBO.setSignOperName(fscOrderInvoicePo.getSignOperName());
            rspBO.setSignTime(fscOrderInvoicePo.getSignTime());
            orderInvoiceBO = (OrderInvoiceBO)JSON.parseObject((String)JSON.toJSONString((Object)fscOrderInvoicePo), OrderInvoiceBO.class);
            DictFrameworkUtils.translateByAnnotation((Object)orderInvoiceBO);
        }
        if (!CollectionUtils.isEmpty((Collection)fscInvoicePOS)) {
            ArrayList<OrderInvoiceBO> orderInvoiceBOS = new ArrayList<OrderInvoiceBO>(fscInvoicePOS.size());
            for (FscInvoicePO invoicePO : fscInvoicePOS) {
                OrderInvoiceBO orderInvoiceBO1 = new OrderInvoiceBO();
                BeanUtils.copyProperties((Object)orderInvoiceBO, (Object)orderInvoiceBO1);
                orderInvoiceBO1.setInvoiceCode(invoicePO.getInvoiceCode());
                orderInvoiceBO1.setInvoiceNo(invoicePO.getInvoiceNo());
                orderInvoiceBO1.setBillDate(invoicePO.getBillDate());
                orderInvoiceBO1.setProvince(fscOrderInvoicePo.getProvince());
                orderInvoiceBO1.setCity(fscOrderInvoicePo.getCity());
                orderInvoiceBO1.setArea(fscOrderInvoicePo.getArea());
                orderInvoiceBO1.setTown(StrUtil.isBlank((CharSequence)fscOrderInvoicePo.getTown()) ? "" : fscOrderInvoicePo.getTown());
                orderInvoiceBOS.add(orderInvoiceBO1);
            }
            rspBO.setOrderInvoiceInfo(orderInvoiceBOS);
            List mailIds = fscInvoicePOS.stream().map(FscInvoicePO::getMailId).collect(Collectors.toList());
            List fscInvoicePostList = this.fscInvoicePostMapper.getListByIds(mailIds);
            if (!CollectionUtils.isEmpty((Collection)fscInvoicePostList)) {
                List invoicePostList = fscInvoicePostList.stream().map(fscInvoicePostPO -> {
                    InvoicePostBO invoicePostBO = new InvoicePostBO();
                    invoicePostBO.setSendCompany(fscInvoicePostPO.getSendCompany());
                    invoicePostBO.setSendDate(fscInvoicePostPO.getSendDate());
                    invoicePostBO.setSendDateStr(DateUtil.format((Date)fscInvoicePostPO.getSendDate(), (String)"yyyy-MM-dd"));
                    invoicePostBO.setSendOperName(fscInvoicePostPO.getSendOperName());
                    invoicePostBO.setSendOrder(fscInvoicePostPO.getSendOrder());
                    invoicePostBO.setSendPhone(fscInvoicePostPO.getSendPhone());
                    return invoicePostBO;
                }).collect(Collectors.toList());
                rspBO.setInvoicePostList(invoicePostList);
            }
            rspBO.setBillDate(((FscInvoicePO)fscInvoicePOS.get(0)).getBillDate());
        } else if (!StringUtils.isEmpty((Object)fscOrderInvoicePo)) {
            rspBO.setOrderInvoiceInfo(Collections.singletonList(orderInvoiceBO));
        }
        FscAttachmentPO fscAttachmentPo = new FscAttachmentPO();
        fscAttachmentPo.setFscOrderId(reqBO.getOrderId());
        fscAttachmentPo.setDataAchiveTabSuffix(dataAchiveTabSuffix);
        List fscAttachmentPOS = this.fscAttachmentMapper.getList(fscAttachmentPo);
        if (!CollectionUtils.isEmpty((Collection)fscAttachmentPOS)) {
            ArrayList<String> attUrls = new ArrayList<String>(fscAttachmentPOS.size());
            for (FscAttachmentPO fscAttachmentPO : fscAttachmentPOS) {
                attUrls.add(fscAttachmentPO.getAttachmentUrl());
            }
            List attachmentBOS = JSON.parseArray((String)JSON.toJSONString((Object)fscAttachmentPOS), AttachmentBO.class);
            rspBO.setAttachmentList(attachmentBOS);
            rspBO.setPayEvidenceUrls(attUrls);
        }
        if (FscComOrderDetailQueryAbilityServiceImpl.isServiceFeeOrInvoice(fscOrderPo) && CollectionUtil.isNotEmpty((Collection)(payFscAttachmentPOS = this.fscAttachmentMapper.getPayAttach(fscOrderPo.getFscOrderId())))) {
            List attachmentBOS = JSON.parseArray((String)JSON.toJSONString((Object)payFscAttachmentPOS), AttachmentBO.class);
            if (CollectionUtil.isEmpty((Collection)rspBO.getAttachmentList())) {
                rspBO.setAttachmentList(attachmentBOS);
            } else {
                rspBO.getAttachmentList().addAll(attachmentBOS);
            }
        }
        FscOrderPayItemPO fscOrderPayItemPO = new FscOrderPayItemPO();
        fscOrderPayItemPO.setFscOrderId(reqBO.getOrderId());
        fscOrderPayItemPO.setDataAchiveTabSuffix(dataAchiveTabSuffix);
        List fscShouldPayPOS = null;
        List fscOrderPayItemMapperList = this.fscOrderPayItemMapper.getList(fscOrderPayItemPO);
        Map<Long, BigDecimal> fscOrderPayItemPOMap = null;
        if (!CollectionUtils.isEmpty((Collection)fscOrderPayItemMapperList)) {
            fscOrderPayItemPOMap = fscOrderPayItemMapperList.stream().collect(Collectors.toMap(FscOrderPayItemPO::getShouldPayId, FscOrderPayItemPO::getPayAmount));
            List shouldPayIds = fscOrderPayItemMapperList.stream().map(FscOrderPayItemPO::getShouldPayId).collect(Collectors.toList());
            FscShouldPayPO fscShouldPayPO = new FscShouldPayPO();
            fscShouldPayPO.setShouldPayIds(shouldPayIds);
            fscShouldPayPOS = this.fscShouldPayMapper.getList(fscShouldPayPO);
        }
        if (!CollectionUtils.isEmpty(fscShouldPayPOS)) {
            List orderPayBOS = JSON.parseArray((String)JSON.toJSONString(fscShouldPayPOS), OrderPayBO.class);
            if (!CollectionUtils.isEmpty(fscOrderPayItemPOMap)) {
                for (OrderPayBO orderPayBO : orderPayBOS) {
                    orderPayBO.setPayAmount(fscOrderPayItemPOMap.get(orderPayBO.getShouldPayId()));
                }
            }
            rspBO.setOrderPayList(orderPayBOS);
        }
        FscOrderRelationPO fscOrderRelationPo = new FscOrderRelationPO();
        fscOrderRelationPo.setFscOrderId(reqBO.getOrderId());
        fscOrderRelationPo.setDataAchiveTabSuffix(dataAchiveTabSuffix);
        if (FscConstants.OrderFlow.PAY.equals(rspBO.getOrderFlow())) {
            FscOrderPayItemPO fscOrderPayItem = new FscOrderPayItemPO();
            fscOrderPayItem.setFscOrderId(reqBO.getOrderId());
            fscOrderPayItem.setDataAchiveTabSuffix(dataAchiveTabSuffix);
            List fscOrderPayItemList = this.fscOrderPayItemMapper.getList(fscOrderPayItem);
            if (!CollectionUtils.isEmpty((Collection)fscOrderPayItemList)) {
                rspBO.setOrderNum(Integer.valueOf(fscOrderPayItemList.size()));
            }
        } else {
            Integer orderNum = this.fscOrderRelationMapper.getCheckBy(fscOrderRelationPo);
            rspBO.setOrderNum(orderNum);
        }
        fscOrderRelationPo = this.fscOrderRelationMapper.getModelByLimit(fscOrderRelationPo);
        if (null != fscOrderRelationPo && null != fscOrderRelationPo.getAcceptOrderId()) {
            FscCheckResultPO fscCheckResultPO = new FscCheckResultPO();
            fscCheckResultPO.setAcceptOrderId(fscOrderRelationPo.getAcceptOrderId());
            fscCheckResultPO.setDataAchiveTabSuffix(dataAchiveTabSuffix);
            List fscCheckResultPOS = this.fscCheckResultMapper.getList(fscCheckResultPO);
            if (!CollectionUtils.isEmpty((Collection)fscCheckResultPOS)) {
                rspBO.setCheckOperName(((FscCheckResultPO)fscCheckResultPOS.get(0)).getOperName());
            }
        }
        this.qryYearServiceFeeOrderNum(fscOrderPo, rspBO);
        return rspBO;
    }

    private void qryYearServiceFeeOrderNum(FscOrderPO fscOrderPo, FscComOrderDetailQueryAbilityRspBO rspBO) {
        if (FscConstants.OrderFlow.YEAR_ACCEPT_SERVICE_FEE.equals(fscOrderPo.getOrderFlow()) || FscConstants.OrderFlow.YEAR_ORDER_SERVICE_FEE.equals(fscOrderPo.getOrderFlow())) {
            String serviceFeeCycle = fscOrderPo.getServiceFeeCycle();
            String[] cycles = serviceFeeCycle.split(",");
            Integer year = LocalDate.now().getYear();
            String firstCycleMonth = cycles[0].length() < 2 ? "0" + cycles[0] : cycles[0];
            String firstCycleDay = cycles[1].length() < 2 ? "0" + cycles[1] : cycles[1];
            String lastCycleMonth = cycles[2].length() < 2 ? "0" + cycles[2] : cycles[2];
            String lastCycleDay = cycles[3].length() < 2 ? "0" + cycles[3] : cycles[3];
            String firstDayStr = year + "-" + firstCycleMonth + "-" + firstCycleDay + " " + YEAR_FIRST_TIME;
            String lastDayStr = year + "-" + lastCycleMonth + "-" + lastCycleDay + " " + YEAR_LAST_TIME;
            Integer searchType = FscConstants.OrderFlow.YEAR_ACCEPT_SERVICE_FEE.equals(fscOrderPo.getOrderFlow()) ? FscConstants.SearchType.ACCEPT : FscConstants.SearchType.ORDER;
            FscPebExtOrdStatisticRspBO fscPebExtOrdStatisticRspBO = this.qryYearOrdInfo(fscOrderPo.getSupplierId(), searchType, firstDayStr, lastDayStr);
            rspBO.setOrderNum(fscPebExtOrdStatisticRspBO.getTotalCount());
        }
    }

    private FscPebExtOrdStatisticRspBO qryYearOrdInfo(Long supId, Integer searchType, String effTime, String expTime) {
        FscPebExtOrdStatisticReqBO fscPebExtOrdStatisticReqBO = new FscPebExtOrdStatisticReqBO();
        fscPebExtOrdStatisticReqBO.setSupNo(supId.toString());
        fscPebExtOrdStatisticReqBO.setSearchType(searchType);
        fscPebExtOrdStatisticReqBO.setCreateTimeEff(effTime);
        fscPebExtOrdStatisticReqBO.setCreateTimeExp(expTime);
        FscPebExtOrdStatisticRspBO fscPebExtOrdStatisticRspBO = this.fscPebExtOrdStatisticAbilityService.queryOrdStatisticInfo(fscPebExtOrdStatisticReqBO);
        if (!"0000".equals(fscPebExtOrdStatisticRspBO.getRespCode())) {
            throw new FscBusinessException("193111", fscPebExtOrdStatisticRspBO.getRespDesc());
        }
        return fscPebExtOrdStatisticRspBO;
    }

    private static boolean isServiceFeeOrInvoice(FscOrderPO fscOrderPo) {
        return Arrays.asList(FscConstants.OrderFlow.INVOICE, FscConstants.OrderFlow.MONTH_SERVICE_FEE, FscConstants.OrderFlow.YEAR_ORDER_SERVICE_FEE, FscConstants.OrderFlow.PL_SERVICE_FEE, FscConstants.OrderFlow.YEAR_ACCEPT_SERVICE_FEE).contains(fscOrderPo.getOrderFlow());
    }
}

