/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.common.busi.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.dyc.base.core.approve.repository.api.ApproveRepository;
import com.tydic.dyc.base.core.approve.repository.bo.FlowTaskHandleDo;
import com.tydic.dyc.base.core.approve.repository.bo.FlowTaskInfoDo;
import com.tydic.dyc.base.core.approve.repository.bo.FlowTaskQryDo;
import com.tydic.fsc.bo.FscCandidatesBO;
import com.tydic.fsc.bo.FscTaskInfoBO;
import com.tydic.fsc.busibase.atom.api.FscBussiBackStepAtomService;
import com.tydic.fsc.busibase.atom.bo.FscBussiBackStepAtomReqBO;
import com.tydic.fsc.common.busi.api.FscFlowCancelBusiService;
import com.tydic.fsc.common.busi.bo.FscFlowCancelBusiReqBO;
import com.tydic.fsc.common.busi.bo.FscFlowCancelBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscInvoiceMapper;
import com.tydic.fsc.dao.FscOrderInvoiceMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAttachmentPO;
import com.tydic.fsc.po.FscInvoicePO;
import com.tydic.fsc.po.FscOrderInvoicePO;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FscFlowCancelBusiServiceImpl
implements FscFlowCancelBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscFlowCancelBusiServiceImpl.class);
    @Autowired
    private FscOrderInvoiceMapper fscOrderInvoiceMapper;
    @Autowired
    private FscInvoiceMapper fscInvoiceMapper;
    @Autowired
    private FscAttachmentMapper fscAttachmentMapper;
    @Autowired
    private ApproveRepository approveRepository;
    @Autowired
    private FscBussiBackStepAtomService fscBussiBackStepAtomService;

    @Override
    public FscFlowCancelBusiRspBO dealCancelFlow(FscFlowCancelBusiReqBO reqBO) {
        this.check(reqBO);
        FscFlowCancelBusiRspBO rspBO = new FscFlowCancelBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        List<FscTaskInfoBO> taskInfoBOList = this.dealAuditTodoTask(reqBO);
        this.clearInfo(reqBO);
        this.dealBack(reqBO);
        rspBO.setCancelTaskInfos(taskInfoBOList);
        return rspBO;
    }

    private void check(FscFlowCancelBusiReqBO reqBO) {
        if (ObjectUtil.isNull((Object)reqBO.getOrderId())) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[orderId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isNull((Object)reqBO.getOrderId())) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[auditProcInstId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private List<FscTaskInfoBO> dealAuditTodoTask(FscFlowCancelBusiReqBO reqBO) {
        FlowTaskQryDo taskInstPoWhere = new FlowTaskQryDo();
        taskInstPoWhere.setObjId(reqBO.getOrderId());
        taskInstPoWhere.setProcInstId(reqBO.getAuditProcInstId());
        taskInstPoWhere.setCenterCode("FSC");
        List uocOrderTaskInstPoList = this.approveRepository.queryFlowTask(taskInstPoWhere);
        if (uocOrderTaskInstPoList.isEmpty()) {
            log.error("\u64a4\u56de\u6d41\u7a0b\uff0c\u67e5\u8be2\u5ba1\u6279\u4efb\u52a1\u4e3a\u7a7a\uff0corderId={},auditProcInstId={}", (Object)reqBO.getOrderId(), (Object)reqBO.getAuditProcInstId());
            return Collections.emptyList();
        }
        List taskIdList = uocOrderTaskInstPoList.stream().map(FlowTaskInfoDo::getTaskInstId).collect(Collectors.toList());
        List<FscTaskInfoBO> taskInfoBOList = uocOrderTaskInstPoList.stream().map(e -> {
            FscTaskInfoBO fscTaskInfoBO = (FscTaskInfoBO)JSON.parseObject((String)JSON.toJSONString((Object)e), FscTaskInfoBO.class);
            fscTaskInfoBO.setFinish(Boolean.valueOf(FscConstants.FinishTag.YES.equals(e.getFinishTag())));
            fscTaskInfoBO.setTaskId(e.getTaskInstId());
            ArrayList<FscCandidatesBO> candidatesBOList = new ArrayList<FscCandidatesBO>();
            FscCandidatesBO fscCandidatesBO = new FscCandidatesBO();
            fscCandidatesBO.setCandidateId(e.getTaskUserId().toString());
            fscCandidatesBO.setCandidateName(e.getTaskUserName());
            candidatesBOList.add(fscCandidatesBO);
            fscTaskInfoBO.setCandidates(candidatesBOList);
            return fscTaskInfoBO;
        }).collect(Collectors.toList());
        for (String taskId : taskIdList) {
            FlowTaskHandleDo flowTaskHandleDo = new FlowTaskHandleDo();
            flowTaskHandleDo.setObjId(reqBO.getOrderId());
            flowTaskHandleDo.setTaskInstId(taskId);
            this.approveRepository.cancelFlowStep(flowTaskHandleDo);
        }
        return taskInfoBOList;
    }

    private void clearInfo(FscFlowCancelBusiReqBO reqBO) {
        FscOrderInvoicePO fscOrderInvoicePo = new FscOrderInvoicePO();
        fscOrderInvoicePo.setFscOrderId(reqBO.getOrderId());
        this.fscOrderInvoiceMapper.updateSignInfo(fscOrderInvoicePo);
        FscInvoicePO fscInvoicePOWhere = new FscInvoicePO();
        fscInvoicePOWhere.setFscOrderId(reqBO.getOrderId());
        FscInvoicePO fscInvoicePOSet = new FscInvoicePO();
        fscInvoicePOSet.setDelFlag(FscConstants.YesOrNoEnum.YES.getCode());
        this.fscInvoiceMapper.updateBy(fscInvoicePOSet, fscInvoicePOWhere);
        FscAttachmentPO fscAttachmentPoWhere = new FscAttachmentPO();
        fscAttachmentPoWhere.setFscOrderId(reqBO.getOrderId());
        FscAttachmentPO fscAttachmentPoSet = new FscAttachmentPO();
        fscAttachmentPoSet.setDelFlag(FscConstants.YesOrNoEnum.YES.getCode());
        this.fscAttachmentMapper.updateBy(fscAttachmentPoSet, fscAttachmentPoWhere);
    }

    private void dealBack(FscFlowCancelBusiReqBO reqBO) {
        FscBussiBackStepAtomReqBO bussiBackStepAtomReqBO = new FscBussiBackStepAtomReqBO();
        bussiBackStepAtomReqBO.setOrderId(reqBO.getOrderId());
        this.fscBussiBackStepAtomService.dealBussiBackStep(bussiBackStepAtomReqBO);
    }
}

